| Supported Targets | ESP32 | ESP32-C2 | ESP32-C3 | ESP32-C5 | ESP32-C6 | ESP32-H2 | ESP32-P4 | ESP32-S2 | ESP32-S3 |
| ----------------- | ----- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- |

# Ethernet Examples

See the [README.md](../README.md) file in the upper level [examples](../) directory for more information about examples.

Ethernet examples demonstrate basic features related to Ethernet layer, such as:

* basic Ethernet initialization and binding to IP stack via ESP-NETIF

* tools for performance measurement, i.e. `iperf`

* hardware time synchronization

## ESP-IDF Ethernet Driver

By default, ESP-IDF offers drivers for its internal Ethernet MAC (see Espressif documentation for supported chips) and for Generic IEEE 802.3 compliant PHYs. However, it does not limit users to use just those options. It is possible to create specific MAC and PHY layer drivers tailored for specific chip needs, including SPI Ethernet modules. Espressif maintains additional Ethernet drivers at [esp-eth-drivers repository](https://github.com/espressif/esp-eth-drivers) and the drivers are accessible via [The ESP Component Registry](https://components.espressif.com/) from users' projects.

## Component for Ethernet Initialization

The `Component for Ethernet Initialization` is a component intended for simple initialization of a wide range of Ethernet PHY chips, including SPI Ethernet modules and for advanced Ethernet configuration options, see [its homepage](https://components.espressif.com/components/espressif/ethernet_init/) for more information.


## Common Troubleshooting

* The data path between ESP32's MAC and PHY needs a fixed 50MHz clock for synchronization, which is also called RMII REF clock. It can either be provided by an external oscillator or generated from internal PLL. The signal integrity of RMII clock is strict, so keep the trace as short as possible!
* If you observe undefined behavior (e.g. LCD glitches) of any **SPI device** which works normally when Ethernet is not connected over internal EMAC, you need to adjust EMAC DMA burst length (the DMA is a shared resource between EMAC and the SPI). The same applies when you observe Ethernet frame corruption at the output of SPI Ethernet module and you use a combination of internal EMAC and SPI Ethernet module as network interfaces. To configure the EMAC DMA burst length, modify internal Ethernet initialization as follows:

```c
esp32_emac_config.dma_burst_len = ETH_DMA_BURST_LEN_4; // or other appropriate value
```

* ESP32 limitations:
    * If the RMII clock is generated from internal APLL, then APLL can't be used for other purposes (e.g. I2S).
    * If Wi-Fi or Bluetooth are used simultaneously with Ethernet, the RMII clock cannot be generated by the internal APLL clock, as it would result in clock instability. See [ESP32 errata](https://docs.espressif.com/projects/esp-chip-errata/en/latest/esp32/03-errata-description/index.html#clock-esp32-cannot-be-used-as-the-phy-clock-source-if-wi-fi-and-ethernet-are-used-at-the-same-time) for more information.