/**
 * SPDX-FileCopyrightText: 2023 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** LP_SYSTEM_REG_LP_SYS_VER_DATE_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SYS_VER_DATE_REG (DR_REG_LP_SYS_BASE + 0x0)
/** LP_SYSTEM_REG_VER_DATE : R/W; bitpos: [31:0]; default: 539165961;
 *  need_des
 */
#define LP_SYSTEM_REG_VER_DATE    0xFFFFFFFFU
#define LP_SYSTEM_REG_VER_DATE_M  (LP_SYSTEM_REG_VER_DATE_V << LP_SYSTEM_REG_VER_DATE_S)
#define LP_SYSTEM_REG_VER_DATE_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_VER_DATE_S  0

/** LP_SYSTEM_REG_CLK_SEL_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_CLK_SEL_CTRL_REG (DR_REG_LP_SYS_BASE + 0x4)
/** LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK : R/W; bitpos: [16]; default: 0;
 *  reserved
 */
#define LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK    (BIT(16))
#define LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK_M  (LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK_V << LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK_S)
#define LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK_V  0x00000001U
#define LP_SYSTEM_REG_ENA_SW_SEL_SYS_CLK_S  16
/** LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL : R/W; bitpos: [17]; default: 0;
 *  reserved
 */
#define LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL    (BIT(17))
#define LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL_M  (LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL_V << LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL_S)
#define LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL_V  0x00000001U
#define LP_SYSTEM_REG_SW_SYS_CLK_SRC_SEL_S  17

/** LP_SYSTEM_REG_SYS_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_SYS_CTRL_REG (DR_REG_LP_SYS_BASE + 0x8)
/** LP_SYSTEM_REG_LP_CORE_DISABLE : R/W; bitpos: [0]; default: 0;
 *  lp cpu disable
 */
#define LP_SYSTEM_REG_LP_CORE_DISABLE    (BIT(0))
#define LP_SYSTEM_REG_LP_CORE_DISABLE_M  (LP_SYSTEM_REG_LP_CORE_DISABLE_V << LP_SYSTEM_REG_LP_CORE_DISABLE_S)
#define LP_SYSTEM_REG_LP_CORE_DISABLE_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_DISABLE_S  0
/** LP_SYSTEM_REG_SYS_SW_RST : WT; bitpos: [1]; default: 0;
 *  digital system software reset bit
 */
#define LP_SYSTEM_REG_SYS_SW_RST    (BIT(1))
#define LP_SYSTEM_REG_SYS_SW_RST_M  (LP_SYSTEM_REG_SYS_SW_RST_V << LP_SYSTEM_REG_SYS_SW_RST_S)
#define LP_SYSTEM_REG_SYS_SW_RST_V  0x00000001U
#define LP_SYSTEM_REG_SYS_SW_RST_S  1
/** LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT : R/W; bitpos: [2]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT    (BIT(2))
#define LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT_M  (LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT_V << LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT_S)
#define LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT_V  0x00000001U
#define LP_SYSTEM_REG_FORCE_DOWNLOAD_BOOT_S  2
/** LP_SYSTEM_REG_DIG_FIB : R/W; bitpos: [10:3]; default: 255;
 *  need_des
 */
#define LP_SYSTEM_REG_DIG_FIB    0x000000FFU
#define LP_SYSTEM_REG_DIG_FIB_M  (LP_SYSTEM_REG_DIG_FIB_V << LP_SYSTEM_REG_DIG_FIB_S)
#define LP_SYSTEM_REG_DIG_FIB_V  0x000000FFU
#define LP_SYSTEM_REG_DIG_FIB_S  3
/** LP_SYSTEM_REG_IO_MUX_RESET_DISABLE : R/W; bitpos: [11]; default: 0;
 *  reset disable bit for LP IOMUX
 */
#define LP_SYSTEM_REG_IO_MUX_RESET_DISABLE    (BIT(11))
#define LP_SYSTEM_REG_IO_MUX_RESET_DISABLE_M  (LP_SYSTEM_REG_IO_MUX_RESET_DISABLE_V << LP_SYSTEM_REG_IO_MUX_RESET_DISABLE_S)
#define LP_SYSTEM_REG_IO_MUX_RESET_DISABLE_V  0x00000001U
#define LP_SYSTEM_REG_IO_MUX_RESET_DISABLE_S  11
/** LP_SYSTEM_REG_ANA_FIB : RO; bitpos: [20:14]; default: 127;
 *  need_des
 */
#define LP_SYSTEM_REG_ANA_FIB    0x0000007FU
#define LP_SYSTEM_REG_ANA_FIB_M  (LP_SYSTEM_REG_ANA_FIB_V << LP_SYSTEM_REG_ANA_FIB_S)
#define LP_SYSTEM_REG_ANA_FIB_V  0x0000007FU
#define LP_SYSTEM_REG_ANA_FIB_S  14
/** LP_SYSTEM_REG_LP_FIB_BOD_RESET : R/W; bitpos: [22]; default: 1;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_FIB_BOD_RST    BIT(22)
#define LP_SYSTEM_REG_LP_FIB_BOD_RST_M  (LP_SYSTEM_REG_LP_FIB_BOD_RST_V << LP_SYSTEM_REG_LP_FIB_BOD_RST_S)
#define LP_SYSTEM_REG_LP_FIB_BOD_RST_V  0x00000001U
#define LP_SYSTEM_REG_LP_FIB_BOD_RST_S  22
/** LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST : R/W; bitpos: [23]; default: 1;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST     BIT(23)
#define LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST_M  (LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST_V << LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST_S)
#define LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST_V  0x00000001U
#define LP_SYSTEM_REG_LP_FIB_SUPER_WDT_RST_S  23
/** LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH : R/W; bitpos: [25]; default: 1;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH    BIT(25)
#define LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH_M  (LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH_V << LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH_S)
#define LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH_V  0x00000001U
#define LP_SYSTEM_REG_LP_FIB_DCDC_SWITCH_S  25

/** LP_SYSTEM_REG_LP_FIB_VSET_ENABLE : R/W; bitpos: [26]; default: 1;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_FIB_VSET_ENABLE    BIT(26)
#define LP_SYSTEM_REG_LP_FIB_VSET_ENABLE_M  (LP_SYSTEM_REG_LP_FIB_VSET_ENABLE_V << LP_SYSTEM_REG_LP_FIB_VSET_ENABLE_S)
#define LP_SYSTEM_REG_LP_FIB_VSET_ENABLE_V  0x00000001U
#define LP_SYSTEM_REG_LP_FIB_VSET_ENABLE_S  26
/** LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR : WT; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR    (BIT(29))
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR_M  (LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR_V << LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR_S)
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_CLR_S  29
/** LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG : R/WTC/SS; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG    (BIT(30))
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_M  (LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_V << LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_S)
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_ETM_WAKEUP_FLAG_S  30
/** LP_SYSTEM_REG_SYSTIMER_STALL_SEL : R/W; bitpos: [31]; default: 0;
 *  0: use systimer_stall signal from hp_core0, 1: use systimer_stall signal from
 *  hp_core1
 */
#define LP_SYSTEM_REG_SYSTIMER_STALL_SEL    (BIT(31))
#define LP_SYSTEM_REG_SYSTIMER_STALL_SEL_M  (LP_SYSTEM_REG_SYSTIMER_STALL_SEL_V << LP_SYSTEM_REG_SYSTIMER_STALL_SEL_S)
#define LP_SYSTEM_REG_SYSTIMER_STALL_SEL_V  0x00000001U
#define LP_SYSTEM_REG_SYSTIMER_STALL_SEL_S  31

/** LP_SYSTEM_REG_LP_CLK_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CLK_CTRL_REG (DR_REG_LP_SYS_BASE + 0xc)
/** LP_SYSTEM_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  need_des
 */
#define LP_SYSTEM_REG_CLK_EN    (BIT(0))
#define LP_SYSTEM_REG_CLK_EN_M  (LP_SYSTEM_REG_CLK_EN_V << LP_SYSTEM_REG_CLK_EN_S)
#define LP_SYSTEM_REG_CLK_EN_V  0x00000001U
#define LP_SYSTEM_REG_CLK_EN_S  0
/** LP_SYSTEM_REG_LP_FOSC_HP_CKEN : R/W; bitpos: [14]; default: 1;
 *  reserved
 */
#define LP_SYSTEM_REG_LP_FOSC_HP_CKEN    (BIT(14))
#define LP_SYSTEM_REG_LP_FOSC_HP_CKEN_M  (LP_SYSTEM_REG_LP_FOSC_HP_CKEN_V << LP_SYSTEM_REG_LP_FOSC_HP_CKEN_S)
#define LP_SYSTEM_REG_LP_FOSC_HP_CKEN_V  0x00000001U
#define LP_SYSTEM_REG_LP_FOSC_HP_CKEN_S  14

/** LP_SYSTEM_REG_LP_RST_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_RST_CTRL_REG (DR_REG_LP_SYS_BASE + 0x10)
/** LP_SYSTEM_REG_ANA_RST_BYPASS : R/W; bitpos: [0]; default: 1;
 *  analog source reset bypass : wdt,brown out,super wdt,glitch
 */
#define LP_SYSTEM_REG_ANA_RST_BYPASS    (BIT(0))
#define LP_SYSTEM_REG_ANA_RST_BYPASS_M  (LP_SYSTEM_REG_ANA_RST_BYPASS_V << LP_SYSTEM_REG_ANA_RST_BYPASS_S)
#define LP_SYSTEM_REG_ANA_RST_BYPASS_V  0x00000001U
#define LP_SYSTEM_REG_ANA_RST_BYPASS_S  0
/** LP_SYSTEM_REG_SYS_RST_BYPASS : R/W; bitpos: [1]; default: 1;
 *  system source reset bypass : software reset,hp wdt,lp wdt,efuse
 */
#define LP_SYSTEM_REG_SYS_RST_BYPASS    (BIT(1))
#define LP_SYSTEM_REG_SYS_RST_BYPASS_M  (LP_SYSTEM_REG_SYS_RST_BYPASS_V << LP_SYSTEM_REG_SYS_RST_BYPASS_S)
#define LP_SYSTEM_REG_SYS_RST_BYPASS_V  0x00000001U
#define LP_SYSTEM_REG_SYS_RST_BYPASS_S  1
/** LP_SYSTEM_REG_EFUSE_FORCE_NORST : R/W; bitpos: [2]; default: 0;
 *  efuse force no reset control
 */
#define LP_SYSTEM_REG_EFUSE_FORCE_NORST    (BIT(2))
#define LP_SYSTEM_REG_EFUSE_FORCE_NORST_M  (LP_SYSTEM_REG_EFUSE_FORCE_NORST_V << LP_SYSTEM_REG_EFUSE_FORCE_NORST_S)
#define LP_SYSTEM_REG_EFUSE_FORCE_NORST_V  0x00000001U
#define LP_SYSTEM_REG_EFUSE_FORCE_NORST_S  2

/** LP_SYSTEM_REG_LP_CORE_BOOT_ADDR_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_BOOT_ADDR_REG (DR_REG_LP_SYS_BASE + 0x18)
/** LP_SYSTEM_REG_LP_CPU_BOOT_ADDR : R/W; bitpos: [31:0]; default: 1343225856;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CPU_BOOT_ADDR    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_CPU_BOOT_ADDR_M  (LP_SYSTEM_REG_LP_CPU_BOOT_ADDR_V << LP_SYSTEM_REG_LP_CPU_BOOT_ADDR_S)
#define LP_SYSTEM_REG_LP_CPU_BOOT_ADDR_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_CPU_BOOT_ADDR_S  0

/** LP_SYSTEM_REG_EXT_WAKEUP1_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_EXT_WAKEUP1_REG (DR_REG_LP_SYS_BASE + 0x1c)
/** LP_SYSTEM_REG_EXT_WAKEUP1_SEL : R/W; bitpos: [15:0]; default: 0;
 *  Bitmap to select RTC pads for ext wakeup1
 */
#define LP_SYSTEM_REG_EXT_WAKEUP1_SEL    0x0000FFFFU
#define LP_SYSTEM_REG_EXT_WAKEUP1_SEL_M  (LP_SYSTEM_REG_EXT_WAKEUP1_SEL_V << LP_SYSTEM_REG_EXT_WAKEUP1_SEL_S)
#define LP_SYSTEM_REG_EXT_WAKEUP1_SEL_V  0x0000FFFFU
#define LP_SYSTEM_REG_EXT_WAKEUP1_SEL_S  0
/** LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR : WT; bitpos: [16]; default: 0;
 *  clear ext wakeup1 status
 */
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR    (BIT(16))
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR_M  (LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR_V << LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR_S)
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR_V  0x00000001U
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_CLR_S  16

/** LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_REG (DR_REG_LP_SYS_BASE + 0x20)
/** LP_SYSTEM_REG_EXT_WAKEUP1_STATUS : RO; bitpos: [15:0]; default: 0;
 *  ext wakeup1 status
 */
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS    0x0000FFFFU
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_M  (LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_V << LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_S)
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_V  0x0000FFFFU
#define LP_SYSTEM_REG_EXT_WAKEUP1_STATUS_S  0

/** LP_SYSTEM_REG_LP_TCM_PWR_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_PWR_CTRL_REG (DR_REG_LP_SYS_BASE + 0x24)
/** LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON : R/W; bitpos: [5]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON    (BIT(5))
#define LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON_M  (LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON_V << LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON_S)
#define LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON_V  0x00000001U
#define LP_SYSTEM_REG_LP_TCM_ROM_CLK_FORCE_ON_S  5
/** LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON : R/W; bitpos: [7]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON    (BIT(7))
#define LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON_M  (LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON_V << LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON_S)
#define LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON_V  0x00000001U
#define LP_SYSTEM_REG_LP_TCM_RAM_CLK_FORCE_ON_S  7

/** LP_SYSTEM_REG_BOOT_ADDR_HP_LP_REG_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_BOOT_ADDR_HP_LP_REG_REG (DR_REG_LP_SYS_BASE + 0x28)
/** LP_SYSTEM_REG_BOOT_ADDR_HP_LP : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_BOOT_ADDR_HP_LP    0xFFFFFFFFU
#define LP_SYSTEM_REG_BOOT_ADDR_HP_LP_M  (LP_SYSTEM_REG_BOOT_ADDR_HP_LP_V << LP_SYSTEM_REG_BOOT_ADDR_HP_LP_S)
#define LP_SYSTEM_REG_BOOT_ADDR_HP_LP_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_BOOT_ADDR_HP_LP_S  0

/** LP_SYSTEM_REG_LP_STORE0_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE0_REG (DR_REG_LP_SYS_BASE + 0x2c)
/** LP_SYSTEM_REG_LP_SCRATCH0 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH0    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH0_M  (LP_SYSTEM_REG_LP_SCRATCH0_V << LP_SYSTEM_REG_LP_SCRATCH0_S)
#define LP_SYSTEM_REG_LP_SCRATCH0_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH0_S  0

/** LP_SYSTEM_REG_LP_STORE1_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE1_REG (DR_REG_LP_SYS_BASE + 0x30)
/** LP_SYSTEM_REG_LP_SCRATCH1 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH1    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH1_M  (LP_SYSTEM_REG_LP_SCRATCH1_V << LP_SYSTEM_REG_LP_SCRATCH1_S)
#define LP_SYSTEM_REG_LP_SCRATCH1_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH1_S  0

/** LP_SYSTEM_REG_LP_STORE2_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE2_REG (DR_REG_LP_SYS_BASE + 0x34)
/** LP_SYSTEM_REG_LP_SCRATCH2 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH2    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH2_M  (LP_SYSTEM_REG_LP_SCRATCH2_V << LP_SYSTEM_REG_LP_SCRATCH2_S)
#define LP_SYSTEM_REG_LP_SCRATCH2_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH2_S  0

/** LP_SYSTEM_REG_LP_STORE3_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE3_REG (DR_REG_LP_SYS_BASE + 0x38)
/** LP_SYSTEM_REG_LP_SCRATCH3 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH3    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH3_M  (LP_SYSTEM_REG_LP_SCRATCH3_V << LP_SYSTEM_REG_LP_SCRATCH3_S)
#define LP_SYSTEM_REG_LP_SCRATCH3_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH3_S  0

/** LP_SYSTEM_REG_LP_STORE4_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE4_REG (DR_REG_LP_SYS_BASE + 0x3c)
/** LP_SYSTEM_REG_LP_SCRATCH4 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH4    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH4_M  (LP_SYSTEM_REG_LP_SCRATCH4_V << LP_SYSTEM_REG_LP_SCRATCH4_S)
#define LP_SYSTEM_REG_LP_SCRATCH4_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH4_S  0

/** LP_SYSTEM_REG_LP_STORE5_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE5_REG (DR_REG_LP_SYS_BASE + 0x40)
/** LP_SYSTEM_REG_LP_SCRATCH5 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH5    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH5_M  (LP_SYSTEM_REG_LP_SCRATCH5_V << LP_SYSTEM_REG_LP_SCRATCH5_S)
#define LP_SYSTEM_REG_LP_SCRATCH5_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH5_S  0

/** LP_SYSTEM_REG_LP_STORE6_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE6_REG (DR_REG_LP_SYS_BASE + 0x44)
/** LP_SYSTEM_REG_LP_SCRATCH6 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH6    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH6_M  (LP_SYSTEM_REG_LP_SCRATCH6_V << LP_SYSTEM_REG_LP_SCRATCH6_S)
#define LP_SYSTEM_REG_LP_SCRATCH6_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH6_S  0

/** LP_SYSTEM_REG_LP_STORE7_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE7_REG (DR_REG_LP_SYS_BASE + 0x48)
/** LP_SYSTEM_REG_LP_SCRATCH7 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH7    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH7_M  (LP_SYSTEM_REG_LP_SCRATCH7_V << LP_SYSTEM_REG_LP_SCRATCH7_S)
#define LP_SYSTEM_REG_LP_SCRATCH7_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH7_S  0

/** LP_SYSTEM_REG_LP_STORE8_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE8_REG (DR_REG_LP_SYS_BASE + 0x4c)
/** LP_SYSTEM_REG_LP_SCRATCH8 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH8    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH8_M  (LP_SYSTEM_REG_LP_SCRATCH8_V << LP_SYSTEM_REG_LP_SCRATCH8_S)
#define LP_SYSTEM_REG_LP_SCRATCH8_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH8_S  0

/** LP_SYSTEM_REG_LP_STORE9_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE9_REG (DR_REG_LP_SYS_BASE + 0x50)
/** LP_SYSTEM_REG_LP_SCRATCH9 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH9    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH9_M  (LP_SYSTEM_REG_LP_SCRATCH9_V << LP_SYSTEM_REG_LP_SCRATCH9_S)
#define LP_SYSTEM_REG_LP_SCRATCH9_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH9_S  0

/** LP_SYSTEM_REG_LP_STORE10_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE10_REG (DR_REG_LP_SYS_BASE + 0x54)
/** LP_SYSTEM_REG_LP_SCRATCH10 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH10    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH10_M  (LP_SYSTEM_REG_LP_SCRATCH10_V << LP_SYSTEM_REG_LP_SCRATCH10_S)
#define LP_SYSTEM_REG_LP_SCRATCH10_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH10_S  0

/** LP_SYSTEM_REG_LP_STORE11_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE11_REG (DR_REG_LP_SYS_BASE + 0x58)
/** LP_SYSTEM_REG_LP_SCRATCH11 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH11    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH11_M  (LP_SYSTEM_REG_LP_SCRATCH11_V << LP_SYSTEM_REG_LP_SCRATCH11_S)
#define LP_SYSTEM_REG_LP_SCRATCH11_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH11_S  0

/** LP_SYSTEM_REG_LP_STORE12_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE12_REG (DR_REG_LP_SYS_BASE + 0x5c)
/** LP_SYSTEM_REG_LP_SCRATCH12 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH12    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH12_M  (LP_SYSTEM_REG_LP_SCRATCH12_V << LP_SYSTEM_REG_LP_SCRATCH12_S)
#define LP_SYSTEM_REG_LP_SCRATCH12_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH12_S  0

/** LP_SYSTEM_REG_LP_STORE13_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE13_REG (DR_REG_LP_SYS_BASE + 0x60)
/** LP_SYSTEM_REG_LP_SCRATCH13 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH13    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH13_M  (LP_SYSTEM_REG_LP_SCRATCH13_V << LP_SYSTEM_REG_LP_SCRATCH13_S)
#define LP_SYSTEM_REG_LP_SCRATCH13_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH13_S  0

/** LP_SYSTEM_REG_LP_STORE14_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE14_REG (DR_REG_LP_SYS_BASE + 0x64)
/** LP_SYSTEM_REG_LP_SCRATCH14 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH14    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH14_M  (LP_SYSTEM_REG_LP_SCRATCH14_V << LP_SYSTEM_REG_LP_SCRATCH14_S)
#define LP_SYSTEM_REG_LP_SCRATCH14_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH14_S  0

/** LP_SYSTEM_REG_LP_STORE15_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_STORE15_REG (DR_REG_LP_SYS_BASE + 0x68)
/** LP_SYSTEM_REG_LP_SCRATCH15 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_SCRATCH15    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH15_M  (LP_SYSTEM_REG_LP_SCRATCH15_V << LP_SYSTEM_REG_LP_SCRATCH15_S)
#define LP_SYSTEM_REG_LP_SCRATCH15_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_SCRATCH15_S  0

/** LP_SYSTEM_REG_LP_PROBEA_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_PROBEA_CTRL_REG (DR_REG_LP_SYS_BASE + 0x6c)
/** LP_SYSTEM_REG_PROBE_A_MOD_SEL : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_A_MOD_SEL    0x0000FFFFU
#define LP_SYSTEM_REG_PROBE_A_MOD_SEL_M  (LP_SYSTEM_REG_PROBE_A_MOD_SEL_V << LP_SYSTEM_REG_PROBE_A_MOD_SEL_S)
#define LP_SYSTEM_REG_PROBE_A_MOD_SEL_V  0x0000FFFFU
#define LP_SYSTEM_REG_PROBE_A_MOD_SEL_S  0
/** LP_SYSTEM_REG_PROBE_A_TOP_SEL : R/W; bitpos: [23:16]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_A_TOP_SEL    0x000000FFU
#define LP_SYSTEM_REG_PROBE_A_TOP_SEL_M  (LP_SYSTEM_REG_PROBE_A_TOP_SEL_V << LP_SYSTEM_REG_PROBE_A_TOP_SEL_S)
#define LP_SYSTEM_REG_PROBE_A_TOP_SEL_V  0x000000FFU
#define LP_SYSTEM_REG_PROBE_A_TOP_SEL_S  16
/** LP_SYSTEM_REG_PROBE_L_SEL : R/W; bitpos: [25:24]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_L_SEL    0x00000003U
#define LP_SYSTEM_REG_PROBE_L_SEL_M  (LP_SYSTEM_REG_PROBE_L_SEL_V << LP_SYSTEM_REG_PROBE_L_SEL_S)
#define LP_SYSTEM_REG_PROBE_L_SEL_V  0x00000003U
#define LP_SYSTEM_REG_PROBE_L_SEL_S  24
/** LP_SYSTEM_REG_PROBE_H_SEL : R/W; bitpos: [27:26]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_H_SEL    0x00000003U
#define LP_SYSTEM_REG_PROBE_H_SEL_M  (LP_SYSTEM_REG_PROBE_H_SEL_V << LP_SYSTEM_REG_PROBE_H_SEL_S)
#define LP_SYSTEM_REG_PROBE_H_SEL_V  0x00000003U
#define LP_SYSTEM_REG_PROBE_H_SEL_S  26
/** LP_SYSTEM_REG_PROBE_GLOBAL_EN : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_GLOBAL_EN    (BIT(28))
#define LP_SYSTEM_REG_PROBE_GLOBAL_EN_M  (LP_SYSTEM_REG_PROBE_GLOBAL_EN_V << LP_SYSTEM_REG_PROBE_GLOBAL_EN_S)
#define LP_SYSTEM_REG_PROBE_GLOBAL_EN_V  0x00000001U
#define LP_SYSTEM_REG_PROBE_GLOBAL_EN_S  28

/** LP_SYSTEM_REG_LP_PROBEB_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_PROBEB_CTRL_REG (DR_REG_LP_SYS_BASE + 0x70)
/** LP_SYSTEM_REG_PROBE_B_MOD_SEL : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_B_MOD_SEL    0x0000FFFFU
#define LP_SYSTEM_REG_PROBE_B_MOD_SEL_M  (LP_SYSTEM_REG_PROBE_B_MOD_SEL_V << LP_SYSTEM_REG_PROBE_B_MOD_SEL_S)
#define LP_SYSTEM_REG_PROBE_B_MOD_SEL_V  0x0000FFFFU
#define LP_SYSTEM_REG_PROBE_B_MOD_SEL_S  0
/** LP_SYSTEM_REG_PROBE_B_TOP_SEL : R/W; bitpos: [23:16]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_B_TOP_SEL    0x000000FFU
#define LP_SYSTEM_REG_PROBE_B_TOP_SEL_M  (LP_SYSTEM_REG_PROBE_B_TOP_SEL_V << LP_SYSTEM_REG_PROBE_B_TOP_SEL_S)
#define LP_SYSTEM_REG_PROBE_B_TOP_SEL_V  0x000000FFU
#define LP_SYSTEM_REG_PROBE_B_TOP_SEL_S  16
/** LP_SYSTEM_REG_PROBE_B_EN : R/W; bitpos: [24]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_B_EN    (BIT(24))
#define LP_SYSTEM_REG_PROBE_B_EN_M  (LP_SYSTEM_REG_PROBE_B_EN_V << LP_SYSTEM_REG_PROBE_B_EN_S)
#define LP_SYSTEM_REG_PROBE_B_EN_V  0x00000001U
#define LP_SYSTEM_REG_PROBE_B_EN_S  24

/** LP_SYSTEM_REG_LP_PROBE_OUT_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_PROBE_OUT_REG (DR_REG_LP_SYS_BASE + 0x74)
/** LP_SYSTEM_REG_PROBE_TOP_OUT : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PROBE_TOP_OUT    0xFFFFFFFFU
#define LP_SYSTEM_REG_PROBE_TOP_OUT_M  (LP_SYSTEM_REG_PROBE_TOP_OUT_V << LP_SYSTEM_REG_PROBE_TOP_OUT_S)
#define LP_SYSTEM_REG_PROBE_TOP_OUT_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_PROBE_TOP_OUT_S  0

/** LP_SYSTEM_REG_F2S_APB_BRG_CNTL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_F2S_APB_BRG_CNTL_REG (DR_REG_LP_SYS_BASE + 0x9c)
/** LP_SYSTEM_REG_F2S_APB_POSTW_EN : R/W; bitpos: [0]; default: 0;
 *  reserved
 */
#define LP_SYSTEM_REG_F2S_APB_POSTW_EN    (BIT(0))
#define LP_SYSTEM_REG_F2S_APB_POSTW_EN_M  (LP_SYSTEM_REG_F2S_APB_POSTW_EN_V << LP_SYSTEM_REG_F2S_APB_POSTW_EN_S)
#define LP_SYSTEM_REG_F2S_APB_POSTW_EN_V  0x00000001U
#define LP_SYSTEM_REG_F2S_APB_POSTW_EN_S  0

/** LP_SYSTEM_REG_USB_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_USB_CTRL_REG (DR_REG_LP_SYS_BASE + 0x100)
/** LP_SYSTEM_REG_SW_HW_USB_PHY_SEL : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_SW_HW_USB_PHY_SEL    (BIT(0))
#define LP_SYSTEM_REG_SW_HW_USB_PHY_SEL_M  (LP_SYSTEM_REG_SW_HW_USB_PHY_SEL_V << LP_SYSTEM_REG_SW_HW_USB_PHY_SEL_S)
#define LP_SYSTEM_REG_SW_HW_USB_PHY_SEL_V  0x00000001U
#define LP_SYSTEM_REG_SW_HW_USB_PHY_SEL_S  0
/** LP_SYSTEM_REG_SW_USB_PHY_SEL : R/W; bitpos: [1]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_SW_USB_PHY_SEL    (BIT(1))
#define LP_SYSTEM_REG_SW_USB_PHY_SEL_M  (LP_SYSTEM_REG_SW_USB_PHY_SEL_V << LP_SYSTEM_REG_SW_USB_PHY_SEL_S)
#define LP_SYSTEM_REG_SW_USB_PHY_SEL_V  0x00000001U
#define LP_SYSTEM_REG_SW_USB_PHY_SEL_S  1
/** LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR : WT; bitpos: [2]; default: 0;
 *  clear usb wakeup to PMU.
 */
#define LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR    (BIT(2))
#define LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR_M  (LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR_V << LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR_S)
#define LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR_V  0x00000001U
#define LP_SYSTEM_REG_USBOTG20_WAKEUP_CLR_S  2
/** LP_SYSTEM_REG_USBOTG20_IN_SUSPEND : R/W; bitpos: [3]; default: 0;
 *  indicate usb otg2.0 is in suspend state.
 */
#define LP_SYSTEM_REG_USBOTG20_IN_SUSPEND    (BIT(3))
#define LP_SYSTEM_REG_USBOTG20_IN_SUSPEND_M  (LP_SYSTEM_REG_USBOTG20_IN_SUSPEND_V << LP_SYSTEM_REG_USBOTG20_IN_SUSPEND_S)
#define LP_SYSTEM_REG_USBOTG20_IN_SUSPEND_V  0x00000001U
#define LP_SYSTEM_REG_USBOTG20_IN_SUSPEND_S  3

/** LP_SYSTEM_REG_ANA_XPD_PAD_GROUP_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_ANA_XPD_PAD_GROUP_REG (DR_REG_LP_SYS_BASE + 0x10c)
/** LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP : R/W; bitpos: [7:0]; default: 255;
 *  Set 1 to power up pad group
 */
#define LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP    0x000000FFU
#define LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP_M  (LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP_V << LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP_S)
#define LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP_V  0x000000FFU
#define LP_SYSTEM_REG_ANA_REG_XPD_PAD_GROUP_S  0

/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_CS_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_CS_REG (DR_REG_LP_SYS_BASE + 0x110)
/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN    (BIT(0))
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN_M  (LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN_V << LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN_S)
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN_V  0x00000001U
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_EN_S  0
/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT    (BIT(1))
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT_M  (LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT_V << LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT_S)
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT_V  0x00000001U
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_RESULT_S  1

/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_REG (DR_REG_LP_SYS_BASE + 0x114)
/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_M  (LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_V << LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_S)
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_LOW_S  0

/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_REG (DR_REG_LP_SYS_BASE + 0x118)
/** LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH : R/W; bitpos: [31:0]; default: 4294967295;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_M  (LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_V << LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_S)
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_RAM_RDN_ECO_HIGH_S  0

/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_CS_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_CS_REG (DR_REG_LP_SYS_BASE + 0x11c)
/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN    (BIT(0))
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN_M  (LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN_V << LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN_S)
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN_V  0x00000001U
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_EN_S  0
/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT    (BIT(1))
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT_M  (LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT_V << LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT_S)
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT_V  0x00000001U
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_RESULT_S  1

/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_REG (DR_REG_LP_SYS_BASE + 0x120)
/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_M  (LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_V << LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_S)
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_LOW_S  0

/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_REG (DR_REG_LP_SYS_BASE + 0x124)
/** LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH : R/W; bitpos: [31:0]; default: 4294967295;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_M  (LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_V << LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_S)
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_TCM_ROM_RDN_ECO_HIGH_S  0

/** LP_SYSTEM_REG_HP_ROOT_CLK_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_HP_ROOT_CLK_CTRL_REG (DR_REG_LP_SYS_BASE + 0x130)
/** LP_SYSTEM_REG_CPU_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  clock gate enable for hp cpu root 400M clk
 */
#define LP_SYSTEM_REG_CPU_CLK_EN    (BIT(0))
#define LP_SYSTEM_REG_CPU_CLK_EN_M  (LP_SYSTEM_REG_CPU_CLK_EN_V << LP_SYSTEM_REG_CPU_CLK_EN_S)
#define LP_SYSTEM_REG_CPU_CLK_EN_V  0x00000001U
#define LP_SYSTEM_REG_CPU_CLK_EN_S  0
/** LP_SYSTEM_REG_SYS_CLK_EN : R/W; bitpos: [1]; default: 1;
 *  clock gate enable for hp sys root 480M clk
 */
#define LP_SYSTEM_REG_SYS_CLK_EN    (BIT(1))
#define LP_SYSTEM_REG_SYS_CLK_EN_M  (LP_SYSTEM_REG_SYS_CLK_EN_V << LP_SYSTEM_REG_SYS_CLK_EN_S)
#define LP_SYSTEM_REG_SYS_CLK_EN_V  0x00000001U
#define LP_SYSTEM_REG_SYS_CLK_EN_S  1

/** LP_SYSTEM_REG_LP_PMU_RDN_ECO_LOW_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_PMU_RDN_ECO_LOW_REG (DR_REG_LP_SYS_BASE + 0x138)
/** LP_SYSTEM_REG_PMU_RDN_ECO_LOW : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_PMU_RDN_ECO_LOW    0xFFFFFFFFU
#define LP_SYSTEM_REG_PMU_RDN_ECO_LOW_M  (LP_SYSTEM_REG_PMU_RDN_ECO_LOW_V << LP_SYSTEM_REG_PMU_RDN_ECO_LOW_S)
#define LP_SYSTEM_REG_PMU_RDN_ECO_LOW_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_PMU_RDN_ECO_LOW_S  0

/** LP_SYSTEM_REG_LP_PMU_RDN_ECO_HIGH_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_PMU_RDN_ECO_HIGH_REG (DR_REG_LP_SYS_BASE + 0x13c)
/** LP_SYSTEM_REG_PMU_RDN_ECO_HIGH : R/W; bitpos: [31:0]; default: 4294967295;
 *  need_des
 */
#define LP_SYSTEM_REG_PMU_RDN_ECO_HIGH    0xFFFFFFFFU
#define LP_SYSTEM_REG_PMU_RDN_ECO_HIGH_M  (LP_SYSTEM_REG_PMU_RDN_ECO_HIGH_V << LP_SYSTEM_REG_PMU_RDN_ECO_HIGH_S)
#define LP_SYSTEM_REG_PMU_RDN_ECO_HIGH_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_PMU_RDN_ECO_HIGH_S  0

/** LP_SYSTEM_REG_PAD_COMP0_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_PAD_COMP0_REG (DR_REG_LP_SYS_BASE + 0x148)
/** LP_SYSTEM_REG_DREF_COMP0 : R/W; bitpos: [2:0]; default: 0;
 *  pad comp dref
 */
#define LP_SYSTEM_REG_DREF_COMP0    0x00000007U
#define LP_SYSTEM_REG_DREF_COMP0_M  (LP_SYSTEM_REG_DREF_COMP0_V << LP_SYSTEM_REG_DREF_COMP0_S)
#define LP_SYSTEM_REG_DREF_COMP0_V  0x00000007U
#define LP_SYSTEM_REG_DREF_COMP0_S  0
/** LP_SYSTEM_REG_MODE_COMP0 : R/W; bitpos: [3]; default: 0;
 *  pad comp mode
 */
#define LP_SYSTEM_REG_MODE_COMP0    (BIT(3))
#define LP_SYSTEM_REG_MODE_COMP0_M  (LP_SYSTEM_REG_MODE_COMP0_V << LP_SYSTEM_REG_MODE_COMP0_S)
#define LP_SYSTEM_REG_MODE_COMP0_V  0x00000001U
#define LP_SYSTEM_REG_MODE_COMP0_S  3
/** LP_SYSTEM_REG_XPD_COMP0 : R/W; bitpos: [4]; default: 0;
 *  pad comp xpd
 */
#define LP_SYSTEM_REG_XPD_COMP0    (BIT(4))
#define LP_SYSTEM_REG_XPD_COMP0_M  (LP_SYSTEM_REG_XPD_COMP0_V << LP_SYSTEM_REG_XPD_COMP0_S)
#define LP_SYSTEM_REG_XPD_COMP0_V  0x00000001U
#define LP_SYSTEM_REG_XPD_COMP0_S  4

/** LP_SYSTEM_REG_PAD_COMP1_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_PAD_COMP1_REG (DR_REG_LP_SYS_BASE + 0x14c)
/** LP_SYSTEM_REG_DREF_COMP1 : R/W; bitpos: [2:0]; default: 0;
 *  pad comp dref
 */
#define LP_SYSTEM_REG_DREF_COMP1    0x00000007U
#define LP_SYSTEM_REG_DREF_COMP1_M  (LP_SYSTEM_REG_DREF_COMP1_V << LP_SYSTEM_REG_DREF_COMP1_S)
#define LP_SYSTEM_REG_DREF_COMP1_V  0x00000007U
#define LP_SYSTEM_REG_DREF_COMP1_S  0
/** LP_SYSTEM_REG_MODE_COMP1 : R/W; bitpos: [3]; default: 0;
 *  pad comp mode
 */
#define LP_SYSTEM_REG_MODE_COMP1    (BIT(3))
#define LP_SYSTEM_REG_MODE_COMP1_M  (LP_SYSTEM_REG_MODE_COMP1_V << LP_SYSTEM_REG_MODE_COMP1_S)
#define LP_SYSTEM_REG_MODE_COMP1_V  0x00000001U
#define LP_SYSTEM_REG_MODE_COMP1_S  3
/** LP_SYSTEM_REG_XPD_COMP1 : R/W; bitpos: [4]; default: 0;
 *  pad comp xpd
 */
#define LP_SYSTEM_REG_XPD_COMP1    (BIT(4))
#define LP_SYSTEM_REG_XPD_COMP1_M  (LP_SYSTEM_REG_XPD_COMP1_V << LP_SYSTEM_REG_XPD_COMP1_S)
#define LP_SYSTEM_REG_XPD_COMP1_V  0x00000001U
#define LP_SYSTEM_REG_XPD_COMP1_S  4

/** LP_SYSTEM_REG_BACKUP_DMA_CFG0_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_BACKUP_DMA_CFG0_REG (DR_REG_LP_SYS_BASE + 0x154)
/** LP_SYSTEM_REG_BURST_LIMIT_AON : R/W; bitpos: [4:0]; default: 10;
 *  need_des
 */
#define LP_SYSTEM_REG_BURST_LIMIT_AON    0x0000001FU
#define LP_SYSTEM_REG_BURST_LIMIT_AON_M  (LP_SYSTEM_REG_BURST_LIMIT_AON_V << LP_SYSTEM_REG_BURST_LIMIT_AON_S)
#define LP_SYSTEM_REG_BURST_LIMIT_AON_V  0x0000001FU
#define LP_SYSTEM_REG_BURST_LIMIT_AON_S  0
/** LP_SYSTEM_REG_READ_INTERVAL_AON : R/W; bitpos: [11:5]; default: 10;
 *  need_des
 */
#define LP_SYSTEM_REG_READ_INTERVAL_AON    0x0000007FU
#define LP_SYSTEM_REG_READ_INTERVAL_AON_M  (LP_SYSTEM_REG_READ_INTERVAL_AON_V << LP_SYSTEM_REG_READ_INTERVAL_AON_S)
#define LP_SYSTEM_REG_READ_INTERVAL_AON_V  0x0000007FU
#define LP_SYSTEM_REG_READ_INTERVAL_AON_S  5
/** LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON : R/W; bitpos: [21:12]; default: 100;
 *  need_des
 */
#define LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON    0x000003FFU
#define LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON_M  (LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON_V << LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON_S)
#define LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON_V  0x000003FFU
#define LP_SYSTEM_REG_LINK_BACKUP_TOUT_THRES_AON_S  12
/** LP_SYSTEM_REG_LINK_TOUT_THRES_AON : R/W; bitpos: [31:22]; default: 100;
 *  need_des
 */
#define LP_SYSTEM_REG_LINK_TOUT_THRES_AON    0x000003FFU
#define LP_SYSTEM_REG_LINK_TOUT_THRES_AON_M  (LP_SYSTEM_REG_LINK_TOUT_THRES_AON_V << LP_SYSTEM_REG_LINK_TOUT_THRES_AON_S)
#define LP_SYSTEM_REG_LINK_TOUT_THRES_AON_V  0x000003FFU
#define LP_SYSTEM_REG_LINK_TOUT_THRES_AON_S  22

/** LP_SYSTEM_REG_BACKUP_DMA_CFG1_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_BACKUP_DMA_CFG1_REG (DR_REG_LP_SYS_BASE + 0x158)
/** LP_SYSTEM_REG_AON_BYPASS : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_AON_BYPASS    (BIT(31))
#define LP_SYSTEM_REG_AON_BYPASS_M  (LP_SYSTEM_REG_AON_BYPASS_V << LP_SYSTEM_REG_AON_BYPASS_S)
#define LP_SYSTEM_REG_AON_BYPASS_V  0x00000001U
#define LP_SYSTEM_REG_AON_BYPASS_S  31

/** LP_SYSTEM_REG_BACKUP_DMA_CFG2_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_BACKUP_DMA_CFG2_REG (DR_REG_LP_SYS_BASE + 0x15c)
/** LP_SYSTEM_REG_LINK_ADDR_AON : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LINK_ADDR_AON    0xFFFFFFFFU
#define LP_SYSTEM_REG_LINK_ADDR_AON_M  (LP_SYSTEM_REG_LINK_ADDR_AON_V << LP_SYSTEM_REG_LINK_ADDR_AON_S)
#define LP_SYSTEM_REG_LINK_ADDR_AON_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LINK_ADDR_AON_S  0

/** LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_REG (DR_REG_LP_SYS_BASE + 0x164)
/** LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1    0xFFFFFFFFU
#define LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_M  (LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_V << LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_S)
#define LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_BOOT_ADDR_HP_CORE1_S  0

/** LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_REG (DR_REG_LP_SYS_BASE + 0x168)
/** LP_SYSTEM_REG_LP_ADDRHOLE_ADDR : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_ADDR    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_M  (LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_V << LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_ADDRHOLE_ADDR_S  0

/** LP_SYSTEM_REG_LP_ADDRHOLE_INFO_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_INFO_REG (DR_REG_LP_SYS_BASE + 0x16c)
/** LP_SYSTEM_REG_LP_ADDRHOLE_ID : RO; bitpos: [4:0]; default: 0;
 *  master id: 5'h0: hp core0, 5'h1:hp core1, 5'h2:lp core, 5'h3:usb otg11, 5'h4:
 *  regdma, 5'h5: gmac, 5'h5 sdmmc, 5'h7: usbotg20, 5'h8: trace0, 5'h9: trace1, 5'ha
 *  tcm monitor, 5'hb: l2mem monitor. 5'h10~5'h1f: ahb pdma.
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_ID    0x0000001FU
#define LP_SYSTEM_REG_LP_ADDRHOLE_ID_M  (LP_SYSTEM_REG_LP_ADDRHOLE_ID_V << LP_SYSTEM_REG_LP_ADDRHOLE_ID_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_ID_V  0x0000001FU
#define LP_SYSTEM_REG_LP_ADDRHOLE_ID_S  0
/** LP_SYSTEM_REG_LP_ADDRHOLE_WR : RO; bitpos: [5]; default: 0;
 *  1:write trans, 0: read trans.
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_WR    (BIT(5))
#define LP_SYSTEM_REG_LP_ADDRHOLE_WR_M  (LP_SYSTEM_REG_LP_ADDRHOLE_WR_V << LP_SYSTEM_REG_LP_ADDRHOLE_WR_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_WR_V  0x00000001U
#define LP_SYSTEM_REG_LP_ADDRHOLE_WR_S  5
/** LP_SYSTEM_REG_LP_ADDRHOLE_SECURE : RO; bitpos: [6]; default: 0;
 *  1: illegal address access, 0: access without permission
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_SECURE    (BIT(6))
#define LP_SYSTEM_REG_LP_ADDRHOLE_SECURE_M  (LP_SYSTEM_REG_LP_ADDRHOLE_SECURE_V << LP_SYSTEM_REG_LP_ADDRHOLE_SECURE_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_SECURE_V  0x00000001U
#define LP_SYSTEM_REG_LP_ADDRHOLE_SECURE_S  6

/** LP_SYSTEM_REG_INT_RAW_REG register
 *  raw interrupt register
 */
#define LP_SYSTEM_REG_INT_RAW_REG (DR_REG_LP_SYS_BASE + 0x170)
/** LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW : R/SS/WTC; bitpos: [0]; default: 0;
 *  the raw interrupt status of lp addrhole(for lp peri  and lp ram tee apm, and lp
 *  matrix default slave)
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW    (BIT(0))
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW_M  (LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW_V << LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_RAW_S  0
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW : R/SS/WTC; bitpos: [1]; default: 0;
 *  the raw interrupt status of idbus addrhole(only for lp cpu ibus and dbus)
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW    (BIT(1))
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_RAW_S  1
/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW : R/SS/WTC; bitpos: [2]; default: 0;
 *  the raw interrupt status of lp core ahb bus timeout
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW    (BIT(2))
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW_M  (LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW_V << LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW_S)
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_RAW_S  2
/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW : R/SS/WTC; bitpos: [3]; default: 0;
 *  the raw interrupt status of lp core  ibus timeout
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW    (BIT(3))
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW_M  (LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW_V << LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW_S)
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_RAW_S  3
/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW : R/SS/WTC; bitpos: [4]; default: 0;
 *  the raw interrupt status of lp core  dbus timeout
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW    (BIT(4))
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW_M  (LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW_V << LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW_S)
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_RAW_S  4
/** LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW : R/SS/WTC; bitpos: [5]; default: 0;
 *  the raw interrupt status of etm task ulp
 */
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW    (BIT(5))
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW_M  (LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW_V << LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW_S)
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_RAW_S  5
/** LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW : R/SS/WTC; bitpos: [6]; default: 0;
 *  the raw interrupt status of slow_clk_tick
 */
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW    (BIT(6))
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW_M  (LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW_V << LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW_S)
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW_V  0x00000001U
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_RAW_S  6

/** LP_SYSTEM_REG_INT_ST_REG register
 *  masked interrupt register
 */
#define LP_SYSTEM_REG_INT_ST_REG (DR_REG_LP_SYS_BASE + 0x174)
/** LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST : RO; bitpos: [0]; default: 0;
 *  the masked interrupt status of lp addrhole (for lp peri  and lp ram tee apm, and lp
 *  matrix default slave)
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST    (BIT(0))
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST_M  (LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST_V << LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ST_S  0
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST : RO; bitpos: [1]; default: 0;
 *  the masked interrupt status of idbus addrhole(only for lp cpu ibus and dbus)
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST    (BIT(1))
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ST_S  1
/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST : RO; bitpos: [2]; default: 0;
 *  the masked interrupt status of lp core ahb bus timeout
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST    (BIT(2))
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST_M  (LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST_V << LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST_S)
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ST_S  2
/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST : RO; bitpos: [3]; default: 0;
 *  the masked interrupt status of lp core  ibus timeout
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST    (BIT(3))
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST_M  (LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST_V << LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST_S)
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ST_S  3
/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST : RO; bitpos: [4]; default: 0;
 *  the masked interrupt status of lp core  dbus timeout
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST    (BIT(4))
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST_M  (LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST_V << LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST_S)
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ST_S  4
/** LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST : RO; bitpos: [5]; default: 0;
 *  the masked interrupt status of etm task ulp
 */
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST    (BIT(5))
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST_M  (LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST_V << LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST_S)
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ST_S  5
/** LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST : RO; bitpos: [6]; default: 0;
 *  the masked interrupt status of slow_clk_tick
 */
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST    (BIT(6))
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST_M  (LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST_V << LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST_S)
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST_V  0x00000001U
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ST_S  6

/** LP_SYSTEM_REG_INT_ENA_REG register
 *  masked interrupt register
 */
#define LP_SYSTEM_REG_INT_ENA_REG (DR_REG_LP_SYS_BASE + 0x178)
/** LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  Write 1 to enable lp addrhole int
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA    (BIT(0))
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA_M  (LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA_V << LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_ENA_S  0
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  Write 1 to enable idbus addrhole int
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA    (BIT(1))
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_ENA_S  1
/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  Write 1 to enable lp_core_ahb_timeout int
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA    (BIT(2))
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA_M  (LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA_V << LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA_S)
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_ENA_S  2
/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  Write 1 to enable lp_core_ibus_timeout int
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA    (BIT(3))
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA_M  (LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA_V << LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA_S)
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_ENA_S  3
/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  Write 1 to enable lp_core_dbus_timeout int
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA    (BIT(4))
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA_M  (LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA_V << LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA_S)
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_ENA_S  4
/** LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  Write 1 to enable etm task ulp int
 */
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA    (BIT(5))
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA_M  (LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA_V << LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA_S)
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_ENA_S  5
/** LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  Write 1 to enable slow_clk_tick int
 */
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA    (BIT(6))
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA_M  (LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA_V << LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA_S)
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA_V  0x00000001U
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_ENA_S  6

/** LP_SYSTEM_REG_INT_CLR_REG register
 *  interrupt clear register
 */
#define LP_SYSTEM_REG_INT_CLR_REG (DR_REG_LP_SYS_BASE + 0x17c)
/** LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR : WT; bitpos: [0]; default: 0;
 *  write 1 to clear lp addrhole int
 */
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR    (BIT(0))
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR_M  (LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR_V << LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR_S)
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_LP_ADDRHOLE_INT_CLR_S  0
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR : WT; bitpos: [1]; default: 0;
 *  write 1 to clear idbus addrhole int
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR    (BIT(1))
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INT_CLR_S  1
/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR : WT; bitpos: [2]; default: 0;
 *  Write 1 to clear lp_core_ahb_timeout int
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR    (BIT(2))
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR_M  (LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR_V << LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR_S)
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_INT_CLR_S  2
/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR : WT; bitpos: [3]; default: 0;
 *  Write 1 to clear lp_core_ibus_timeout int
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR    (BIT(3))
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR_M  (LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR_V << LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR_S)
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_INT_CLR_S  3
/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR : WT; bitpos: [4]; default: 0;
 *  Write 1 to clear lp_core_dbus_timeout int
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR    (BIT(4))
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR_M  (LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR_V << LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR_S)
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_INT_CLR_S  4
/** LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR : WT; bitpos: [5]; default: 0;
 *  Write 1 to clear etm tasl ulp int
 */
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR    (BIT(5))
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR_M  (LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR_V << LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR_S)
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_ETM_TASK_ULP_INT_CLR_S  5
/** LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR : WT; bitpos: [6]; default: 0;
 *  Write 1 to clear slow_clk_tick int
 */
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR    (BIT(6))
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR_M  (LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR_V << LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR_S)
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR_V  0x00000001U
#define LP_SYSTEM_REG_SLOW_CLK_TICK_INT_CLR_S  6

/** LP_SYSTEM_REG_HP_MEM_AUX_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_HP_MEM_AUX_CTRL_REG (DR_REG_LP_SYS_BASE + 0x180)
/** LP_SYSTEM_REG_HP_MEM_AUX_CTRL : R/W; bitpos: [31:0]; default: 8304;
 *  need_des
 */
#define LP_SYSTEM_REG_HP_MEM_AUX_CTRL    0xFFFFFFFFU
#define LP_SYSTEM_REG_HP_MEM_AUX_CTRL_M  (LP_SYSTEM_REG_HP_MEM_AUX_CTRL_V << LP_SYSTEM_REG_HP_MEM_AUX_CTRL_S)
#define LP_SYSTEM_REG_HP_MEM_AUX_CTRL_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_HP_MEM_AUX_CTRL_S  0

/** LP_SYSTEM_REG_LP_MEM_AUX_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_MEM_AUX_CTRL_REG (DR_REG_LP_SYS_BASE + 0x184)
/** LP_SYSTEM_REG_LP_MEM_AUX_CTRL : R/W; bitpos: [31:0]; default: 8304;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_MEM_AUX_CTRL    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_MEM_AUX_CTRL_M  (LP_SYSTEM_REG_LP_MEM_AUX_CTRL_V << LP_SYSTEM_REG_LP_MEM_AUX_CTRL_S)
#define LP_SYSTEM_REG_LP_MEM_AUX_CTRL_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_MEM_AUX_CTRL_S  0

/** LP_SYSTEM_REG_HP_ROM_AUX_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_HP_ROM_AUX_CTRL_REG (DR_REG_LP_SYS_BASE + 0x188)
/** LP_SYSTEM_REG_HP_ROM_AUX_CTRL : R/W; bitpos: [31:0]; default: 112;
 *  need_des
 */
#define LP_SYSTEM_REG_HP_ROM_AUX_CTRL    0xFFFFFFFFU
#define LP_SYSTEM_REG_HP_ROM_AUX_CTRL_M  (LP_SYSTEM_REG_HP_ROM_AUX_CTRL_V << LP_SYSTEM_REG_HP_ROM_AUX_CTRL_S)
#define LP_SYSTEM_REG_HP_ROM_AUX_CTRL_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_HP_ROM_AUX_CTRL_S  0

/** LP_SYSTEM_REG_LP_ROM_AUX_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_ROM_AUX_CTRL_REG (DR_REG_LP_SYS_BASE + 0x18c)
/** LP_SYSTEM_REG_LP_ROM_AUX_CTRL : R/W; bitpos: [31:0]; default: 112;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_ROM_AUX_CTRL    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_ROM_AUX_CTRL_M  (LP_SYSTEM_REG_LP_ROM_AUX_CTRL_V << LP_SYSTEM_REG_LP_ROM_AUX_CTRL_S)
#define LP_SYSTEM_REG_LP_ROM_AUX_CTRL_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_ROM_AUX_CTRL_S  0

/** LP_SYSTEM_REG_LP_CPU_DBG_PC_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CPU_DBG_PC_REG (DR_REG_LP_SYS_BASE + 0x190)
/** LP_SYSTEM_REG_LP_CPU_DBG_PC : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CPU_DBG_PC    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_CPU_DBG_PC_M  (LP_SYSTEM_REG_LP_CPU_DBG_PC_V << LP_SYSTEM_REG_LP_CPU_DBG_PC_S)
#define LP_SYSTEM_REG_LP_CPU_DBG_PC_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_CPU_DBG_PC_S  0

/** LP_SYSTEM_REG_LP_CPU_EXC_PC_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CPU_EXC_PC_REG (DR_REG_LP_SYS_BASE + 0x194)
/** LP_SYSTEM_REG_LP_CPU_EXC_PC : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CPU_EXC_PC    0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_CPU_EXC_PC_M  (LP_SYSTEM_REG_LP_CPU_EXC_PC_V << LP_SYSTEM_REG_LP_CPU_EXC_PC_S)
#define LP_SYSTEM_REG_LP_CPU_EXC_PC_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_LP_CPU_EXC_PC_S  0

/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_REG (DR_REG_LP_SYS_BASE + 0x198)
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR    0xFFFFFFFFU
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ADDR_S  0

/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_INFO_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_INFO_REG (DR_REG_LP_SYS_BASE + 0x19c)
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID : RO; bitpos: [4:0]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID    0x0000001FU
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID_V  0x0000001FU
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_ID_S  0
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR : RO; bitpos: [5]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR    (BIT(5))
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR_V  0x00000001U
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_WR_S  5
/** LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE    (BIT(6))
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE_M  (LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE_V << LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE_S)
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE_V  0x00000001U
#define LP_SYSTEM_REG_IDBUS_ADDRHOLE_SECURE_S  6

/** LP_SYSTEM_REG_HP_POR_RST_BYPASS_CTRL_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_HP_POR_RST_BYPASS_CTRL_REG (DR_REG_LP_SYS_BASE + 0x1a0)
/** LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL : R/W; bitpos: [15:8]; default: 255;
 *  [15] 1'b1: po_cnnt_rstn bypass sys_sw_rstn
 *  [14] 1'b1: po_cnnt_rstn bypass hp_wdt_sys_rstn
 *  [13] 1'b1: po_cnnt_rstn bypass hp_cpu_intrusion_rstn
 *  [12] 1'b1: po_cnnt_rstn bypass hp_sdio_sys_rstn
 *  [11] 1'b1: po_cnnt_rstn bypass usb_jtag_chip_rst
 *  [10] 1'b1: po_cnnt_rstn bypass usb_uart_chip_rst
 *  [9] 1'b1: po_cnnt_rstn bypass lp_wdt_hp_sys_rstn
 *  [8] 1'b1: po_cnnt_rstn bypass efuse_err_rstn
 */
#define LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL    0x000000FFU
#define LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL_M  (LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL_V << LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL_S)
#define LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL_V  0x000000FFU
#define LP_SYSTEM_REG_HP_PO_CNNT_RSTN_BYPASS_CTRL_S  8
/** LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL : R/W; bitpos: [31:24]; default: 255;
 *  [31] 1'b1: po_rstn bypass sys_sw_rstn
 *  [30] 1'b1: po_rstn bypass hp_wdt_sys_rstn
 *  [29] 1'b1: po_rstn bypass hp_cpu_intrusion_rstn
 *  [28] 1'b1: po_rstn bypass hp_sdio_sys_rstn
 *  [27] 1'b1: po_rstn bypass usb_jtag_chip_rst
 *  [26] 1'b1: po_rstn bypass usb_uart_chip_rst
 *  [25] 1'b1: po_rstn bypass lp_wdt_hp_sys_rstn
 *  [24] 1'b1: po_rstn bypass efuse_err_rstn
 */
#define LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL    0x000000FFU
#define LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL_M  (LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL_V << LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL_S)
#define LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL_V  0x000000FFU
#define LP_SYSTEM_REG_HP_PO_RSTN_BYPASS_CTRL_S  24

/** LP_SYSTEM_REG_RNG_DATA_REG register
 *  rng data register
 */
#define LP_SYSTEM_REG_RNG_DATA_REG (DR_REG_LP_SYS_BASE + 0x1a4)
/** LP_SYSTEM_REG_RND_DATA : RO; bitpos: [31:0]; default: 0;
 *  result of rng output
 */
#define LP_SYSTEM_REG_RND_DATA    0xFFFFFFFFU
#define LP_SYSTEM_REG_RND_DATA_M  (LP_SYSTEM_REG_RND_DATA_V << LP_SYSTEM_REG_RND_DATA_S)
#define LP_SYSTEM_REG_RND_DATA_V  0xFFFFFFFFU
#define LP_SYSTEM_REG_RND_DATA_S  0

/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_REG (DR_REG_LP_SYS_BASE + 0x1b0)
/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN : R/W; bitpos: [0]; default: 1;
 *  set this field to 1 to enable lp core ahb timeout handle
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN    (BIT(0))
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN_M  (LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN_V << LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN_S)
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_EN_S  0
/** LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES : R/W; bitpos: [16:1]; default: 65535;
 *  This field used to set lp core ahb bus timeout  threshold
 */
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES    0x0000FFFFU
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES_M  (LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES_V << LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES_S)
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES_V  0x0000FFFFU
#define LP_SYSTEM_REG_LP_CORE_AHB_TIMEOUT_THRES_S  1
/** LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN : R/W; bitpos: [17]; default: 1;
 *  set this field to 1 to enable lp2hp ahb timeout handle
 */
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN    (BIT(17))
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN_M  (LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN_V << LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN_S)
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN_V  0x00000001U
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_EN_S  17
/** LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES : R/W; bitpos: [22:18]; default: 31;
 *  This field used to set lp2hp ahb bus timeout  threshold
 */
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES    0x0000001FU
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES_M  (LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES_V << LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES_S)
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES_V  0x0000001FU
#define LP_SYSTEM_REG_LP2HP_AHB_TIMEOUT_THRES_S  18

/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_REG (DR_REG_LP_SYS_BASE + 0x1b4)
/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN : R/W; bitpos: [0]; default: 1;
 *  set this field to 1 to enable lp core ibus timeout handle
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN    (BIT(0))
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN_M  (LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN_V << LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN_S)
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_EN_S  0
/** LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES : R/W; bitpos: [16:1]; default: 65535;
 *  This field used to set lp core ibus timeout  threshold
 */
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES    0x0000FFFFU
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES_M  (LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES_V << LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES_S)
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES_V  0x0000FFFFU
#define LP_SYSTEM_REG_LP_CORE_IBUS_TIMEOUT_THRES_S  1

/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_REG (DR_REG_LP_SYS_BASE + 0x1b8)
/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN : R/W; bitpos: [0]; default: 1;
 *  set this field to 1 to enable lp core dbus timeout handle
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN    (BIT(0))
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN_M  (LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN_V << LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN_S)
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN_V  0x00000001U
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_EN_S  0
/** LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES : R/W; bitpos: [16:1]; default: 65535;
 *  This field used to set lp core dbus timeout  threshold
 */
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES    0x0000FFFFU
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES_M  (LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES_V << LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES_S)
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES_V  0x0000FFFFU
#define LP_SYSTEM_REG_LP_CORE_DBUS_TIMEOUT_THRES_S  1

/** LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_REG register
 *  need_des
 */
#define LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_REG (DR_REG_LP_SYS_BASE + 0x1bc)
/** LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS : R/W; bitpos: [2:0]; default: 0;
 *  Set bit0 to disable ibus err resp;Set bit1 to disable dbus err resp; Set bit 2 to
 *  disable ahb err resp.
 */
#define LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS    0x00000007U
#define LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_M  (LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_V << LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_S)
#define LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_V  0x00000007U
#define LP_SYSTEM_REG_LP_CORE_ERR_RESP_DIS_S  0

/** LP_SYSTEM_REG_RNG_CFG_REG register
 *  rng cfg register
 */
#define LP_SYSTEM_REG_RNG_CFG_REG (DR_REG_LP_SYS_BASE + 0x1c0)
/** LP_SYSTEM_REG_RNG_TIMER_EN : R/W; bitpos: [0]; default: 1;
 *  enable rng timer
 */
#define LP_SYSTEM_REG_RNG_TIMER_EN    (BIT(0))
#define LP_SYSTEM_REG_RNG_TIMER_EN_M  (LP_SYSTEM_REG_RNG_TIMER_EN_V << LP_SYSTEM_REG_RNG_TIMER_EN_S)
#define LP_SYSTEM_REG_RNG_TIMER_EN_V  0x00000001U
#define LP_SYSTEM_REG_RNG_TIMER_EN_S  0
/** LP_SYSTEM_REG_RNG_TIMER_PSCALE : R/W; bitpos: [8:1]; default: 1;
 *  configure ng timer pscale
 */
#define LP_SYSTEM_REG_RNG_TIMER_PSCALE    0x000000FFU
#define LP_SYSTEM_REG_RNG_TIMER_PSCALE_M  (LP_SYSTEM_REG_RNG_TIMER_PSCALE_V << LP_SYSTEM_REG_RNG_TIMER_PSCALE_S)
#define LP_SYSTEM_REG_RNG_TIMER_PSCALE_V  0x000000FFU
#define LP_SYSTEM_REG_RNG_TIMER_PSCALE_S  1
/** LP_SYSTEM_REG_RNG_SAR_ENABLE : R/W; bitpos: [9]; default: 0;
 *  enable rng_saradc
 */
#define LP_SYSTEM_REG_RNG_SAR_ENABLE    (BIT(9))
#define LP_SYSTEM_REG_RNG_SAR_ENABLE_M  (LP_SYSTEM_REG_RNG_SAR_ENABLE_V << LP_SYSTEM_REG_RNG_SAR_ENABLE_S)
#define LP_SYSTEM_REG_RNG_SAR_ENABLE_V  0x00000001U
#define LP_SYSTEM_REG_RNG_SAR_ENABLE_S  9
/** LP_SYSTEM_REG_RNG_SAR_DATA : RO; bitpos: [28:16]; default: 0;
 *  debug rng sar sample cnt
 */
#define LP_SYSTEM_REG_RNG_SAR_DATA    0x00001FFFU
#define LP_SYSTEM_REG_RNG_SAR_DATA_M  (LP_SYSTEM_REG_RNG_SAR_DATA_V << LP_SYSTEM_REG_RNG_SAR_DATA_S)
#define LP_SYSTEM_REG_RNG_SAR_DATA_V  0x00001FFFU
#define LP_SYSTEM_REG_RNG_SAR_DATA_S  16

#ifdef __cplusplus
}
#endif
