/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "modem/reg_base.h"
#ifdef __cplusplus
extern "C" {
#endif

/* MODEM_LPCON_TEST_CONF_REG register*/
#define MODEM_LPCON_TEST_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x0)
/* MODEM_LPCON_CLK_EN : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CLK_EN    (BIT(0))
#define MODEM_LPCON_CLK_EN_M  (MODEM_LPCON_CLK_EN_V << MODEM_LPCON_CLK_EN_S)
#define MODEM_LPCON_CLK_EN_V  0x00000001U
#define MODEM_LPCON_CLK_EN_S  0

/* MODEM_LPCON_LP_TIMER_CONF_REG register*/
#define MODEM_LPCON_LP_TIMER_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x4)
/* MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW    (BIT(0))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_V << MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_S  0
/* MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST : R/W; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST    (BIT(1))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_V << MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_S  1
/* MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL    (BIT(2))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_V << MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_S  2
/* MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K : R/W; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K    (BIT(3))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_V << MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_S  3
/* MODEM_LPCON_CLK_LP_TIMER_DIV_NUM : R/W; bitpos: [15:4]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM    0x00000FFFU
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_M  (MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_V << MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_S)
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_V  0x00000FFFU
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_S  4

/* MODEM_LPCON_COEX_LP_CLK_CONF_REG register*/
#define MODEM_LPCON_COEX_LP_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x8)
/* MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW    (BIT(0))
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_M  (MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_V << MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_S  0
/* MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST : R/W; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST    (BIT(1))
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_M  (MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_V << MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_S  1
/* MODEM_LPCON_CLK_COEX_LP_SEL_XTAL : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL    (BIT(2))
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_M  (MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_V << MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_S  2
/* MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K : R/W; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K    (BIT(3))
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_M  (MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_V << MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_S  3
/* MODEM_LPCON_CLK_COEX_LP_DIV_NUM : R/W; bitpos: [15:4]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM    0x00000FFFU
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM_M  (MODEM_LPCON_CLK_COEX_LP_DIV_NUM_V << MODEM_LPCON_CLK_COEX_LP_DIV_NUM_S)
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM_V  0x00000FFFU
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM_S  4

/* MODEM_LPCON_WIFI_LP_CLK_CONF_REG register*/
#define MODEM_LPCON_WIFI_LP_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0xc)
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW    (BIT(0))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_S  0
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST : R/W; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST    (BIT(1))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_S  1
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL    (BIT(2))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_S  2
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K : R/W; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K    (BIT(3))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_S  3
/* MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM : R/W; bitpos: [15:4]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM    0x00000FFFU
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_M  (MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_V << MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_V  0x00000FFFU
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_S  4

/* MODEM_LPCON_MODEM_SRC_CLK_CONF_REG register*/
#define MODEM_LPCON_MODEM_SRC_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x10)
/* MODEM_LPCON_CLK_MODEM_AON_FORCE : R/W; bitpos: [1:0]; default: 0;*/
#define MODEM_LPCON_CLK_MODEM_AON_FORCE    0x00000003U
#define MODEM_LPCON_CLK_MODEM_AON_FORCE_M  (MODEM_LPCON_CLK_MODEM_AON_FORCE_V << MODEM_LPCON_CLK_MODEM_AON_FORCE_S)
#define MODEM_LPCON_CLK_MODEM_AON_FORCE_V  0x00000003U
#define MODEM_LPCON_CLK_MODEM_AON_FORCE_S  0
/* MODEM_LPCON_MODEM_PWR_32K_FO : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_MODEM_PWR_32K_FO    (BIT(2))
#define MODEM_LPCON_MODEM_PWR_32K_FO_M  (MODEM_LPCON_MODEM_PWR_32K_FO_V << MODEM_LPCON_MODEM_PWR_32K_FO_S)
#define MODEM_LPCON_MODEM_PWR_32K_FO_V  0x00000001U
#define MODEM_LPCON_MODEM_PWR_32K_FO_S  2
/* MODEM_LPCON_MODEM_PWR_FOSC_FO : R/W; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_MODEM_PWR_FOSC_FO    (BIT(3))
#define MODEM_LPCON_MODEM_PWR_FOSC_FO_M  (MODEM_LPCON_MODEM_PWR_FOSC_FO_V << MODEM_LPCON_MODEM_PWR_FOSC_FO_S)
#define MODEM_LPCON_MODEM_PWR_FOSC_FO_V  0x00000001U
#define MODEM_LPCON_MODEM_PWR_FOSC_FO_S  3
/* MODEM_LPCON_MODEM_PWR_SOSC_FO : R/W; bitpos: [4]; default: 0;*/
#define MODEM_LPCON_MODEM_PWR_SOSC_FO    (BIT(4))
#define MODEM_LPCON_MODEM_PWR_SOSC_FO_M  (MODEM_LPCON_MODEM_PWR_SOSC_FO_V << MODEM_LPCON_MODEM_PWR_SOSC_FO_S)
#define MODEM_LPCON_MODEM_PWR_SOSC_FO_V  0x00000001U
#define MODEM_LPCON_MODEM_PWR_SOSC_FO_S  4
/* MODEM_LPCON_MODEM_PWR_XTAL_FO : R/W; bitpos: [5]; default: 0;*/
#define MODEM_LPCON_MODEM_PWR_XTAL_FO    (BIT(5))
#define MODEM_LPCON_MODEM_PWR_XTAL_FO_M  (MODEM_LPCON_MODEM_PWR_XTAL_FO_V << MODEM_LPCON_MODEM_PWR_XTAL_FO_S)
#define MODEM_LPCON_MODEM_PWR_XTAL_FO_V  0x00000001U
#define MODEM_LPCON_MODEM_PWR_XTAL_FO_S  5

/* MODEM_LPCON_MODEM_32K_CLK_CONF_REG register*/
#define MODEM_LPCON_MODEM_32K_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x14)
/* MODEM_LPCON_CLK_MODEM_32K_SEL : R/W; bitpos: [1:0]; default: 0;*/
#define MODEM_LPCON_CLK_MODEM_32K_SEL    0x00000003U
#define MODEM_LPCON_CLK_MODEM_32K_SEL_M  (MODEM_LPCON_CLK_MODEM_32K_SEL_V << MODEM_LPCON_CLK_MODEM_32K_SEL_S)
#define MODEM_LPCON_CLK_MODEM_32K_SEL_V  0x00000003U
#define MODEM_LPCON_CLK_MODEM_32K_SEL_S  0

/* MODEM_LPCON_CLK_CONF_REG register*/
#define MODEM_LPCON_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x18)
/* MODEM_LPCON_CLK_WIFIPWR_EN : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_EN    (BIT(0))
#define MODEM_LPCON_CLK_WIFIPWR_EN_M  (MODEM_LPCON_CLK_WIFIPWR_EN_V << MODEM_LPCON_CLK_WIFIPWR_EN_S)
#define MODEM_LPCON_CLK_WIFIPWR_EN_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_EN_S  0
/* MODEM_LPCON_CLK_COEX_EN : R/W; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_EN    (BIT(1))
#define MODEM_LPCON_CLK_COEX_EN_M  (MODEM_LPCON_CLK_COEX_EN_V << MODEM_LPCON_CLK_COEX_EN_S)
#define MODEM_LPCON_CLK_COEX_EN_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_EN_S  1
/* MODEM_LPCON_CLK_I2C_MST_EN : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_CLK_I2C_MST_EN    (BIT(2))
#define MODEM_LPCON_CLK_I2C_MST_EN_M  (MODEM_LPCON_CLK_I2C_MST_EN_V << MODEM_LPCON_CLK_I2C_MST_EN_S)
#define MODEM_LPCON_CLK_I2C_MST_EN_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_EN_S  2
/* MODEM_LPCON_CLK_LP_TIMER_EN : R/W; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_EN    (BIT(3))
#define MODEM_LPCON_CLK_LP_TIMER_EN_M  (MODEM_LPCON_CLK_LP_TIMER_EN_V << MODEM_LPCON_CLK_LP_TIMER_EN_S)
#define MODEM_LPCON_CLK_LP_TIMER_EN_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_EN_S  3
/* MODEM_LPCON_CLK_ANA_XTAL_EN : R/W; bitpos: [4]; default: 1;*/
#define MODEM_LPCON_CLK_ANA_XTAL_EN    (BIT(4))
#define MODEM_LPCON_CLK_ANA_XTAL_EN_M  (MODEM_LPCON_CLK_ANA_XTAL_EN_V << MODEM_LPCON_CLK_ANA_XTAL_EN_S)
#define MODEM_LPCON_CLK_ANA_XTAL_EN_V  0x00000001U
#define MODEM_LPCON_CLK_ANA_XTAL_EN_S  4

/* MODEM_LPCON_CLK_CONF_FORCE_ON_REG register*/
#define MODEM_LPCON_CLK_CONF_FORCE_ON_REG (DR_REG_MODEM_LPCON_BASE + 0x1c)
/* MODEM_LPCON_CLK_WIFIPWR_FO : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_FO    (BIT(0))
#define MODEM_LPCON_CLK_WIFIPWR_FO_M  (MODEM_LPCON_CLK_WIFIPWR_FO_V << MODEM_LPCON_CLK_WIFIPWR_FO_S)
#define MODEM_LPCON_CLK_WIFIPWR_FO_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_FO_S  0
/* MODEM_LPCON_CLK_COEX_FO : R/W; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_FO    (BIT(1))
#define MODEM_LPCON_CLK_COEX_FO_M  (MODEM_LPCON_CLK_COEX_FO_V << MODEM_LPCON_CLK_COEX_FO_S)
#define MODEM_LPCON_CLK_COEX_FO_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_FO_S  1
/* MODEM_LPCON_CLK_I2C_MST_FO : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_CLK_I2C_MST_FO    (BIT(2))
#define MODEM_LPCON_CLK_I2C_MST_FO_M  (MODEM_LPCON_CLK_I2C_MST_FO_V << MODEM_LPCON_CLK_I2C_MST_FO_S)
#define MODEM_LPCON_CLK_I2C_MST_FO_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_FO_S  2
/* MODEM_LPCON_CLK_LP_TIMER_FO : R/W; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_CLK_LP_TIMER_FO    (BIT(3))
#define MODEM_LPCON_CLK_LP_TIMER_FO_M  (MODEM_LPCON_CLK_LP_TIMER_FO_V << MODEM_LPCON_CLK_LP_TIMER_FO_S)
#define MODEM_LPCON_CLK_LP_TIMER_FO_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_FO_S  3
/* MODEM_LPCON_CLK_AGC_MEM_FO : R/W; bitpos: [4]; default: 0;*/
#define MODEM_LPCON_CLK_AGC_MEM_FO    (BIT(4))
#define MODEM_LPCON_CLK_AGC_MEM_FO_M  (MODEM_LPCON_CLK_AGC_MEM_FO_V << MODEM_LPCON_CLK_AGC_MEM_FO_S)
#define MODEM_LPCON_CLK_AGC_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_AGC_MEM_FO_S  4
/* MODEM_LPCON_CLK_PBUS_MEM_FO : R/W; bitpos: [5]; default: 0;*/
#define MODEM_LPCON_CLK_PBUS_MEM_FO    (BIT(5))
#define MODEM_LPCON_CLK_PBUS_MEM_FO_M  (MODEM_LPCON_CLK_PBUS_MEM_FO_V << MODEM_LPCON_CLK_PBUS_MEM_FO_S)
#define MODEM_LPCON_CLK_PBUS_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_PBUS_MEM_FO_S  5
/* MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO : R/W; bitpos: [6]; default: 0;*/
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO    (BIT(6))
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_M  (MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_V << MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_S)
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_S  6
/* MODEM_LPCON_CLK_AGC_DCMEM_FO : R/W; bitpos: [7]; default: 0;*/
#define MODEM_LPCON_CLK_AGC_DCMEM_FO    (BIT(7))
#define MODEM_LPCON_CLK_AGC_DCMEM_FO_M  (MODEM_LPCON_CLK_AGC_DCMEM_FO_V << MODEM_LPCON_CLK_AGC_DCMEM_FO_S)
#define MODEM_LPCON_CLK_AGC_DCMEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_AGC_DCMEM_FO_S  7
/* MODEM_LPCON_CLK_BCMEM_FO : R/W; bitpos: [8]; default: 0;*/
#define MODEM_LPCON_CLK_BCMEM_FO    (BIT(8))
#define MODEM_LPCON_CLK_BCMEM_FO_M  (MODEM_LPCON_CLK_BCMEM_FO_V << MODEM_LPCON_CLK_BCMEM_FO_S)
#define MODEM_LPCON_CLK_BCMEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_BCMEM_FO_S  8
/* MODEM_LPCON_CLK_I2C_MST_MEM_FO : R/W; bitpos: [9]; default: 0;*/
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO    (BIT(9))
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO_M  (MODEM_LPCON_CLK_I2C_MST_MEM_FO_V << MODEM_LPCON_CLK_I2C_MST_MEM_FO_S)
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO_S  9

/* MODEM_LPCON_CLK_CONF_POWER_ST_REG register*/
#define MODEM_LPCON_CLK_CONF_POWER_ST_REG (DR_REG_MODEM_LPCON_BASE + 0x20)
/* MODEM_LPCON_CLK_WIFIPWR_ST_MAP : R/W; bitpos: [19:16]; default: 0;*/
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP_M  (MODEM_LPCON_CLK_WIFIPWR_ST_MAP_V << MODEM_LPCON_CLK_WIFIPWR_ST_MAP_S)
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP_S  16
/* MODEM_LPCON_CLK_COEX_ST_MAP : R/W; bitpos: [23:20]; default: 0;*/
#define MODEM_LPCON_CLK_COEX_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_COEX_ST_MAP_M  (MODEM_LPCON_CLK_COEX_ST_MAP_V << MODEM_LPCON_CLK_COEX_ST_MAP_S)
#define MODEM_LPCON_CLK_COEX_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_COEX_ST_MAP_S  20
/* MODEM_LPCON_CLK_I2C_MST_ST_MAP : R/W; bitpos: [27:24]; default: 0;*/
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP_M  (MODEM_LPCON_CLK_I2C_MST_ST_MAP_V << MODEM_LPCON_CLK_I2C_MST_ST_MAP_S)
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP_S  24
/* MODEM_LPCON_CLK_LP_APB_ST_MAP : R/W; bitpos: [31:28]; default: 0;*/
#define MODEM_LPCON_CLK_LP_APB_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_LP_APB_ST_MAP_M  (MODEM_LPCON_CLK_LP_APB_ST_MAP_V << MODEM_LPCON_CLK_LP_APB_ST_MAP_S)
#define MODEM_LPCON_CLK_LP_APB_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_LP_APB_ST_MAP_S  28

/* MODEM_LPCON_RST_CONF_REG register*/
#define MODEM_LPCON_RST_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x24)
/* MODEM_LPCON_RST_WIFIPWR : WO; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_RST_WIFIPWR    (BIT(0))
#define MODEM_LPCON_RST_WIFIPWR_M  (MODEM_LPCON_RST_WIFIPWR_V << MODEM_LPCON_RST_WIFIPWR_S)
#define MODEM_LPCON_RST_WIFIPWR_V  0x00000001U
#define MODEM_LPCON_RST_WIFIPWR_S  0
/* MODEM_LPCON_RST_COEX : WO; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_RST_COEX    (BIT(1))
#define MODEM_LPCON_RST_COEX_M  (MODEM_LPCON_RST_COEX_V << MODEM_LPCON_RST_COEX_S)
#define MODEM_LPCON_RST_COEX_V  0x00000001U
#define MODEM_LPCON_RST_COEX_S  1
/* MODEM_LPCON_RST_I2C_MST : WO; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_RST_I2C_MST    (BIT(2))
#define MODEM_LPCON_RST_I2C_MST_M  (MODEM_LPCON_RST_I2C_MST_V << MODEM_LPCON_RST_I2C_MST_S)
#define MODEM_LPCON_RST_I2C_MST_V  0x00000001U
#define MODEM_LPCON_RST_I2C_MST_S  2
/* MODEM_LPCON_RST_LP_TIMER : WO; bitpos: [3]; default: 0;*/
#define MODEM_LPCON_RST_LP_TIMER    (BIT(3))
#define MODEM_LPCON_RST_LP_TIMER_M  (MODEM_LPCON_RST_LP_TIMER_V << MODEM_LPCON_RST_LP_TIMER_S)
#define MODEM_LPCON_RST_LP_TIMER_V  0x00000001U
#define MODEM_LPCON_RST_LP_TIMER_S  3
/* MODEM_LPCON_RST_DCMEM : WO; bitpos: [4]; default: 0;*/
#define MODEM_LPCON_RST_DCMEM    (BIT(4))
#define MODEM_LPCON_RST_DCMEM_M  (MODEM_LPCON_RST_DCMEM_V << MODEM_LPCON_RST_DCMEM_S)
#define MODEM_LPCON_RST_DCMEM_V  0x00000001U
#define MODEM_LPCON_RST_DCMEM_S  4
/* MODEM_LPCON_RST_MODEM_POWER_CTRL : WO; bitpos: [5]; default: 0;*/
#define MODEM_LPCON_RST_MODEM_POWER_CTRL    (BIT(5))
#define MODEM_LPCON_RST_MODEM_POWER_CTRL_M  (MODEM_LPCON_RST_MODEM_POWER_CTRL_V << MODEM_LPCON_RST_MODEM_POWER_CTRL_S)
#define MODEM_LPCON_RST_MODEM_POWER_CTRL_V  0x00000001U
#define MODEM_LPCON_RST_MODEM_POWER_CTRL_S  5

/* MODEM_LPCON_TICK_CONF_REG register*/
#define MODEM_LPCON_TICK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x28)
/* MODEM_LPCON_MODEM_PWR_TICK_TARGET : R/W; bitpos: [5:0]; default: 39;*/
#define MODEM_LPCON_MODEM_PWR_TICK_TARGET    0x0000003FU
#define MODEM_LPCON_MODEM_PWR_TICK_TARGET_M  (MODEM_LPCON_MODEM_PWR_TICK_TARGET_V << MODEM_LPCON_MODEM_PWR_TICK_TARGET_S)
#define MODEM_LPCON_MODEM_PWR_TICK_TARGET_V  0x0000003FU
#define MODEM_LPCON_MODEM_PWR_TICK_TARGET_S  0

/* MODEM_LPCON_MEM_CONF_REG register*/
#define MODEM_LPCON_MEM_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x2c)
/* MODEM_LPCON_DC_MEM_MODE : R/W; bitpos: [2:0]; default: 0;*/
#define MODEM_LPCON_DC_MEM_MODE    0x00000007U
#define MODEM_LPCON_DC_MEM_MODE_M  (MODEM_LPCON_DC_MEM_MODE_V << MODEM_LPCON_DC_MEM_MODE_S)
#define MODEM_LPCON_DC_MEM_MODE_V  0x00000007U
#define MODEM_LPCON_DC_MEM_MODE_S  0
/* MODEM_LPCON_DC_MEM_FORCE : R/W; bitpos: [3]; default: 1;*/
#define MODEM_LPCON_DC_MEM_FORCE    (BIT(3))
#define MODEM_LPCON_DC_MEM_FORCE_M  (MODEM_LPCON_DC_MEM_FORCE_V << MODEM_LPCON_DC_MEM_FORCE_S)
#define MODEM_LPCON_DC_MEM_FORCE_V  0x00000001U
#define MODEM_LPCON_DC_MEM_FORCE_S  3
/* MODEM_LPCON_AGC_MEM_MODE : R/W; bitpos: [6:4]; default: 0;*/
#define MODEM_LPCON_AGC_MEM_MODE    0x00000007U
#define MODEM_LPCON_AGC_MEM_MODE_M  (MODEM_LPCON_AGC_MEM_MODE_V << MODEM_LPCON_AGC_MEM_MODE_S)
#define MODEM_LPCON_AGC_MEM_MODE_V  0x00000007U
#define MODEM_LPCON_AGC_MEM_MODE_S  4
/* MODEM_LPCON_AGC_MEM_FORCE : R/W; bitpos: [7]; default: 1;*/
#define MODEM_LPCON_AGC_MEM_FORCE    (BIT(7))
#define MODEM_LPCON_AGC_MEM_FORCE_M  (MODEM_LPCON_AGC_MEM_FORCE_V << MODEM_LPCON_AGC_MEM_FORCE_S)
#define MODEM_LPCON_AGC_MEM_FORCE_V  0x00000001U
#define MODEM_LPCON_AGC_MEM_FORCE_S  7
/* MODEM_LPCON_PBUS_MEM_MODE : R/W; bitpos: [10:8]; default: 0;*/
#define MODEM_LPCON_PBUS_MEM_MODE    0x00000007U
#define MODEM_LPCON_PBUS_MEM_MODE_M  (MODEM_LPCON_PBUS_MEM_MODE_V << MODEM_LPCON_PBUS_MEM_MODE_S)
#define MODEM_LPCON_PBUS_MEM_MODE_V  0x00000007U
#define MODEM_LPCON_PBUS_MEM_MODE_S  8
/* MODEM_LPCON_PBUS_MEM_FORCE : R/W; bitpos: [11]; default: 1;*/
#define MODEM_LPCON_PBUS_MEM_FORCE    (BIT(11))
#define MODEM_LPCON_PBUS_MEM_FORCE_M  (MODEM_LPCON_PBUS_MEM_FORCE_V << MODEM_LPCON_PBUS_MEM_FORCE_S)
#define MODEM_LPCON_PBUS_MEM_FORCE_V  0x00000001U
#define MODEM_LPCON_PBUS_MEM_FORCE_S  11
/* MODEM_LPCON_BC_MEM_MODE : R/W; bitpos: [14:12]; default: 0;*/
#define MODEM_LPCON_BC_MEM_MODE    0x00000007U
#define MODEM_LPCON_BC_MEM_MODE_M  (MODEM_LPCON_BC_MEM_MODE_V << MODEM_LPCON_BC_MEM_MODE_S)
#define MODEM_LPCON_BC_MEM_MODE_V  0x00000007U
#define MODEM_LPCON_BC_MEM_MODE_S  12
/* MODEM_LPCON_BC_MEM_FORCE : R/W; bitpos: [15]; default: 1;*/
#define MODEM_LPCON_BC_MEM_FORCE    (BIT(15))
#define MODEM_LPCON_BC_MEM_FORCE_M  (MODEM_LPCON_BC_MEM_FORCE_V << MODEM_LPCON_BC_MEM_FORCE_S)
#define MODEM_LPCON_BC_MEM_FORCE_V  0x00000001U
#define MODEM_LPCON_BC_MEM_FORCE_S  15
/* MODEM_LPCON_I2C_MST_MEM_MODE : R/W; bitpos: [18:16]; default: 0;*/
#define MODEM_LPCON_I2C_MST_MEM_MODE    0x00000007U
#define MODEM_LPCON_I2C_MST_MEM_MODE_M  (MODEM_LPCON_I2C_MST_MEM_MODE_V << MODEM_LPCON_I2C_MST_MEM_MODE_S)
#define MODEM_LPCON_I2C_MST_MEM_MODE_V  0x00000007U
#define MODEM_LPCON_I2C_MST_MEM_MODE_S  16
/* MODEM_LPCON_I2C_MST_MEM_FORCE : R/W; bitpos: [19]; default: 1;*/
#define MODEM_LPCON_I2C_MST_MEM_FORCE    (BIT(19))
#define MODEM_LPCON_I2C_MST_MEM_FORCE_M  (MODEM_LPCON_I2C_MST_MEM_FORCE_V << MODEM_LPCON_I2C_MST_MEM_FORCE_S)
#define MODEM_LPCON_I2C_MST_MEM_FORCE_V  0x00000001U
#define MODEM_LPCON_I2C_MST_MEM_FORCE_S  19
/* MODEM_LPCON_CHAN_FREQ_MEM_MODE : R/W; bitpos: [22:20]; default: 0;*/
#define MODEM_LPCON_CHAN_FREQ_MEM_MODE    0x00000007U
#define MODEM_LPCON_CHAN_FREQ_MEM_MODE_M  (MODEM_LPCON_CHAN_FREQ_MEM_MODE_V << MODEM_LPCON_CHAN_FREQ_MEM_MODE_S)
#define MODEM_LPCON_CHAN_FREQ_MEM_MODE_V  0x00000007U
#define MODEM_LPCON_CHAN_FREQ_MEM_MODE_S  20
/* MODEM_LPCON_CHAN_FREQ_MEM_FORCE : R/W; bitpos: [23]; default: 1;*/
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE    (BIT(23))
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_M  (MODEM_LPCON_CHAN_FREQ_MEM_FORCE_V << MODEM_LPCON_CHAN_FREQ_MEM_FORCE_S)
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_V  0x00000001U
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_S  23

/* MODEM_LPCON_MEM_RF1_AUX_CTRL_REG register*/
#define MODEM_LPCON_MEM_RF1_AUX_CTRL_REG (DR_REG_MODEM_LPCON_BASE + 0x30)
/* MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL : R/W; bitpos: [31:0]; default: 10320;*/
#define MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL    0xFFFFFFFFU
#define MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL_M  (MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL_V << MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL_S)
#define MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL_V  0xFFFFFFFFU
#define MODEM_LPCON_MODEM_PWR_RF1_AUX_CTRL_S  0

/* MODEM_LPCON_MEM_RF2_AUX_CTRL_REG register*/
#define MODEM_LPCON_MEM_RF2_AUX_CTRL_REG (DR_REG_MODEM_LPCON_BASE + 0x34)
/* MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL : R/W; bitpos: [31:0]; default: 0;*/
#define MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL    0xFFFFFFFFU
#define MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL_M  (MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL_V << MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL_S)
#define MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL_V  0xFFFFFFFFU
#define MODEM_LPCON_MODEM_PWR_RF2_AUX_CTRL_S  0

/* MODEM_LPCON_APB_MEM_SEL_REG register*/
#define MODEM_LPCON_APB_MEM_SEL_REG (DR_REG_MODEM_LPCON_BASE + 0x38)
/* MODEM_LPCON_CHAN_FREQ_MEM_EN : R/W; bitpos: [0]; default: 0;*/
#define MODEM_LPCON_CHAN_FREQ_MEM_EN    (BIT(0))
#define MODEM_LPCON_CHAN_FREQ_MEM_EN_M  (MODEM_LPCON_CHAN_FREQ_MEM_EN_V << MODEM_LPCON_CHAN_FREQ_MEM_EN_S)
#define MODEM_LPCON_CHAN_FREQ_MEM_EN_V  0x00000001U
#define MODEM_LPCON_CHAN_FREQ_MEM_EN_S  0
/* MODEM_LPCON_PBUS_MEM_EN : R/W; bitpos: [1]; default: 0;*/
#define MODEM_LPCON_PBUS_MEM_EN    (BIT(1))
#define MODEM_LPCON_PBUS_MEM_EN_M  (MODEM_LPCON_PBUS_MEM_EN_V << MODEM_LPCON_PBUS_MEM_EN_S)
#define MODEM_LPCON_PBUS_MEM_EN_V  0x00000001U
#define MODEM_LPCON_PBUS_MEM_EN_S  1
/* MODEM_LPCON_AGC_MEM_EN : R/W; bitpos: [2]; default: 0;*/
#define MODEM_LPCON_AGC_MEM_EN    (BIT(2))
#define MODEM_LPCON_AGC_MEM_EN_M  (MODEM_LPCON_AGC_MEM_EN_V << MODEM_LPCON_AGC_MEM_EN_S)
#define MODEM_LPCON_AGC_MEM_EN_V  0x00000001U
#define MODEM_LPCON_AGC_MEM_EN_S  2
/* MODEM_LPCON_PWR_MEM_BASE : R/W; bitpos: [18:3]; default: 0;*/
#define MODEM_LPCON_PWR_MEM_BASE    0x0000FFFFU
#define MODEM_LPCON_PWR_MEM_BASE_M  (MODEM_LPCON_PWR_MEM_BASE_V << MODEM_LPCON_PWR_MEM_BASE_S)
#define MODEM_LPCON_PWR_MEM_BASE_V  0x0000FFFFU
#define MODEM_LPCON_PWR_MEM_BASE_S  3

/* MODEM_LPCON_DCMEM_VALID_0_REG register*/
#define MODEM_LPCON_DCMEM_VALID_0_REG (DR_REG_MODEM_LPCON_BASE + 0x3c)
/* MODEM_LPCON_DCMEM_VALID_0 : RO; bitpos: [31:0]; default: 0;*/
#define MODEM_LPCON_DCMEM_VALID_0    0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_0_M  (MODEM_LPCON_DCMEM_VALID_0_V << MODEM_LPCON_DCMEM_VALID_0_S)
#define MODEM_LPCON_DCMEM_VALID_0_V  0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_0_S  0

/* MODEM_LPCON_DCMEM_VALID_1_REG register*/
#define MODEM_LPCON_DCMEM_VALID_1_REG (DR_REG_MODEM_LPCON_BASE + 0x40)
/* MODEM_LPCON_DCMEM_VALID_1 : RO; bitpos: [31:0]; default: 0;*/
#define MODEM_LPCON_DCMEM_VALID_1    0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_1_M  (MODEM_LPCON_DCMEM_VALID_1_V << MODEM_LPCON_DCMEM_VALID_1_S)
#define MODEM_LPCON_DCMEM_VALID_1_V  0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_1_S  0

/* MODEM_LPCON_DCMEM_VALID_2_REG register*/
#define MODEM_LPCON_DCMEM_VALID_2_REG (DR_REG_MODEM_LPCON_BASE + 0x44)
/* MODEM_LPCON_DCMEM_VALID_2 : RO; bitpos: [31:0]; default: 0;*/
#define MODEM_LPCON_DCMEM_VALID_2    0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_2_M  (MODEM_LPCON_DCMEM_VALID_2_V << MODEM_LPCON_DCMEM_VALID_2_S)
#define MODEM_LPCON_DCMEM_VALID_2_V  0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_2_S  0

/* MODEM_LPCON_DCMEM_VALID_3_REG register*/
#define MODEM_LPCON_DCMEM_VALID_3_REG (DR_REG_MODEM_LPCON_BASE + 0x48)
/* MODEM_LPCON_DCMEM_VALID_3 : RO; bitpos: [31:0]; default: 0;*/
#define MODEM_LPCON_DCMEM_VALID_3    0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_3_M  (MODEM_LPCON_DCMEM_VALID_3_V << MODEM_LPCON_DCMEM_VALID_3_S)
#define MODEM_LPCON_DCMEM_VALID_3_V  0xFFFFFFFFU
#define MODEM_LPCON_DCMEM_VALID_3_S  0

/* MODEM_LPCON_DATE_REG register*/
#define MODEM_LPCON_DATE_REG (DR_REG_MODEM_LPCON_BASE + 0x4c)
/* MODEM_LPCON_DATE : R/W; bitpos: [27:0]; default: 37823024;*/
#define MODEM_LPCON_DATE    0x0FFFFFFFU
#define MODEM_LPCON_DATE_M  (MODEM_LPCON_DATE_V << MODEM_LPCON_DATE_S)
#define MODEM_LPCON_DATE_V  0x0FFFFFFFU
#define MODEM_LPCON_DATE_S  0

#ifdef __cplusplus
}
#endif
