/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_REG register
 *  WIFI_MAC_INTR mapping register
 */
#define INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x0)
/** INTERRUPT_CORE0_WIFI_MAC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_WIFI_MAC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_M  (INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_V << INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_S)
#define INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_WIFI_MAC_INTR_MAP_S  0
/** INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_WIFI_MAC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_REG register
 *  WIFI_MAC_NMI mapping register
 */
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_REG (DR_REG_INTMTX_BASE + 0x4)
/** INTERRUPT_CORE0_WIFI_MAC_NMI_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP    0x0000003FU
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_M  (INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_V << INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_S)
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_S  0
/** INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC_M  (INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC_V << INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_WIFI_MAC_NMI_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_REG register
 *  WIFI_PWR_INTR mapping register
 */
#define INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x8)
/** INTERRUPT_CORE0_WIFI_PWR_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_WIFI_PWR_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_M  (INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_V << INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_S)
#define INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_WIFI_PWR_INTR_MAP_S  0
/** INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_WIFI_PWR_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_WIFI_BB_INTR_MAP_REG register
 *  WIFI_BB_INTR mapping register
 */
#define INTERRUPT_CORE0_WIFI_BB_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc)
/** INTERRUPT_CORE0_WIFI_BB_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_WIFI_BB_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_WIFI_BB_INTR_MAP_M  (INTERRUPT_CORE0_WIFI_BB_INTR_MAP_V << INTERRUPT_CORE0_WIFI_BB_INTR_MAP_S)
#define INTERRUPT_CORE0_WIFI_BB_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_WIFI_BB_INTR_MAP_S  0
/** INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_WIFI_BB_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_BT_MAC_INTR_MAP_REG register
 *  BT_MAC_INTR mapping register
 */
#define INTERRUPT_CORE0_BT_MAC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x10)
/** INTERRUPT_CORE0_BT_MAC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_BT_MAC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_BT_MAC_INTR_MAP_M  (INTERRUPT_CORE0_BT_MAC_INTR_MAP_V << INTERRUPT_CORE0_BT_MAC_INTR_MAP_S)
#define INTERRUPT_CORE0_BT_MAC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_BT_MAC_INTR_MAP_S  0
/** INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_BT_MAC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_BT_BB_INTR_MAP_REG register
 *  BT_BB_INTR mapping register
 */
#define INTERRUPT_CORE0_BT_BB_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x14)
/** INTERRUPT_CORE0_BT_BB_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_BT_BB_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_BT_BB_INTR_MAP_M  (INTERRUPT_CORE0_BT_BB_INTR_MAP_V << INTERRUPT_CORE0_BT_BB_INTR_MAP_S)
#define INTERRUPT_CORE0_BT_BB_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_BT_BB_INTR_MAP_S  0
/** INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_BT_BB_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_BT_BB_NMI_MAP_REG register
 *  BT_BB_NMI mapping register
 */
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_REG (DR_REG_INTMTX_BASE + 0x18)
/** INTERRUPT_CORE0_BT_BB_NMI_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_BT_BB_NMI_MAP    0x0000003FU
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_M  (INTERRUPT_CORE0_BT_BB_NMI_MAP_V << INTERRUPT_CORE0_BT_BB_NMI_MAP_S)
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_S  0
/** INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC_M  (INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC_V << INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_BT_BB_NMI_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_LP_TIMER_INTR_MAP_REG register
 *  LP_TIMER_INTR mapping register
 */
#define INTERRUPT_CORE0_LP_TIMER_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x1c)
/** INTERRUPT_CORE0_LP_TIMER_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_LP_TIMER_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_LP_TIMER_INTR_MAP_M  (INTERRUPT_CORE0_LP_TIMER_INTR_MAP_V << INTERRUPT_CORE0_LP_TIMER_INTR_MAP_S)
#define INTERRUPT_CORE0_LP_TIMER_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_LP_TIMER_INTR_MAP_S  0
/** INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_LP_TIMER_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_COEX_INTR_MAP_REG register
 *  COEX_INTR mapping register
 */
#define INTERRUPT_CORE0_COEX_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x20)
/** INTERRUPT_CORE0_COEX_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_COEX_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_COEX_INTR_MAP_M  (INTERRUPT_CORE0_COEX_INTR_MAP_V << INTERRUPT_CORE0_COEX_INTR_MAP_S)
#define INTERRUPT_CORE0_COEX_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_COEX_INTR_MAP_S  0
/** INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_COEX_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_REG register
 *  BLE_TIMER_INTR mapping register
 */
#define INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x24)
/** INTERRUPT_CORE0_BLE_TIMER_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_BLE_TIMER_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_M  (INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_V << INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_S)
#define INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_BLE_TIMER_INTR_MAP_S  0
/** INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_BLE_TIMER_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_BLE_SEC_INTR_MAP_REG register
 *  BLE_SEC_INTR mapping register
 */
#define INTERRUPT_CORE0_BLE_SEC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x28)
/** INTERRUPT_CORE0_BLE_SEC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_BLE_SEC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_BLE_SEC_INTR_MAP_M  (INTERRUPT_CORE0_BLE_SEC_INTR_MAP_V << INTERRUPT_CORE0_BLE_SEC_INTR_MAP_S)
#define INTERRUPT_CORE0_BLE_SEC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_BLE_SEC_INTR_MAP_S  0
/** INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_BLE_SEC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_I2C_MST_INTR_MAP_REG register
 *  I2C_MST_INTR mapping register
 */
#define INTERRUPT_CORE0_I2C_MST_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x2c)
/** INTERRUPT_CORE0_I2C_MST_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_I2C_MST_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_I2C_MST_INTR_MAP_M  (INTERRUPT_CORE0_I2C_MST_INTR_MAP_V << INTERRUPT_CORE0_I2C_MST_INTR_MAP_S)
#define INTERRUPT_CORE0_I2C_MST_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_I2C_MST_INTR_MAP_S  0
/** INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_I2C_MST_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_ZB_MAC_INTR_MAP_REG register
 *  ZB_MAC_INTR mapping register
 */
#define INTERRUPT_CORE0_ZB_MAC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x30)
/** INTERRUPT_CORE0_ZB_MAC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_ZB_MAC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_ZB_MAC_INTR_MAP_M  (INTERRUPT_CORE0_ZB_MAC_INTR_MAP_V << INTERRUPT_CORE0_ZB_MAC_INTR_MAP_S)
#define INTERRUPT_CORE0_ZB_MAC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_ZB_MAC_INTR_MAP_S  0
/** INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_ZB_MAC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_PMU_INTR_MAP_REG register
 *  PMU_INTR mapping register
 */
#define INTERRUPT_CORE0_PMU_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x34)
/** INTERRUPT_CORE0_PMU_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_PMU_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_PMU_INTR_MAP_M  (INTERRUPT_CORE0_PMU_INTR_MAP_V << INTERRUPT_CORE0_PMU_INTR_MAP_S)
#define INTERRUPT_CORE0_PMU_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_PMU_INTR_MAP_S  0
/** INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_PMU_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_EFUSE_INTR_MAP_REG register
 *  EFUSE_INTR mapping register
 */
#define INTERRUPT_CORE0_EFUSE_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x38)
/** INTERRUPT_CORE0_EFUSE_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_EFUSE_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_EFUSE_INTR_MAP_M  (INTERRUPT_CORE0_EFUSE_INTR_MAP_V << INTERRUPT_CORE0_EFUSE_INTR_MAP_S)
#define INTERRUPT_CORE0_EFUSE_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_EFUSE_INTR_MAP_S  0
/** INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_EFUSE_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_REG register
 *  LP_RTC_TIMER_INTR mapping register
 */
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x3c)
/** INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_M  (INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_V << INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_S)
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_MAP_S  0
/** INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_LP_RTC_TIMER_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_LP_WDT_INTR_MAP_REG register
 *  LP_WDT_INTR mapping register
 */
#define INTERRUPT_CORE0_LP_WDT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x40)
/** INTERRUPT_CORE0_LP_WDT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_LP_WDT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_LP_WDT_INTR_MAP_M  (INTERRUPT_CORE0_LP_WDT_INTR_MAP_V << INTERRUPT_CORE0_LP_WDT_INTR_MAP_S)
#define INTERRUPT_CORE0_LP_WDT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_LP_WDT_INTR_MAP_S  0
/** INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_LP_WDT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_REG register
 *  LP_PERI_TIMEOUT_INTR mapping register
 */
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x44)
/** INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_M  (INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_V << INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_S)
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_MAP_S  0
/** INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_LP_PERI_TIMEOUT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_REG register
 *  LP_APM_M0_INTR mapping register
 */
#define INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x48)
/** INTERRUPT_CORE0_LP_APM_M0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_LP_APM_M0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_M  (INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_V << INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_S)
#define INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_LP_APM_M0_INTR_MAP_S  0
/** INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_LP_APM_M0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG register
 *  CPU_INTR_FROM_CPU_0 mapping register
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG (DR_REG_INTMTX_BASE + 0x4c)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_S  0
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG register
 *  CPU_INTR_FROM_CPU_1 mapping register
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG (DR_REG_INTMTX_BASE + 0x50)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_S  0
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG register
 *  CPU_INTR_FROM_CPU_2 mapping register
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG (DR_REG_INTMTX_BASE + 0x54)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_S  0
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG register
 *  CPU_INTR_FROM_CPU_3 mapping register
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG (DR_REG_INTMTX_BASE + 0x58)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_S  0
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_REG register
 *  ASSIST_DEBUG_INTR mapping register
 */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x5c)
/** INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_M  (INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_V << INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_S)
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_S  0
/** INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TRACE_INTR_MAP_REG register
 *  TRACE_INTR mapping register
 */
#define INTERRUPT_CORE0_TRACE_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x60)
/** INTERRUPT_CORE0_TRACE_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TRACE_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TRACE_INTR_MAP_M  (INTERRUPT_CORE0_TRACE_INTR_MAP_V << INTERRUPT_CORE0_TRACE_INTR_MAP_S)
#define INTERRUPT_CORE0_TRACE_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TRACE_INTR_MAP_S  0
/** INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TRACE_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CACHE_INTR_MAP_REG register
 *  CACHE_INTR mapping register
 */
#define INTERRUPT_CORE0_CACHE_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x64)
/** INTERRUPT_CORE0_CACHE_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CACHE_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_CACHE_INTR_MAP_M  (INTERRUPT_CORE0_CACHE_INTR_MAP_V << INTERRUPT_CORE0_CACHE_INTR_MAP_S)
#define INTERRUPT_CORE0_CACHE_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CACHE_INTR_MAP_S  0
/** INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CACHE_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_REG register
 *  CPU_PERI_TIMEOUT_INTR mapping register
 */
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x68)
/** INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_M  (INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_V << INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_S)
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_S  0
/** INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_PERI_TIMEOUT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_REG register
 *  GPIO_INTERRUPT_PRO mapping register
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_REG (DR_REG_INTMTX_BASE + 0x6c)
/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP    0x0000003FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_M  (INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_V << INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_S)
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_S  0
/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC_M  (INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC_V << INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_REG register
 *  GPIO_INTERRUPT_EXT mapping register
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_REG (DR_REG_INTMTX_BASE + 0x70)
/** INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP    0x0000003FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_M  (INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_V << INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_S)
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_MAP_S  0
/** INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC_M  (INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC_V << INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_GPIO_INTERRUPT_EXT_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_PAU_INTR_MAP_REG register
 *  PAU_INTR mapping register
 */
#define INTERRUPT_CORE0_PAU_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x74)
/** INTERRUPT_CORE0_PAU_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_PAU_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_PAU_INTR_MAP_M  (INTERRUPT_CORE0_PAU_INTR_MAP_V << INTERRUPT_CORE0_PAU_INTR_MAP_S)
#define INTERRUPT_CORE0_PAU_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_PAU_INTR_MAP_S  0
/** INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_PAU_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_REG register
 *  HP_PERI_TIMEOUT_INTR mapping register
 */
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x78)
/** INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_M  (INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_V << INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_S)
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_MAP_S  0
/** INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_HP_PERI_TIMEOUT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_REG register
 *  MODEM_PERI_TIMEOUT_INTR mapping register
 */
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x7c)
/** INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_M  (INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_V << INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_S)
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_MAP_S  0
/** INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_MODEM_PERI_TIMEOUT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_REG register
 *  HP_APM_M0_INTR mapping register
 */
#define INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x80)
/** INTERRUPT_CORE0_HP_APM_M0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_HP_APM_M0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_M  (INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_V << INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_S)
#define INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M0_INTR_MAP_S  0
/** INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_HP_APM_M0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_REG register
 *  HP_APM_M1_INTR mapping register
 */
#define INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x84)
/** INTERRUPT_CORE0_HP_APM_M1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_HP_APM_M1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_M  (INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_V << INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_S)
#define INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M1_INTR_MAP_S  0
/** INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_HP_APM_M1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_REG register
 *  HP_APM_M2_INTR mapping register
 */
#define INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x88)
/** INTERRUPT_CORE0_HP_APM_M2_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_HP_APM_M2_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_M  (INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_V << INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_S)
#define INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M2_INTR_MAP_S  0
/** INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_HP_APM_M2_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_REG register
 *  HP_APM_M3_INTR mapping register
 */
#define INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x8c)
/** INTERRUPT_CORE0_HP_APM_M3_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_HP_APM_M3_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_M  (INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_V << INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_S)
#define INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_HP_APM_M3_INTR_MAP_S  0
/** INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_HP_APM_M3_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_REG register
 *  CPU_APM_M0_INTR mapping register
 */
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x90)
/** INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_M  (INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_V << INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_S)
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_MAP_S  0
/** INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_APM_M0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_REG register
 *  CPU_APM_M1_INTR mapping register
 */
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x94)
/** INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_M  (INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_V << INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_S)
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_MAP_S  0
/** INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CPU_APM_M1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_MSPI_INTR_MAP_REG register
 *  MSPI_INTR mapping register
 */
#define INTERRUPT_CORE0_MSPI_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x98)
/** INTERRUPT_CORE0_MSPI_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_MSPI_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_MSPI_INTR_MAP_M  (INTERRUPT_CORE0_MSPI_INTR_MAP_V << INTERRUPT_CORE0_MSPI_INTR_MAP_S)
#define INTERRUPT_CORE0_MSPI_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_MSPI_INTR_MAP_S  0
/** INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_MSPI_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_I2S1_INTR_MAP_REG register
 *  I2S1_INTR mapping register
 */
#define INTERRUPT_CORE0_I2S1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x9c)
/** INTERRUPT_CORE0_I2S1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_I2S1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_I2S1_INTR_MAP_M  (INTERRUPT_CORE0_I2S1_INTR_MAP_V << INTERRUPT_CORE0_I2S1_INTR_MAP_S)
#define INTERRUPT_CORE0_I2S1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_I2S1_INTR_MAP_S  0
/** INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_I2S1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_UART0_INTR_MAP_REG register
 *  UART0_INTR mapping register
 */
#define INTERRUPT_CORE0_UART0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xa0)
/** INTERRUPT_CORE0_UART0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_UART0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_UART0_INTR_MAP_M  (INTERRUPT_CORE0_UART0_INTR_MAP_V << INTERRUPT_CORE0_UART0_INTR_MAP_S)
#define INTERRUPT_CORE0_UART0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_UART0_INTR_MAP_S  0
/** INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_UART0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_UART1_INTR_MAP_REG register
 *  UART1_INTR mapping register
 */
#define INTERRUPT_CORE0_UART1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xa4)
/** INTERRUPT_CORE0_UART1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_UART1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_UART1_INTR_MAP_M  (INTERRUPT_CORE0_UART1_INTR_MAP_V << INTERRUPT_CORE0_UART1_INTR_MAP_S)
#define INTERRUPT_CORE0_UART1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_UART1_INTR_MAP_S  0
/** INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_UART1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_UART2_INTR_MAP_REG register
 *  UART2_INTR mapping register
 */
#define INTERRUPT_CORE0_UART2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xa8)
/** INTERRUPT_CORE0_UART2_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_UART2_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_UART2_INTR_MAP_M  (INTERRUPT_CORE0_UART2_INTR_MAP_V << INTERRUPT_CORE0_UART2_INTR_MAP_S)
#define INTERRUPT_CORE0_UART2_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_UART2_INTR_MAP_S  0
/** INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_UART2_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_LEDC_INTR_MAP_REG register
 *  LEDC_INTR mapping register
 */
#define INTERRUPT_CORE0_LEDC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xac)
/** INTERRUPT_CORE0_LEDC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_LEDC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_LEDC_INTR_MAP_M  (INTERRUPT_CORE0_LEDC_INTR_MAP_V << INTERRUPT_CORE0_LEDC_INTR_MAP_S)
#define INTERRUPT_CORE0_LEDC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_LEDC_INTR_MAP_S  0
/** INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_LEDC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_USB_INTR_MAP_REG register
 *  USB_INTR mapping register
 */
#define INTERRUPT_CORE0_USB_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xb0)
/** INTERRUPT_CORE0_USB_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_USB_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_USB_INTR_MAP_M  (INTERRUPT_CORE0_USB_INTR_MAP_V << INTERRUPT_CORE0_USB_INTR_MAP_S)
#define INTERRUPT_CORE0_USB_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_USB_INTR_MAP_S  0
/** INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_USB_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_REG register
 *  I2C_EXT0_INTR mapping register
 */
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xb4)
/** INTERRUPT_CORE0_I2C_EXT0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_M  (INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_V << INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_S)
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_S  0
/** INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_I2C_EXT0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TG0_T0_INTR_MAP_REG register
 *  TG0_T0_INTR mapping register
 */
#define INTERRUPT_CORE0_TG0_T0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xb8)
/** INTERRUPT_CORE0_TG0_T0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TG0_T0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TG0_T0_INTR_MAP_M  (INTERRUPT_CORE0_TG0_T0_INTR_MAP_V << INTERRUPT_CORE0_TG0_T0_INTR_MAP_S)
#define INTERRUPT_CORE0_TG0_T0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TG0_T0_INTR_MAP_S  0
/** INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TG0_T0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TG0_T1_INTR_MAP_REG register
 *  TG0_T1_INTR mapping register
 */
#define INTERRUPT_CORE0_TG0_T1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xbc)
/** INTERRUPT_CORE0_TG0_T1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TG0_T1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TG0_T1_INTR_MAP_M  (INTERRUPT_CORE0_TG0_T1_INTR_MAP_V << INTERRUPT_CORE0_TG0_T1_INTR_MAP_S)
#define INTERRUPT_CORE0_TG0_T1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TG0_T1_INTR_MAP_S  0
/** INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TG0_T1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TG0_WDT_INTR_MAP_REG register
 *  TG0_WDT_INTR mapping register
 */
#define INTERRUPT_CORE0_TG0_WDT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc0)
/** INTERRUPT_CORE0_TG0_WDT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TG0_WDT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TG0_WDT_INTR_MAP_M  (INTERRUPT_CORE0_TG0_WDT_INTR_MAP_V << INTERRUPT_CORE0_TG0_WDT_INTR_MAP_S)
#define INTERRUPT_CORE0_TG0_WDT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TG0_WDT_INTR_MAP_S  0
/** INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TG0_WDT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TG1_T0_INTR_MAP_REG register
 *  TG1_T0_INTR mapping register
 */
#define INTERRUPT_CORE0_TG1_T0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc4)
/** INTERRUPT_CORE0_TG1_T0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TG1_T0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TG1_T0_INTR_MAP_M  (INTERRUPT_CORE0_TG1_T0_INTR_MAP_V << INTERRUPT_CORE0_TG1_T0_INTR_MAP_S)
#define INTERRUPT_CORE0_TG1_T0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TG1_T0_INTR_MAP_S  0
/** INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TG1_T0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TG1_T1_INTR_MAP_REG register
 *  TG1_T1_INTR mapping register
 */
#define INTERRUPT_CORE0_TG1_T1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc8)
/** INTERRUPT_CORE0_TG1_T1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TG1_T1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TG1_T1_INTR_MAP_M  (INTERRUPT_CORE0_TG1_T1_INTR_MAP_V << INTERRUPT_CORE0_TG1_T1_INTR_MAP_S)
#define INTERRUPT_CORE0_TG1_T1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TG1_T1_INTR_MAP_S  0
/** INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TG1_T1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_TG1_WDT_INTR_MAP_REG register
 *  TG1_WDT_INTR mapping register
 */
#define INTERRUPT_CORE0_TG1_WDT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xcc)
/** INTERRUPT_CORE0_TG1_WDT_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_TG1_WDT_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_TG1_WDT_INTR_MAP_M  (INTERRUPT_CORE0_TG1_WDT_INTR_MAP_V << INTERRUPT_CORE0_TG1_WDT_INTR_MAP_S)
#define INTERRUPT_CORE0_TG1_WDT_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_TG1_WDT_INTR_MAP_S  0
/** INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_TG1_WDT_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_REG register
 *  SYSTIMER_TARGET0_INTR mapping register
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xd0)
/** INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_M  (INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_V << INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_MAP_S  0
/** INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_REG register
 *  SYSTIMER_TARGET1_INTR mapping register
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xd4)
/** INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_M  (INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_V << INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_MAP_S  0
/** INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_REG register
 *  SYSTIMER_TARGET2_INTR mapping register
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xd8)
/** INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_M  (INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_V << INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_MAP_S  0
/** INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_APB_ADC_INTR_MAP_REG register
 *  APB_ADC_INTR mapping register
 */
#define INTERRUPT_CORE0_APB_ADC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xdc)
/** INTERRUPT_CORE0_APB_ADC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_APB_ADC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_APB_ADC_INTR_MAP_M  (INTERRUPT_CORE0_APB_ADC_INTR_MAP_V << INTERRUPT_CORE0_APB_ADC_INTR_MAP_S)
#define INTERRUPT_CORE0_APB_ADC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_APB_ADC_INTR_MAP_S  0
/** INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_APB_ADC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_SLC0_INTR_MAP_REG register
 *  SLC0_INTR mapping register
 */
#define INTERRUPT_CORE0_SLC0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xe0)
/** INTERRUPT_CORE0_SLC0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_SLC0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_SLC0_INTR_MAP_M  (INTERRUPT_CORE0_SLC0_INTR_MAP_V << INTERRUPT_CORE0_SLC0_INTR_MAP_S)
#define INTERRUPT_CORE0_SLC0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_SLC0_INTR_MAP_S  0
/** INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_SLC0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_SLC1_INTR_MAP_REG register
 *  SLC1_INTR mapping register
 */
#define INTERRUPT_CORE0_SLC1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xe4)
/** INTERRUPT_CORE0_SLC1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_SLC1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_SLC1_INTR_MAP_M  (INTERRUPT_CORE0_SLC1_INTR_MAP_V << INTERRUPT_CORE0_SLC1_INTR_MAP_S)
#define INTERRUPT_CORE0_SLC1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_SLC1_INTR_MAP_S  0
/** INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_SLC1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_REG register
 *  DMA_IN_CH0_INTR mapping register
 */
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xe8)
/** INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_M  (INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_V << INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_S)
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_MAP_S  0
/** INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_DMA_IN_CH0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_REG register
 *  DMA_IN_CH1_INTR mapping register
 */
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xec)
/** INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_M  (INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_V << INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_S)
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_MAP_S  0
/** INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_DMA_IN_CH1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_REG register
 *  DMA_OUT_CH0_INTR mapping register
 */
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xf0)
/** INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_M  (INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_V << INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_S)
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_MAP_S  0
/** INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_DMA_OUT_CH0_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_REG register
 *  DMA_OUT_CH1_INTR mapping register
 */
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xf4)
/** INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_M  (INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_V << INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_S)
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_MAP_S  0
/** INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_DMA_OUT_CH1_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_GPSPI2_INTR_MAP_REG register
 *  GPSPI2_INTR mapping register
 */
#define INTERRUPT_CORE0_GPSPI2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xf8)
/** INTERRUPT_CORE0_GPSPI2_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_GPSPI2_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_GPSPI2_INTR_MAP_M  (INTERRUPT_CORE0_GPSPI2_INTR_MAP_V << INTERRUPT_CORE0_GPSPI2_INTR_MAP_S)
#define INTERRUPT_CORE0_GPSPI2_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_GPSPI2_INTR_MAP_S  0
/** INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_GPSPI2_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_SHA_INTR_MAP_REG register
 *  SHA_INTR mapping register
 */
#define INTERRUPT_CORE0_SHA_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xfc)
/** INTERRUPT_CORE0_SHA_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_SHA_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_SHA_INTR_MAP_M  (INTERRUPT_CORE0_SHA_INTR_MAP_V << INTERRUPT_CORE0_SHA_INTR_MAP_S)
#define INTERRUPT_CORE0_SHA_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_SHA_INTR_MAP_S  0
/** INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_SHA_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_ECC_INTR_MAP_REG register
 *  ECC_INTR mapping register
 */
#define INTERRUPT_CORE0_ECC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x100)
/** INTERRUPT_CORE0_ECC_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_ECC_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_ECC_INTR_MAP_M  (INTERRUPT_CORE0_ECC_INTR_MAP_V << INTERRUPT_CORE0_ECC_INTR_MAP_S)
#define INTERRUPT_CORE0_ECC_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_ECC_INTR_MAP_S  0
/** INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_ECC_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_ECDSA_INTR_MAP_REG register
 *  ECDSA_INTR mapping register
 */
#define INTERRUPT_CORE0_ECDSA_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x104)
/** INTERRUPT_CORE0_ECDSA_INTR_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_ECDSA_INTR_MAP    0x0000003FU
#define INTERRUPT_CORE0_ECDSA_INTR_MAP_M  (INTERRUPT_CORE0_ECDSA_INTR_MAP_V << INTERRUPT_CORE0_ECDSA_INTR_MAP_S)
#define INTERRUPT_CORE0_ECDSA_INTR_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_ECDSA_INTR_MAP_S  0
/** INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC : R/W; bitpos: [8]; default: 0;
 *  Configures the PASS_IN_SEC flag of the interrupt source.
 */
#define INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC    (BIT(8))
#define INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC_M  (INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC_V << INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_ECDSA_INTR_PASS_IN_SEC_S  8

/** INTERRUPT_CORE0_INT_STATUS_REG_0_REG register
 *  Status register for interrupt sources 0 ~ 31
 */
#define INTERRUPT_CORE0_INT_STATUS_REG_0_REG (DR_REG_INTMTX_BASE + 0x108)
/** INTERRUPT_CORE0_INT_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  Represents the status of the interrupt sources within interrupt-index-range 0 ~ 31.
 *  Each bit corresponds to one interrupt source
 *  0:The corresponding interrupt source triggered an interrupt
 *  1:No interrupt triggered
 */
#define INTERRUPT_CORE0_INT_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_STATUS_0_M  (INTERRUPT_CORE0_INT_STATUS_0_V << INTERRUPT_CORE0_INT_STATUS_0_S)
#define INTERRUPT_CORE0_INT_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_STATUS_0_S  0

/** INTERRUPT_CORE0_INT_STATUS_REG_1_REG register
 *  Status register for interrupt sources 32 ~ 63
 */
#define INTERRUPT_CORE0_INT_STATUS_REG_1_REG (DR_REG_INTMTX_BASE + 0x10c)
/** INTERRUPT_CORE0_INT_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  Represents the status of the interrupt sources within interrupt-index-range 32 ~
 *  63. Each bit corresponds to one interrupt source
 *  0:The corresponding interrupt source triggered an interrupt
 *  1:No interrupt triggered
 */
#define INTERRUPT_CORE0_INT_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_STATUS_1_M  (INTERRUPT_CORE0_INT_STATUS_1_V << INTERRUPT_CORE0_INT_STATUS_1_S)
#define INTERRUPT_CORE0_INT_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_STATUS_1_S  0

/** INTERRUPT_CORE0_INT_STATUS_REG_2_REG register
 *  Status register for interrupt sources 64 ~ 65
 */
#define INTERRUPT_CORE0_INT_STATUS_REG_2_REG (DR_REG_INTMTX_BASE + 0x110)
/** INTERRUPT_CORE0_INT_STATUS_2 : RO; bitpos: [1:0]; default: 0;
 *  Represents the status of the interrupt sources within interrupt-index-range 64 ~
 *  65. Each bit corresponds to one interrupt source
 *  0:The corresponding interrupt source triggered an interrupt
 *  1:No interrupt triggered
 */
#define INTERRUPT_CORE0_INT_STATUS_2    0x00000003U
#define INTERRUPT_CORE0_INT_STATUS_2_M  (INTERRUPT_CORE0_INT_STATUS_2_V << INTERRUPT_CORE0_INT_STATUS_2_S)
#define INTERRUPT_CORE0_INT_STATUS_2_V  0x00000003U
#define INTERRUPT_CORE0_INT_STATUS_2_S  0

/** INTERRUPT_CORE0_SRC_PASS_IN_SEC_STATUS_0_REG register
 *  PASS_IN_SEC status register for interrupt sources 0 ~ 31
 */
#define INTERRUPT_CORE0_SRC_PASS_IN_SEC_STATUS_0_REG (DR_REG_INTMTX_BASE + 0x114)
/** INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  Represents the PASS_IN_SEC status of the interrupt sources within
 *  interrupt-index-range 0 ~ 31. Each bit corresponds to one interrupt source
 *  0:The corresponding interrupt source is not PASS_IN_SEC.
 *  1:The corresponding interrupt source is PASS_IN_SEC.
 */
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0_M  (INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0_V << INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0_S)
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_0_S  0

/** INTERRUPT_CORE0_SRC_PASS_IN_SEC_STATUS_1_REG register
 *  PASS_IN_SEC status register for interrupt sources 32 ~ 63
 */
#define INTERRUPT_CORE0_SRC_PASS_IN_SEC_STATUS_1_REG (DR_REG_INTMTX_BASE + 0x118)
/** INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  Represents the PASS_IN_SEC status of the interrupt sources within
 *  interrupt-index-range 32 ~ 63. Each bit corresponds to one interrupt source
 *  0:The corresponding interrupt source is not PASS_IN_SEC.
 *  1:The corresponding interrupt source is PASS_IN_SEC.
 */
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1_M  (INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1_V << INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1_S)
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_1_S  0

/** INTERRUPT_CORE0_SRC_PASS_IN_SEC_STATUS_2_REG register
 *  PASS_IN_SEC status register for interrupt sources 64 ~ 65
 */
#define INTERRUPT_CORE0_SRC_PASS_IN_SEC_STATUS_2_REG (DR_REG_INTMTX_BASE + 0x11c)
/** INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2 : RO; bitpos: [1:0]; default: 0;
 *  Represents the PASS_IN_SEC status of the interrupt sources with
 *  interrupt-index-range 64 ~ 65. Each bit corresponds to one interrupt source
 *  0:The corresponding interrupt source is not PASS_IN_SEC.
 *  1:The corresponding interrupt source is PASS_IN_SEC.
 */
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2    0x00000003U
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2_M  (INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2_V << INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2_S)
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2_V  0x00000003U
#define INTERRUPT_CORE0_INT_SRC_PASS_IN_SEC_STATUS_2_S  0

/** INTERRUPT_CORE0_SIG_IDX_ASSERT_IN_SEC_REG register
 *  reserved
 */
#define INTERRUPT_CORE0_SIG_IDX_ASSERT_IN_SEC_REG (DR_REG_INTMTX_BASE + 0x120)
/** INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC : R/W; bitpos: [5:0]; default: 0;
 *  reserved
 */
#define INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC    0x0000003FU
#define INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC_M  (INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC_V << INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC_S)
#define INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC_V  0x0000003FU
#define INTERRUPT_CORE0_INT_SIG_IDX_ASSERT_IN_SEC_S  0

/** INTERRUPT_CORE0_SECURE_STATUS_REG register
 *  reserved
 */
#define INTERRUPT_CORE0_SECURE_STATUS_REG (DR_REG_INTMTX_BASE + 0x124)
/** INTERRUPT_CORE0_INT_SECURE_STATUS : RO; bitpos: [31:0]; default: 0;
 *  reserved
 */
#define INTERRUPT_CORE0_INT_SECURE_STATUS    0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_SECURE_STATUS_M  (INTERRUPT_CORE0_INT_SECURE_STATUS_V << INTERRUPT_CORE0_INT_SECURE_STATUS_S)
#define INTERRUPT_CORE0_INT_SECURE_STATUS_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INT_SECURE_STATUS_S  0

/** INTERRUPT_CORE0_CLOCK_GATE_REG register
 *  Interrupt clock gating configure register
 */
#define INTERRUPT_CORE0_CLOCK_GATE_REG (DR_REG_INTMTX_BASE + 0x128)
/** INTERRUPT_CORE0_REG_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  Interrupt clock gating configure register
 */
#define INTERRUPT_CORE0_REG_CLK_EN    (BIT(0))
#define INTERRUPT_CORE0_REG_CLK_EN_M  (INTERRUPT_CORE0_REG_CLK_EN_V << INTERRUPT_CORE0_REG_CLK_EN_S)
#define INTERRUPT_CORE0_REG_CLK_EN_V  0x00000001U
#define INTERRUPT_CORE0_REG_CLK_EN_S  0

/** INTERRUPT_CORE0_INTERRUPT_DATE_REG register
 *  Version control register
 */
#define INTERRUPT_CORE0_INTERRUPT_DATE_REG (DR_REG_INTMTX_BASE + 0x7fc)
/** INTERRUPT_CORE0_INTERRUPT_DATE : R/W; bitpos: [27:0]; default: 38801441;
 *  Version control register
 */
#define INTERRUPT_CORE0_INTERRUPT_DATE    0x0FFFFFFFU
#define INTERRUPT_CORE0_INTERRUPT_DATE_M  (INTERRUPT_CORE0_INTERRUPT_DATE_V << INTERRUPT_CORE0_INTERRUPT_DATE_S)
#define INTERRUPT_CORE0_INTERRUPT_DATE_V  0x0FFFFFFFU
#define INTERRUPT_CORE0_INTERRUPT_DATE_S  0

#ifdef __cplusplus
}
#endif
