/*
 * SPDX-FileCopyrightText: 2022 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * File generated by gen_digital_signature_tests.py
 */
#define NUM_HMAC_KEYS 3

static const uint8_t test_hmac_keys[NUM_HMAC_KEYS][32] = {
    { 0xe0, 0x19, 0xfc, 0x51, 0xb3, 0xa6, 0x3f, 0x31, 0xca, 0x43, 0xb5, 0x17, 0xe9, 0x7b, 0xe2, 0x87, 0x85, 0x41, 0x9c, 0x42, 0x60, 0x52, 0xd8, 0x8e, 0x45, 0xc3, 0x7c, 0x3b, 0x82, 0xe0, 0xe2, 0x80 },
    { 0x3d, 0x71, 0xd5, 0xc7, 0xe0, 0x15, 0xe6, 0x30, 0x66, 0xe8, 0xee, 0x5d, 0x14, 0x1e, 0xe1, 0xa1, 0x03, 0xd9, 0x7d, 0x48, 0x16, 0xde, 0xbc, 0xba, 0xaa, 0xf4, 0x3e, 0xd5, 0xb2, 0xbc, 0x46, 0xbc },
    { 0xa7, 0x84, 0x00, 0x57, 0xd9, 0x09, 0x0b, 0xab, 0x02, 0xfe, 0x76, 0x14, 0x21, 0xc9, 0x41, 0x0f, 0x8d, 0xe9, 0x94, 0xb7, 0x70, 0xc6, 0xf9, 0xec, 0xd4, 0xd9, 0xd4, 0xee, 0x00, 0xce, 0xde, 0x58 },
};

#define NUM_MESSAGES 10

static const uint32_t test_messages[NUM_MESSAGES][4096 / 32] = {
    // Message 0
    { 0x5b8223c6, 0xfa88edc7, 0x583c1799, 0xedc7c223, 0x9fb0857c, 0xed3c6f20, 0x05d1fb6e, 0x96d1dac3, 0x85c6d96d, 0x8b3a9a1d, 0x2e786a8f, 0xd2e4e243, 0xb364f14e, 0x44010946, 0xd9cd527f, 0x618cc373, 0xa0a19bd9, 0x7d97761f, 0xfb079173, 0x3c540391, 0x02d239ac, 0xe911c2f1, 0xf65c484b, 0xcf487211, 0x4125e65c, 0xb26ae57f, 0x1a3e9853, 0x019647f5, 0xb14d1638, 0x07069668, 0x19ad19b5, 0x19251d1d, 0xb685c504, 0x6760e85b, 0xa0fb61cc, 0x0b3f7909, 0x0377025d, 0x7654239b, 0x5c93db67, 0x3482b3f5, 0x1a79c91b, 0x02e91b71, 0x8557f72b, 0x2a45cf00, 0x3d180e14, 0x6f73b72b, 0xd9652bd2, 0xd49095cc, 0xffc72050, 0x799ac0a3, 0x23d37af6, 0xf30c65f5, 0x86daf4f1, 0xad2f3c99, 0xe0ba6ff9, 0x362de37c, 0x4846218d, 0x9a9a52aa, 0xd08e871a, 0xbc17c032, 0x91c16b34, 0x285fe6f8, 0xda1f4561, 0xa8fa480d, 0x9caff2a9, 0xd4bc8149, 0xb16f4ba3, 0x0ae0c85c, 0x8b261fb3, 0xaa5d5e9c, 0x9af38deb, 0xbcf4fc65, 0xabe82ab0, 0x5e478c29, 0x0e166ddf, 0x8080359b, 0x4a33e024, 0xafaf0456, 0x9d68deda, 0xcbbcdae1, 0x02f97709, 0x810de7ce, 0x5e9c6b43, 0x0267aa74, 0x18d763b2, 0xdd88fb86, 0x3c006c8b, 0x55b8b0cc, 0xf8413d02, 0xde19f942, 0xd4b64c8a, 0x7cf2bea1, 0xcdac985b, 0xa5fadac5, 0xf1bef008, 0x6098c15d, 0x23b0c27a, 0x7c4393f9, 0xe9c49179, 0x4b947a62, 0xfff2f206, 0xf639587d, 0x5ee8da18, 0xd10f0450, 0xd8b4bc25, 0x20e7eb82, 0x1736eef5, 0x6a8f4ef8, 0x3ff7f07f, 0x10795bba, 0x0b18864b, 0x494c96dc, 0x2fb5a260, 0xe28127bb, 0xab1162c6, 0x2bace451, 0x40874cd9, 0xf74700e8, 0x602cf820, 0xe1551cd9, 0x09747e29, 0x20bb223c, 0x77b3a76d, 0x3794e803, 0xf42f126d, 0x2de8434d, 0x668ac9fb, 0x4f7c92b6 },
    // Message 1
    { 0x6db17696, 0x244fca66, 0xe983297c, 0x937d0785, 0xa24fb4a4, 0x975c141b, 0x2d56770c, 0x5773491e, 0xb7827329, 0xb0789fa1, 0x5f91495c, 0x50a1535f, 0xc224980f, 0x2bcfc99d, 0x63379435, 0xc7d84f81, 0xf3f8b326, 0x9d1de54c, 0x3a91fc0a, 0xcf0776e5, 0x54c367ac, 0xb94e8202, 0xb6a1541f, 0x41bcbc32, 0x95d38d73, 0xe5c36c21, 0xb12d6159, 0x954b6dae, 0x45973e71, 0x1cda2855, 0xf8df9ad8, 0x644e1ca7, 0x2d4da7f1, 0x7fb3453a, 0x40f8eece, 0x0527c74c, 0x63e4fc08, 0x24e043f3, 0x22258133, 0x11c6417c, 0xf81232b7, 0xa4036037, 0x1aded35c, 0x20492892, 0x58d442a3, 0x48858b44, 0x9a6526a2, 0xc222ce2a, 0xd62ddcdc, 0xa83ec889, 0xa6aead0f, 0x00064cd1, 0x97cc7619, 0xdcfeead8, 0x084c9fbb, 0x0e706ee7, 0x52f492e4, 0xa51f2798, 0xf411d709, 0x1ae71c6f, 0xa94a6094, 0x68c34f12, 0xc4fb3f5d, 0xc0d9640d, 0xb1d17cad, 0xb9037e04, 0x7a6befa8, 0xa8611c7e, 0x3caf3730, 0x898f42a6, 0x67436870, 0x2a10a9f4, 0xbc4e74d8, 0x1790ec00, 0xdd193f23, 0x2b028522, 0xa33da521, 0x265ddcab, 0x3b23a204, 0xd1c622a8, 0x1531f752, 0xb8d48f02, 0x3d361e11, 0x87efe588, 0xc0b7d7f4, 0x21320e85, 0xbdd0491e, 0x6878b882, 0xf43c7d58, 0x95ccfda9, 0xdb39e8f5, 0x29d88964, 0xd282a492, 0xc889f542, 0xce6304e9, 0xc457a787, 0x47f7bc8e, 0x4eed33c0, 0xed150c28, 0xd4abcd08, 0xa20961b3, 0xaf5d0429, 0x245df52b, 0xd47d84f8, 0xdd44316d, 0x39643183, 0xee61e6a6, 0x7d366b7c, 0xde6bb656, 0x4563aea7, 0x1c967894, 0xacb7f54d, 0xc4c62fff, 0xf8846bbb, 0x9589e180, 0xd36d33b0, 0xbdd135b7, 0x4654580c, 0xb9ab2521, 0x9f0dbea2, 0x24827593, 0xf55d24b7, 0xb7a905f7, 0x14d542bd, 0x47859654, 0x4583d9a1, 0x6e711a70, 0xfd811de1 },
    // Message 2
    { 0xed4d7109, 0x4e0e1a49, 0xf89b6ff3, 0xe056fb57, 0x53afa880, 0xfe1c49f7, 0xd1830e17, 0x912eae65, 0x226fb7f9, 0xe21039d4, 0x0bc5639d, 0x2da133cb, 0x714531e1, 0xfda0a79d, 0x4c862b04, 0x3a04103d, 0xb5890521, 0xa77c5feb, 0x16114180, 0x0bb05b6d, 0x32cf6395, 0x0b6522f2, 0xaa36a343, 0x3e32599f, 0xc5a89214, 0xd1330f28, 0x3e5ec6d8, 0xfbd07f92, 0xbf4159ce, 0x5e04e915, 0x034f4e92, 0x170f2180, 0x1e792d8e, 0x96074aaa, 0xf59d11ed, 0x2ebfc19b, 0x920df270, 0x9e4b85d2, 0xa87cbc78, 0xe6b7a7ba, 0x5e61a1d2, 0x66ff5fad, 0xc6908748, 0xb42666df, 0x4111505a, 0x03d10421, 0x7e9f5def, 0x224d3e9a, 0xd5df568c, 0x99e03c83, 0xc8f756e6, 0x8f1c460e, 0xa9a518fe, 0x739bbd22, 0xf7343f19, 0x6f377270, 0xa1514341, 0x3006ec98, 0xd65ace1e, 0xf9ae42d6, 0xc0bdb44f, 0x50324808, 0xc784d0cb, 0xada4436a, 0xb32fcb5c, 0x6fe45992, 0xbe1e1fbc, 0x4d12f24b, 0x2894525d, 0x0d628aae, 0x5d3af461, 0x31e31010, 0x7041f204, 0xd16e221a, 0x2ff374ed, 0xdaca35b8, 0x74f67c88, 0x49457357, 0x3cc37ffb, 0x05fe90f7, 0x4816177d, 0xd90a410c, 0x2b6bcf0d, 0x83b98c58, 0x5bdffd49, 0xe8cd6b54, 0x5df214ed, 0x3c2b17da, 0x4d88c905, 0xfcf2d541, 0x6113416b, 0xa6bfeaff, 0x6e982de6, 0x1915da2d, 0x2a665024, 0x54db334f, 0x2f68a4c7, 0x11f25492, 0x1dcc6510, 0x2907beaa, 0x05506517, 0xceddd753, 0x2b06fafd, 0xfd34373e, 0x3efed25a, 0xef2b25b7, 0x7ffc85cb, 0x5d426c00, 0x1e74d9a1, 0x9c6a47f2, 0x24f85a07, 0xe23b2f49, 0xe3c98f1e, 0xbed8064f, 0x82d0acb5, 0x7b2287cc, 0xb5b2df41, 0xcecb3734, 0x0fdcdecf, 0xa2082a23, 0x0ecc613a, 0x88f4fe31, 0x9e454af1, 0x5ecc4ddf, 0x925e1590, 0xd722dcf5, 0x25317545, 0x80553b6a },
    // Message 3
    { 0xdb8ab0d8, 0x8352a755, 0x814109e2, 0x026b88a2, 0xf109e093, 0xa97346bc, 0x2b8eafc3, 0xf5959191, 0x7b6cbffa, 0x3ed8c580, 0x9f8ff337, 0xb5b5eff9, 0x5ef86b9b, 0x082990c4, 0x25b8347c, 0x4ff662a8, 0x81d76ca1, 0x3142818e, 0x850f1a66, 0xda5be26b, 0xbd2435ef, 0x642b9d78, 0x94c2c6ba, 0x236a0b09, 0x70693da2, 0xc4e36393, 0x423c3169, 0x65018e28, 0x9d8af95b, 0x308f6d35, 0x78c057f9, 0x79ae2e67, 0xc14332a6, 0x8e90ad6a, 0xba4f98e6, 0x36e2e12a, 0xa0af779c, 0x7ff2042d, 0x09cb88a1, 0xcd9a013e, 0x946c25f0, 0x1e2de977, 0xcc71d0e9, 0x1e91760e, 0xd2db1aa9, 0x82f4015e, 0x62b34d2e, 0xea817d00, 0x7e068c6f, 0x9cd45388, 0x87e56478, 0xb941472f, 0xab0c68ed, 0xc5841e8e, 0x7a011679, 0x45a83b37, 0x30eaed98, 0x8276a091, 0x2878646f, 0xed9db655, 0x748dcb7f, 0xfbb50291, 0xb9366921, 0x4a6ab2bc, 0x412de9c3, 0x312a2879, 0x2ccaa654, 0xacd304e6, 0x0952d148, 0x367ccc61, 0xec0d0533, 0x643ed028, 0x390a38bd, 0xeb939b4c, 0x66973d9a, 0xfeac4855, 0x3e5a5b39, 0x286a27b3, 0x3c4f1c95, 0xce7dd02b, 0xa0437ba3, 0x25b8d742, 0x14ac3921, 0x31f20af2, 0xbbbbfdc4, 0x24b70692, 0x38ca4e54, 0x5669e1b6, 0xa3ed2237, 0x3bdc1f5d, 0x59a88cdc, 0x6f413613, 0x7e96e4af, 0x61e0ec78, 0x41e045a5, 0x1c2ea76f, 0x41fc44eb, 0x1660063c, 0x5a2d4861, 0xeb4a0150, 0x998ca467, 0x97818ef6, 0xa94b9fad, 0x70f2fd65, 0xd070ceb9, 0x6cfdcef8, 0x37634bdc, 0xcfda5cc0, 0xeef09548, 0x496f0fab, 0x307c15a1, 0xccd90d15, 0xd497071e, 0x24c18289, 0x7e9793bc, 0x90119197, 0xdf285a15, 0x5726b6b0, 0xff787a3f, 0x37745cea, 0x1a452044, 0xfe59e0e1, 0x04641bd5, 0x3c81c3c0, 0x0189793d, 0xb4d7d362, 0x73cb084e, 0x802954ab },
    // Message 4
    { 0x57714ceb, 0xd4ea891d, 0x80634624, 0x2674d5f0, 0xe64b9955, 0xfc897081, 0xc70d11db, 0x4b66a1fc, 0x9277589b, 0x082a949b, 0xc4b57ea3, 0x22483603, 0x38ac45ec, 0xd8d49671, 0xff6a9258, 0x28abc76a, 0x2c5cbc7b, 0x99c37b2a, 0x35ac630c, 0x2e29515f, 0x5f6ce059, 0x23bb1811, 0xdea61bf7, 0x1674ee6e, 0x63f403ec, 0x005e0e6f, 0x4b95d017, 0xb3210c9c, 0xf018616f, 0x2ebe0ca3, 0x6e520e83, 0x53f3c811, 0x4e12d834, 0x3ea94f5f, 0x9cf7cea2, 0x672b6af7, 0xef95e58c, 0xcacb6a25, 0xa2073d06, 0xba3e1080, 0xe17ad704, 0x43120fd8, 0x01ddaad2, 0x0ac909ff, 0x22f02430, 0x93e40d0e, 0x29c31bf7, 0xdcf82e58, 0xdbb4fb4b, 0x0cd41b95, 0xdd719a49, 0x0b92337a, 0x1cde0032, 0x86159699, 0xcd43e1e2, 0xe1d04c4f, 0x6f8cf803, 0xe95778df, 0x428ba9e6, 0x90a11dc9, 0x324aaf5a, 0xf52929e9, 0xa6d657b9, 0x041e73d8, 0xf7389e23, 0xe1e74b63, 0xe036afa3, 0xf8ebc2e7, 0x2d13682b, 0xfc69124e, 0xcb6d7207, 0x4ce9620c, 0x3e33621b, 0x0a7ef135, 0x8261faeb, 0x61c43173, 0xd3c623da, 0x7fb60c10, 0xbd560cec, 0xd613ff75, 0xa4ce6ac0, 0x72686b41, 0x6ced92f5, 0x7ca77287, 0xcd7e09f5, 0x544243e1, 0x24ad9e3f, 0x6be8c4ce, 0xa7149e51, 0xd208d6ae, 0x5ce4aba8, 0xe9c71f29, 0x59646779, 0x28f50d3f, 0x7a3be6eb, 0xff9c5011, 0x3450f7c9, 0x0ac73164, 0x8bc2ed8e, 0x5c230617, 0x447a3097, 0x41a35f7b, 0x03a5220c, 0x3cc3467b, 0xd7f466a3, 0x49bcf01a, 0xd4f3c7f6, 0x1095dcfd, 0xe74419d1, 0xb0e64bcc, 0xddf2eed5, 0x8a50d90c, 0x5fa5dc2d, 0xff0edf86, 0x71780ed4, 0xefd6d10d, 0xb5cb49e4, 0x782284a4, 0x54d9dcf8, 0x8f80ccb9, 0x21f2f84f, 0x2e6a336e, 0x11f0b9a8, 0x748f2261, 0x38bcd6e4, 0x221aa382, 0xd62ee339, 0xe358a45c },
    // Message 5
    { 0x1bc12cdf, 0x28a72c65, 0xf48690b2, 0xd5fc0ea2, 0xe5c0b276, 0x2de130dc, 0x7d515090, 0x31e582bc, 0x83071741, 0xf32d18c2, 0x401aceb2, 0x90cc2f31, 0x2bf5fbd6, 0xbacb8936, 0x1149875c, 0x5eef4a04, 0x2f3e6897, 0xe71bb41e, 0x50fd7691, 0xf0ad6ade, 0x89d7bdb3, 0x90573e25, 0x981ac9fa, 0x33f2d2ac, 0x166cbde4, 0x27f6dc9b, 0x9eee56d3, 0x0dc8e6b8, 0x1aace0a4, 0xa7aaa2fe, 0x80d4b7f3, 0x79014f16, 0x320ed7ff, 0xb9e289b1, 0x15e46a2e, 0x4bdf1eb7, 0xf8f3e838, 0x9a4b3c01, 0x8d88fa6b, 0x64536a00, 0x2a59d92a, 0x05af4c72, 0x9e0ea16a, 0xeb9fe653, 0x46a8a13e, 0x78096135, 0x284b8f7b, 0x17bb4c3b, 0xe816798d, 0x840515d3, 0x0ece68a9, 0x6e6a06ac, 0xfe328057, 0x9024ca90, 0x56dc779e, 0x7ed4587f, 0xf76f9497, 0xfb36a58d, 0x63afa410, 0xf452e511, 0x017b27c1, 0x5b5c89b1, 0x6816acc8, 0xad2974c0, 0x82e3c44a, 0x91b952db, 0x3abff058, 0xba35c474, 0xa2face8d, 0xd013fe9d, 0x756417f1, 0xf49758c3, 0xdde5e21d, 0xb5c32be4, 0x6a0c656a, 0x95b4534f, 0xd745cf46, 0xf5fa5f3b, 0xae5ab31c, 0xd5909050, 0x5ad2287c, 0xd19d877f, 0xf6886332, 0x05689388, 0x6e2c702d, 0x3eb76528, 0xbf229d83, 0x1f5a7e14, 0xad9649bd, 0x6063a966, 0xdb3aedc5, 0x70b412ff, 0xb5bde84d, 0x57b85da6, 0x1a6358e8, 0xfe5fcdef, 0xb6082c47, 0x639322b1, 0x244fa7ed, 0xcb35cade, 0xc28e5248, 0x3337c589, 0x326371a8, 0xd34bc537, 0x1a5a675e, 0xa50ff5e4, 0x8650af04, 0xa20bf18e, 0x9b0bbf85, 0xb5093ec3, 0x2b378916, 0xd1d9bb53, 0x06e6f702, 0x90c4f3e1, 0x42894cb4, 0x1d4562db, 0x69bf1c93, 0x90f474cb, 0x3824e888, 0x3d5bddb2, 0xbd742ead, 0x117160ef, 0xa5827f9b, 0x6485517a, 0x47743509, 0x9b35f24b, 0x7e376093, 0xa45f0ac8 },
    // Message 6
    { 0xe452f4bc, 0xc9d479a5, 0x29a1b641, 0xd1e9a939, 0x89d3ed73, 0x703551d0, 0x94a03ee3, 0xc795d169, 0xfa647432, 0xd12cc217, 0x6b4eb934, 0x9acefaf1, 0x0253eda3, 0x1cd8ac3a, 0xd9d328d1, 0x7f9c57c8, 0x55d3ddbb, 0x7ef5df37, 0xf01de95b, 0x55687231, 0x632850a7, 0x04610301, 0x4930c2d6, 0xd5c67abb, 0x88f6490e, 0xc673cce5, 0xd41292b0, 0xe8436103, 0x18fc0817, 0x703aa3f0, 0xf4fe010b, 0x4de8f608, 0x1fa73843, 0x15f386ff, 0x055a6a1d, 0xcf3b302f, 0xd54e17bf, 0x432c2cf4, 0xdc1ae47c, 0x8b273462, 0xeaeb313a, 0x3d70ee11, 0x43e27f96, 0x6abf2b4c, 0xc24a16a3, 0x58c6373a, 0xa43dc335, 0x9c2519cf, 0x928ca803, 0xe63a772e, 0xfb004fa4, 0xd82bd259, 0xf9ae3953, 0xe8d293a8, 0xe60199af, 0x183acf8e, 0x5036227a, 0xff271487, 0xca4ae0ee, 0xa294276b, 0xd044da85, 0xc06c63fc, 0x46d0b7a3, 0x2718eef5, 0x11bf8763, 0x2ecad730, 0xaa9d785d, 0x705cb33c, 0xa5a058ac, 0x56b8f206, 0xbb8589be, 0x43f29d50, 0x9f99c44a, 0xdc4a2d7e, 0x7a67f3a6, 0xf9f2a464, 0x72e15395, 0x058c896b, 0x3f012837, 0x47c28d1b, 0xc5af9885, 0x8470ee34, 0x0a2d96dc, 0x84c85dd2, 0x4e698e29, 0xfdf921f3, 0x74d238ab, 0xa24fc6ec, 0x8c5e7858, 0x66538b3f, 0x70624478, 0x67962dad, 0x8872ff12, 0xc8f874fc, 0x576e08b9, 0x679637e2, 0x5a4b25e1, 0x1cf2c23f, 0x2f517298, 0x40737162, 0x83106478, 0x00b6e580, 0x574b57bb, 0x49f2367a, 0x4509f9d8, 0xffc90327, 0x09da762e, 0x0f0032db, 0x5e4d3a6b, 0x832e51f5, 0x5cba2bb2, 0x796c76ab, 0x1a924931, 0xad68199b, 0xcae04e9b, 0x1b01a7cf, 0x538e362d, 0xe5d42a13, 0x9f74c756, 0xbc9a23af, 0x8f4d9ac3, 0xd126c669, 0xc7b7729e, 0x18f3d75a, 0x2e4b0461, 0x7a5a7436, 0xa5e4442f, 0x9c0b3af8 },
    // Message 7
    { 0xcc8dd298, 0x3e17956c, 0xdfa1522d, 0x6e536c43, 0x36e504ce, 0xab4b3d1e, 0x1d855b66, 0x7a5d8774, 0x032a37d0, 0xf8089adf, 0x7d0a68c8, 0xedb67d0c, 0x28bf8099, 0x53908c44, 0xd64aef09, 0x3a888eed, 0x9bf63716, 0xdc30171a, 0xf6dc15b9, 0x2142ad89, 0xdfbc7e72, 0xd15f60c4, 0xe40a7cd0, 0x9f024434, 0xef2af8d4, 0xc33f3e8c, 0xfb1aef47, 0xfd75ee6a, 0xaf43429f, 0xa91320c5, 0xe75223f8, 0x932102ad, 0xe0285748, 0x6e49073a, 0x54b7a14f, 0xc578136a, 0x764637dc, 0x5a4233ec, 0x22244d8d, 0xbf1e51e8, 0x1c7ff213, 0xf2892d06, 0x9b83cbac, 0xed54b7b2, 0x94ede988, 0x95b1b8c0, 0x057e0c7a, 0x3ab93c3f, 0xb6b87bb8, 0x0bdb2659, 0x31683aa5, 0x1bb0ffab, 0x5d6920d4, 0xc05fac74, 0x1db3121c, 0xcff11207, 0x29e7dc11, 0x9605eb05, 0x96a3769c, 0x315d485a, 0x1495b308, 0xcd1993a6, 0x032b8d2a, 0xf1ec677b, 0xb09e1f6e, 0x8479bb94, 0xeac3f10b, 0x9bd252bf, 0x50a23458, 0x6c8b24d5, 0x2ecb3c03, 0x708c6957, 0x1f599bac, 0xbbbdcaf8, 0xfb5fdb49, 0xeb26f5fe, 0xc32d74fb, 0xce1ca095, 0x60df7ac8, 0xbf0874e7, 0xcef6a57d, 0xc79cf491, 0x85ec6d40, 0x519f7ec2, 0x870c4573, 0x5566fd01, 0x99a91b71, 0x2573ab71, 0xd0967389, 0xf53aebc1, 0x19e2d893, 0x7fb25e60, 0x0b59d165, 0x7e85aa2d, 0x1b02ece3, 0xf71378df, 0xe9c237c6, 0xa0365fce, 0x286c2f3d, 0x6783e4c3, 0x47c86229, 0xc18ab13c, 0x33e1fc5b, 0x308d23c3, 0x2e875b30, 0x55f7a991, 0x1e3ac107, 0x0af30db9, 0x16ee6859, 0x165e0740, 0xa4ac4587, 0x0e01b996, 0x418b7684, 0xd3d95ed4, 0x5818cda8, 0x06e23868, 0x86323661, 0x899dcf13, 0x1a805c58, 0x365f027b, 0x8f3edf67, 0x7b7788d4, 0x54433277, 0xa76dbdf3, 0xa4b4853f, 0x25b9edc4, 0x65513104, 0xf80ff68c },
    // Message 8
    { 0xee334586, 0xcff4221e, 0xf9f78033, 0xe47cb45d, 0x286aee0c, 0x4f098fae, 0xb09c4aa1, 0x0156b937, 0x6b17c99b, 0x61022994, 0xe39a53ef, 0xae99a69e, 0x49317b54, 0xe59fd748, 0x5e9e28e5, 0x8580e373, 0xfb4ab864, 0x3ddbdaf6, 0x53d9f846, 0x6746c176, 0xecc7acf2, 0x011b4527, 0x997c908f, 0xa5377ac5, 0x8e362d50, 0xa82ffdc7, 0xd5ac6bdd, 0x7fea3597, 0xce83aa16, 0x5a876007, 0x0350729b, 0xbbce5b23, 0xfa4d1ea8, 0x01141379, 0x3b7610bf, 0x5c7e8e2d, 0x72d941dd, 0xf4f90443, 0x77eeb2f1, 0x9d04214a, 0x730fe00d, 0x478b9d4f, 0x74648cc0, 0xcba3e985, 0x76861fb8, 0xa732fc65, 0x42c37470, 0x34fa6e2b, 0xaea8f19c, 0x184c3ddb, 0x68e6f193, 0x57d6aa56, 0xb6d73fb1, 0x8cdc8b2d, 0x2ca44938, 0xd274bb8d, 0x322216e1, 0x236d88c9, 0x373f0604, 0x5d453e43, 0x3e43dacb, 0x956be271, 0x6cd2de66, 0xf20ebbe5, 0xe712d372, 0x2a52bcaa, 0x7ef61eee, 0x7373e0a5, 0x2546a8c5, 0xf8b7a409, 0x0dd39577, 0xf76b1790, 0x02bae1d9, 0xab2cfa90, 0x9d813594, 0x297f4a40, 0x15b3ae12, 0xfd68916a, 0x11144092, 0x7a7acfe6, 0x3fc0b46d, 0xe4ef53b5, 0xdafa0a2f, 0x48a0adab, 0x6adfb440, 0x9c9f8156, 0xbbdafb71, 0x42724c46, 0x5d52b219, 0x0c1902c0, 0xab73ab10, 0x372ff909, 0x0c4bba52, 0xbe3cf13f, 0xd8f904e9, 0x357de8ef, 0x4b8b9853, 0xd2e8a5bd, 0x0ad12d1b, 0x8fb563f1, 0xfeb51ccb, 0x2ca72e4e, 0x9232f8ec, 0x7b1f59c2, 0xd373a2eb, 0x4934908d, 0xca2908b4, 0x0a60b257, 0x7613c894, 0x9e8d0a95, 0x08310a85, 0x18e38a72, 0xf7e3dd3b, 0x91023003, 0x47f430c4, 0x9fd0b861, 0xe04d5f15, 0x627b7b00, 0xc1be62fa, 0xdde5c280, 0xa7def84e, 0xf1f2bc80, 0x3a52ae63, 0x1dafded7, 0x9f2d0c67, 0xf7e0e23c, 0x4df71751, 0xfbe52f39 },
    // Message 9
    { 0x114c7b7d, 0x6e0a4091, 0xa1ca8ff8, 0xbbebd6e2, 0xcf0e1f0c, 0xc37d6fd1, 0xd95988a5, 0x3f037509, 0xf63f01e7, 0xf7da3c13, 0x5dac7e31, 0xf3827bd4, 0x19814a2f, 0xc9eba643, 0xe76dd339, 0x4808ff4b, 0x021c6f56, 0x0a8bf157, 0x7c6da00d, 0x5bb73f8b, 0x8451c583, 0x879ff0b9, 0x0b0202d9, 0x2def9b31, 0xffe90a1e, 0x2edf353d, 0x4d5907c9, 0x5ede67dc, 0x73fc44e0, 0x3cb1996c, 0xe0232147, 0x55417647, 0x51608a6a, 0xa01891d5, 0xa24e1b0b, 0xd350fd6e, 0x6df5f0f0, 0xa25b1109, 0xaf70b2be, 0xde1eb7b7, 0x11e96416, 0xb0440223, 0x7a990004, 0x996082b6, 0xca604575, 0x37289ac1, 0x22f9f957, 0x411460d7, 0xb96d073e, 0x1cf5a29a, 0x59bb1a1b, 0x02ae9a70, 0xa003257e, 0xbd5db231, 0xaf627522, 0xc3aee50e, 0xef12de92, 0x5fbfad38, 0x1955fdbe, 0xe9912624, 0x0f4dfc59, 0x04abc583, 0xa541abb3, 0xf18e6fff, 0xd7836cfc, 0x8b5b314f, 0xb8186f24, 0xb792523d, 0xd6c278e9, 0x589106ab, 0x8309afb4, 0x9d6b1a57, 0xf9b8ca53, 0x127fa2dd, 0x6811c966, 0x3e779dc9, 0x65079638, 0x8fef2e22, 0xfb323a4f, 0x53867c83, 0xee4c4541, 0xd240a0a8, 0xef876f46, 0x2d3718ae, 0x257120c8, 0xff6c2012, 0x8205fe7c, 0xef12a0d1, 0xb2ba4c7a, 0x009eaa05, 0xd6c21798, 0x8b349dd2, 0x112ba334, 0x69e7e390, 0xe7158d36, 0x9ee0366f, 0x6ae77879, 0x2b465530, 0x32a480d2, 0x351f20ec, 0x480f8597, 0x26123637, 0x33e60117, 0x599fa78a, 0x601744cb, 0xdfa7210d, 0x577088ef, 0x9329fd6d, 0x145599c8, 0x5600b3a2, 0xb3e97a3a, 0xffffa1d1, 0x16eb6985, 0x3d492390, 0xcd0fcede, 0x083c474b, 0x213361e0, 0xa0085c40, 0x52c04f44, 0x4ed84b85, 0x17c46f1b, 0x9964fc00, 0x29e33a1e, 0xcae24444, 0xf2a63dbb, 0x2c5f1694, 0x51b97d95, 0x7fa91cb7 },
};

#define NUM_CASES 6

static const encrypt_testcase_t test_cases[NUM_CASES] = {
    { /* Case 0 */
        .iv = { 0xb6, 0xf5, 0xa9, 0x4b, 0x0a, 0xf4, 0x12, 0x77, 0x0b, 0x1b, 0x23, 0x09, 0xc3, 0x0e, 0x98, 0x0c },
        .p_data = {
            .Y = { 0xd9bc5e81, 0x5278a41f, 0x738cfbc5, 0x1b8a9e66, 0xab2af510, 0x2c9dcbca, 0x5f7f5aaf, 0x2e25ef6d, 0x816ed715, 0xdfd33bf8, 0x48bd8a07, 0x8734c506, 0xa8000f0f, 0xae247ce5, 0xb341793d, 0x1487a983, 0x7fbbd48f, 0x3187dbed, 0xdb76a21f, 0x6d30fb92, 0xa46af22f, 0xd4a6a40b, 0xc9d72a63, 0x031322f3, 0xdd70ece8, 0x00397a58, 0x3d487b66, 0x62bd7792, 0x43384493, 0x01a1b0bb, 0x0aa8e094, 0x6850a0f7, 0xe4c8b84e, 0xcd8bc178, 0xbee248ce, 0x180e1413, 0x0834e7c0, 0x65dbc25d, 0xfe9240ba, 0x55a83d31, 0xc7a33eac, 0x0902a0a4, 0x1a85f7e0, 0x3d2e9d85, 0x2df3888d, 0x039b374a, 0xb3eccdf9, 0x6941313f, 0xdf97c189, 0xb48eca17, 0xd6ea82fb, 0x94134a26, 0xae4d0772, 0xf2304d22, 0x88e033a0, 0xec796d04, 0x6d602162, 0x03a9e6fe, 0x65d23c30, 0x94b518e5, 0xfd7e673c, 0xd4daf275, 0x787c73a8, 0x4118eefd, 0x98c199b4, 0x420fea74, 0xe1c3b8d0, 0x6cfb93d0, 0x0c2a112b, 0x44949ea4, 0xf0cd7d25, 0xc096e916, 0xf3563f74, 0xf65d9eb9, 0x12bcbcb6, 0x7b209e1e, 0x25f4e4df, 0x61a3c7bc, 0xa1698274, 0x58f6e7a1, 0x45671c4b, 0x7b2b1e22, 0x3e1794e1, 0xf9bb5e68, 0xdf850597, 0x05cece2a, 0x79e91d82, 0xfc161b5e, 0xe9e11217, 0x5b1c18fb, 0x3e53ace6, 0x4e8892da, 0xcdd787aa, 0x8450b1e7, 0xe2a33d01, 0xd35754a4, 0xf68daac5, 0x10c2a67e, 0xee013ccd, 0xdebf382c, 0x0190adb8, 0x43990fe5, 0xee29aa5b, 0x95fabd11, 0x175159b2, 0xc89bfd61, 0x92ecd835, 0x45e823bd, 0x300e1fc3, 0xc2f686f1, 0x2fa2e7c0, 0x99262371, 0xc5fc3aa3, 0xc9497f49, 0xf0c12a26, 0x20bb0862, 0x05bb77d1, 0x9f0f2cca, 0xf1bdc1d6, 0xc895ad79, 0xaf1c095a, 0xb2f98d0a, 0xf7f13949, 0x82408cf8, 0x95246078, 0x7dadb502, 0xce4b534a, 0x025dbdbc },
            .M = { 0x3e5be0e3, 0xf52833a1, 0xfaaa3a32, 0x05c752eb, 0xe1b51c99, 0x13443332, 0xb4f7c41e, 0x99524fa1, 0xdfc54d11, 0xbc645327, 0xe1b033fe, 0x937eaca5, 0x800491f4, 0xf57591c9, 0xe5fc3e12, 0x80da6612, 0x9780f6f7, 0x55b11c5c, 0x0179fc8b, 0x04623dfe, 0x666a6b7b, 0x6a454e45, 0xd1a1fb65, 0x18941ef0, 0x0aa01777, 0xd9ca9098, 0xa2c6af75, 0x47856509, 0x5b73b08a, 0x057ddaf7, 0xbe9983a1, 0x65d4ce2d, 0xfc744622, 0x344b94a7, 0x8b500462, 0xc0577e09, 0x20a166aa, 0xfb600ac2, 0x18357e29, 0xad80d41f, 0x40cf7884, 0x4f0620a0, 0xa71755e3, 0xb3730828, 0x3b57c8a2, 0x037b6797, 0x0a0504c4, 0xadc84e8a, 0xe7ca75cf, 0x0d7ec10d, 0xa41d0c19, 0xf89480ad, 0x33003db2, 0xfc8fcd65, 0x6e58d19e, 0x7da9a7fb, 0x58157d95, 0x06c58ea2, 0x5ff77fc1, 0xd530d00a, 0xd5a33559, 0x86edb7b3, 0x88d67a31, 0xc009267b, 0xd43b7b63, 0xb5fe7abb, 0xf24cb5f0, 0x4bff1cb1, 0x361dc50f, 0xf9ddf251, 0xa4096a6f, 0xe472bc8f, 0x9fcff5bc, 0xc8f7b470, 0xb938b4c0, 0xf698e42d, 0xecdfc785, 0xd78d0041, 0xbfb1319d, 0x8e139488, 0xa37802e6, 0xb854ad74, 0x6a2dc19c, 0x133bab93, 0x11ffc10a, 0x2b7f4cbd, 0x278c755c, 0x94f7403b, 0xfffee20f, 0x66bf66e6, 0xb7dd64b0, 0xcc19e6b5, 0x3fe276a9, 0xa24ff09b, 0xf728ac2b, 0x9896e0b7, 0x278f34d5, 0x3c62885a, 0x0318e882, 0x42de2419, 0x625fc485, 0x9050d8e9, 0x4be23084, 0xdb339a1e, 0xed8a20b5, 0x45d4baae, 0x0f17e3e2, 0x2a8ccc9c, 0x48c0fd56, 0x72e7d7fb, 0xbce7b35b, 0xf9d33b71, 0xbf19699f, 0x043d2d8f, 0xe6ca2ab3, 0xbb8999ec, 0x70be2438, 0x6caacf3d, 0xcaf12efa, 0x0b7fe0d4, 0xd0c59b45, 0x519cb602, 0xdec543a7, 0x7b70ab45, 0xce1088b4, 0x1e4969c0, 0x946c0dd1, 0xa8023f63 },
            .Rb = { 0x249f12c5, 0xbfa04790, 0x6f15e58b, 0x622c5bd5, 0x58ed2bab, 0xbccbf725, 0xb7ef2f34, 0x44f9b33e, 0x75c70e78, 0x10106974, 0x861d85af, 0x68e8c6f7, 0xf2b40dbb, 0x7bbb891b, 0x7a9221b9, 0xdc0e7ceb, 0xd06d32ec, 0x53ae3d27, 0xb8b542bf, 0x85378510, 0x91239094, 0x3a205f3c, 0x406fe2db, 0xe91cc561, 0x58e1ef61, 0x1bcaaed0, 0x0091fe94, 0x1c62aa45, 0xaa1fd46c, 0x037f59b8, 0x5323106d, 0xc12662e8, 0x52c938c2, 0xe6c0e25e, 0xd122cc49, 0xd7386afa, 0xac74d12b, 0x6ab7a0e8, 0x869720b2, 0xfa7bc0ca, 0x773ab48a, 0xf1c10c44, 0xd7a49c2c, 0xb7a4390a, 0xd1d0327e, 0xa948aac3, 0xf52713b3, 0x256e890a, 0x911b97ae, 0x5470529f, 0x70a03d5e, 0x99c502bf, 0xb50b90af, 0x16885774, 0xd93e9bd0, 0x690e1ce0, 0x5d0531cb, 0x9ad07417, 0x439088ea, 0x57fbbd4e, 0xf304be99, 0x790196d1, 0x1f4a8335, 0xc7cbbae5, 0xad3fd79e, 0x85c3cd73, 0xdf294021, 0x8abcd42b, 0x398ec188, 0x8ebb0b9d, 0xd05edce2, 0x1fa6e879, 0xe3ac6de7, 0xc3deb4a4, 0x1e3640c7, 0x8e8fee5a, 0x66476e67, 0x3eab72be, 0xc51eb4b9, 0xca865930, 0x0285d777, 0x3880c0d8, 0x2a1522b3, 0x721ee77d, 0x34e0d955, 0xf5973965, 0x12ec085f, 0xe26061df, 0x2335063a, 0x9fe3251d, 0x9665de8b, 0x7caec6bb, 0x84b51e0e, 0xbb416b04, 0x89bd0b7b, 0x95f117c2, 0xaa0a2971, 0x5f91cefb, 0x27afb45d, 0xac96dae7, 0x5d62cb98, 0x5e9bbb81, 0x72ccf5d3, 0x2ba887e4, 0xc34b5f8f, 0x21808a6a, 0x0cc9ec13, 0x0d8dc7e8, 0x2bca56a0, 0xd68cdc1b, 0xdbb390e0, 0x84c90089, 0x21174c96, 0xd728c34d, 0xd0f6ad8a, 0x4fe46a1c, 0x954f3cf7, 0xceeba0fd, 0x1b8b48bd, 0xace97594, 0x5e4136fa, 0xc5d4fb92, 0x4f6e95cf, 0x0116c9bb, 0x3e201fdb, 0x3e839b6d, 0xf9d27fce, 0x9a0b4575 },
            .M_prime = 0x10bb9b35,
            .length = 127, // 4096 bit
        },
        .expected_c = { 0xe9, 0xb0, 0x95, 0xe3, 0x03, 0xf1, 0x78, 0xf2, 0x79, 0x24, 0x73, 0x10, 0x4f, 0x9f, 0xc4, 0x45, 0x67, 0xf6, 0xf7, 0xba, 0xfb, 0xa4, 0xcd, 0xda, 0x0e, 0x14, 0x48, 0x5d, 0x71, 0xc7, 0x2e, 0x80, 0x49, 0x44, 0xc0, 0x2d, 0xcb, 0x8a, 0x6a, 0x70, 0x33, 0xfe, 0x10, 0x0a, 0xf4, 0xa0, 0x15, 0xa0, 0xdb, 0xc0, 0x8f, 0xad, 0xe3, 0xfe, 0x0b, 0x69, 0x95, 0xd1, 0xd3, 0x09, 0x67, 0x69, 0x5a, 0x99, 0xa0, 0xc1, 0x98, 0xb1, 0x2e, 0x77, 0xbd, 0x35, 0xfc, 0x96, 0x5d, 0xb9, 0xf4, 0x9c, 0x99, 0x61, 0x44, 0x77, 0x8e, 0xa1, 0x73, 0x25, 0x2c, 0x7b, 0x95, 0xd8, 0xa7, 0xf3, 0xe3, 0x08, 0xeb, 0x48, 0xc8, 0x44, 0x69, 0x19, 0xe6, 0x9b, 0x30, 0x0e, 0x16, 0xfc, 0x2f, 0xf1, 0xe8, 0xd9, 0x2d, 0xe5, 0xa9, 0x95, 0x5c, 0x2b, 0xb3, 0xd6, 0x2b, 0xca, 0x5b, 0x1f, 0xff, 0x99, 0xcc, 0x22, 0x7b, 0x28, 0x1a, 0x26, 0x0c, 0x98, 0x02, 0x04, 0x36, 0x51, 0x4c, 0x1b, 0xc6, 0xe3, 0x1a, 0x91, 0x8b, 0x24, 0x50, 0x57, 0x04, 0xdc, 0x11, 0x6d, 0x17, 0xc3, 0x52, 0x3e, 0x2e, 0xc5, 0x2c, 0x14, 0xdd, 0x82, 0x38, 0x87, 0x48, 0xad, 0xcf, 0x5f, 0xfb, 0xc9, 0x37, 0x78, 0x07, 0x44, 0xc1, 0x79, 0xcb, 0x01, 0xf1, 0x6c, 0xe6, 0xb9, 0x59, 0x49, 0xd9, 0x6f, 0x55, 0xdb, 0x80, 0x3f, 0x64, 0x6f, 0xb9, 0xb6, 0x82, 0xf2, 0x35, 0xb6, 0x66, 0x37, 0x32, 0xc2, 0x8b, 0xb6, 0xc9, 0xe6, 0x96, 0xa9, 0xb7, 0x03, 0xd9, 0x0b, 0xc1, 0xb9, 0xeb, 0x28, 0xf2, 0x15, 0x52, 0x05, 0x7c, 0xf8, 0xa2, 0x5f, 0xc9, 0x2a, 0x58, 0xae, 0x6a, 0xeb, 0x9c, 0x42, 0x07, 0x25, 0x19, 0xb8, 0x26, 0x69, 0x2a, 0x90, 0x42, 0x7b, 0xf6, 0x0f, 0xb6, 0xdf, 0x64, 0x51, 0xd0, 0x1f, 0x08, 0xf6, 0xc3, 0x14, 0x5f, 0x2d, 0x57, 0x40, 0xde, 0x6d, 0x85, 0x52, 0x29, 0x42, 0x6c, 0x84, 0xb1, 0x93, 0x4b, 0xe3, 0xb7, 0x8a, 0xa0, 0xe6, 0x24, 0xd8, 0xa9, 0x98, 0x70, 0xd6, 0x0e, 0xa1, 0x97, 0xcd, 0x99, 0x10, 0x3f, 0x2f, 0xe6, 0x5e, 0x22, 0xf7, 0xa9, 0x26, 0xc9, 0x4d, 0x5e, 0x36, 0xa1, 0x95, 0xbd, 0xc9, 0x20, 0x1a, 0xd3, 0x68, 0x06, 0x50, 0x33, 0x2a, 0xbb, 0xb4, 0x05, 0x04, 0x58, 0x31, 0xd9, 0x5d, 0x7d, 0x12, 0x16, 0xc0, 0x94, 0x73, 0x52, 0x96, 0xce, 0x35, 0x55, 0xfb, 0x61, 0x49, 0x02, 0xe5, 0xbd, 0xc1, 0x46, 0x77, 0x78, 0x35, 0xb1, 0x27, 0x61, 0x10, 0x12, 0x16, 0x76, 0x77, 0x26, 0x79, 0xfb, 0x6c, 0x3e, 0x91, 0x8f, 0xfd, 0x00, 0x0c, 0x9b, 0xc6, 0xae, 0x43, 0x63, 0x89, 0xf4, 0x4d, 0x72, 0x05, 0x1c, 0xf2, 0x53, 0xd9, 0xd7, 0xd4, 0x73, 0x7c, 0x8b, 0x09, 0xed, 0x22, 0x74, 0x2a, 0xda, 0xa7, 0xaa, 0xf8, 0x63, 0x4e, 0x5b, 0xb5, 0x6a, 0x4a, 0x88, 0x30, 0x34, 0xd3, 0x31, 0x60, 0x26, 0xed, 0x9a, 0x6b, 0x26, 0x1d, 0xf8, 0xb6, 0x9c, 0xdc, 0x7f, 0xab, 0x55, 0x69, 0xf5, 0x40, 0x04, 0x46, 0xdb, 0xdf, 0xc8, 0xbd, 0x52, 0x70, 0x61, 0xd7, 0x34, 0x84, 0x29, 0x67, 0x53, 0x4e, 0x7e, 0xa9, 0xb7, 0x5c, 0xa4, 0x15, 0xbc, 0x53, 0xea, 0x50, 0x4c, 0x72, 0xd9, 0x77, 0x94, 0xac, 0x69, 0x5b, 0xe3, 0xe7, 0x96, 0x03, 0xc1, 0x69, 0x48, 0xcc, 0x7b, 0xdc, 0x39, 0xd4, 0x71, 0xf6, 0x1a, 0x80, 0x45, 0x00, 0xf0, 0xdb, 0xd8, 0x66, 0xe2, 0x1f, 0x7c, 0x89, 0xa3, 0x20, 0xb7, 0x77, 0x70, 0x76, 0x35, 0x3d, 0x4a, 0xb5, 0xc1, 0x73, 0x87, 0x11, 0x0b, 0x7b, 0x5c, 0x1e, 0x3d, 0x52, 0x01, 0xae, 0x70, 0x97, 0xf0, 0x08, 0x5a, 0x1d, 0x3a, 0xff, 0x06, 0xba, 0x3e, 0x28, 0xda, 0xcb, 0x64, 0xb9, 0xf1, 0x24, 0xf8, 0x6a, 0xe8, 0xb7, 0x3d, 0x84, 0xfb, 0xaa, 0x7e, 0x20, 0x4e, 0x08, 0x30, 0x36, 0xbb, 0x2b, 0xd0, 0x31, 0xad, 0xb6, 0x28, 0x04, 0x08, 0x00, 0x39, 0xad, 0x6f, 0xba, 0xd3, 0x93, 0x85, 0x07, 0xa8, 0x3f, 0x44, 0x7a, 0x8f, 0x7a, 0x03, 0x2e, 0xc5, 0xb0, 0xb4, 0x6e, 0x38, 0x32, 0xb7, 0x4f, 0x39, 0xf3, 0xe0, 0x89, 0x93, 0xb0, 0x18, 0x1e, 0xde, 0xaf, 0x06, 0xe2, 0x1e, 0x6b, 0x9f, 0xd6, 0x5c, 0x5d, 0x58, 0x46, 0x71, 0x99, 0x09, 0x08, 0x37, 0x9b, 0x04, 0x76, 0x37, 0xa1, 0x49, 0x28, 0xdf, 0x5b, 0x07, 0x93, 0x0e, 0xc9, 0x34, 0x87, 0x0d, 0x3b, 0xd3, 0x66, 0x4c, 0x26, 0x21, 0x62, 0x38, 0x82, 0x3e, 0xab, 0x79, 0xc4, 0x9c, 0x70, 0xe2, 0x34, 0x1e, 0x96, 0x38, 0x81, 0xd9, 0x8c, 0x54, 0xfb, 0xe2, 0x2f, 0xc4, 0xe4, 0xe4, 0x6c, 0xfc, 0x94, 0x9d, 0x08, 0x66, 0xa0, 0xa3, 0xa0, 0xb8, 0xf7, 0x76, 0x3e, 0xff, 0x0d, 0x81, 0x2b, 0x14, 0x91, 0x27, 0xc7, 0x63, 0xec, 0xb6, 0x2a, 0x49, 0xf3, 0x7f, 0x4a, 0xb3, 0x0c, 0x82, 0x10, 0x44, 0x94, 0x5f, 0x86, 0x47, 0x2c, 0x0c, 0xaa, 0x8f, 0xc9, 0xa6, 0xd6, 0xa5, 0xd3, 0x22, 0x1b, 0x6a, 0xe3, 0xe6, 0x0f, 0x6d, 0x6c, 0xb4, 0x24, 0x75, 0x88, 0xb3, 0x5f, 0xb9, 0x74, 0xac, 0xce, 0x61, 0x79, 0xa1, 0xd0, 0x3b, 0x79, 0x89, 0x95, 0xbb, 0x8a, 0xcd, 0xd4, 0xad, 0x21, 0xec, 0x29, 0x3d, 0xd2, 0x72, 0x46, 0x84, 0xcf, 0xb0, 0x09, 0xcf, 0x6d, 0xd1, 0x7e, 0x8f, 0x21, 0x91, 0x2f, 0x15, 0xec, 0x13, 0x18, 0x4b, 0xb2, 0x0d, 0x78, 0x88, 0xa1, 0xc0, 0x08, 0x6a, 0xc9, 0xbb, 0xbb, 0x08, 0xc6, 0x42, 0x0e, 0xf3, 0xf0, 0x34, 0xc7, 0x26, 0xfc, 0x14, 0x08, 0x9a, 0x14, 0x5c, 0x12, 0x14, 0x97, 0xf8, 0x58, 0x13, 0xbd, 0x5d, 0x6a, 0xe1, 0x14, 0x8e, 0xf9, 0xf9, 0x21, 0xbc, 0x92, 0xbb, 0xda, 0xf8, 0x14, 0x20, 0x13, 0x98, 0xa1, 0xc3, 0xf8, 0x19, 0x53, 0x4b, 0x87, 0x48, 0x74, 0xce, 0xac, 0xb0, 0x41, 0x17, 0x23, 0x35, 0xc9, 0xc1, 0xbe, 0xe4, 0x1d, 0xf9, 0x2c, 0x67, 0x52, 0xaa, 0x0c, 0xc4, 0x8a, 0x54, 0x8b, 0xed, 0x5d, 0x23, 0xaa, 0x0f, 0x60, 0x13, 0xdc, 0x31, 0xa8, 0x02, 0x55, 0xbf, 0x90, 0x71, 0x60, 0x8f, 0x91, 0x6f, 0x16, 0x3b, 0xfa, 0xf9, 0xaa, 0x8a, 0xd8, 0x60, 0x9d, 0xd5, 0x2e, 0x3e, 0xee, 0xbd, 0x9d, 0x19, 0x02, 0x55, 0x91, 0xc3, 0x0a, 0xb7, 0xb4, 0x82, 0x00, 0xc7, 0x01, 0x75, 0xda, 0x26, 0x3a, 0x74, 0x8b, 0xe2, 0x19, 0x28, 0xe9, 0xf2, 0x2c, 0x5e, 0x40, 0x0a, 0x43, 0xde, 0x25, 0xc9, 0xeb, 0xf5, 0x39, 0x78, 0xac, 0xb0, 0x72, 0x5c, 0x5e, 0xaf, 0xad, 0x2e, 0x6d, 0xf0, 0x5f, 0x1a, 0x5a, 0x7d, 0xa1, 0x12, 0xcd, 0x77, 0xf3, 0xdc, 0x5d, 0x2a, 0x2b, 0xba, 0xd7, 0x3e, 0xe1, 0x22, 0xc9, 0xf8, 0x4c, 0x95, 0x10, 0x95, 0x67, 0x25, 0xdd, 0x0a, 0xfb, 0x79, 0xed, 0xc6, 0x3f, 0x27, 0x1d, 0xb3, 0x1a, 0x9b, 0x00, 0x26, 0x0f, 0x47, 0x02, 0xf3, 0xbb, 0xbb, 0x2f, 0xb9, 0x66, 0xc2, 0x24, 0x6e, 0x09, 0xdc, 0x9e, 0x63, 0x08, 0x8c, 0xad, 0xf3, 0x38, 0x57, 0x0e, 0x6f, 0x9f, 0xf4, 0xaa, 0xd8, 0xb6, 0x34, 0x49, 0xc2, 0x01, 0x07, 0x1a, 0x0e, 0x55, 0x7b, 0x5d, 0xac, 0x15, 0xb8, 0x1b, 0x39, 0xbc, 0x10, 0x5a, 0x02, 0x3c, 0xd4, 0x2b, 0xdb, 0x01, 0x3b, 0x3e, 0xde, 0xf2, 0x2d, 0x34, 0x19, 0x4a, 0x83, 0x7d, 0x4a, 0xbc, 0x67, 0x35, 0x34, 0x7c, 0xbf, 0x20, 0x61, 0xa3, 0x8b, 0x7d, 0x63, 0x75, 0x08, 0xd4, 0x07, 0xfb, 0x7a, 0x00, 0xa1, 0xcc, 0x94, 0x64, 0x69, 0x29, 0x40, 0x63, 0x51, 0xb8, 0xf9, 0x25, 0x47, 0x72, 0x93, 0x6a, 0xeb, 0xa9, 0x20, 0xd0, 0xd8, 0x02, 0x01, 0xad, 0xc1, 0x64, 0xa3, 0x67, 0xa6, 0x76, 0x30, 0xeb, 0x20, 0x64, 0xdb, 0xa5, 0x58, 0xf3, 0x34, 0x87, 0x45, 0x66, 0x85, 0xcc, 0xf2, 0x95, 0x73, 0x2c, 0xbc, 0xbd, 0xe1, 0x4c, 0x94, 0x94, 0x07, 0xba, 0x84, 0x64, 0x1e, 0x58, 0xb0, 0x8a, 0x16, 0x3a, 0x73, 0xd6, 0x30, 0xd8, 0x44, 0x05, 0x51, 0x03, 0x9d, 0x95, 0xe3, 0xd2, 0xd2, 0xad, 0x5c, 0xdb, 0xaa, 0x27, 0x61, 0x0a, 0xf1, 0x70, 0x2f, 0x57, 0x15, 0x82, 0x26, 0x51, 0xe6, 0xb9, 0xb2, 0x16, 0x71, 0xd7, 0xb5, 0x54, 0x2d, 0x6e, 0x6d, 0xd1, 0xa6, 0xbb, 0x84, 0x14, 0x25, 0xf6, 0x59, 0x6a, 0xf5, 0xd1, 0x5b, 0x0f, 0xf5, 0xd3, 0xc6, 0xc0, 0x89, 0x8e, 0x89, 0x32, 0x30, 0xb8, 0x59, 0x90, 0xfa, 0xf2, 0xa2, 0x9f, 0x3b, 0xbe, 0x5c, 0x73, 0x66, 0xd9, 0x2c, 0xec, 0xcc, 0x07, 0x73, 0xde, 0x88, 0xe1, 0x64, 0x1e, 0x5d, 0x63, 0x18, 0xdb, 0x48, 0xba, 0x79, 0x58, 0xa6, 0x24, 0x0b, 0xa1, 0x1e, 0x20, 0x36, 0x5c, 0x93, 0x13, 0xfc, 0x00, 0x5f, 0xe9, 0x6a, 0x62, 0xb7, 0x6f, 0xde, 0xcf, 0x95, 0x4f, 0x81, 0x87, 0x60, 0x77, 0x47, 0xac, 0x0e, 0xed, 0x9e, 0xb9, 0xfc, 0xaa, 0xbf, 0x31, 0x14, 0x21, 0x00, 0x1f, 0xd1, 0x4e, 0x81, 0x75, 0xbb, 0x04, 0x8c, 0x4c, 0xde, 0xc3, 0x6b, 0x61, 0x51, 0x89, 0xcd, 0x4a, 0xc1, 0xf1, 0xee, 0xa1, 0x57, 0x27, 0x64, 0xbb, 0x47, 0x02, 0xd8, 0xea, 0xd9, 0x56, 0xf1, 0x45, 0x0e, 0xfc, 0x77, 0xe5, 0xde, 0x1f, 0x55, 0x17, 0x63, 0x99, 0x10, 0xab, 0xe1, 0xd0, 0x66, 0xb5, 0x73, 0x2e, 0xc3, 0xf3, 0x7e, 0xc6, 0x1e, 0x80, 0x70, 0xde, 0x0c, 0xec, 0x7d, 0xfc, 0xb3, 0xa1, 0x1c, 0xd7, 0x76, 0x6b, 0x44, 0x0d, 0x65, 0x96, 0xc3, 0xb5, 0x97, 0xe8, 0xcd, 0x1f, 0xa6, 0x84, 0xbf, 0x6b, 0x26, 0x1b, 0xfd, 0x96, 0x3a, 0xd8, 0xb9, 0xb3, 0x19, 0x70, 0xce, 0xbf, 0x2b, 0xa9, 0x9c, 0xce, 0x63, 0xd4, 0xd6, 0x63, 0x4b, 0x3c, 0x87, 0x75, 0x6d, 0xe3, 0x3f, 0x58, 0x74, 0x3e, 0x47, 0xc7, 0x73, 0xba, 0x37, 0xa1, 0xb0, 0x61, 0x33, 0xc5, 0xcb, 0x5d, 0xc4, 0x9b, 0xf4, 0x41, 0xb5, 0x6c, 0x56, 0xe2, 0x3b, 0xc2, 0x20, 0xdc, 0x83, 0xe1, 0x70, 0x02, 0xb4, 0xd6, 0x08, 0xa8, 0xdf, 0xab, 0x48, 0x85, 0x0b, 0x88, 0xa3, 0x8c, 0xb0, 0x0a, 0x35, 0xc3, 0xae, 0x7b, 0x50, 0x13, 0x90, 0xf0, 0x4c, 0xe2, 0x5d, 0x7e, 0xcd, 0x7c, 0x70, 0x4f, 0xd6, 0xe9, 0xc6, 0x5b, 0x8d, 0xd0, 0xac, 0xe5, 0x9e, 0xac, 0xa4, 0xbc, 0x6a, 0x3e, 0xbc, 0xea, 0x27, 0xff, 0xb0, 0xf9, 0x4c, 0x54, 0x99, 0x87, 0x7f, 0x3b, 0xfe, 0x7d, 0x64, 0x0e, 0x40, 0x45, 0xd7, 0x3f, 0x22, 0xbe, 0x57, 0x5e, 0x57, 0x93, 0x7e, 0x0a, 0x6f, 0x96, 0x9b, 0x4a, 0x4c, 0xea, 0xc7, 0xff, 0x0c, 0xbf, 0x0c, 0xda, 0x3e, 0x9f, 0xb1, 0x19, 0xd5, 0x5d, 0x30, 0xed, 0xae, 0x9b, 0xc9, 0x84, 0xaa, 0x69, 0x64, 0xf8, 0xa2, 0xdb, 0x0a, 0x0b, 0x87, 0xa6, 0x93, 0x4b, 0x15, 0x2d, 0x7f, 0x31, 0x19, 0x9a, 0xbc, 0x76, 0xc5, 0x3c, 0xe8, 0x3b, 0xe8, 0x1f, 0xc1, 0xed, 0xc5, 0xdf, 0xcf, 0x66, 0xe0, 0x6b, 0xda, 0xd0, 0xbc, 0x0a, 0xe1, 0x7f, 0xe2, 0x17, 0x0c, 0x54, 0xe8, 0x77, 0x54, 0x00, 0xf9, 0xd4, 0x9a, 0xe3, 0xd7, 0x33, 0x96, 0x7a, 0xae, 0x7a, 0xa6, 0x7c, 0xf0, 0x4c, 0x6c, 0x91, 0xc1, 0x51, 0x1f, 0x13, 0xd7, 0xc5, 0x3c, 0x09, 0xc6, 0xd9, 0x34, 0x0f, 0x66, 0xff, 0x05, 0x1b, 0x54, 0x33, 0xc0, 0xdc, 0x29, 0xa5, 0x26, 0x57, 0x9e, 0xd9, 0xfd, 0x38, 0xd4, 0xe6, 0xb1, 0x96, 0x9a, 0xf6, 0x12, 0xfb, 0x2d, 0x3a, 0x1c, 0x19, 0xc9, 0x52, 0xb4, 0xbf, 0x39, 0x35, 0xdf, 0x96, 0x0c, 0xab, 0xba, 0x5f, 0x77, 0x49, 0x3c, 0x46, 0x3c, 0x2b, 0x24, 0xcf, 0x92, 0x2c, 0x7e, 0xaa, 0x33, 0x83, 0x01, 0x04, 0x51, 0x10, 0xeb, 0xb0 },
        .hmac_key_idx = 1,
        // results of message array encrypted with these keys
        .expected_results = {
            // Message 0
            { 0xfbb74b40, 0xe374e619, 0x5e13f3db, 0x7c115126, 0x6de46b23, 0x8da94cf4, 0xbca82dfd, 0x36dc0605, 0x09ded882, 0xd93fc63e, 0x3f4f182d, 0xc9a82503, 0x12855997, 0x5e81b49e, 0x612e6356, 0x9d3065d4, 0x59588dda, 0xa7686076, 0xd250bc05, 0x548c132f, 0x74afb3f2, 0xe64e4afd, 0xe0278a09, 0xb1eb40c7, 0x2ae1182f, 0xbd18fb09, 0xd99bce5d, 0x0cea8a0b, 0x9ba0ebda, 0xa4bb85ee, 0x9d952fc8, 0x6d0d28e1, 0x6624f74f, 0x7c3780cc, 0x1dc160c6, 0xfae23c41, 0x521b525f, 0xc4c605ce, 0xf8a74470, 0x153ae915, 0x66df5b13, 0x99240058, 0x2f9ad9bc, 0xbd9032c5, 0xf8b610df, 0x71c0af21, 0x1060a640, 0x5a3044a0, 0xf4b9ef05, 0x13ddbc92, 0x3bd52348, 0xac2a7296, 0x632a2311, 0x8641de76, 0x89b8ec44, 0xf2a91646, 0x10b48913, 0x30438ad9, 0x87896ce2, 0xea99866a, 0x69c5e9d2, 0xba889f66, 0x0ab126f0, 0x2fae8e24, 0xfdd0d95f, 0x89e512c9, 0xded5dd87, 0x34ccca78, 0x7d981cd8, 0xafbbe035, 0xfc3ddd8d, 0x4b736f1c, 0xb0b08d7f, 0x26d18579, 0x873ecc99, 0xb6516ea3, 0xd8a3a0a8, 0x8cc51732, 0xb0da3748, 0x2f06ddca, 0xb6ce3545, 0x52d1f19c, 0x768baf6c, 0x3e8280ee, 0xe23773f4, 0x8483e2cc, 0x9410a287, 0x4b2c665f, 0xe3ed9cc6, 0xf8fe6a43, 0x13d008a1, 0x29e64695, 0x2a8f1cbc, 0x46487188, 0x3599a7ec, 0xd8f352a0, 0x4f63d0d0, 0x46c31575, 0xb7074e32, 0x4c513bef, 0xc087fe37, 0x9ee8a681, 0x126bb86a, 0x45704d3d, 0x0eebf8a3, 0x6b1e9929, 0x60f8c04f, 0x698c225e, 0x2e484f0b, 0xebd420e1, 0x0d4cbcec, 0x90806b6e, 0x59acf71d, 0x9d3085fd, 0xde69a76c, 0x862cf540, 0xd5b1a736, 0x6c656d00, 0xd4bc2f10, 0x8a3c9937, 0x158a07a5, 0x768e377f, 0x6b28aeff, 0xaf0e2c3d, 0x5dad8716, 0x0053eb21, 0x10dd81c7, 0x9c8ae64c },        // Message 1
            { 0x154c6f0d, 0x893dde00, 0x7d5e029c, 0x2e4b8d06, 0xbb6df4ac, 0x4cb04e00, 0x69d9903e, 0x92a87011, 0x8a2408c3, 0x89554b0c, 0xc473f6cc, 0xa9539442, 0xd373a3dd, 0x23e29be9, 0x71184cd6, 0xdb0496dd, 0x33ab6ee5, 0xd1ff944c, 0x8a59be18, 0x5eb3a04a, 0x695f9e2e, 0x9c66f231, 0x4ef5f557, 0xa02364b7, 0x2d6e8dc1, 0x9770a469, 0xbc423ecc, 0xf0d24bfe, 0x408cfeff, 0xa1ce8322, 0xfd9b0e38, 0xf113dbf2, 0x2f6f1112, 0x41079246, 0xd55fe926, 0x6b7580b6, 0xd0ffbbd2, 0xb08953cd, 0x1fa944a7, 0x1f052e74, 0x82ea3e77, 0xf96fd0aa, 0x93a6fd98, 0x9d999340, 0x73929756, 0x7d4dc5e5, 0xe83af128, 0x24a7107a, 0x70ade5cc, 0x0731b568, 0x4f9dd476, 0xf5aae73c, 0x69a436d2, 0x0e644225, 0x0a35824c, 0xd59556f6, 0xb889da39, 0xb861b76a, 0xc2608d4c, 0x6f60cae4, 0xf8b57bb7, 0xa53f6e4b, 0xbe5358e8, 0x2f250533, 0x5c3e3302, 0xf8deee3d, 0x5e4c5a65, 0xb2ea65f5, 0x9662bbf1, 0x20047818, 0x9f9271f3, 0xc14b7ba5, 0xd53cede7, 0x8c2494be, 0xb8dbd1e3, 0x91ce3f06, 0xe420b978, 0x9dcc8aed, 0x5c0843a7, 0x4dececff, 0x9c4935a8, 0xf60772d4, 0x563ed0f2, 0x19d1d292, 0xc902fb76, 0xf19c94eb, 0x8a5ea691, 0x7108cf70, 0x8b6ef23f, 0x6506c9e3, 0xef33bb00, 0xba72b340, 0x03fa28c7, 0xdd737c71, 0xdd420641, 0x957da2a1, 0xb02645a4, 0x945e6c9d, 0x5c8db47c, 0xd02cebdb, 0xc72b55a5, 0x037a2b21, 0x8a275fd5, 0x4d36326e, 0xe220273d, 0x31151800, 0xfc37e730, 0x7ec85000, 0x78532720, 0x84cca231, 0xa8a16c95, 0x72c93f0c, 0xfa4cc77e, 0x4dc73d1a, 0x370a9e4c, 0xdd362d71, 0x812dae5c, 0x634e0385, 0xd3c65aff, 0x416f4cb7, 0xeed31f6d, 0x9ebefeb4, 0x847d0839, 0xdf201773, 0x2d65c879, 0xd7e55c30, 0x50a2b1fb, 0x177f646b },        // Message 2
            { 0xf620b880, 0x217bf2cd, 0x1628ca08, 0x1c0504d1, 0x474863c2, 0xdaac839d, 0xc0c00b24, 0x5b8aaa1a, 0xb84df421, 0x46a300e2, 0x74b58522, 0x348ead4c, 0x979217da, 0xae684a30, 0x8f3d81f0, 0xfa29906d, 0x08be2185, 0x8d1bc86d, 0x620114f8, 0x286ebf04, 0xa40c02b7, 0x4a888992, 0x60cb10b7, 0xb50d40ed, 0x9c1df301, 0xe47a0f98, 0x77b59d6a, 0xdda6ea41, 0x6a0ca045, 0xbb287481, 0xf71b1916, 0xe68d6d01, 0x8f515997, 0xccc6d707, 0xa34f2e26, 0x1ee9d6de, 0xfd303121, 0x13769977, 0x9a990fcb, 0x1a32b103, 0x60141055, 0x208fa8eb, 0xb9e0a27a, 0x83a7518d, 0xb768a2a7, 0xbb4e57f5, 0x59049ae1, 0x2cdffce2, 0x507ed979, 0x4c7cdfa4, 0x01af0305, 0x64ef02b1, 0x889c3faa, 0xeac30e58, 0xcb60e3e7, 0x0908767b, 0x185e5484, 0x439157a7, 0x9461824c, 0x542282f2, 0xa339778f, 0x4961930f, 0xf2ba657d, 0x9ec23324, 0x842de8e4, 0xe3620524, 0x485a6b83, 0x06ecb4e7, 0xfbfdb186, 0xd151bd47, 0x94cb5ba1, 0x5b3b3db4, 0x1b4888c7, 0x1c87b82b, 0x3c9cb229, 0x29c1f0c4, 0xe1cf9700, 0x38954b6e, 0xbccb5cf4, 0x19f1c54b, 0x8f250486, 0x7258c7dd, 0x43460daf, 0xb97d1ec3, 0x241a291f, 0x86ac4ba0, 0xbfdd64ce, 0xb6fa651f, 0xbbdd65b5, 0xeba5db10, 0x4bf74893, 0xb24e22e1, 0x2d9c0945, 0xbade7f79, 0xf8a4d456, 0x43ec690c, 0x1ac6ef92, 0x7e3e869a, 0x062d6ecc, 0xc5b73105, 0x3e4fcb51, 0x96741d01, 0x9a21ef67, 0xc8772eae, 0x00498faf, 0x05e5e725, 0x600975fb, 0x0e3fb83e, 0xb75c2046, 0x4f9310d5, 0x9b620514, 0x7f2140a1, 0xee33197b, 0xad539c75, 0xe052de0d, 0x372337d4, 0xbe861bec, 0x1475891a, 0x245789da, 0x45ac9587, 0x0bc7c997, 0x1f2def07, 0x5a9871ef, 0xe4c3b849, 0xa36fa0f3, 0x6cab69b4, 0x9cca66d6, 0x855a048d },        // Message 3
            { 0x251cd1f2, 0x594996a7, 0x8c97afad, 0xdb76f5ce, 0xa4607eff, 0xeaf9d348, 0x5b6c0726, 0x93a1be80, 0xdd39377c, 0x7e6efc39, 0x10be7d35, 0xba0ee678, 0xd8a8a050, 0xd8c5af3e, 0x88b6aeb7, 0x6622552d, 0x2823b689, 0xc8a16dfd, 0x2da1cd21, 0x66caad46, 0x07e36a34, 0x1545a5e3, 0x5570f123, 0x28b4eec5, 0xf6aac927, 0x71aa8ad8, 0xe99513b9, 0x46990c24, 0x141d6a0e, 0x6c9a599c, 0x02172a3b, 0xa537c9f0, 0xf6267ea9, 0x6c819eb4, 0x1f12cf67, 0xc20a92a9, 0xe347d7ba, 0xb5055575, 0x89cc5300, 0x7dc0441a, 0x0f7e8123, 0xeabba812, 0x2eb32ada, 0x86763f88, 0x584e8747, 0xa6ed7130, 0xbcd64bdd, 0x67fef4c5, 0xc3176bfb, 0xf9559dfd, 0x6e7774a8, 0xff6be862, 0xd600b8bd, 0x92cd7c59, 0x2e0eec59, 0x0bd6f56b, 0xc78306fe, 0xf0dd994f, 0x84e19119, 0x070e6c58, 0xf4b0d608, 0x16b4d852, 0xa8f41101, 0xb6209170, 0xe8f34d78, 0x869a50b7, 0x5fabb0ba, 0x22a1a136, 0x049c258b, 0x5fdcd9cf, 0x22f1dfc8, 0x742db2ef, 0x7b53a211, 0x880e2357, 0x55d28f55, 0xb89cda05, 0xf006e0fd, 0xd79165a2, 0x72edbb99, 0x00e92524, 0xf9e44ccf, 0xbe2482a8, 0x6ecef96a, 0x7db4a9e3, 0xe22e91ff, 0xaf790acd, 0x4d13cb47, 0x86b160c1, 0x9cdc9680, 0x486a41e8, 0xfd755bfc, 0xa53f2bcf, 0xaf5b02f1, 0xfcfbb672, 0x3c695034, 0xa5a4a863, 0x793ef2aa, 0xf677dd31, 0x9b9f80e5, 0x2634504d, 0x6f10a58c, 0x3d8242fd, 0x88dee96f, 0x84be51b0, 0x80e607cd, 0x0abee960, 0xa069f191, 0xd663f8e2, 0xe9b28406, 0x0e42b309, 0x8ba4632d, 0x744abc04, 0xacafdb68, 0xe9ce03c3, 0x010d9093, 0x46317cb3, 0x25c55562, 0x1d8013d1, 0x7e5b24b2, 0x77877589, 0x16872b15, 0x10c6e231, 0xc2177c50, 0xea84d46c, 0x01c06181, 0x852a5f00, 0xa15d3b80, 0x1cf6a21e },        // Message 4
            { 0x8e450d5f, 0x6ad0dd00, 0xf494c37a, 0xba60b757, 0x9e528e32, 0x8ad223f6, 0x4e4ac37e, 0x864eafca, 0x3dc4d02b, 0xf5c89928, 0xff864462, 0x898c9c60, 0x31a57b3e, 0xc00a3f8a, 0xb76a25cd, 0x133025c7, 0x923fd239, 0xab6e0104, 0x7b0db6d3, 0x1ae4b0e7, 0x138f9171, 0xbaae0554, 0x03c5678c, 0x88b9168b, 0x2646a196, 0xeb89a848, 0xb04fcecb, 0xe8e6318b, 0x168c6d3a, 0xe94c6b6f, 0xb8711658, 0xce7cc24a, 0xbef25a0c, 0x6afbe897, 0x5668f8cb, 0x9c8f3bcf, 0x1d482de1, 0xd14b386f, 0xeebf404a, 0x0d8b4b42, 0x58d65520, 0xe2ebb9a7, 0x3cd269a4, 0x6583accc, 0xc29cca81, 0x2b5c3944, 0xac1f9a4f, 0xc6aa106f, 0x38de4972, 0xc8681bed, 0x20657187, 0xd91e23b4, 0x97d6efaa, 0xf2cc1855, 0x9185c4f0, 0xabc3b423, 0x28680d3c, 0x82de1141, 0x916053d3, 0x9af73e47, 0xea4d2741, 0xab2910e6, 0x7577ad7f, 0xe8ca0842, 0xbae59043, 0x5fc14a23, 0xfafe4784, 0x1cc899bb, 0x80a3f00d, 0xade3aa31, 0x18648dff, 0xf0f48d62, 0xa10688d6, 0xa7141a1f, 0x803fd159, 0x53a80a18, 0x2b67e2ca, 0x459c9d97, 0x47cd5ad7, 0x45f9e4b1, 0xc1189f8b, 0x19e164b7, 0x94ae2457, 0xb6bf30dc, 0xb11d67d1, 0xc53ca3c8, 0x13279983, 0xbf0795d8, 0x119734a5, 0x0f322272, 0x8935dc32, 0xc4f391b3, 0x47fec962, 0x05291603, 0x079e420b, 0xf8111bb1, 0xff10edff, 0x5e8000c0, 0x7befdb2e, 0x2dc21eb6, 0x1143bb6b, 0xaad6e511, 0xa0edd169, 0x886e625b, 0x8cd085a7, 0x7bec0223, 0x8650853d, 0xc209055d, 0x9c2c4194, 0x0226c197, 0xaa8fa4c2, 0x5366f876, 0xaeebe186, 0xdfbb7f09, 0x86422ac4, 0xdeb9c38e, 0xde6eb812, 0x03b326c9, 0x5bdf5c5a, 0x6c6d2bec, 0x1741eaac, 0xc9470180, 0x15c59502, 0x79f931e0, 0x99963116, 0x68e0a0ce, 0xe992dd6e, 0x86a26261 },        // Message 5
            { 0xfae3ee44, 0x60e00973, 0x529a647c, 0x5c77b6fd, 0x37d8ae67, 0x7644c936, 0xaa021da8, 0x8aad585d, 0x39b0f64a, 0x92d8faea, 0x490740cc, 0x0bbde4c0, 0x2dfa365b, 0x8de0252d, 0xd63905d3, 0xe85f77ae, 0x3b8cf0f4, 0x28cd27c5, 0xf5d8a39d, 0x5bfa068b, 0x38de4c93, 0x3ef1c7f5, 0xd274a075, 0x3d3eebcc, 0xbe1b1804, 0xebe368a5, 0x5f22ceb4, 0x5964c309, 0xd1a44d2c, 0xebefd6a7, 0x3c596525, 0x2fd4ea75, 0xf751a130, 0x7ed57b2c, 0x53d543fc, 0xcada892c, 0x28a62ffa, 0x65bde524, 0x93b72e41, 0x86b6f11f, 0x3f1f6acb, 0x372109eb, 0xca351285, 0xa7b45bdd, 0x8f981c5a, 0x9c09556a, 0xb7845478, 0x34d18840, 0xd531e749, 0xbb9e5d52, 0xd0f2499a, 0x33d941f6, 0x050256d2, 0xeb5feac0, 0x06920ec9, 0xb38205e1, 0x68d9558a, 0x2ff020ef, 0xadb7d176, 0xc5e29bb5, 0x78ef0b80, 0x0cb42fb5, 0x6bacd277, 0x49c6fe88, 0xb2d87ca8, 0x140716e6, 0x2c9310b1, 0xe1f619aa, 0x3dab476d, 0x679c140c, 0xcf8f1ff1, 0x1ba0d9ed, 0x0031ddc1, 0x3be56f1f, 0xb79c5649, 0xfe23c8c2, 0x15b3a1dd, 0x1b6b5a49, 0xdd6343a5, 0x5c68362c, 0x88b40e2c, 0x1cf400cb, 0x08395155, 0x6d537d59, 0xb7906d58, 0x4ba13819, 0xf26e4f9c, 0x0c2285cd, 0x1814ae52, 0x5e550533, 0x8c07c227, 0xd8c7d099, 0x4179c9a5, 0x01747fad, 0xe9c86a72, 0x62905779, 0x1a5a42d8, 0xf667a583, 0xc17bbc19, 0x35b4cdd1, 0x67fefbd7, 0x64a2d08f, 0xeadbe370, 0xb51d09f9, 0x2a16c1e2, 0x20a4e179, 0xc65be038, 0x28137542, 0x2eced8c7, 0xa7622629, 0x386cc4af, 0x6c8ec462, 0xac96b1a6, 0xfa5e1028, 0x6a8e29f5, 0x83e31df2, 0xc5ecb1ac, 0x353a6734, 0x8224971e, 0x6e5795ee, 0xed425a2e, 0xf2484f56, 0x04a98a76, 0x798d8730, 0x6b8bc8ba, 0x554c1511, 0xe10a6957, 0x1db9e1ad },        // Message 6
            { 0x7dc11dff, 0xb1156ada, 0xb23d6a94, 0x23548c27, 0xec712d07, 0x83974324, 0x53dcd264, 0xde546fd4, 0xbb464aa5, 0x77ce12d0, 0x5792800d, 0x07d83939, 0x50afe0e7, 0xfac5d626, 0x79b31e5f, 0x1c18ab84, 0x81a4b82a, 0xb42481c3, 0x5a76f763, 0xd173db91, 0xbdbdccd2, 0xc2d07502, 0x9d845ca3, 0x2ee9dc99, 0x09317aa0, 0x0c4bf0d0, 0x94257465, 0x0cf8a221, 0x9ad1d006, 0xb4d3ce4c, 0x4b63ccaa, 0x437fa97f, 0xb415582a, 0x68c5f7f5, 0x45df2a12, 0xc1f26f6f, 0xe866558d, 0x291d1dd5, 0x58b81986, 0xaf2f2c09, 0xf44a1d2a, 0xd7faf0a9, 0x482bd662, 0x73da75a7, 0x757363a8, 0x85c33b90, 0x9716dada, 0x88c409f3, 0x1084d962, 0xa2ccee92, 0x9e749976, 0x64ecfdf6, 0xff2c5376, 0x247e7205, 0x28f2ffdd, 0x4feb7d32, 0x8c2d9f14, 0xd9f1becd, 0x7f3945f1, 0x99eff322, 0xd6c78add, 0x07d09180, 0xdc233a10, 0xd3f70b29, 0x5476c844, 0x45af6fd5, 0xafdc264b, 0x660bb873, 0x8b49e478, 0x739e5862, 0x421fd9bf, 0xe9b7fe8b, 0x9d54492e, 0xb24e52c5, 0x5d4dc940, 0xabd5c995, 0xa191afd1, 0x84ebb1c1, 0x3193317d, 0x66eb4eda, 0x34d7fef6, 0x694af146, 0x99018e25, 0x4a51ce83, 0x1e1ba0d2, 0x412b9ebe, 0x67836ee4, 0x28194719, 0xd087e92f, 0x2f008a49, 0xfb793379, 0xa3b0f3ca, 0xea670b5b, 0x9b7d2897, 0x5736eb1d, 0x33c381ce, 0x8cf7708c, 0x344ab658, 0x9fad8c4d, 0x993f0c5b, 0x25296e78, 0x99c10d8e, 0x11c5d555, 0x2f111753, 0x3284ce18, 0x743af7c0, 0x5f4d0b95, 0x81b16894, 0xd60a6eda, 0xb701fe87, 0xfaa6d80a, 0xef966884, 0x80ea6bd3, 0x15999e6a, 0x970adadb, 0xbdcad573, 0x61f41970, 0x9609603d, 0x4a81e22d, 0x1c165af9, 0x5c8b7661, 0xc7e71dbc, 0xa765cc2f, 0x81480902, 0x0ab291fd, 0xb24b0fe8, 0x89bd0a03, 0x197f9145 },        // Message 7
            { 0x2e389a08, 0x629db53a, 0xfead0a32, 0x6b1a1b3f, 0x4db22855, 0xea7bc14b, 0x22d28362, 0xc8aaafb0, 0x09574613, 0x1186a531, 0x7314d648, 0x269abc08, 0x47db9ef4, 0x3d4fd364, 0x674d2960, 0x63949eab, 0x099645b2, 0xf6fe1777, 0x60ff4598, 0xce40cbba, 0x6e94f60f, 0x5f6d7fe4, 0x82458625, 0x33052262, 0x16027ecb, 0xc5be855a, 0xa7f22f87, 0x0116d93d, 0x0ef05754, 0xf6c74648, 0xf51656b9, 0x90a06115, 0x8dd01ad5, 0x4f9050f1, 0xbcf8cf7b, 0xb14fba3d, 0xa1285f92, 0x62758a5e, 0xee909968, 0x4182f5dc, 0xed3e055a, 0xe05a023b, 0xa0b00ad6, 0xfb5cf304, 0x583406d7, 0x0539162f, 0x101c41d8, 0x514b29d6, 0x3eb3f2f7, 0x23bb7a8e, 0xbe33d2ec, 0x7315852c, 0xd5ecb314, 0xf9c562d6, 0x86a6ae5f, 0x7f3c3963, 0xae44e848, 0xe83b84c0, 0xe2ff7e1a, 0xce70d227, 0xcbe3ed46, 0x50d83022, 0x62039d34, 0x2bc65794, 0x4c3e1fc9, 0x2526dc47, 0x6008680f, 0x8de3580e, 0xf8c1f7f4, 0x2dbe4fa2, 0x48180f90, 0x779c0e90, 0x81c73e5b, 0x5e114ab8, 0x61751abb, 0x16ae818a, 0x057b21bd, 0xbcff0537, 0xcc6f7774, 0x4f94d9f5, 0x32d4c296, 0x73a384ee, 0x1d75ed46, 0x9044e2bc, 0x2f0e3f76, 0x76d94e88, 0x45e1f18d, 0x4a02f43b, 0xcab2bedc, 0x996f535c, 0xe4de18dc, 0xc0e0c081, 0xbd967d90, 0x6ed1493f, 0xda0cdabe, 0xc86dc1a2, 0xf240dd7b, 0x85d87e49, 0xec38a229, 0xd9b9d1af, 0xca98c8d2, 0xfd0245ec, 0xc265bf26, 0x37d7ea68, 0xf3ebc9e4, 0x39e9aa93, 0xb8fa7d3d, 0x37aa0b8e, 0xd052314d, 0xdd12882f, 0x9759b302, 0x21ee3b31, 0x315009cb, 0xc3358ae2, 0x1e44340e, 0x9584300f, 0xf1f6b83f, 0x48f4bfab, 0xe17785c7, 0xa9c2f604, 0xdbc7ff0b, 0x2628cb1d, 0x3919c8e6, 0x7330d62a, 0x2f25fa8b, 0xe5ee3990, 0x7a91b924, 0x02893f77 },        // Message 8
            { 0x68ec8519, 0xf571b9c8, 0xbb38c337, 0x46fe53a8, 0x10626192, 0x2e89e74f, 0x65c40bb6, 0x948dfc3f, 0xb1ca54fd, 0x210563b2, 0xb49711c6, 0xa977fcc6, 0xdfbebc09, 0x781201dd, 0xd00a59ba, 0xdfc3d908, 0xe979f20d, 0x6328d52d, 0x24036580, 0x7ac3cc1b, 0x250d69fc, 0xf43c9944, 0x1103a4a7, 0x70074821, 0x505a1256, 0x78d1a577, 0x13fe8bd1, 0xcd27b13b, 0xed2b505d, 0x65d4dc75, 0x7a1057fc, 0x0329d776, 0x788d92dd, 0x296bf77a, 0x364761e8, 0x44878f25, 0x9e951b12, 0xbc332538, 0x4c31b43d, 0xe832195a, 0x6bd1d3fe, 0x49ce1265, 0xb312bfd5, 0x2722bb91, 0xc7facfca, 0x5c568aeb, 0xca6cde0f, 0x58c9ddcc, 0xdd2558f9, 0x1f3f5438, 0xb9243f7d, 0xaf12f165, 0x57bd24c8, 0xd17a76ff, 0xd194afbe, 0xe4bf7a7d, 0x2b468c6a, 0x2b0620ef, 0xdd64bc8c, 0xffc4fb90, 0x6c0230ec, 0x6b1d25df, 0xe5a825fe, 0xfc617173, 0x2bf790aa, 0x6a3a015e, 0xba5cbdd0, 0x84da315c, 0x885b072b, 0xbb8f3fd7, 0x501bf81f, 0x1f8337fc, 0x772f858d, 0x9e41d3b9, 0xa6a1d2b7, 0x4266c4a8, 0x5ef537c4, 0x7938501c, 0x07c38f7e, 0xa6c63cbc, 0x570082fa, 0x2bc5b3e7, 0xe8ee0268, 0xc0776a2b, 0xcae6c48d, 0x8512383c, 0xf61051ee, 0xbc668b50, 0x10f2451b, 0x859bc0ee, 0xa7659871, 0x89f167e7, 0xbcacb15b, 0x14b6b16e, 0xf5efe62a, 0x85a2ff2c, 0xd6a0ec4c, 0x827140be, 0x7a2bdea1, 0x1945c255, 0x118c97bb, 0xd32324fb, 0x2b487f54, 0x11c606ec, 0x7a8f5b36, 0x33a7cfa0, 0x11a03731, 0xfcbd1a14, 0x5bd9cb85, 0xeae08c9b, 0xf67e2abe, 0x882c7b9e, 0x49a16cc9, 0xaeb4d6e0, 0xb1863649, 0xd228b211, 0x751f005b, 0xc6f3cd54, 0x77d206e9, 0xcaf57852, 0xc76e543e, 0x124be84a, 0x361d35fc, 0xded42998, 0x0683a134, 0xd0d9dd6a, 0x7d91d1b0, 0x3c08073e },        // Message 9
            { 0x08b22864, 0xfdc51028, 0x7b1e8f1f, 0x70d5716c, 0xa187b780, 0x658c1164, 0x78f34049, 0xb45926a6, 0xa95d7b70, 0x45f21c13, 0xd35d3712, 0x69f9f676, 0x7f79cd5f, 0xbe6e6e05, 0x898923c9, 0xe5c27236, 0x427db647, 0x45cc0175, 0x9c1c52b5, 0xcd48aac8, 0x41b82773, 0xd9841a08, 0x1bc4433a, 0xd1e155b3, 0xf48c7c9c, 0x1d8c8bbe, 0x572b856e, 0x9d638bfa, 0x69d2ebba, 0xb1c97e2f, 0x349675dd, 0x89eb7c45, 0x8071bfd6, 0xb9d62198, 0xeb117c56, 0xd8d20636, 0x3bb7f484, 0x0167c059, 0x9b006f91, 0x53313146, 0x3dffdca0, 0xfef27540, 0x8a554c03, 0xbbed0920, 0xfa0ae45b, 0xc6898b45, 0x0cdcc4c7, 0x0a361b64, 0x14c72edb, 0x9d649bed, 0x57111e81, 0x86e49ac9, 0xe84bb28b, 0x8df11985, 0x8adc2d7d, 0x1312dfea, 0xc0b3225a, 0xfc7801c5, 0xd2e1c447, 0x5d7b1814, 0x445c1084, 0x94bb8fc9, 0x523fc3ce, 0x6ab2e330, 0xf85da456, 0x86179ef3, 0x018d44f4, 0x2415f643, 0x866d90ae, 0xe7ea7afc, 0x5309f860, 0x324b0b46, 0x31316b2a, 0x2dde18c3, 0x69243936, 0xf0495848, 0xe3f89e69, 0x05d3ea06, 0x92b78005, 0x9942cbed, 0x03d912bf, 0x7f9bc3f6, 0xe87298c2, 0x2e08af7c, 0x0c6fdb87, 0x75a14da4, 0xf034dc24, 0xc3a7db20, 0xb3b8e530, 0xa35721ed, 0x584f1c4f, 0xe0c8c764, 0x43edc51b, 0xf8821414, 0x0c9e4a2a, 0x39d94bf1, 0xcddc96fd, 0x0b3e4b2d, 0x743d2fe8, 0x21f5d70f, 0x164538db, 0x60aaa592, 0xfa62bcff, 0x7cc19be4, 0x3db5edfb, 0xbab4a921, 0x30c68244, 0x139f7bd6, 0x797b0e30, 0xb7f9e399, 0xe7272a08, 0x70ae9449, 0xeae4ed71, 0x8b884db8, 0x9ddbd0f0, 0x3bfdbc06, 0x3b6ae04f, 0xd5fd13ab, 0x4a55db2d, 0xeb8926bd, 0x23c262a9, 0x746a862e, 0x8fe3193f, 0xcd0e9c7d, 0x68242a25, 0x3249df04, 0x0dae94cb, 0x79a3f7f8 },
        },
    },
    { /* Case 1 */
        .iv = { 0x97, 0xd4, 0xc6, 0xa6, 0x36, 0xf6, 0x5b, 0x90, 0x2d, 0xbe, 0x19, 0x38, 0x75, 0xcd, 0x08, 0x56 },
        .p_data = {
            .Y = { 0x951a34c9, 0xccae5647, 0x7a079316, 0x845cada2, 0xbebb34e0, 0x95094811, 0x185654f0, 0xf4db9796, 0xd249a05e, 0x099a3b3f, 0x133822d8, 0x94ade868, 0x616ded7e, 0x2a075baa, 0xfa5a21b3, 0x3f918c50, 0x7fa678f0, 0x71d34ae8, 0xa01c1f1e, 0xec44ab64, 0xa186d5f9, 0xa267aa5d, 0x80efb9db, 0x9a289e76, 0x529f74e1, 0xe8aaa733, 0x668574ef, 0xabaa3f14, 0xd3e35805, 0x3af660a8, 0x6bf87b6c, 0x2a920dda, 0x75b5c0a7, 0x372bd1bf, 0x1acaa469, 0xbfe31c02, 0xfab811bc, 0xeb9b939f, 0x8a879c99, 0x95b7655d, 0xa0ca67ed, 0xa4dcb019, 0xb4d202b7, 0x80fd4048, 0xe7671fb1, 0x04a8241b, 0x79c44a87, 0xe8e5d70f, 0x8aa37edb, 0x4871b066, 0xa241611c, 0xcb3fe7bb, 0xb5980f9a, 0xe4531acb, 0x67ebf907, 0xf3afabee, 0x6bbe7ce1, 0x2882357d, 0x3214dca5, 0x3430c6bb, 0x29adc028, 0xd2dae59c, 0x3d9e0955, 0x6a7ebbe6, 0xd081f470, 0x0cfc91f0, 0xe06b3d89, 0x79523cb4, 0xb2c8b52a, 0xefbc02d1, 0xdfc09bb5, 0x34f383d4, 0xeb423eea, 0x7c0fbea2, 0xde81af74, 0x56ffd15a, 0x49158963, 0xeaed41a1, 0xb2a54d3f, 0xf4d486c3, 0x9cde7214, 0x0de6379c, 0x25d9c928, 0x06581ceb, 0x0fd03112, 0xb5bf67b8, 0xef8e4069, 0x8a9adb3b, 0xde33afb3, 0x20ebb56e, 0x11ce27ad, 0xa119f507, 0xebbefb2d, 0x51fc6edd, 0x1425b833, 0x861ae340 },
            .M = { 0x31bbd807, 0xa861c407, 0x92f96b67, 0x9f4c5d3b, 0xaa1a43c3, 0xabd90e5b, 0x89c3d4ca, 0x43ec5589, 0xe434cef6, 0x43f89089, 0xd43a64ff, 0xf6136391, 0x14b4011f, 0xabe85ecb, 0xbfb858f5, 0x4360c9ed, 0x6f287d4d, 0x22291aae, 0x5e70e0f6, 0x889f7942, 0x5aec9b03, 0x743bfd6e, 0xa0f20fad, 0xc59e70e0, 0xddeda78a, 0x40bf8fcb, 0x9a39225d, 0x6039fded, 0x237cf58c, 0x488a4f19, 0x9cac5843, 0x58b5fd62, 0x0d2c93bc, 0xf34d0397, 0x82fd3243, 0xba1d0ea4, 0xc29f1dc9, 0x997e49d2, 0x3c7f513f, 0x811bbd66, 0x0623e514, 0xbae0d286, 0x6b2f233a, 0x7001fc67, 0x7be399ab, 0x852211dd, 0xe83b72a5, 0xeed324af, 0xb9423f45, 0x619cbbc8, 0xb432cfa4, 0x92c2af7d, 0x93836f52, 0x8e3abcd4, 0x957bf4ab, 0x821db4f6, 0x7efbb842, 0x0d76ddc1, 0x085f699b, 0xf1b54ccf, 0x33a35100, 0x9008f633, 0xf2ae840c, 0x03a9a5db, 0xee98a0c1, 0x0026dcfb, 0xeab30f7c, 0x0454632e, 0x1572233a, 0xad2d3b0b, 0x3aeae29b, 0xc4ba69a6, 0x44d1143c, 0x60236cdb, 0x54657fc7, 0x91ed80e5, 0xf9f60c63, 0xc9a18b09, 0x4ca49a40, 0x9a48c57a, 0x9fd6f197, 0x64cd425f, 0x768ec7d2, 0x5029d3ec, 0x953f175d, 0xa1ff2ad4, 0x52ae91b9, 0x47e7b7a8, 0x5ebae7bb, 0xd33bdd63, 0x4988976b, 0x7cb0349f, 0x3db77b04, 0x36096709, 0x31dc1550, 0xcb6bfedb },
            .Rb = { 0x7275f857, 0x4d7defcc, 0xdb5e757b, 0x8f452c9b, 0x44b52168, 0x70e6ac35, 0xcf58398a, 0x3b2fb477, 0x8bd83728, 0x96c95676, 0x510b3241, 0xadacb956, 0x8c5565b0, 0xcb39dde9, 0x797b8fa7, 0xde254108, 0x243dfd87, 0x6f9ca2b0, 0xca3c2a6b, 0xd4d73187, 0x2d3b5ece, 0xf7f74b31, 0xf5346a71, 0x473410dd, 0xbc03d660, 0x0bf5f2cf, 0xbe949594, 0xed2e027a, 0x473ca37d, 0x9ab7f84c, 0x93863217, 0x065afc4b, 0x67331ba8, 0x2ec262ba, 0xdd215fa1, 0xb7e6046e, 0x454dba87, 0x95d5014a, 0x013ab8b7, 0xf43948f3, 0x414c5335, 0x9d2ff8b0, 0x1f3889e2, 0x2ec3cff3, 0xbf4fa9db, 0x43c3a45a, 0xe68270f6, 0x718d9762, 0x9fa85fec, 0xe20a4344, 0xe11d2655, 0x956e2c77, 0x3c27e149, 0xbc17d416, 0x432441b7, 0x00ce539f, 0x3fb73f3e, 0x3344e09d, 0xcd1273c6, 0x6b518f83, 0xbce56b31, 0x73d85ebe, 0x06e7a087, 0x079680b5, 0x7163bc88, 0x2ef149ac, 0x961431e4, 0xee92e9c3, 0x8a25b3ca, 0x35735064, 0xa3cec88e, 0x45eaf68f, 0x2edf5f53, 0xff40043d, 0x70253035, 0x27f5b91f, 0x07a8eef7, 0x4a9fe48f, 0x3affdfac, 0x949fd3a1, 0xb1354085, 0xa654404b, 0x63f3d375, 0x6ccce12d, 0x11b8b819, 0xf13c8016, 0xb56a9b87, 0xc657dd11, 0x7725986f, 0xc5ad4e73, 0xc25732cd, 0xe15ffb93, 0x0e328ccf, 0xf618976c, 0xd3e09a5b, 0x5a98416e },
            .M_prime = 0xd9ffea49,
            .length = 95, // 3072 bit
        },
        .expected_c = { 0x81, 0xa5, 0xd8, 0x77, 0x3c, 0x8b, 0x6c, 0x26, 0x46, 0x72, 0x8a, 0x5c, 0x3e, 0x19, 0xcf, 0x2a, 0x72, 0xde, 0x38, 0x6d, 0x5d, 0x8d, 0x74, 0x6d, 0x89, 0xdc, 0xc6, 0xf7, 0xed, 0x1b, 0x7a, 0x1a, 0x44, 0x04, 0xe7, 0xfd, 0xb2, 0xce, 0x26, 0x51, 0x01, 0x18, 0xf2, 0x45, 0x81, 0x4c, 0x77, 0xb6, 0x95, 0x1c, 0x5d, 0x66, 0xa3, 0x21, 0xf7, 0xef, 0x5b, 0xf1, 0x5c, 0xbc, 0x7c, 0xda, 0x5d, 0x82, 0xcf, 0x94, 0xae, 0x34, 0xbf, 0x98, 0x1b, 0x6e, 0x8d, 0x14, 0xc5, 0xbb, 0xed, 0x9e, 0xf3, 0xdc, 0x63, 0xa3, 0xd8, 0x0d, 0xc0, 0xcf, 0xdc, 0x4f, 0xd5, 0x0f, 0x13, 0xb8, 0x8d, 0x12, 0x92, 0xf1, 0xdd, 0xc5, 0x6f, 0xd3, 0x69, 0xef, 0x94, 0x77, 0x87, 0x7a, 0xeb, 0x97, 0xf5, 0x02, 0x40, 0x8b, 0x5a, 0xd5, 0x9a, 0x1b, 0xb7, 0x89, 0x04, 0xb4, 0xb9, 0xf2, 0xaa, 0xb7, 0xd1, 0xe4, 0xb5, 0xb1, 0x76, 0x4c, 0x8d, 0xd1, 0x10, 0xf3, 0x0a, 0x0e, 0x54, 0xf0, 0x27, 0x23, 0x08, 0xa2, 0xf5, 0xd1, 0xfb, 0xc6, 0xa9, 0x12, 0xc6, 0xb0, 0x4d, 0x8d, 0x5f, 0xe3, 0x24, 0xad, 0xf8, 0x7c, 0xea, 0x62, 0xa5, 0x28, 0xeb, 0x0b, 0x93, 0x6d, 0x75, 0xa4, 0x6b, 0x1e, 0x28, 0x4a, 0x97, 0x75, 0x43, 0x46, 0x4e, 0x75, 0x1f, 0x13, 0xfc, 0x93, 0xa6, 0x9c, 0x7b, 0x66, 0x2d, 0xda, 0x3b, 0x60, 0x57, 0xb4, 0x5e, 0xaf, 0x25, 0x5b, 0x32, 0xbf, 0x3d, 0x02, 0x40, 0x7e, 0x10, 0xac, 0x00, 0xa8, 0x68, 0x1b, 0x32, 0xe0, 0x82, 0xa8, 0xf5, 0x6c, 0xa3, 0xfe, 0xdf, 0x3c, 0xde, 0x01, 0x78, 0xe5, 0x12, 0xe7, 0xdc, 0x8e, 0x09, 0xb5, 0xbf, 0x8d, 0x13, 0x49, 0x2a, 0x47, 0xcf, 0x97, 0x1d, 0x64, 0x93, 0x13, 0x39, 0xb1, 0x98, 0xb6, 0x40, 0x77, 0x04, 0x37, 0x30, 0x97, 0x62, 0x63, 0x31, 0x61, 0xb9, 0x12, 0x97, 0x43, 0xe7, 0x94, 0x82, 0x84, 0xa9, 0x3f, 0x1d, 0x64, 0x7b, 0x5f, 0x75, 0xdc, 0x88, 0xec, 0x8f, 0x65, 0x53, 0xb2, 0x11, 0xa3, 0x81, 0x28, 0xd9, 0x7b, 0xdd, 0x8a, 0x01, 0xed, 0xfa, 0x7c, 0x41, 0xe3, 0x04, 0x2c, 0x70, 0x6e, 0xb7, 0x1d, 0x72, 0x0d, 0x60, 0x0f, 0xaf, 0x66, 0x0d, 0x47, 0x10, 0xa6, 0x9d, 0x65, 0x5b, 0x4f, 0x0d, 0x85, 0x51, 0x2c, 0x2c, 0x4c, 0x7e, 0x30, 0xd5, 0x45, 0x66, 0x53, 0x8b, 0x31, 0x7f, 0x50, 0xc9, 0xd3, 0x70, 0x08, 0xe5, 0x0c, 0x4d, 0x7e, 0x68, 0x91, 0xed, 0x5a, 0x12, 0xd7, 0x45, 0x18, 0xb6, 0x20, 0x70, 0x04, 0x23, 0x21, 0x5f, 0x9f, 0xc8, 0x00, 0xf9, 0x28, 0x03, 0x4e, 0x96, 0xf4, 0x1c, 0x47, 0x83, 0x9c, 0x47, 0x95, 0xde, 0xf6, 0xd9, 0xb3, 0xfa, 0x81, 0xad, 0x2f, 0x77, 0x37, 0x47, 0x80, 0xd7, 0xe3, 0xf2, 0x15, 0x73, 0xf2, 0x7b, 0x61, 0x4b, 0x0a, 0x97, 0xfd, 0x1a, 0x7b, 0x50, 0x3b, 0x98, 0x3d, 0xf5, 0x55, 0xc3, 0x7b, 0x79, 0x57, 0xbd, 0xba, 0xe5, 0x3e, 0x45, 0x46, 0x11, 0x51, 0x7f, 0x36, 0x16, 0xbb, 0x03, 0x67, 0x7f, 0x80, 0x1b, 0x6f, 0x62, 0x84, 0xb7, 0x27, 0x00, 0x38, 0x1e, 0x42, 0xbe, 0x29, 0x3d, 0x8a, 0x5b, 0xd6, 0x58, 0xa4, 0x4d, 0xbb, 0xaa, 0x6a, 0x0a, 0x12, 0x13, 0x2e, 0xbf, 0x00, 0x62, 0x28, 0x85, 0x1f, 0xd6, 0x1f, 0xd5, 0x36, 0xa2, 0xbf, 0x82, 0xbb, 0x31, 0x75, 0xe6, 0xa6, 0x86, 0xc8, 0x5c, 0x51, 0x73, 0x82, 0xdf, 0xf1, 0x56, 0x62, 0xa8, 0x16, 0x6f, 0x13, 0xa4, 0xb1, 0xe9, 0x46, 0x55, 0x3e, 0xeb, 0x7c, 0x00, 0x4f, 0x97, 0x54, 0xfd, 0xd5, 0x66, 0x78, 0x50, 0xe9, 0xcf, 0xb5, 0x73, 0x75, 0xcb, 0x3f, 0x8b, 0x3c, 0x5e, 0x70, 0xb4, 0x60, 0x5b, 0x12, 0xd2, 0x70, 0xad, 0x6f, 0x48, 0x91, 0xab, 0x36, 0x8e, 0xc5, 0xfd, 0x4f, 0xb1, 0x36, 0x9d, 0x79, 0xa1, 0x30, 0x85, 0x7b, 0x64, 0x54, 0xbb, 0x27, 0xf9, 0x16, 0xd2, 0x3b, 0x9e, 0xc4, 0xa8, 0xa2, 0x04, 0x76, 0x8c, 0x02, 0x91, 0xb5, 0x1e, 0xa9, 0x8d, 0x11, 0x16, 0xd2, 0xd8, 0x3d, 0xe2, 0x39, 0x1a, 0x2d, 0x0a, 0xe3, 0x55, 0x46, 0x68, 0x46, 0x91, 0xb5, 0xed, 0xea, 0x56, 0xb1, 0x83, 0x91, 0x52, 0x42, 0x96, 0x67, 0x0f, 0x6f, 0xbc, 0xed, 0x1c, 0xf8, 0x5f, 0x49, 0x3a, 0x2a, 0x50, 0xc7, 0xb3, 0xb2, 0x6d, 0x41, 0x98, 0x8d, 0x9c, 0x2a, 0x13, 0xc5, 0x29, 0xe9, 0xbf, 0x93, 0xac, 0x52, 0x09, 0x70, 0xe6, 0x24, 0xac, 0xd4, 0x36, 0xe8, 0x07, 0x00, 0xe6, 0x89, 0xd9, 0xd9, 0x65, 0xeb, 0x3a, 0xda, 0xf7, 0xdb, 0x6a, 0x9a, 0x30, 0x02, 0xf6, 0x14, 0xf5, 0x86, 0x56, 0x5d, 0x86, 0xa7, 0x3c, 0x94, 0x2d, 0x7e, 0x71, 0x98, 0x51, 0x08, 0xab, 0xaf, 0xec, 0xd4, 0x5c, 0x71, 0xcc, 0xe6, 0x95, 0xda, 0x54, 0xc2, 0x23, 0xb9, 0xdb, 0xce, 0xcc, 0xf5, 0xf4, 0x8b, 0x96, 0xa3, 0xa3, 0x25, 0xd0, 0x7f, 0x79, 0x23, 0x22, 0x90, 0xed, 0x92, 0xac, 0x05, 0x12, 0xe0, 0x6a, 0x7d, 0xad, 0xd9, 0x28, 0xed, 0x33, 0x25, 0xbf, 0x3c, 0xdf, 0xbf, 0x8d, 0x82, 0x63, 0xec, 0x5e, 0x5d, 0x34, 0xbe, 0x70, 0xf9, 0x50, 0x1d, 0x35, 0x5a, 0x68, 0x04, 0x6f, 0xe6, 0x14, 0x93, 0xe0, 0x06, 0xc4, 0xfa, 0x47, 0xea, 0x5d, 0x04, 0xe4, 0xd4, 0x41, 0xfb, 0x7a, 0x72, 0x50, 0x28, 0x08, 0xba, 0xbd, 0x82, 0xa2, 0x0f, 0x10, 0x0d, 0x74, 0xe9, 0xdf, 0x8a, 0x94, 0x7e, 0x8b, 0x7b, 0xa9, 0x76, 0xc3, 0x5e, 0x4a, 0xc6, 0x80, 0x61, 0x20, 0x03, 0x58, 0xc0, 0xa1, 0x8f, 0x3f, 0xd5, 0x82, 0x49, 0xb7, 0x8c, 0x3a, 0xc0, 0x39, 0x47, 0x53, 0x27, 0x3a, 0x32, 0x33, 0x1e, 0xef, 0x9f, 0x70, 0xb7, 0xff, 0xa6, 0x4b, 0xce, 0x0e, 0x60, 0xd7, 0xe2, 0xb6, 0xef, 0x6d, 0x37, 0xd7, 0x7f, 0xcd, 0xc8, 0xae, 0x6e, 0xe8, 0x68, 0x44, 0x6a, 0x27, 0x8c, 0x4a, 0x44, 0xb3, 0xc8, 0x43, 0x09, 0x54, 0x00, 0x30, 0x91, 0xb3, 0x5b, 0xf1, 0xaf, 0xa9, 0x16, 0xee, 0x41, 0xb2, 0xd4, 0x0e, 0x93, 0xd3, 0x00, 0xcf, 0xb4, 0x17, 0x15, 0x95, 0x7a, 0x66, 0xa3, 0x4f, 0x29, 0xf4, 0x15, 0x72, 0x8b, 0x7b, 0x05, 0xf1, 0xa7, 0x69, 0x0f, 0x65, 0x70, 0x1e, 0x90, 0x7f, 0x1f, 0x72, 0x65, 0x21, 0xc3, 0xb9, 0x52, 0xba, 0x5c, 0x30, 0xa5, 0x83, 0xf1, 0x3a, 0xc6, 0x75, 0xfc, 0xa5, 0x30, 0x8e, 0x25, 0xb4, 0xcb, 0xdb, 0x64, 0xcc, 0x2b, 0x2b, 0x50, 0xb0, 0x0f, 0x3d, 0xd0, 0x24, 0x1b, 0x6f, 0xef, 0xef, 0x90, 0xb0, 0x51, 0xbc, 0x2e, 0x04, 0x6e, 0xbf, 0x38, 0x26, 0x86, 0x2f, 0x00, 0x1a, 0x6a, 0x9a, 0x10, 0x59, 0xcb, 0xc2, 0xbb, 0xfa, 0x6c, 0xea, 0xb9, 0x88, 0x53, 0x70, 0x61, 0x6c, 0x89, 0xa4, 0xa1, 0xb9, 0x17, 0x47, 0x09, 0x71, 0x32, 0x80, 0xc0, 0x3c, 0x22, 0x3d, 0x04, 0xcb, 0xc9, 0x34, 0xf0, 0xc6, 0x27, 0x6c, 0xfd, 0x5d, 0x9d, 0x7c, 0x73, 0xce, 0xfd, 0x4a, 0xea, 0xd2, 0x7e, 0xdf, 0x66, 0x3d, 0x36, 0x4b, 0x6f, 0x7f, 0x64, 0x8f, 0xcb, 0xcd, 0x27, 0x9e, 0x83, 0x1c, 0x2b, 0xeb, 0x82, 0x80, 0xe1, 0xe7, 0x9a, 0xdb, 0x69, 0x40, 0x26, 0xcc, 0x63, 0x88, 0xd3, 0x97, 0x78, 0x27, 0x78, 0xfc, 0x55, 0x5e, 0x91, 0xd2, 0x49, 0xdd, 0x4c, 0x4d, 0x80, 0x45, 0x02, 0xcf, 0x44, 0x25, 0xd1, 0x27, 0x0c, 0x20, 0xa0, 0x14, 0xe2, 0x4b, 0x52, 0x9c, 0x61, 0x13, 0x2d, 0x81, 0x69, 0xc4, 0x8b, 0x63, 0x16, 0xc0, 0x43, 0x03, 0xf7, 0xb1, 0x31, 0xde, 0xbc, 0xf8, 0x51, 0xcf, 0x32, 0x1d, 0xd2, 0x42, 0x75, 0x27, 0x5e, 0xc4, 0x80, 0xc0, 0x86, 0x4e, 0x5e, 0xfc, 0x86, 0x15, 0x08, 0x62, 0xfc, 0x93, 0xd5, 0x94, 0x33, 0x46, 0xd8, 0xa0, 0xb8, 0x5b, 0xeb, 0x91, 0x56, 0xce, 0xda, 0x14, 0xea, 0x37, 0xfe, 0x57, 0x1e, 0xa3, 0xad, 0xa1, 0x6f, 0xc2, 0xd0, 0x01, 0xf4, 0xc2, 0x50, 0x65, 0x35, 0x57, 0xc1, 0xac, 0xc9, 0xc8, 0x11, 0x40, 0x13, 0x4f, 0xfc, 0x4f, 0x50, 0xac, 0xb4, 0xf4, 0xf5, 0x90, 0xf1, 0xb4, 0xac, 0x1f, 0x90, 0xa6, 0xa9, 0xe4, 0xd5, 0x7f, 0x9a, 0x98, 0xee, 0xf6, 0x17, 0x18, 0xa9, 0x59, 0x7f, 0xee, 0x17, 0xca, 0x73, 0x69, 0x47, 0x04, 0x09, 0xd1, 0x42, 0xa3, 0xa6, 0x77, 0x48, 0x08, 0xc8, 0x46, 0x20, 0x62, 0x1d, 0x39, 0x2b, 0x25, 0x2f, 0x0f, 0xa6, 0x92, 0x36, 0xe5, 0xc3, 0x47, 0x4a, 0x7f, 0xd3, 0x9f, 0x2a, 0xd8, 0x75, 0x6a, 0x99, 0x41, 0xb7, 0xb3, 0x53, 0x41, 0x04, 0xd0, 0x57, 0x37, 0xf2, 0x15, 0x01, 0x58, 0xf2, 0xe1, 0xba, 0x77, 0xcb, 0x98, 0xfd, 0x1a, 0x74, 0x26, 0xce, 0x6d, 0xa1, 0x67, 0x1f, 0xcd, 0x80, 0xed, 0x34, 0x50, 0x89, 0x48, 0x75, 0x4f, 0x0f, 0x29, 0xbe, 0x0d, 0x29, 0xde, 0x0f, 0xfb, 0x32, 0x4d, 0xf1, 0xce, 0xf5, 0x55, 0xc8, 0x2f, 0xaa, 0xa1, 0xb4, 0x66, 0xdc, 0x56, 0xb8, 0xfb, 0x6a, 0xe7, 0xe7, 0xc2, 0xa4, 0x9b, 0xc0, 0xa9, 0xb1, 0xb7, 0x09, 0x71, 0x86, 0x44, 0x85, 0xf2, 0xd3, 0xac, 0xc2, 0x25, 0x87, 0xd3, 0xbe, 0x3b, 0x94, 0xa5, 0x9e, 0x79, 0x79, 0x88, 0x30, 0x2b, 0x30, 0xec, 0x95, 0x89, 0xc9, 0x00, 0x2f, 0xc4, 0x2a, 0xc7, 0x55, 0x61, 0xe8, 0x39, 0xee, 0xfb, 0x68, 0x40, 0x15, 0xfa, 0xc4, 0x9d, 0x3d, 0xa3, 0xc5, 0x81, 0x29, 0xc2, 0xab, 0x84, 0x28, 0xcf, 0x9d, 0x3d, 0x90, 0x57, 0xb4, 0x12, 0x0b, 0x3e, 0x20, 0x5d, 0xc3, 0x69, 0xf3, 0xc1, 0x3d, 0x8b, 0x74, 0x03, 0x71, 0x60, 0x7b, 0xda, 0xb5, 0xab, 0xc8, 0xe9, 0xe5, 0x53, 0x90, 0x2f, 0x6a, 0x67, 0x90, 0xd2, 0x4e, 0xdb, 0xf1, 0x2f, 0xe1, 0x65, 0xb7, 0x94, 0xc9, 0x19, 0xe6, 0x5c, 0x3e, 0x44, 0x1d, 0xaa, 0xa9, 0x21, 0x9c, 0xc6, 0x21, 0x5a, 0x50, 0x13, 0xbc, 0x17, 0x84, 0xb2, 0xa3, 0x2e, 0xc6, 0x6a, 0x9f, 0x92, 0x5f, 0x85, 0xd1, 0x14, 0x70, 0x2b, 0x5a, 0xbb, 0xbf, 0x14, 0x42, 0x11, 0x9e, 0x48, 0x09, 0x3f, 0x8c, 0x8c, 0xf7, 0x29, 0x85, 0x71, 0x1d, 0x49, 0xe8, 0xda, 0x1f, 0xb8, 0xe1, 0xd5, 0xb8, 0xcf, 0x22, 0xf8, 0xac, 0x70, 0xf6, 0x09, 0x6a, 0x32, 0x1f, 0x78, 0x2e, 0x61, 0x04, 0x61, 0x1a, 0xfa, 0x81, 0x25, 0xab, 0x37, 0x88, 0xd7, 0x68, 0x48, 0x65, 0x94, 0x9b, 0x03, 0x77, 0x7e, 0x04, 0x4e, 0x9c, 0xdd, 0x6a, 0xb3, 0xcf, 0xc6, 0x4a, 0xa9, 0x6a, 0xf3, 0xb3, 0x79, 0xed, 0xf8, 0x40, 0xcc, 0xb2, 0x04, 0x2b, 0x60, 0x28, 0xb9, 0x2d, 0x68, 0x10, 0xba, 0xc8, 0xbb, 0xfe, 0x01, 0x54, 0xad, 0xc2, 0x9f, 0xac, 0x3b, 0xd1, 0x64, 0x88, 0xf3, 0x29, 0x7d, 0x96, 0x7f, 0xd3, 0xc1, 0x32, 0xf7, 0xef, 0x19, 0x61, 0x62, 0x9f, 0x31, 0xef, 0x6c, 0xda, 0x6e, 0x6b, 0xe5, 0x7a, 0x5c, 0x11, 0x80, 0xba, 0xde, 0xa2, 0x30, 0x71, 0x70, 0x7c, 0x29, 0xb4, 0xb7, 0x4e, 0x74, 0x72, 0xcb, 0xdd, 0xef, 0x32, 0x47, 0x15, 0x3b, 0x1b, 0x9f, 0x94, 0x9c, 0x5b, 0x77, 0x44, 0xba, 0x1b, 0x0b, 0x5e, 0xef, 0xfa, 0xb0, 0x6b, 0x7f, 0x13, 0xa5, 0x9b, 0xb1, 0x4e, 0xd0, 0x4e, 0x9b, 0x38, 0x4b, 0x89, 0xec, 0x33, 0x23, 0x9d, 0x3b, 0x95, 0xa1, 0xb7, 0xbe, 0xf7, 0x20, 0xd1, 0xda, 0x68, 0xb8, 0xef, 0x43, 0xab, 0xbe, 0x4e, 0x72, 0x83, 0x50, 0x26, 0xb5, 0x29, 0xad, 0x52, 0xb7, 0xbe, 0xd8, 0xc8, 0x9a, 0xa8, 0xb9, 0xfc, 0xd1, 0xf0, 0x41, 0x11, 0x45, 0xaa, 0xd0, 0x4f, 0x5a, 0xcd, 0x7e, 0xcc, 0x38, 0xa3, 0x1e, 0x13, 0x87, 0x9f, 0x63, 0x9e, 0x46, 0x25, 0x05, 0xb3 },
        .hmac_key_idx = 2,
        // results of message array encrypted with these keys
        .expected_results = {
            // Message 0
            { 0x2409519c, 0xbd193601, 0x812295cc, 0x191705c7, 0x11523082, 0x68cf854f, 0x344c7460, 0xee5862b0, 0xda2f44a6, 0x632a3fb2, 0xc6587773, 0xa7ffca35, 0xb1a7c1aa, 0x278121a5, 0x25ce15ea, 0xd2e7f22b, 0xd9ddd7e2, 0x2bee43dd, 0xf54dcf7b, 0x2be2f8f4, 0xd4aac2a0, 0x71cf94d7, 0xffccce1b, 0x84efa515, 0x20669452, 0x962d6716, 0xb1443ca9, 0x03ada35d, 0x6f321068, 0x156102c3, 0x1debb96b, 0xcbd0fb3b, 0x8585f721, 0x28151959, 0xeb177d23, 0x57cc8035, 0x024d3d63, 0xf5ce1936, 0xf0bc9c1e, 0x4f34859b, 0xada7f8bf, 0x56b76a72, 0x1607707e, 0x72f51923, 0xf4ed89a1, 0x60c79c7e, 0xa710fd23, 0xbe50ecdc, 0x405962ab, 0x9640b41f, 0xf06ba9e7, 0xd039f2a7, 0x0afddfbd, 0xbc575b5c, 0x503f75aa, 0xf69e8c0d, 0xb6f5a40c, 0x4b44b906, 0xb73f55a0, 0x285c460d, 0x6b28a87b, 0x7cc657c7, 0xf358d67c, 0xf7c72066, 0x3fff8de7, 0x65010724, 0x1f7bb30e, 0xb751aa60, 0xa5d0fdd3, 0x2d5d5107, 0x9384f03c, 0x69d85b17, 0x8863fe78, 0xa98f1b93, 0xee9aabe2, 0xfb904702, 0x6655a531, 0x7a391ef0, 0x102e42b3, 0x6e00a335, 0x1daa4046, 0x85283eb0, 0xb69dbcd4, 0x9a432fc5, 0x135dfdac, 0xa26767b3, 0xa0b0e390, 0xc7995ef3, 0x726e839d, 0x5606b772, 0xc34668ec, 0xade8e3bd, 0x97cc48ed, 0xa4639be9, 0x8eeef91f, 0x60771930 },        // Message 1
            { 0xf0156d41, 0x6fe08f0f, 0x03190cce, 0x10fa8567, 0xf04daa47, 0x4d143fc8, 0xe2ae7a2b, 0x1d12ec75, 0xe4422c90, 0xbecd4972, 0x11808bc6, 0x469113b0, 0x1fb2fb4c, 0x94b57b6d, 0x94793e20, 0x5adc5bc7, 0x7fb02330, 0x4e557aed, 0x8aff515e, 0x888a587d, 0x0f852f62, 0x18953c32, 0x0d63bafc, 0xa61d2ff1, 0x3242d7a0, 0x93daf785, 0x6d25cbf8, 0x19be3158, 0x3cae164a, 0x76cf89f2, 0xd2a5c456, 0x5de6e54b, 0x5afb02b8, 0xa4c857e0, 0x21f76527, 0x28da35e6, 0xd2af3238, 0xd0a743a8, 0x393223ad, 0xc1c4ac1b, 0xd0f16fe5, 0xdc24e47c, 0x69a05a6f, 0x31c328f3, 0xe607ac82, 0x5211a108, 0xd102fa0e, 0x50330896, 0x39c5883f, 0x57e33307, 0xf75eac31, 0x3d5a58b7, 0x7279f883, 0x861d0a08, 0x7b073033, 0x16147866, 0x8ffa5c7b, 0x28a91a63, 0xc5f2b236, 0xf0f0f2f9, 0xe0f9670b, 0x82b1b842, 0xb34a49d8, 0xa75b6f63, 0x27ef3e3e, 0x3c05d2d2, 0x39c0904f, 0x342495c2, 0x8049679e, 0xe5705973, 0x8da356f4, 0x16e1ad10, 0x5333f72d, 0x3729b23a, 0x9f410ea0, 0x7c4554a6, 0x73e7cf4b, 0x2c830da8, 0x37364474, 0x8b924a8e, 0x3410d68e, 0x7c7caeaf, 0x876b4be8, 0x2f215ec8, 0x8ca14335, 0x655fa1ae, 0x5fcdf97e, 0xc014814e, 0xdaf26bda, 0x1fcb2904, 0xac89b2a4, 0xa174f74e, 0xff493e03, 0x402d735f, 0x1684a4dd, 0x0f8720f5 },        // Message 2
            { 0x3759ec07, 0xc12f58eb, 0x62dd5e70, 0xda1ad998, 0xd027a1c8, 0x0380d18b, 0x5aa4a1b6, 0x31677a0a, 0xaa61aeb8, 0x12330b93, 0xeec9f36f, 0x6b33a37c, 0x35a542f2, 0xb69b01b2, 0xa47c4692, 0x9373cd83, 0x30245602, 0xb7737108, 0x814351f8, 0xd77ec36f, 0xe48ce52c, 0xa3a03d34, 0xed4de380, 0x2ead5f19, 0xddb9eb16, 0xd7252de0, 0x13ed0a87, 0x26bb4ffd, 0x1fac4f20, 0x8128e96e, 0x70fa4773, 0x324c1182, 0xd249fa4e, 0xd8e40184, 0x7d55bc73, 0x9fb71f36, 0x421d0c4c, 0x48f8cb67, 0xa4eb1f0f, 0x8a7bfeae, 0xa64ccda3, 0xa069b814, 0x87482b48, 0x8230e457, 0xc556a69f, 0xdf3831fc, 0xa2ee579f, 0x45df7dc3, 0xf0d8443f, 0x4d05c92e, 0x6bf8b99b, 0x95d22e6b, 0x162330e0, 0xc3431829, 0xb24d0a17, 0xfae28b17, 0x3ec27815, 0x007708a3, 0x2b84f611, 0x7441c1d0, 0xf4a383bc, 0x04b4e4e7, 0x547d811a, 0xba64014b, 0x19b30195, 0x6996efe8, 0x28e5f6c4, 0x10a582a1, 0xfa190d01, 0x860b111d, 0x85e45a43, 0x0d13e752, 0xddc57a9c, 0xd0bc56c9, 0x15ed8723, 0x58b19aec, 0x3b00c8da, 0x4d51a8ff, 0x72c08db1, 0xe9e18e15, 0x9c014ffa, 0x82b5c681, 0xe488fedb, 0x2b8bc706, 0x4e9bb6f8, 0x98a98e99, 0x670b6c9f, 0x1da131cd, 0x153ee0d3, 0x38f44938, 0xe98937a5, 0xff94654e, 0x68c5bd7f, 0x5d2f0e9c, 0x9921faf3, 0xb3efb9a0 },        // Message 3
            { 0x3f48cabf, 0xe132eb41, 0xb667b5f2, 0x5eeb5d01, 0x19a45aa3, 0xfbc85e16, 0xefb7f1ec, 0x257c44f4, 0x42748fea, 0xa179ff56, 0xad41bd57, 0x81255837, 0x1a0b5abf, 0x8ac673b2, 0xf3d7d3e0, 0x87d1c550, 0x2ce6dfbf, 0xef0180f5, 0x38d7640e, 0x5ccee480, 0x137d1fe3, 0x277ce4b6, 0xf3c9d33b, 0x50f08d4a, 0x204486dd, 0xc0ee7491, 0x02f0498e, 0xa889fd95, 0xa9c9ca70, 0xbe7908a7, 0xb91752bb, 0x793fb266, 0xa4ee4f04, 0xdbc09f07, 0xd7918256, 0x442125d8, 0xef5f71cf, 0xf0e039f5, 0xc941d011, 0x9caf7342, 0xb35f98ea, 0x03d339f6, 0x06382af2, 0x446dcbcc, 0x3d897a6e, 0x4c068d74, 0x42178ccf, 0x5e7cb388, 0x5599e219, 0x35a54d36, 0x34542531, 0x148ac25e, 0x3c625dea, 0x9e04792f, 0x8f52631d, 0xa5850fc3, 0xed7d1df8, 0xf0f74d5f, 0xd9ca19f1, 0xb4b905a0, 0xdc63422d, 0xc79940b5, 0x15c9ef50, 0x8b5420cb, 0xcbca78e7, 0xc0445d46, 0x221957e7, 0x8bc6b9c2, 0x33f9273c, 0x5cf97589, 0xa537cdd5, 0xd0e7ef3b, 0xeced5007, 0xafefe7bc, 0x15175097, 0xcc357433, 0xb47118d9, 0x187aa821, 0x5a836ead, 0x752a9084, 0xfa8c183a, 0x945f1ca7, 0xc8dd067d, 0x36291bde, 0x9952ba07, 0xad96a131, 0x1b384d38, 0xc67e02ca, 0x7ba2c7d2, 0x2f24c5d8, 0xb46101b1, 0x14b46d2b, 0x32a00ad8, 0xe102d6ce, 0x49b2a5de, 0x11c2b100 },        // Message 4
            { 0x641a1236, 0x442fca06, 0xc9d6321a, 0x4e8e40d9, 0xd09062e1, 0x39acc384, 0x1e67a09f, 0x64f1a05e, 0x9a8f85a0, 0x1b7743dc, 0xae332434, 0x722ff5da, 0x60a66064, 0xef66977e, 0x186d71c5, 0xf5cc7d43, 0xb5519d31, 0x04fd1720, 0x99843778, 0x7eb8236c, 0x27ddb197, 0x0d5d6f2f, 0xff366f1a, 0xcbfd542e, 0x55d2b0f3, 0xf802f937, 0xa2ec467a, 0x54b7e7b0, 0xd3f81c8e, 0xf8cdc61b, 0xc1a1d69f, 0xca7fe5ed, 0xf4f4be5c, 0xeea0e672, 0x4d4b05c4, 0x129d4f19, 0xcf735cf2, 0x18598f50, 0xf3598afc, 0x3d773f1b, 0x148e63b4, 0x5ce0e393, 0x61a9b151, 0x25b45156, 0xa8e2ac74, 0x8b50dccf, 0x79f882ab, 0x839db8a8, 0xca0f3aac, 0xa708850c, 0x347ccbf2, 0xe8851f37, 0x5ed0479b, 0x225917a1, 0x147f4f16, 0x558b44b4, 0x08bdcfc9, 0xbc414a90, 0x8a67eb12, 0xca945a73, 0xfc30e27f, 0xe4b6185e, 0x245579be, 0xa505acd1, 0x2a875b92, 0x38cb59b4, 0xc84aaddb, 0xcd00b784, 0x4d4aa33d, 0x83ff8662, 0x58c0bace, 0x14d3cef6, 0x0bee7817, 0x459666b9, 0x940f4463, 0x91fa5945, 0xb7c7d1d8, 0x46ade57d, 0xbdde6e57, 0xfdd1d957, 0x12ec9392, 0x843982c4, 0xec47b3ba, 0x209cebd4, 0x19c8c859, 0x376548de, 0xa578fe6a, 0x0fc72259, 0x33f1fb58, 0x011b3853, 0x1be20ee3, 0xdb2132a5, 0x9625c273, 0xbb289e1a, 0xae09452b, 0x0deaa174 },        // Message 5
            { 0x673e9708, 0x05b60159, 0xcb967266, 0xca6b9a56, 0xefe0aa43, 0x1f3d4ded, 0xc3199cf4, 0x9b13c377, 0xcacdb49f, 0x068d4f4f, 0xb193d342, 0x23db8617, 0x803f7062, 0x306d8e06, 0xd3074f62, 0x124ad0ad, 0x781f5c18, 0xac7dd88e, 0x71906a56, 0x7b5ff9c0, 0x9bbc925b, 0x9b13b3fd, 0xc74ce7f5, 0x26236c7a, 0x3f4c6aa9, 0x90bcf0ef, 0xf161ce37, 0xff82f8c0, 0x719fa25f, 0x547901ff, 0x6b9cc3d3, 0xe56f6de5, 0xb87fdfeb, 0x727e8f60, 0xe8fb200b, 0x918329f6, 0x67d76d37, 0x1609d3f5, 0xd4bc764d, 0xd6ffe007, 0x2b546c1e, 0xe12c9ff3, 0x903da24b, 0x7e457b75, 0x36628d8f, 0xf749ecfd, 0x5e029903, 0x0e97b3ef, 0xd82994e3, 0x1dbbaad1, 0x14e7a694, 0x35285b53, 0x8f4a9091, 0x0d5d2d6e, 0x568eacf0, 0xc6dd56a7, 0x4cca123e, 0xefc5f313, 0x7f6bef35, 0x63cf95f6, 0xba6dd9eb, 0xeb33955d, 0x7aa3c476, 0x02bc1f84, 0x112dc79f, 0x8f09e158, 0x2e68dcac, 0x1f5c4fd3, 0x6d9da11a, 0xed4cb4c0, 0xbefb92bf, 0x51a1cf72, 0x87f99885, 0xf27b9cf3, 0xa72c2a30, 0x27286879, 0xf357d3dc, 0xe8430c6b, 0x2ee739eb, 0xb6e3b349, 0x4cd2a14e, 0x495f71b2, 0x6cc3c37c, 0x47748fc1, 0x875b7f5c, 0x0dac13bd, 0xaef4e56a, 0x7a48824b, 0xee236e71, 0x96c99803, 0xeedd9867, 0xa91e8077, 0xe84ca623, 0xfe3c5b70, 0xa55f485d, 0x2dd4c20b },        // Message 6
            { 0x0b06c9da, 0x4cd15188, 0x27915641, 0x8d179402, 0x9500064d, 0x518818cc, 0x85cecef7, 0x4b471b6b, 0xffb415fc, 0x474613ff, 0xd93a97c5, 0x33bd68d6, 0x1cc082f4, 0x183a5623, 0xd5ac8a90, 0xe61688ec, 0x166c312b, 0x32c11857, 0x4469b905, 0x4411f6b7, 0xba893cac, 0x2bfcedd6, 0x64d2414d, 0x45581259, 0xe8b69e7d, 0x882d5cc2, 0xb43c7329, 0xef4dd745, 0x62f9bc04, 0xb4d12d33, 0x3b90db0c, 0xa337e1d3, 0x39296b35, 0xe040b266, 0x9bdf5a09, 0x8e5cf5df, 0xcba7df3d, 0xe9572388, 0xae3ea401, 0xe9600bfa, 0x62cd137f, 0xf9f63491, 0x95d87fac, 0x119fdb73, 0xd558be3a, 0x92017586, 0xe11a554f, 0x4dc2019a, 0x2acb9f5e, 0x79f27b85, 0xbcf48ec5, 0xff4ce3d4, 0xd72f506e, 0x25952a04, 0x0089ff66, 0xc5eb2af3, 0xbea25a82, 0xebaa428c, 0xf1988559, 0xef6a81db, 0x2684421d, 0xe807a5d4, 0x5f5350c1, 0xc40f4718, 0xe585636c, 0x6712a2e3, 0xf5736a2f, 0xefcbce94, 0x2e4c4478, 0x1433d020, 0x3f6bbed0, 0xa298fe86, 0x20a254e6, 0x2d43d95a, 0x8525668d, 0xc93cb9a5, 0x2774c4a9, 0xa649aee0, 0x8249a6ec, 0x014b390c, 0xc5a8364f, 0x93dac9ae, 0x2ee706c5, 0x6b9b0ba9, 0x88494ce8, 0x692b0d2f, 0x21a3caac, 0x2a16de8f, 0xba42163a, 0x7f911099, 0x4f1f7583, 0xef6816ad, 0x11d7b62f, 0xe059d337, 0x029e43fb, 0xad96bedd },        // Message 7
            { 0x125c0216, 0x2a38cc49, 0xae5fb6ab, 0xbc9a3fa4, 0x8dd23ac9, 0xc338e315, 0xfaa1bf07, 0x86867363, 0x5a9154e0, 0x3ede1c02, 0x9d8b3656, 0x32f92b62, 0xc06a7892, 0x7c5a53e9, 0x0d279cbb, 0x6ff86c7e, 0x98363741, 0x920abf78, 0x3fb3d4ac, 0xdd2690c5, 0x6c998427, 0x642c709f, 0x7461b3af, 0x2a73fce2, 0x40b0ce56, 0x47f6865d, 0xd846050b, 0x3a23c53d, 0x74423bc5, 0xfac96032, 0xc5d7beef, 0x0aa9ffaa, 0xbf42933d, 0x9841bfe3, 0xbee7577a, 0xe3ea0a75, 0xb8c98050, 0x1ded6eb4, 0x0a48ea14, 0x17e65029, 0x9fa0f651, 0x3824aadb, 0xee43b619, 0xc1894aec, 0xe8590fdb, 0x0b784a9f, 0xe8cb6a14, 0xc4f47449, 0x57f7c3a2, 0x6e19b551, 0x1dad6c7b, 0x5389b88c, 0x33d8d9ae, 0x05afe038, 0x28466f96, 0x31c5eddc, 0x6541c962, 0x95b2de5e, 0xa6fdffc2, 0xb15e93ea, 0x0553ffd5, 0x1ad4afc4, 0xd2fd7102, 0x09e40a6c, 0xbfc6a5a1, 0x41ca1dfc, 0x37f09919, 0x0c01f809, 0x4096f505, 0xa7c27a7d, 0xe9082b73, 0x73fd7007, 0xdced3262, 0x46efbff3, 0x8682ced3, 0x9546b182, 0x0038b42c, 0x498e68fc, 0xd0b4252c, 0xa61ad839, 0xd26a4b61, 0x184e0e29, 0x975fc404, 0x0bcec781, 0x23d870bb, 0x1a2ffb42, 0x97c02bd0, 0x3c50984f, 0x78fc3ce9, 0x07db579a, 0xb74ce45a, 0x108be2b6, 0x3e002d5a, 0xd91cd1aa, 0xb6ce7a25, 0xc49dd643 },        // Message 8
            { 0xe9d3cbe9, 0xb1ea952e, 0x8c0ed244, 0x6bbe76ff, 0x08f6a337, 0x30acd50b, 0x713c043b, 0x6c199435, 0x253fda83, 0x69cad8cc, 0x97fbcd79, 0xbac98340, 0xe1d172ca, 0xa0bce93d, 0x08070e35, 0xda5d354e, 0xc9f12d03, 0x4cf1e6b1, 0xeaa1f0f9, 0x866cffcd, 0x88caa2f1, 0x282e655c, 0x8ed45770, 0x8cb28b01, 0x3c608d81, 0x4d42d1be, 0xd8a4a53e, 0x263d26de, 0x41b45e6f, 0xadf6415b, 0xa02c7965, 0x34c5b885, 0xe481bdfa, 0xd2974004, 0x27be3240, 0xe860b2cc, 0x1e4b6c34, 0x794b5f84, 0xf676dc4e, 0x5a280bc4, 0xa7f09dd6, 0x4e5a4f50, 0x78b9ba94, 0x040f1179, 0x173c1da7, 0xaf6ef39d, 0x94afb20d, 0xf868e096, 0x14e422d7, 0xbbb33d78, 0x85549504, 0x6699263e, 0x15b28dbc, 0x3cea7407, 0x6ac47cf2, 0x5399a971, 0xe1638190, 0x4dd4fa87, 0x9697ebb0, 0x756c17c5, 0x4b2a9c36, 0x183d8239, 0x78a9e0c1, 0x15998ed1, 0xadd6be1d, 0x32aeee95, 0x1ffedd99, 0x090553b6, 0x36474687, 0x6fd609fd, 0x422cc2d8, 0x54bfedf4, 0x98b93ba2, 0x462150f3, 0xa31a469e, 0x9f7f636c, 0x5d6012b0, 0xfd95cb2c, 0xe4909ff6, 0xe49ff27b, 0x27e1a1bc, 0x73290f67, 0xc6e43a1f, 0x48227646, 0x5c5bfe4a, 0x2979375e, 0x527d6659, 0xe0eabf49, 0x9cf14c0c, 0xcf3e9985, 0x50445e40, 0xe041389c, 0x498630df, 0x670d26bd, 0xc2ade384, 0x9b4c1653 },        // Message 9
            { 0x1cc6ba26, 0x0e7756e7, 0xd6a016f6, 0x2370930d, 0x4c96a62b, 0x07088df9, 0xc62bd0c6, 0x117ac64e, 0x64021b8f, 0xb9b34536, 0x6e211947, 0x9e5b5adc, 0x707108fa, 0xc1ae745c, 0x14fe842e, 0x66ebe017, 0xfd99a725, 0x4dfd484b, 0xdc8f69bb, 0x6f47777e, 0x903a3203, 0x02c6e04b, 0x3204650f, 0x6e933828, 0x004a6ccd, 0x6a7278ad, 0x2ad9be64, 0x40d4758c, 0x73c71314, 0x8dfeea2b, 0x304774f9, 0xac936a3f, 0xfbc0d9aa, 0x2832b6c4, 0x055df478, 0x3217bffd, 0xf6e60b49, 0xb8edec60, 0xee1a927b, 0x597e16fc, 0x92a3c496, 0x6c94954d, 0x23ceb621, 0xab1f5efc, 0xcac411c3, 0x183046ba, 0xa17163db, 0x181bfe85, 0xa1521e27, 0x5a6482d7, 0x3aef85d3, 0x9b34756c, 0x0b18c1ae, 0x7ce044af, 0x410dc013, 0x8e453a12, 0x23e7130a, 0x060be370, 0xe56f5185, 0x4a7da34d, 0x05e6b797, 0x3fac2cc7, 0x9974e726, 0x0f661205, 0x30445e0a, 0x34f5884e, 0xa2aba24a, 0x90b9a90c, 0xd027c62e, 0x9c217a5a, 0x470d6585, 0xa0145795, 0x4b227351, 0xd08ae822, 0x6c8e5a23, 0x14d2ae93, 0x7372aa46, 0x4edcad0e, 0x1e2e3ad6, 0xe90b4f3a, 0x3fa50466, 0x6cd1ee94, 0x99da9419, 0xd5eaf5f2, 0xf6f61662, 0xe275da8e, 0xc7bf7d15, 0x3f1de288, 0xb113d05a, 0xb2278268, 0x64111935, 0x56c36edd, 0xc3976fa7, 0xc029f35d, 0x6f06a172, 0x5c84a5cb },
        },
    },
    { /* Case 2 */
        .iv = { 0x56, 0x3b, 0xc1, 0x5a, 0x62, 0xcf, 0xfb, 0xc5, 0x8c, 0xfc, 0x2a, 0x0d, 0xb8, 0x77, 0x0d, 0x7c },
        .p_data = {
            .Y = { 0x96464501, 0x786e0f50, 0x5156c737, 0x3414fba0, 0xd1867963, 0xb4ea4fcf, 0x588bee90, 0x42199bca, 0x7db378d3, 0xdc5c1742, 0x4d8d29a4, 0x411bb4f0, 0xe684b248, 0xa5f43318, 0x4dab1c1c, 0x41765d8e, 0x02e0b169, 0xd2bfeddf, 0x209f5b76, 0x23e9d097, 0xc7b4cbe6, 0x3a442cfd, 0xc88e5c35, 0xca04575a, 0xa1844add, 0x5efb2b7a, 0x867eaa5d, 0x7954c058, 0x26a83a80, 0xa49c7ab5, 0xed50f6ba, 0x7b05235a, 0x9f0602a5, 0x1c24852a, 0x94eece3a, 0x7ba3884b, 0x15560697, 0x6aedf3c1, 0xc042ec32, 0x3f83ff5f, 0x94252db8, 0xdac29c5d, 0x8462fa39, 0x7747f6bf, 0x1c95f2de, 0x01912a8a, 0xd76ca7ea, 0x4b89f285, 0xaefeeca9, 0xd5db0979, 0xed531c5d, 0x91164867, 0x1162b3ab, 0xd46944cf, 0x1c4fe5ec, 0xdc6b05be, 0x843ca8af, 0xdd4f37a7, 0xe5ba6d9a, 0xf8735498, 0xdca3b2f5, 0x3b2f519b, 0x1c32c3e4, 0x995ca936 },
            .M = { 0xe799fe75, 0x8e75f4bc, 0x18291cd5, 0xab929bb1, 0x4f6a8e5d, 0x3b7c4763, 0x50c8f902, 0x908b29dc, 0x580f8b21, 0x58c2e4ce, 0xfe1b99e3, 0x7b29ee83, 0x808f3d99, 0xa4da03b2, 0xbfc9f648, 0x39f86580, 0x611ceda5, 0xcbeac59a, 0xd55048a0, 0x8c89024c, 0xf72d1b77, 0x6e2bbd0c, 0xd8d3ac6c, 0xf0abb46b, 0xfb5cbe4a, 0xc0992c51, 0xc79307bb, 0x545a5879, 0xd757f2d1, 0x6cfd1252, 0x5af08dc7, 0x0cf18767, 0x5fcd5abb, 0x9f87f320, 0xa4ff872a, 0x1de80a26, 0xd48e9680, 0x885732f3, 0x73c78280, 0x0bdba0b1, 0x96b3c183, 0x9cecad28, 0x3d2ffacd, 0xb3c0f07b, 0xf998b9bd, 0x1d7dacc9, 0xe36d664b, 0xedbef9ed, 0x08431e80, 0xc7d49eab, 0x93c8cfad, 0xa172fdf8, 0xa2175944, 0x48b3ed65, 0x0429b91c, 0x4960000c, 0x38ff4512, 0x68070e66, 0x16246f63, 0x41aef4e5, 0xb6e10daf, 0xe53c97c0, 0xc3933ac8, 0xc9c7c711 },
            .Rb = { 0xdaf34cbf, 0xe10eeaaf, 0x64bf581f, 0xaebe5724, 0xab0bb94f, 0x85e4fff3, 0xbc8c2b5b, 0xcacb94bd, 0x6e20d65c, 0x8d425537, 0xf89a182c, 0xea8d9374, 0x8a8a08f0, 0x6a1201c7, 0xb13f6ea2, 0x9cd3987f, 0x57de4856, 0x292a233e, 0x6010b31d, 0x7747d940, 0x50df6d97, 0x1be82fed, 0xa5cb77b1, 0xffe45d64, 0xbe8c4809, 0xf528c435, 0x09f6eef1, 0x7429f1c7, 0xca2b1973, 0x0b0e8b4f, 0xb97241b1, 0x830b035e, 0x11fc7f3b, 0x41f13f82, 0x4978b8e3, 0xc7526f69, 0x47db512b, 0xe5693bb9, 0x090db86e, 0x334a5b26, 0x2990a886, 0xc3233d6c, 0xa0ceef03, 0x15b8538f, 0x6af0cdba, 0x378473e0, 0xadd6d072, 0xf4c831e6, 0xe4e04c69, 0xc2a9b0df, 0x70ef3199, 0xa4621f85, 0xb5614255, 0x7eaf86af, 0x2a6a553e, 0xd6133c99, 0x57422b74, 0x120d1b0e, 0x892462ca, 0x75906ef1, 0x07b7d512, 0x22f2619b, 0x41f03a05, 0x31f0fd1c },
            .M_prime = 0xce8e9e23,
            .length = 63, // 2048 bit
        },
        .expected_c = { 0xca, 0x84, 0x36, 0x38, 0x9c, 0xb2, 0x96, 0x19, 0xbb, 0xa6, 0x4f, 0x1f, 0xb9, 0x57, 0x9a, 0x63, 0xd4, 0xcf, 0x78, 0xae, 0xec, 0x47, 0xe8, 0x6a, 0xd4, 0xd5, 0x96, 0x82, 0x5f, 0xcd, 0x6e, 0x52, 0xd4, 0xde, 0x91, 0x24, 0xa9, 0x8f, 0x1a, 0xe8, 0xc9, 0x36, 0x39, 0x8b, 0x1c, 0x5f, 0xb0, 0xd4, 0x59, 0xba, 0x79, 0x71, 0xcf, 0xf9, 0x02, 0x4d, 0xcc, 0x3b, 0xe7, 0x3b, 0x74, 0x17, 0x88, 0xd0, 0xba, 0x59, 0x72, 0xc9, 0xdd, 0xa8, 0x62, 0xa3, 0x0f, 0x99, 0x84, 0xb0, 0x14, 0xbb, 0x75, 0x58, 0xc9, 0x4c, 0xd4, 0x3f, 0x3d, 0x0f, 0x28, 0x9f, 0xa1, 0x12, 0x1d, 0xdf, 0x29, 0x73, 0x2d, 0xbe, 0x96, 0x17, 0x07, 0x04, 0xd8, 0xe1, 0xdc, 0x70, 0xd2, 0xe0, 0x7d, 0xd0, 0x0b, 0x2b, 0x10, 0x52, 0x8d, 0x7f, 0xcf, 0xf6, 0xee, 0x72, 0x18, 0x95, 0x8c, 0x3e, 0x82, 0x3e, 0xda, 0xfe, 0xf9, 0x8b, 0x75, 0x7e, 0x1d, 0xc4, 0x0a, 0xc8, 0xb5, 0x78, 0xd1, 0x12, 0xd8, 0xc6, 0xff, 0xff, 0x21, 0xb4, 0x3c, 0x35, 0xd5, 0xf1, 0x04, 0x67, 0x51, 0xaa, 0xce, 0x75, 0x25, 0xd6, 0x32, 0x91, 0x54, 0x8b, 0xd9, 0xe1, 0x26, 0x78, 0x76, 0x52, 0xfa, 0x5b, 0x31, 0x32, 0xc2, 0x39, 0xfa, 0x82, 0x04, 0x72, 0x53, 0x94, 0x3a, 0xb7, 0x92, 0xde, 0x90, 0xba, 0x87, 0xb0, 0xd5, 0xb5, 0x43, 0xdc, 0x39, 0xd9, 0x4a, 0xa8, 0xdc, 0x17, 0x27, 0x74, 0x3d, 0xef, 0x2c, 0x2a, 0x88, 0xe9, 0xaa, 0x8f, 0xfb, 0x5e, 0xdc, 0x70, 0xce, 0x16, 0x8d, 0xbb, 0x51, 0x15, 0x6d, 0x6f, 0x76, 0x8e, 0xa5, 0x58, 0x95, 0x45, 0x87, 0xd7, 0xd0, 0xce, 0xee, 0x39, 0xd1, 0xdf, 0x7e, 0x40, 0xc1, 0x76, 0x48, 0xe8, 0xf0, 0x10, 0x70, 0x00, 0x9a, 0x03, 0x64, 0x33, 0x03, 0xbc, 0x66, 0xed, 0x45, 0xe3, 0x8c, 0xef, 0xa0, 0xa2, 0xe6, 0xbc, 0x3d, 0xda, 0xee, 0x14, 0x3e, 0xa1, 0xba, 0x2d, 0xe1, 0x6a, 0x26, 0xb2, 0xea, 0xeb, 0x1d, 0x09, 0x1e, 0xd1, 0x4f, 0x9e, 0xa7, 0xf7, 0x1c, 0xb6, 0xdc, 0x29, 0x57, 0x85, 0x5b, 0xcc, 0x64, 0xd2, 0x6e, 0x85, 0x3b, 0x08, 0x4c, 0x0b, 0x61, 0x38, 0x6b, 0xcb, 0xce, 0x9f, 0xa1, 0xca, 0x1c, 0xd5, 0xca, 0xc1, 0x11, 0x5d, 0xd8, 0x88, 0x27, 0xa9, 0x91, 0x0d, 0xe2, 0xed, 0xfc, 0x63, 0x3a, 0x1f, 0x12, 0xaf, 0x74, 0x3b, 0x35, 0x81, 0xa2, 0x11, 0x81, 0xe7, 0x90, 0x83, 0x3e, 0x08, 0x39, 0x26, 0xb0, 0x40, 0xb1, 0xa4, 0x7a, 0x08, 0xc7, 0xfa, 0xdc, 0x37, 0x06, 0x07, 0x24, 0xec, 0x6a, 0x73, 0x6a, 0xc8, 0x56, 0x80, 0x39, 0x70, 0x00, 0xef, 0xf9, 0x97, 0x42, 0x4f, 0x41, 0x43, 0xef, 0x5d, 0xd9, 0x90, 0x6a, 0x27, 0x34, 0x3a, 0x79, 0x0c, 0x83, 0x0e, 0x04, 0x90, 0xd8, 0x51, 0xe5, 0x05, 0x6a, 0x3a, 0xe0, 0xd5, 0xec, 0x2d, 0x19, 0xf4, 0x80, 0xb5, 0x6c, 0xe2, 0x74, 0xd9, 0x1e, 0x53, 0x9d, 0x25, 0x91, 0x80, 0xfb, 0xa3, 0xc1, 0x9e, 0x8a, 0x23, 0x67, 0xaf, 0x46, 0x55, 0x82, 0x97, 0xa8, 0xe7, 0xad, 0xb0, 0x49, 0x5f, 0xbc, 0xb6, 0xcd, 0xcc, 0xf6, 0x9a, 0xbc, 0x37, 0x99, 0xf9, 0x36, 0xc9, 0x7c, 0x49, 0x9b, 0x7e, 0x4e, 0xd7, 0x5a, 0x22, 0x91, 0x9f, 0x74, 0x29, 0x95, 0xae, 0xf5, 0x9f, 0xf7, 0x69, 0xe2, 0xc4, 0x2c, 0xcd, 0xfe, 0x36, 0x1f, 0x87, 0xac, 0xd3, 0xa4, 0x16, 0x0b, 0x9e, 0xc6, 0x5e, 0xff, 0x2d, 0x17, 0x9b, 0x72, 0xd8, 0x37, 0x39, 0xc7, 0xe6, 0x74, 0x1c, 0x2a, 0x5b, 0x1e, 0xde, 0x7e, 0x85, 0x1d, 0xe1, 0xd7, 0x11, 0xb7, 0xa6, 0x5c, 0xab, 0xc7, 0x4b, 0xb5, 0x4b, 0xc5, 0xd3, 0x90, 0xa4, 0x31, 0xef, 0x65, 0x88, 0x13, 0x4e, 0x61, 0x33, 0xe1, 0xc2, 0xfd, 0xef, 0x15, 0xce, 0x85, 0x95, 0xfe, 0xa2, 0xda, 0x34, 0x17, 0xfa, 0x20, 0xad, 0xf8, 0x47, 0x09, 0x2f, 0xfa, 0xcc, 0x25, 0x98, 0xcd, 0x83, 0xef, 0xf8, 0x1b, 0xa8, 0x53, 0x37, 0xe6, 0xc9, 0x01, 0x71, 0x82, 0x5d, 0x1e, 0x4d, 0x5a, 0x8b, 0x2c, 0x41, 0x3f, 0xd0, 0x8f, 0xbd, 0x32, 0x9d, 0x29, 0xcf, 0x6e, 0xce, 0xa0, 0xe8, 0x6a, 0xb3, 0xcd, 0xdb, 0xc1, 0x2b, 0x54, 0xea, 0x61, 0x45, 0xa8, 0x18, 0x8b, 0xc4, 0x7e, 0xc1, 0xde, 0x20, 0x0b, 0x28, 0xb8, 0x4f, 0x6f, 0x9a, 0x88, 0x40, 0x15, 0x67, 0x59, 0x09, 0x89, 0xec, 0x5d, 0x4a, 0x8c, 0xc1, 0xa6, 0x56, 0x00, 0x61, 0x72, 0x06, 0xa4, 0xa6, 0x64, 0x9e, 0x62, 0x1b, 0x9b, 0x30, 0xdf, 0xce, 0x04, 0x44, 0xd2, 0x9c, 0x73, 0xa9, 0xc9, 0x92, 0x7c, 0x86, 0x45, 0x21, 0xe3, 0x5f, 0xb4, 0x2f, 0x71, 0x22, 0x0d, 0x3b, 0x70, 0xab, 0x17, 0xa7, 0x32, 0x46, 0x79, 0xa5, 0x15, 0xf5, 0x04, 0x0e, 0xaf, 0x54, 0xa6, 0x70, 0xff, 0xbe, 0xa7, 0x79, 0xce, 0xe1, 0xbe, 0x91, 0x6a, 0x16, 0x06, 0xe7, 0x40, 0x22, 0xd1, 0x9a, 0x95, 0xa5, 0x95, 0xf7, 0xdb, 0xa0, 0x0a, 0x74, 0x02, 0x96, 0xd1, 0xd1, 0x4d, 0x44, 0xe3, 0xe9, 0xab, 0xa6, 0xaf, 0xb9, 0x38, 0x1f, 0x91, 0x34, 0x30, 0x00, 0xba, 0xbf, 0xb7, 0x56, 0x6b, 0x34, 0x59, 0x59, 0x13, 0x9c, 0xaa, 0xfa, 0x2b, 0x3e, 0xd6, 0x48, 0x3c, 0x24, 0x4e, 0x5b, 0x6a, 0x2e, 0xc0, 0x43, 0xb6, 0x17, 0x19, 0xdc, 0x64, 0xd5, 0x8a, 0x5e, 0x64, 0x8c, 0x0a, 0xdf, 0xd4, 0xbf, 0xaf, 0x91, 0x47, 0x51, 0x01, 0xc0, 0x2c, 0xcb, 0x10, 0x9a, 0x41, 0x47, 0x26, 0xf4, 0x3b, 0xf9, 0xe0, 0xa7, 0x8a, 0x4f, 0xf5, 0x62, 0x5a, 0xe8, 0xdc, 0xce, 0x23, 0x51, 0xab, 0xa5, 0xb8, 0x6c, 0xbf, 0x4d, 0x00, 0x23, 0x74, 0x40, 0x47, 0x77, 0xd7, 0x78, 0xb8, 0x3f, 0xe9, 0xd2, 0xf1, 0x9c, 0xdc, 0xad, 0x88, 0x67, 0xe3, 0x71, 0xb1, 0x31, 0xa6, 0xb7, 0x4a, 0x36, 0xf0, 0x19, 0x80, 0x3d, 0xfe, 0xe9, 0x0c, 0xa0, 0xa4, 0xf6, 0x55, 0x62, 0xf7, 0x28, 0x38, 0x1b, 0x05, 0x1a, 0x9e, 0x40, 0x57, 0xaa, 0xf1, 0xb5, 0xc4, 0x85, 0x58, 0x3c, 0xee, 0xb1, 0x5b, 0x50, 0xd2, 0x94, 0xd4, 0x68, 0xe3, 0x5a, 0x54, 0x73, 0x58, 0x35, 0x17, 0x44, 0x32, 0xc3, 0xb2, 0xaf, 0xf4, 0xd4, 0x55, 0xd2, 0xd7, 0xa7, 0xda, 0x2c, 0xdc, 0x27, 0xca, 0x11, 0xdc, 0x83, 0xec, 0x2f, 0x3c, 0x51, 0x9b, 0x5b, 0x14, 0xbc, 0xa5, 0x98, 0x65, 0x66, 0x4c, 0x2b, 0x49, 0x74, 0x3d, 0x85, 0xb3, 0x4b, 0x67, 0x32, 0xa7, 0x2e, 0xea, 0xfe, 0x45, 0x03, 0x1d, 0x3a, 0x21, 0xc7, 0x26, 0x41, 0xec, 0x64, 0xf0, 0xb1, 0xdf, 0xeb, 0x0a, 0x9b, 0x97, 0x50, 0xaa, 0x58, 0xf8, 0x99, 0xa5, 0xe6, 0xe2, 0x9a, 0x04, 0xdc, 0xf4, 0xa1, 0x44, 0xd4, 0xa4, 0x98, 0xbf, 0x65, 0x8f, 0xa2, 0x11, 0xa9, 0x59, 0xf9, 0x58, 0x1f, 0xf6, 0xe2, 0x2f, 0x1c, 0x91, 0xbe, 0x2d, 0xd1, 0x25, 0xc7, 0x3b, 0x1b, 0x42, 0x6b, 0xa5, 0x14, 0xcb, 0x39, 0xd5, 0xe7, 0x56, 0xb6, 0x2b, 0x45, 0xde, 0xae, 0x3d, 0xcd, 0xa6, 0x01, 0xbe, 0x5c, 0xcc, 0x98, 0xc9, 0x45, 0xa0, 0x35, 0x13, 0x1a, 0xa9, 0x0a, 0x22, 0xaf, 0x65, 0x85, 0x3f, 0x38, 0x31, 0x3c, 0x5e, 0x55, 0xef, 0x76, 0x98, 0x53, 0xb9, 0xc5, 0xcb, 0x32, 0xc9, 0x1a, 0x57, 0xfd, 0xce, 0x05, 0xbb, 0x96, 0x35, 0x33, 0xbb, 0x99, 0xce, 0x91, 0xaf, 0x34, 0x60, 0xff, 0x10, 0x91, 0x86, 0xa5, 0x8a, 0x62, 0x68, 0x24, 0xe0, 0x39, 0xfb, 0x42, 0xf6, 0xdf, 0x77, 0x50, 0x51, 0x46, 0x99, 0xc4, 0xc6, 0x4c, 0xed, 0x79, 0x0d, 0xaf, 0xfc, 0x5b, 0xac, 0x4e, 0x77, 0x27, 0xac, 0x1f, 0x59, 0xfb, 0x3b, 0xb3, 0x3f, 0xdd, 0xa9, 0x5a, 0x5e, 0xbf, 0xd5, 0x4e, 0x5a, 0xc5, 0x22, 0x90, 0x80, 0xaf, 0x50, 0x92, 0xa9, 0x14, 0x62, 0x6a, 0xd3, 0x6c, 0x22, 0x02, 0xca, 0x6d, 0x47, 0x7c, 0x4f, 0xfc, 0x8d, 0x2d, 0x79, 0x3e, 0xc2, 0xfa, 0x1f, 0x13, 0xe6, 0x67, 0xd4, 0x4f, 0x49, 0xc5, 0x67, 0xc5, 0x6b, 0x44, 0xcf, 0x0d, 0xe6, 0xde, 0x22, 0x61, 0xa5, 0xb8, 0x75, 0x1c, 0x69, 0x1c, 0x9a, 0x61, 0x1d, 0xab, 0xdb, 0x4d, 0x07, 0xf2, 0x97, 0x57, 0xa9, 0x65, 0x53, 0x1a, 0x32, 0xb3, 0xdc, 0xf0, 0x9d, 0x59, 0x17, 0x93, 0x31, 0x6e, 0x10, 0xc0, 0x5d, 0xd2, 0x3a, 0xc8, 0x75, 0xb3, 0x0f, 0xb5, 0x30, 0x35, 0xe5, 0xa2, 0x4d, 0x9e, 0x88, 0x64, 0x15, 0x54, 0xf5, 0x19, 0x28, 0xf2, 0x7a, 0x5c, 0x5d, 0xb2, 0x13, 0xba, 0x9b, 0xaf, 0xd4, 0x8d, 0x8c, 0x0c, 0xdc, 0x82, 0x2a, 0xce, 0x47, 0xdd, 0x1f, 0x34, 0x82, 0xc6, 0x16, 0xf7, 0xb1, 0x14, 0xa7, 0x80, 0x99, 0xa7, 0xef, 0xd3, 0x3b, 0x8c, 0x3e, 0x89, 0x07, 0xc2, 0x06, 0x50, 0xaf, 0x21, 0x2e, 0x65, 0xdb, 0xc7, 0x72, 0x78, 0xd1, 0x21, 0xc7, 0x26, 0x67, 0x7e, 0xd0, 0xd8, 0xe4, 0xe7, 0x74, 0x9a, 0x63, 0x55, 0xea, 0xc6, 0xf8, 0x93, 0x31, 0xec, 0x17, 0x15, 0x59, 0x72, 0xf1, 0x94, 0x73, 0x78, 0x1c, 0xbc, 0x41, 0xd5, 0x9c, 0x46, 0x17, 0xb1, 0x1c, 0x69, 0xbd, 0x58, 0x6e, 0x6e, 0x1b, 0xf4, 0x97, 0x1c, 0xf6, 0x3c, 0x91, 0xfa, 0x92, 0x49, 0xb7, 0xdb, 0x87, 0xa3, 0xc4, 0x00, 0xd1, 0xf3, 0x82, 0x92, 0x49, 0x2c, 0xa1, 0x16, 0xb6, 0xb8, 0xde, 0x1f, 0xf8, 0xcc, 0xd4, 0x3b, 0xca, 0x19, 0xef, 0x29, 0x82, 0x89, 0xed, 0x13, 0x03, 0x30, 0xc4, 0xf3, 0x37, 0xcf, 0x3f, 0xde, 0x7f, 0x86, 0xb2, 0x8d, 0x76, 0x2b, 0x9f, 0x8b, 0xa8, 0x2c, 0xa5, 0xd3, 0x60, 0x66, 0xee, 0xb3, 0xe9, 0x3b, 0xc5, 0x0f, 0x4e, 0xfc, 0xa8, 0x01, 0x4e, 0x41, 0x6f, 0x23, 0x8e, 0x21, 0xb3, 0x98, 0x84, 0x50, 0x64, 0x29, 0x9d, 0xc9, 0xb6, 0xfb, 0x6d, 0x41, 0x8e, 0xb9, 0x53, 0xa1, 0xd6, 0xfa, 0xa5, 0xc3, 0xc9, 0xfe, 0x12, 0xce, 0x90, 0x06, 0x74, 0x91, 0x09, 0x17, 0x9a, 0x96, 0x34, 0xe9, 0x7c, 0xd4, 0xc3, 0x66, 0x21, 0x17, 0x57, 0xa9, 0x1a, 0x07, 0xef, 0xb6, 0xc8, 0xac, 0x1a, 0xcf, 0xdf, 0x38, 0x6a, 0x1e, 0x33, 0x7c, 0x86, 0x47, 0xa1, 0x7b, 0x0b, 0x75, 0x14, 0x7c, 0x57, 0x82, 0xab, 0xe3, 0x42, 0x4b, 0x51, 0xbe, 0xe0, 0xc3, 0x04, 0x3e, 0x76, 0x9a, 0x6a, 0x3c, 0x78, 0x75, 0xf2, 0x66, 0x4e, 0xad, 0xed, 0xea, 0x90, 0x3b, 0x8a, 0x2b, 0xa5, 0xcc, 0x5d, 0x29, 0x80, 0x11, 0xdc, 0xf1, 0xe4, 0x21, 0xea, 0xef, 0x7b, 0xea, 0xdd, 0x5b, 0x70, 0x46, 0xd8, 0xa6, 0xfe, 0x50, 0xa3, 0x32, 0x2d, 0x0f, 0xc0, 0x20, 0xa5, 0xf7, 0x8d, 0xfc, 0xcf, 0x0f, 0x1c, 0xec, 0x8b, 0xe0, 0x84, 0x46, 0xf2, 0x5e, 0x7f, 0x91, 0xf9, 0x7f, 0x89, 0x2a, 0x92, 0x22, 0x02, 0x21, 0x30, 0xb2, 0x89, 0x3a, 0x17, 0x6c, 0xc4, 0xe5, 0xad, 0xd7, 0x20, 0x91, 0x66, 0x63, 0x44, 0x30, 0x2f, 0x4a, 0x6f, 0xaa, 0xaf, 0x9f, 0x37, 0x11, 0x9f, 0xb2, 0x1d, 0x24, 0xd3, 0xab, 0xea, 0xa0, 0x4a, 0x44, 0x75, 0x93, 0xad, 0xdd, 0x89, 0x0c, 0xd3, 0xb0, 0x0b, 0x4e, 0xab, 0x96, 0x79, 0x52, 0x24, 0x84, 0x1f, 0xc6, 0xc3, 0xb7, 0x6c, 0xf5, 0x03, 0x55, 0x33, 0x67, 0xa0, 0xc6, 0xf4, 0x08, 0xd1, 0x10, 0x79, 0x82, 0x64, 0xbe, 0x36, 0x6e, 0xb5, 0xd5, 0xcd, 0x72, 0xf1, 0x19, 0xf9, 0x30, 0x7f, 0x79, 0x09, 0x61, 0x24, 0x15, 0xfd, 0x1a, 0x3e, 0x49, 0xa0, 0xb9, 0x58, 0x97, 0xb2, 0x5f, 0xdf, 0x7a, 0xf4, 0x31, 0xcb, 0xb0, 0x8c, 0x33, 0x2c, 0x13, 0x3d, 0x8c, 0xe3, 0x79, 0x08, 0x66, 0xa0, 0x2d, 0xad, 0x3d, 0xeb, 0x82, 0xaf, 0x9c },
        .hmac_key_idx = 0,
        // results of message array encrypted with these keys
        .expected_results = {
            // Message 0
            { 0x49250367, 0x223e05ec, 0x236a3106, 0x039643fd, 0x90043d2a, 0x0aac40c8, 0x34f693ab, 0x6b5afda8, 0xb5ddc3de, 0x32fa592e, 0x1e61619e, 0x8f28f70a, 0xbd2e7743, 0x84fc7709, 0x1acbcb72, 0x5043839d, 0x86b3105a, 0xed47d9a0, 0x50da66c0, 0xebfc5d93, 0x2295e705, 0x1a6b62e4, 0xa9f16862, 0x95a2cb5d, 0x2e840c12, 0x78784e1d, 0xa008eff2, 0x63fd629f, 0x2e492a37, 0x00fcc1d8, 0x6bf6f354, 0x25665c0b, 0x62dbba8e, 0xf5b0c71c, 0x745a3e91, 0x3ac48470, 0xf53ca24f, 0x012f09fc, 0x3318ad13, 0x0ed89270, 0xf13f7ccd, 0xc8463b8c, 0xdb59027d, 0x16e5f0f9, 0x6df47a4a, 0x69413f62, 0x94af9430, 0x1958aac0, 0xdb1cf99c, 0x3d917432, 0xe8f9dce3, 0x906463bd, 0x0f084605, 0x377b1b40, 0x9db1ce8f, 0xcb78b6ad, 0xb83a1a77, 0x3cc75aa9, 0xbd6a7e31, 0xd66cf2d1, 0x2cb06253, 0x133a667e, 0x1a237e6e, 0x1388df8f },        // Message 1
            { 0xf93c60dc, 0x486541c6, 0x92219fae, 0x0cad6c8d, 0x49edf5f2, 0x4796b929, 0xcb8ed982, 0x02f38196, 0x2f1f8668, 0x65444d8e, 0xcb21a501, 0xc9078acc, 0x1f776f93, 0x22b7c745, 0xb9dc17d8, 0xdcf59598, 0x4d205da2, 0x20006e97, 0xb9e60ca4, 0x638b8531, 0x3cba2018, 0x2972eee8, 0x0df43a5a, 0x4046e476, 0x556c78dc, 0xb0c322ac, 0x85785e08, 0x0cc2426d, 0x0a439f48, 0xb5f566e3, 0x5b835bf0, 0x9bad5cc9, 0xd4ec0ca5, 0x3e90666a, 0xdf48539f, 0x1f16dea8, 0x134e3935, 0x11bfb72f, 0xf66715ec, 0xf4ddad53, 0x954cb62f, 0x8cd6311e, 0x5fc447e9, 0x7dc30657, 0x1409fec0, 0x69102142, 0xa1d0d9e5, 0xa0981307, 0x2c4a9847, 0xfc3e9014, 0xe4c5345c, 0x8279ba5c, 0xdd5072c4, 0x44b5391f, 0x30c9f8a8, 0x5100d8c8, 0x1de1eec1, 0x1d3b315a, 0x3054db23, 0x81e9963d, 0xba57923e, 0x34c47686, 0x51b8ed34, 0x8550746c },        // Message 2
            { 0x95af51cc, 0xa56a6c39, 0xa5fac474, 0x32ee3574, 0x5ef7979d, 0x151d6891, 0xa1bec650, 0x54337154, 0x903e3628, 0x499c751d, 0x76163d37, 0x2df23770, 0xd7d7a86e, 0x457e3eef, 0x95a4e128, 0x69e5977a, 0xed460985, 0xd13ff0f6, 0x6cd33014, 0x330f694d, 0x48c9b70c, 0xcd1581de, 0x59aef213, 0x87c973a2, 0x63a54a55, 0xc0ef37bb, 0xf3526357, 0xa503cb2a, 0xa3b1d1f3, 0xc818a48a, 0x033ba4c6, 0x7192d05c, 0x804da2ee, 0x28021be1, 0x918cddbb, 0x9fd04445, 0xcc58ba79, 0x9e159615, 0x74b27132, 0xc45cd0b2, 0xb6dc6a16, 0x5d9d448f, 0x0c808f2c, 0xe92f2c44, 0xa202a48c, 0xfaf57df7, 0xbf884580, 0xd43d5df6, 0x93a952c2, 0x8dd2da38, 0xd48b9d95, 0x59325bc5, 0xa3b915f8, 0xa3175aaf, 0xcdf45fc2, 0xc989e5cf, 0x5b56d793, 0xeac73628, 0xbf2c8284, 0x9f9f2411, 0xd23df80d, 0x08bb046c, 0x4e222cbe, 0x4892eea2 },        // Message 3
            { 0x2bcc8348, 0xe8e9a108, 0x7edb4886, 0x31c9d055, 0xd4bd6aa0, 0x727160c3, 0xaa4628c4, 0x7b6799aa, 0xf80fc2a9, 0xc83a4581, 0xfad80e05, 0x69d360f3, 0xb46ba0aa, 0x3bebf640, 0xa078e6f8, 0xd9d1c05d, 0x67cd08fe, 0x2507319f, 0x871d2711, 0x1d665776, 0x80970e20, 0x342a6269, 0x5d1c88d3, 0x79b23450, 0x1db17b92, 0xbf99fc3a, 0x286f0cb6, 0xdc7a87bb, 0xa2f846b2, 0x85f3e429, 0xcee5337a, 0xf830ace1, 0xc8af1f36, 0xe40cb208, 0x5248cd9e, 0x99305e9b, 0x3cd76b1c, 0x833cae1c, 0xfe846a7a, 0xab76863a, 0xb266d518, 0x53fa2463, 0xe7b42c45, 0xed9b9555, 0xfad7afd0, 0x0b734ee8, 0xb82438a2, 0xadd4c3b1, 0x52832f3f, 0x55e7498e, 0x84f92417, 0xf1f04308, 0xd04374ab, 0x5bdc0249, 0x0a95e342, 0x6b1514f7, 0x56883eb8, 0xdb46a3eb, 0xa573fbed, 0x93bad740, 0xadb9bdb3, 0x5a4db433, 0x79ae9bbb, 0xa66a46e3 },        // Message 4
            { 0xa4bf6899, 0xf5896ab5, 0x28291d49, 0x4f122ab9, 0x7267fb0c, 0x2fbb18a7, 0xbe4f71ac, 0x68449c16, 0xe4e98f31, 0xf2cbba4e, 0x537caad6, 0x342eb897, 0x5fbf9290, 0xd0a7067f, 0x4245557f, 0x0852baf6, 0xb59edc95, 0x6f37f0c7, 0xacbe95b8, 0xf7fbf6e5, 0x2253b689, 0xcddf28b1, 0xc551eb52, 0xbbc94fff, 0x3c816ef8, 0x5a951f22, 0xd417dae7, 0xec90bc0b, 0x1979ec22, 0xfb95d654, 0xbb3bd8ab, 0xafb07eaf, 0xa751e478, 0x2d527447, 0xa47465a0, 0x21356b70, 0x948043e6, 0x6a11044b, 0x61f30e37, 0x3717e8d9, 0x4ed1f3b8, 0x583bf989, 0xfcb15635, 0xacb520c1, 0xb9599f19, 0xd0befe91, 0x2dbc347e, 0x23f51388, 0x9f2cdc68, 0x39bea045, 0xb21efe8c, 0x857ade32, 0x2115e30a, 0x3f38a23e, 0xedb9f5c4, 0x08b0c13d, 0x08e00e7b, 0x318c4a82, 0x50a2b0f7, 0xe9889c07, 0xf8621f05, 0x253c1a97, 0x581ed775, 0x71895842 },        // Message 5
            { 0xda588f90, 0x7fc5f0de, 0x868529f6, 0xbb94d3a0, 0x934b5396, 0xf708be09, 0xfa2bcb40, 0xde70cc2c, 0x1e6585db, 0x91546ec5, 0xed186173, 0xda22c913, 0x3b51ba96, 0x767f64ba, 0x58b5d3cb, 0xce96a53b, 0xe9e65bb7, 0xe490accd, 0x8b9c0088, 0x759df710, 0x557a7a8a, 0x23738c7d, 0xb8880d68, 0xb23092e2, 0xecce9455, 0x06c7f10a, 0x7ce960b8, 0x029a2178, 0x518f9ba9, 0x42e441cd, 0x50e3f22e, 0x93092d49, 0xc2a0fe82, 0x2932e731, 0xad606c81, 0xd35af42d, 0xd79ea3a8, 0x514584c1, 0x348f21d1, 0x65c7d980, 0x6656881d, 0x59bbfe3f, 0x2c9853e0, 0x26c8835e, 0xa18bcff0, 0xdc94d7d0, 0x7d0ab137, 0xb2f280b0, 0x75875db5, 0x520e2e18, 0x0a79b614, 0xf3938392, 0xbfdabc9e, 0x76e1211d, 0x02c0a97d, 0x14d021d7, 0xa901f427, 0xaa976834, 0x5a2e42f6, 0xa3eacba0, 0x33a2931b, 0xdea99739, 0x5f0d1759, 0xa01316d7 },        // Message 6
            { 0x5d6f3d9c, 0x41079187, 0xd491e278, 0xf6e4c86a, 0xe55c3381, 0xd393eb03, 0x0471ae74, 0xdbdd383e, 0xaf579429, 0x94637bfa, 0x14862f4f, 0xa58a3b93, 0xc35ea5ef, 0x5f0de2f4, 0xe6c2a0d1, 0x949449fc, 0xf0f2c31a, 0x0ffad251, 0x6e005487, 0xa7f3f6cd, 0xba4a846f, 0xa49086d3, 0x5d9edece, 0x099d64c1, 0x24064f82, 0x2d1736ea, 0x6cea5361, 0xbf97aff8, 0x60989760, 0xd9e74c31, 0x349ebfc6, 0xe9920c52, 0xc4c4b082, 0x3ad314e1, 0xe5abf591, 0x166b097b, 0xe6b686b8, 0x85f79ab3, 0x206deb9e, 0xed54a3bd, 0x36e3cc6f, 0x7d839ed7, 0x81e26900, 0x20e0ad10, 0xa77967ce, 0x8a9f84b7, 0x1b33e82a, 0x49cbf2a5, 0x0279db93, 0x4d778e49, 0xecd1af58, 0x83539324, 0x0b11a5db, 0x8a1f27e4, 0x61f539fa, 0x317d68b3, 0xede9ef7c, 0x4392cfcf, 0x68493e17, 0x0045944c, 0x1786b566, 0x20958881, 0x373bd388, 0x65d37d26 },        // Message 7
            { 0xd3bde9e6, 0xa57dc31c, 0x9124efe3, 0x48b33f1e, 0xae7fab80, 0x02cf600d, 0x8887f934, 0x9608cb7b, 0xfa5dc8f6, 0x1ccf1980, 0xa53a73c4, 0x8fd5657c, 0x1afa2dc4, 0x0c167611, 0xd8ee01ab, 0x145020b0, 0x06d60ed6, 0xaff7acde, 0xb5e41331, 0x9bce2ed8, 0xd8c3ce5f, 0x830ec28b, 0x9340206d, 0x6a400341, 0xb19128f9, 0x2b0a8ece, 0x2cb059fb, 0x7fb3fbb1, 0xa9702a3b, 0x8c7e4f62, 0x434f7ecb, 0x88d6aa1e, 0x10e3f024, 0x72438c62, 0x4403348d, 0xe43e7962, 0x19d8307a, 0xe360be64, 0x1dcc14fb, 0xd468ed7a, 0xdf22198e, 0x48b7c193, 0xaa183f77, 0x02f08b4d, 0x3f0b8951, 0x4ecf53f1, 0x6e34c59b, 0xbb0af7e7, 0x4c4e5f20, 0xd9d9528e, 0x761f7be6, 0xf6d96e7f, 0x6cceacd0, 0xfe5e0c06, 0x0de869cb, 0x76dd5cba, 0x2d1c5e29, 0x84fe071e, 0xad96421f, 0x7006bfed, 0xc1446ba4, 0x012d11c6, 0x38c57992, 0x59766787 },        // Message 8
            { 0x5a1af4e7, 0xe37c6a65, 0xa7818fb6, 0xc137ba2f, 0x2dc002f5, 0x5c2d362d, 0x0863073a, 0xd74e27b7, 0x0deaec8c, 0x3a041309, 0x5ec383b5, 0x4e7e5446, 0x8236d27c, 0x1ab06bab, 0x08ec1002, 0xedf6cb2b, 0x6a30b850, 0xd9dedbb8, 0x8ac220c1, 0x1b87ec58, 0x8c55f115, 0x2829ecda, 0x11b4445e, 0x2a35a31e, 0xaac438ce, 0xb5731aca, 0x36fb003c, 0x34b9f2ec, 0xcf6fc098, 0x450dafb6, 0x6807491a, 0xa82d5440, 0xb46d9c55, 0xc3b4cfa3, 0x9ddda5fb, 0x55f6e50d, 0xcdf3b551, 0x446a78c6, 0x67c6a7b8, 0x389447a2, 0xede898f9, 0x0cdf84bf, 0x78669e91, 0xb9d74cd1, 0x7e28242b, 0xde7a9ee2, 0x94bf6106, 0xa4597461, 0x69e8b2b9, 0x932cf68d, 0x6d56fae4, 0xabbb1103, 0xc1478340, 0x2ee55b73, 0xd98a09ec, 0x3c41deb2, 0xfdf109c1, 0xcd2129c8, 0x7e25e9a0, 0x1e3f837e, 0x64afa918, 0x11f11232, 0x56c22d35, 0xc96345da },        // Message 9
            { 0x18ec7c18, 0x82de9be7, 0xf0bd0776, 0x80d93889, 0xc7c20ab9, 0xcbedc9ff, 0xfdf533df, 0xf51bada0, 0x6a7448d8, 0xb53fca55, 0xc7ff0037, 0x1c658ed5, 0xc4403f58, 0x23da4d71, 0xc453c05e, 0xb2abf7ba, 0x6415c335, 0xba6f98cf, 0x5de8ab10, 0x82c4d0a7, 0x7eceae99, 0x9947ce99, 0x097290d5, 0x9539d658, 0xf9a48bdf, 0xcd9f2dab, 0x153c933b, 0x1a790d41, 0x9456a5cf, 0xdafae171, 0xf663dc8c, 0x41297d88, 0x5117dbf2, 0x1a1b6ca0, 0xbb1d54a1, 0xbdf7face, 0xa8016018, 0x6194d0e3, 0x7e35d377, 0x1c1d477d, 0xc9822385, 0xbbdb0f0d, 0x5b5e4b0e, 0xd1a14271, 0x3bed8fd5, 0x04fcaadd, 0x4ba4eb22, 0x9d60891c, 0xb32a7d01, 0xe3b68bed, 0x95b00333, 0x858a5d08, 0xe0f35109, 0x2113a3d4, 0x7fd2874d, 0x47b80f75, 0x5729eac6, 0x9fb93b0e, 0xaa65a597, 0xef3d72d4, 0xd91a3587, 0x1edfd0aa, 0xf65b3c2f, 0x16badb1a },
        },
    },
    { /* Case 3 */
        .iv = { 0x4d, 0x39, 0x4b, 0x5f, 0x64, 0xd7, 0x95, 0xaf, 0x88, 0xe4, 0xab, 0x73, 0xe9, 0x4f, 0x16, 0x5a },
        .p_data = {
            .Y = { 0xb338c1c9, 0x8067b3a5, 0x52a0dfdd, 0x33e05415, 0x30912994, 0x418af50a, 0x2aa6cf30, 0xa76ddb96, 0xbe03c020, 0x19485a62, 0x44a9c82f, 0x3a4ea0f4, 0x29e8ce3f, 0x9f77bcc3, 0x8ac5a934, 0x21d999e0, 0xad9dc793, 0x705b9692, 0xf11b5b64, 0x40f39af8, 0x8f6a8c5d, 0x55ad72b5, 0x412a1151, 0xd0ead3e8, 0x9d1028fc, 0xd4c3a930, 0xa9acae1e, 0xed732262, 0x4cd52629, 0x91c4cdbd, 0x33f7bed7, 0x6e6c8203 },
            .M = { 0x3398b9a9, 0xe004f59e, 0xe293ab68, 0xfe9508d0, 0xc419416e, 0xbc1955f6, 0x8f963035, 0x628c7a2f, 0xcde5f08b, 0x430c457c, 0x708b5823, 0x5024e5f3, 0x55adf617, 0x393ee334, 0x8d8c8f09, 0xd608e46c, 0x80ff13f7, 0x7dbc8407, 0x727ede3c, 0x7930b272, 0x3c7b43ef, 0x00a9c471, 0xa5a6a9cf, 0xbce8732b, 0x03eead94, 0x945169c2, 0xfd1d6f05, 0x8c471354, 0x37eeb506, 0x5324ef4d, 0xc8348330, 0xa63818d5 },
            .Rb = { 0x7265b9fd, 0x78d90d73, 0x86061d2b, 0xb4f3cd24, 0x6d53f461, 0x5f2b8893, 0xf05faf7b, 0xc4a52a02, 0xbfd629e1, 0x9ea05cfb, 0xdc73e38c, 0xd8cc030d, 0x824966fd, 0x0a3c9e0b, 0x0887b000, 0xe54bd673, 0xe34ecada, 0xe5991711, 0x33f0a439, 0x8c047ecf, 0xe81262cf, 0x135fc37a, 0x7d6c72a8, 0x8501a8b0, 0x8f1fc453, 0x5032b172, 0x95474942, 0xa2ae96a8, 0xab241f12, 0x6d63962f, 0xf39293b7, 0x0a94759a },
            .M_prime = 0xd8a50567,
            .length = 31, // 1024 bit
        },
        .expected_c = { 0x5a, 0x60, 0x69, 0x68, 0x29, 0x96, 0x85, 0xb3, 0xba, 0x39, 0x9d, 0x2d, 0x82, 0x39, 0xac, 0x5e, 0x41, 0x70, 0xcc, 0xb7, 0x80, 0x57, 0x4f, 0x9c, 0x32, 0xb6, 0xdf, 0x76, 0xe0, 0x55, 0xa2, 0xaf, 0x23, 0x03, 0x55, 0xb2, 0xe5, 0x42, 0xf6, 0xa3, 0x08, 0x5d, 0x8e, 0x72, 0xd9, 0x24, 0x4e, 0x0e, 0x60, 0x01, 0xcd, 0x9b, 0xe1, 0x39, 0xa8, 0xb8, 0x50, 0xa5, 0xcb, 0xb3, 0x73, 0x9f, 0x7e, 0x43, 0xd9, 0x04, 0xba, 0xbd, 0xed, 0x0d, 0x9f, 0xa7, 0xd8, 0x54, 0x04, 0xdc, 0xf0, 0x9c, 0x3e, 0x21, 0x12, 0x27, 0x84, 0xac, 0x3b, 0x6d, 0x25, 0x77, 0xc4, 0x6e, 0xa9, 0x8c, 0xbd, 0x51, 0xbb, 0x77, 0x74, 0x78, 0x38, 0x6f, 0x12, 0x7e, 0x3b, 0x78, 0x0a, 0x2c, 0xee, 0x20, 0xf8, 0x38, 0xb8, 0x94, 0xe0, 0x15, 0x01, 0x4a, 0x03, 0x96, 0xbc, 0x2b, 0xe2, 0x6e, 0x1c, 0x60, 0x43, 0xc4, 0xdb, 0x17, 0x2d, 0x10, 0x1a, 0x1e, 0x8d, 0x0a, 0x42, 0xb5, 0xfb, 0x94, 0x7c, 0xd7, 0xb7, 0xcf, 0x58, 0xc0, 0x0e, 0xda, 0x57, 0x9e, 0x65, 0x26, 0xc2, 0x71, 0xb0, 0x05, 0x82, 0x8b, 0x48, 0x5a, 0x3f, 0x6d, 0x09, 0x22, 0x96, 0x4f, 0x97, 0xa8, 0xbc, 0x50, 0x28, 0x04, 0x64, 0xf8, 0xa2, 0x84, 0x2e, 0x97, 0x67, 0x29, 0x9c, 0x03, 0xad, 0x8e, 0xd9, 0x64, 0xaa, 0x45, 0x90, 0x41, 0x82, 0xd9, 0x92, 0x05, 0x43, 0x30, 0x8d, 0x58, 0x0f, 0x21, 0xdc, 0xa5, 0xb4, 0x29, 0xdd, 0x5a, 0xeb, 0xb8, 0x63, 0xed, 0x62, 0x73, 0x8a, 0x4c, 0x32, 0xa7, 0xad, 0xf5, 0x47, 0x4d, 0x21, 0x25, 0x93, 0x03, 0x38, 0x7e, 0x7d, 0x34, 0x86, 0x44, 0xd6, 0x2c, 0x20, 0x4f, 0xa0, 0xbb, 0x61, 0xee, 0x7c, 0x1e, 0xe8, 0xa2, 0x69, 0x33, 0xaf, 0x77, 0x2f, 0xa9, 0xae, 0x88, 0x8b, 0xa5, 0x18, 0x12, 0x11, 0x5b, 0x67, 0x92, 0xe5, 0x6e, 0xe4, 0xa3, 0x86, 0xbc, 0x6a, 0x8e, 0x8b, 0x15, 0xb3, 0x15, 0x41, 0x43, 0xc4, 0x46, 0x02, 0x77, 0x36, 0x6e, 0xcf, 0xcc, 0x2d, 0xb6, 0x97, 0xaa, 0x15, 0xe0, 0xf5, 0xe6, 0xc0, 0x4d, 0xfb, 0x26, 0x1c, 0x95, 0x8f, 0xcd, 0x23, 0xee, 0x2e, 0x12, 0x93, 0x22, 0xb6, 0xa1, 0xe1, 0x41, 0xb6, 0x60, 0x46, 0xf0, 0xae, 0x86, 0x25, 0xe6, 0x8f, 0x3b, 0xdb, 0x93, 0xc9, 0x46, 0x2a, 0x47, 0xba, 0x29, 0xd0, 0xec, 0xa8, 0x98, 0x8d, 0x9b, 0x89, 0x38, 0x80, 0x64, 0x39, 0x61, 0xf2, 0x2d, 0x51, 0xb2, 0x4d, 0xc8, 0xab, 0x89, 0x19, 0x61, 0xb0, 0x4f, 0x4a, 0x78, 0xff, 0xa6, 0xd3, 0x82, 0xd0, 0x42, 0x67, 0xd8, 0x17, 0x5c, 0x4e, 0x95, 0xb8, 0x74, 0x88, 0x43, 0x18, 0x2b, 0x9b, 0x01, 0x1a, 0xf6, 0x23, 0x02, 0xba, 0x0f, 0xeb, 0xe2, 0xc3, 0xec, 0x95, 0x93, 0x92, 0x42, 0x80, 0x19, 0x98, 0xb4, 0x21, 0x91, 0x5d, 0x48, 0x86, 0xca, 0xe7, 0xdc, 0xc9, 0x9b, 0x00, 0x2d, 0xd0, 0x0e, 0x87, 0x55, 0x18, 0x5b, 0x2a, 0x65, 0xb4, 0xeb, 0x52, 0x68, 0x8e, 0x09, 0xdf, 0x14, 0x34, 0x6b, 0x63, 0x4b, 0x4a, 0x67, 0xaa, 0x7c, 0x96, 0xf5, 0x6c, 0x7b, 0x89, 0xf0, 0xe2, 0xf2, 0x2d, 0x64, 0x1c, 0xc8, 0x39, 0x70, 0x7f, 0xf5, 0xc7, 0xd4, 0x99, 0xd6, 0x7b, 0x4d, 0x75, 0xfc, 0xda, 0x0e, 0xdf, 0x15, 0xf8, 0xfe, 0x60, 0x96, 0xa6, 0x0e, 0x3a, 0x07, 0x67, 0xab, 0x46, 0x56, 0x1e, 0xb1, 0xb6, 0x7d, 0xc4, 0x5c, 0x71, 0x78, 0xd6, 0x77, 0xd8, 0xfe, 0xb5, 0x42, 0x83, 0x4d, 0x1a, 0x51, 0x86, 0x68, 0x68, 0x6a, 0x52, 0xb0, 0x21, 0x39, 0x4c, 0x9b, 0x28, 0xc0, 0xc7, 0xfe, 0x82, 0x5e, 0x35, 0x35, 0xc1, 0xd1, 0xeb, 0x86, 0xcc, 0x4c, 0xe9, 0xc7, 0xd5, 0x07, 0xdd, 0x7b, 0xfd, 0x51, 0x7b, 0xcb, 0xe1, 0xec, 0xa5, 0xc7, 0x49, 0xa2, 0x94, 0x2f, 0x75, 0x5b, 0x5b, 0xdf, 0x3e, 0x46, 0xa8, 0x52, 0x6b, 0xbf, 0x3a, 0xb2, 0xb8, 0xb5, 0x84, 0xb8, 0x20, 0xa4, 0x49, 0x17, 0x4c, 0x5e, 0x88, 0x81, 0x9a, 0x56, 0x0c, 0x07, 0xdf, 0xff, 0x2a, 0x64, 0xfa, 0xd1, 0x4d, 0xd3, 0x2b, 0x08, 0xca, 0x0f, 0x6d, 0x1a, 0xa0, 0xbb, 0xd3, 0xc2, 0x76, 0xa3, 0x1a, 0x08, 0x76, 0x02, 0xdf, 0xba, 0xb8, 0x7f, 0xcf, 0xcf, 0x86, 0x37, 0x97, 0x5d, 0xad, 0xf3, 0x35, 0xe0, 0x39, 0x32, 0xef, 0xf6, 0x5e, 0xd3, 0xfa, 0x8c, 0xe5, 0xc6, 0x0e, 0x02, 0x87, 0x8e, 0x81, 0x57, 0xb8, 0x65, 0xa5, 0x2f, 0x3a, 0x3b, 0x28, 0xa3, 0xb8, 0x9a, 0xaf, 0x71, 0xa4, 0xac, 0xbf, 0xa8, 0xcf, 0xf6, 0x9a, 0x8c, 0xa0, 0xd5, 0x90, 0x91, 0x0d, 0x5a, 0x93, 0xdf, 0x5d, 0x1b, 0x1b, 0x69, 0x18, 0xb4, 0xc5, 0x77, 0xe8, 0xef, 0x9c, 0xb4, 0x7e, 0xa6, 0xf9, 0xcb, 0xf3, 0xd2, 0x38, 0xfc, 0xce, 0x21, 0x7a, 0x00, 0xf5, 0x0c, 0xa5, 0x6b, 0x34, 0x39, 0x40, 0x44, 0x22, 0x5d, 0xf6, 0xce, 0x67, 0x87, 0xb7, 0xaa, 0x48, 0x2a, 0x4f, 0x25, 0xaa, 0xed, 0x13, 0x3b, 0x68, 0x98, 0xc2, 0x1a, 0x01, 0x58, 0xc8, 0x97, 0xda, 0xff, 0x27, 0x3b, 0x61, 0xbf, 0x55, 0x86, 0x22, 0xa8, 0x23, 0xd2, 0x22, 0xd5, 0x31, 0x58, 0x42, 0xf3, 0xe1, 0x88, 0xc2, 0x3a, 0x45, 0xc5, 0xa9, 0x78, 0x80, 0x5d, 0x0b, 0x52, 0x41, 0x01, 0x75, 0x82, 0x4a, 0x73, 0xb4, 0xae, 0xbd, 0xb0, 0xe4, 0x4f, 0x5c, 0xbc, 0x0e, 0xfc, 0x8b, 0x82, 0xfb, 0x1d, 0xa3, 0xc2, 0xa9, 0x63, 0x6d, 0x38, 0x0e, 0x87, 0x7c, 0x49, 0x96, 0x8a, 0xda, 0x16, 0x0b, 0x93, 0x3a, 0xd4, 0xd7, 0x61, 0x8b, 0x87, 0xfb, 0x12, 0xd2, 0xe1, 0x21, 0x1e, 0x5c, 0x73, 0x07, 0xce, 0x76, 0x95, 0x27, 0xa8, 0x2e, 0xe4, 0x3f, 0xfc, 0xc5, 0x70, 0xc8, 0xae, 0x2f, 0x60, 0x13, 0x04, 0x13, 0xe8, 0xe5, 0x08, 0x71, 0xa4, 0xb9, 0xe9, 0x24, 0x3d, 0x55, 0xaa, 0xc1, 0x38, 0xe0, 0x01, 0x6a, 0xc5, 0x15, 0xa4, 0x93, 0x6f, 0x8e, 0x39, 0x25, 0xf7, 0x92, 0x63, 0x06, 0x04, 0x6f, 0xb6, 0xa6, 0x18, 0x7e, 0x22, 0xbd, 0x18, 0x85, 0x17, 0xf8, 0xdd, 0x9d, 0xa7, 0x6c, 0xef, 0x05, 0x90, 0x63, 0x7f, 0x3a, 0x49, 0xcd, 0x9c, 0x5f, 0x92, 0xe6, 0x37, 0x27, 0x0f, 0xa4, 0x60, 0x8e, 0xe3, 0x4b, 0x37, 0x6e, 0x20, 0xd9, 0xf2, 0x0b, 0x66, 0x30, 0x9b, 0xae, 0x1a, 0x3d, 0x6e, 0xb4, 0x00, 0x2c, 0x35, 0x68, 0x29, 0x3b, 0xe7, 0xd9, 0xa0, 0x7c, 0xa8, 0xd0, 0x63, 0x86, 0x1b, 0xca, 0x65, 0x20, 0x32, 0xeb, 0x00, 0x92, 0x7b, 0x97, 0xc5, 0xf4, 0x06, 0xca, 0x67, 0xc8, 0x76, 0x06, 0xf2, 0xaf, 0x8e, 0xc9, 0x5b, 0x11, 0x04, 0x86, 0x78, 0xc5, 0x64, 0x8b, 0x59, 0x9c, 0x4f, 0xee, 0x8e, 0xf4, 0x47, 0x0f, 0xf8, 0x67, 0x9a, 0xb9, 0x0f, 0x35, 0x61, 0x8a, 0xa4, 0x7e, 0x98, 0x7f, 0x77, 0x6b, 0x3a, 0x1f, 0xb2, 0xff, 0x16, 0x65, 0x3a, 0xb2, 0x4b, 0xc6, 0xab, 0x58, 0x93, 0xe1, 0x3c, 0x23, 0x5c, 0xa7, 0x7c, 0xc1, 0xeb, 0xb8, 0xff, 0x33, 0x6e, 0x8e, 0xf1, 0xef, 0x2f, 0x35, 0x21, 0x18, 0xc4, 0xd8, 0x76, 0x00, 0xe4, 0x35, 0x05, 0xa7, 0xb2, 0xdd, 0x29, 0x2a, 0xf1, 0x9a, 0x71, 0xdc, 0x8b, 0x8a, 0xfe, 0x65, 0x7c, 0x69, 0xb1, 0x96, 0x50, 0xca, 0xad, 0x3e, 0x24, 0x8e, 0xf3, 0xa3, 0xc2, 0x45, 0xfb, 0xb0, 0x6a, 0xef, 0xdd, 0x43, 0xd7, 0x7f, 0x9f, 0x9d, 0x60, 0xe8, 0xa6, 0xe2, 0xf1, 0x66, 0x74, 0x2d, 0xe8, 0xce, 0xf4, 0xf6, 0x36, 0x20, 0x98, 0x61, 0x6d, 0xdd, 0x5c, 0xc0, 0x51, 0x4d, 0x02, 0xda, 0x91, 0x54, 0x7c, 0x86, 0xc3, 0x78, 0xbd, 0x79, 0xda, 0x49, 0x03, 0xe3, 0x7e, 0xc4, 0x85, 0x97, 0xa9, 0x5d, 0x61, 0x8b, 0xb8, 0x09, 0xf1, 0x72, 0xfa, 0xbb, 0xcd, 0x6d, 0x8d, 0x69, 0x98, 0x4c, 0xe9, 0xe6, 0xbe, 0x9e, 0xeb, 0x41, 0xaa, 0xf2, 0x76, 0x7a, 0xcf, 0x00, 0x87, 0x5d, 0x80, 0x02, 0x9a, 0x18, 0xd9, 0x60, 0xac, 0xce, 0xa6, 0x8a, 0xc9, 0xa6, 0xf9, 0x66, 0x29, 0x85, 0x2c, 0x8d, 0x2d, 0x65, 0x95, 0x2e, 0xdc, 0x10, 0xac, 0x0d, 0xb2, 0x0d, 0x78, 0x9e, 0x9b, 0x1d, 0x03, 0xe4, 0x3d, 0xc2, 0x8f, 0x4c, 0xc7, 0x85, 0x5f, 0xde, 0xf2, 0xe0, 0x6f, 0x40, 0x3f, 0x98, 0x4a, 0x8c, 0xbe, 0x1c, 0x03, 0x11, 0x1b, 0x35, 0x22, 0xe1, 0x1b, 0xfc, 0x35, 0x50, 0x24, 0xe4, 0x69, 0xe1, 0x84, 0x62, 0xbf, 0xd2, 0xb8, 0xf6, 0x33, 0x16, 0x6b, 0x43, 0x82, 0xa8, 0x3f, 0xd8, 0xe2, 0xdd, 0x70, 0xf4, 0x10, 0xe7, 0x28, 0x93, 0xa9, 0x90, 0x83, 0x8b, 0x6c, 0xe5, 0x02, 0xba, 0xd5, 0x70, 0x24, 0x06, 0x04, 0x92, 0xba, 0x69, 0x0f, 0xae, 0xa8, 0xc2, 0x50, 0x6c, 0x02, 0xa6, 0x7c, 0xf5, 0x34, 0xd2, 0xe1, 0x96, 0x72, 0x2d, 0x21, 0x8d, 0xff, 0x54, 0x93, 0x60, 0x65, 0x55, 0xbc, 0x44, 0xe4, 0x1e, 0xbf, 0x76, 0xde, 0x3e, 0xbb, 0x24, 0x66, 0x29, 0xd2, 0x6d, 0xcf, 0xc2, 0x51, 0x0c, 0x70, 0xa0, 0x8e, 0xcf, 0x8a, 0xf2, 0x46, 0x1c, 0xe9, 0x65, 0x4b, 0x30, 0xd4, 0xe2, 0x6c, 0x2a, 0x54, 0xf2, 0x8c, 0x3c, 0x50, 0xd7, 0x94, 0x73, 0x82, 0xb2, 0xcc, 0x15, 0x0f, 0x13, 0x98, 0x46, 0x09, 0x7f, 0xeb, 0x5e, 0xba, 0xba, 0x91, 0xfb, 0x04, 0x1e, 0x0d, 0xc9, 0x9c, 0x6b, 0x36, 0x71, 0x09, 0xc6, 0xb2, 0xf1, 0x5f, 0xf8, 0xc5, 0x05, 0x61, 0x4c, 0xc4, 0x73, 0x7e, 0xe9, 0x7b, 0x56, 0x5d, 0xef, 0x57, 0x4f, 0xe5, 0x31, 0x67, 0x35, 0x40, 0xf6, 0x98, 0x9a, 0x6d, 0x6e, 0x4e, 0x89, 0xf9, 0x89, 0x19, 0x3a, 0x37, 0x0e, 0x88, 0x2b, 0x10, 0x72, 0x5e, 0x98, 0x9f, 0xdc, 0x35, 0xfb, 0xec, 0x15, 0x3e, 0xfb, 0x77, 0xf2, 0xbf, 0x9c, 0x2a, 0x35, 0x24, 0x6a, 0xea, 0x8f, 0x2e, 0x7e, 0x5a, 0xab, 0x0f, 0x14, 0x54, 0x41, 0xea, 0x58, 0x7f, 0x8a, 0x8f, 0x9d, 0xa3, 0x20, 0xf8, 0x67, 0x77, 0xf1, 0x12, 0xd1, 0x8a, 0xef, 0x9e, 0x84, 0x8f, 0x9e, 0xeb, 0x6d, 0xab, 0x9b, 0xd7, 0x0e, 0x80, 0x90, 0x81, 0x9d, 0x84, 0x79, 0x26, 0xd4, 0x38, 0x1c, 0x37, 0x72, 0xaa, 0x70, 0x91, 0x29, 0x7f, 0xbc, 0xe5, 0x63, 0xff, 0x91, 0x24, 0x55, 0xbf, 0xa8, 0xc5, 0xb5, 0x3e, 0xec, 0x60, 0x76, 0xa3, 0x58, 0x79, 0xc8, 0x59, 0x1f, 0x9b, 0x50, 0xcc, 0x6a, 0x56, 0xc2, 0xc4, 0xf1, 0x15, 0xeb, 0xde, 0xdc, 0x25, 0x48, 0x2f, 0x44, 0x2e, 0x5f, 0xbd, 0xb8, 0xb2, 0x08, 0x6c, 0x71, 0x46, 0x94, 0x23, 0xf6, 0x74, 0x10, 0x08, 0x55, 0xe3, 0xcb, 0xa0, 0x26, 0x62, 0x1a, 0xea, 0x45, 0xa5, 0x7c, 0xbb, 0x82, 0x5b, 0x37, 0x14, 0x8f, 0xa9, 0x32, 0xef, 0x9f, 0x31, 0xf6, 0xee, 0xb1, 0xe6, 0x10, 0xa6, 0xec, 0xa0, 0xa6, 0xa1, 0x9a, 0x1c, 0x44, 0xab, 0x05, 0x01, 0xea, 0x09, 0x9e, 0x5d, 0xdd, 0x19, 0x00, 0x88, 0xf9, 0xd6, 0x95, 0x0d, 0x7c, 0xdc, 0xa9, 0x82, 0x62, 0x8d, 0xd9, 0x1e, 0x66, 0x66, 0x08, 0xe9, 0xd8, 0x5b, 0x1c, 0x31, 0x37, 0x8b, 0x73, 0xf8, 0x6a, 0xbb, 0x98, 0xd0, 0xd0, 0x8c, 0x3a, 0xfc, 0x24, 0x26, 0xf4, 0x14, 0xaa, 0x7d, 0x30, 0x82, 0x3a, 0x0a, 0x21, 0x2a, 0x59, 0xc4, 0xe0, 0xf4, 0x06, 0xce, 0xaa, 0x15, 0x4b, 0x9b, 0x01, 0x8d, 0xd8, 0xff, 0x50, 0x93, 0xd4, 0x9b, 0x4b, 0x6b, 0xac, 0xe4, 0xe4, 0xf8, 0xe7, 0xde, 0x11, 0x55, 0xdd, 0x3e, 0xdf, 0x95, 0x61, 0x17, 0x59, 0x39, 0xb5, 0x4d, 0x29, 0x9f, 0x1d, 0x1d, 0x47, 0xa5, 0x86, 0x28, 0x0e, 0x49, 0xda, 0xd0, 0xf1, 0x7e, 0x41, 0x52, 0x40, 0xae, 0x83, 0xe1 },
        .hmac_key_idx = 2,
        // results of message array encrypted with these keys
        .expected_results = {
            // Message 0
            { 0xba72e92f, 0xae10df70, 0x5bca3cd7, 0x6f04225e, 0x7d00b5fe, 0x76636818, 0x735c0bcb, 0xd9c0a2f3, 0x95fc03cb, 0x718358cf, 0xdb1d125c, 0xfa75964a, 0xcc15b01d, 0xd6a7be53, 0x4cce1454, 0xfbfc6367, 0x1d368629, 0x412dc330, 0x77bff74f, 0x0778de39, 0xde435343, 0x4fd119cf, 0x09b03a17, 0x1646d9a4, 0x842792ff, 0x11d79d7c, 0x665a863e, 0x9f73563f, 0x6bb67178, 0xeb86aa6c, 0xbf8e8e48, 0x01a8d767 },        // Message 1
            { 0xc1c56630, 0x9d4cfbd6, 0x5d0c0e26, 0x2e2fdcf2, 0x7f4d4c2f, 0xc7d3ba31, 0x9b4c5947, 0x972bea0e, 0x50d8c701, 0xe7480b9c, 0xe5958dcd, 0xe90cd25f, 0x4ccd89ce, 0x2361da6c, 0xf23e79e9, 0xd4e9214a, 0x97e3888b, 0x1a47d051, 0x555dbfeb, 0x366afe71, 0x2ac64722, 0xc8bf47d0, 0x6749c7ab, 0x13234bc6, 0xca154ad5, 0x9041f2a2, 0xf48b17be, 0x647f92ae, 0xe9224a6f, 0x5680bd1c, 0x6f5512cb, 0x2b1c7048 },        // Message 2
            { 0xa2977003, 0xd6e9b4da, 0x07b95635, 0x87991e87, 0x7182ef05, 0x62a6944c, 0xddc01bd2, 0xb0829257, 0x6761e7e1, 0xd4bf505e, 0xe7352707, 0x0098f9b4, 0x03b47ad3, 0xf35a66f2, 0xe98ce33b, 0x9595952f, 0x7c3edce8, 0x04398454, 0x83103ce5, 0x998a2a52, 0xd0958b7e, 0x44ea25c1, 0xf3d014cb, 0x79a16fa2, 0x3d124088, 0x4877d6c1, 0x10d51185, 0xa6efc61d, 0xc1145c15, 0x7c96e140, 0x4193064e, 0xa5f7909b },        // Message 3
            { 0x864f2c69, 0x97195cb9, 0xd8e1b427, 0x67617eee, 0xd3b9f6b5, 0x21b3c45e, 0x5e1fa103, 0x007ff8bd, 0xf390f594, 0xe0cc5d88, 0xa33e4dd7, 0x3be82420, 0x8ebb3666, 0x0acfe045, 0xf7cf562d, 0x0b45c08a, 0xb07adcc7, 0xe08e7b43, 0x6b4d1ded, 0x5f455255, 0x5a62e11d, 0x9ba5cf08, 0xebe4bbe9, 0x3f224968, 0x2899388d, 0x1ed06a6d, 0x673439db, 0xed018c95, 0x97a5f184, 0xdac94ee8, 0xb300bd6d, 0x4f5d8901 },        // Message 4
            { 0xe813a6e9, 0xf8623ece, 0x606d6f56, 0x011b4d25, 0x253e2eda, 0x8e8976b1, 0x35539708, 0x4f7fc2b4, 0xcf49ac33, 0x00db8b47, 0xa8c11748, 0x3fed9d93, 0xcfb60a60, 0x8634cb77, 0x2d927735, 0xf6fac4d4, 0x38b444c1, 0x75b3dbaa, 0x4685dc9f, 0x84d87a81, 0x32ebad0f, 0xb90a1d5a, 0xca174ccc, 0x1461733e, 0xed5de1cf, 0xab125242, 0xe96c9f99, 0x0f6adca9, 0x745efae6, 0xf23a814c, 0xbeff6914, 0x54137808 },        // Message 5
            { 0x82ded2bc, 0x595f0fb7, 0xe83f6022, 0x95d1d131, 0xc0f0951a, 0x625ab669, 0x000413a9, 0x924f0a65, 0x4ccbcf64, 0xbd3a1add, 0xc220053c, 0x373376b2, 0x5536dc78, 0xa68790f9, 0x1598c8fe, 0x70c47c05, 0xef79b99b, 0x493c273a, 0xd68da949, 0x0c8a939a, 0x1725d6cc, 0x9d811bb0, 0x451664f7, 0x9f0caa28, 0xc12a02bd, 0xdf5eb10a, 0x72f76059, 0xe7adb519, 0x4cfd1f4b, 0xe906aab0, 0x875fffa3, 0x21de0263 },        // Message 6
            { 0xd1dfe4b8, 0x4fe33710, 0xaff420d1, 0xb17e0316, 0xe2dddf0a, 0xd5bb0e95, 0x77269d33, 0x30221c42, 0x78a95629, 0x12656b4a, 0x856115c8, 0x77f54093, 0xe4d4b1fe, 0x9e4f4619, 0x631102dc, 0x76bf9be9, 0xdb148371, 0x914e1715, 0x82652047, 0xb30a16ff, 0x28e2d7c9, 0xf917308e, 0x467e65c2, 0xc2cf2b3d, 0x7d717ee6, 0x1dcd4a9e, 0x8a5e8a3d, 0x38d72800, 0xd07673be, 0x1bdf65fc, 0xf81f3c8a, 0x9c2e0d34 },        // Message 7
            { 0xf3e4c4ad, 0x74912017, 0x7a37d474, 0x4c51f003, 0x9f0fcc31, 0x8ee33b4f, 0xe6b28d72, 0xe4234f2d, 0xab7d56fc, 0x2903a668, 0xdf4dd82f, 0x22df0964, 0xfc520d2d, 0x1f8f162e, 0x953853a6, 0x854d9d13, 0x17793a8e, 0xbbb6a63b, 0xb933d590, 0x58617cd6, 0x25ff965b, 0x69782821, 0xf42953ef, 0x9f0bd425, 0xd5bdec4d, 0x631186c2, 0xdba17911, 0x38ae42c5, 0x4fc90e3e, 0xa34f5a43, 0xa7015f30, 0x1158d75c },        // Message 8
            { 0x39c5f930, 0x62fb432e, 0x923867a7, 0xd97c80d9, 0xeda172b8, 0xd13f057a, 0x755bb3da, 0xeb66d1f9, 0x92c010e6, 0xe6d71871, 0x6c8093c8, 0xe2661836, 0x1da9f585, 0xad7b59a7, 0x47d33f5f, 0x374d36e2, 0x950e48ca, 0xeae29093, 0x55db981b, 0x8a9840ba, 0xfaf72af6, 0xb75af9b5, 0x06ff33bd, 0xb4a10b80, 0x69cca0e4, 0xb37fe48c, 0x7302fb82, 0x1c8f53d3, 0x1b960ddb, 0x40381075, 0xb5f802a7, 0x561ae9f2 },        // Message 9
            { 0x79b623c1, 0x837bde5a, 0x8f808b24, 0x109569ad, 0x6c8ec555, 0x5663ef90, 0x7dd62181, 0xe3887a1d, 0x204008ab, 0xa9b00a5c, 0xf11a6639, 0x919e68e6, 0xfd30a100, 0xc7d72472, 0x9fc1f51c, 0x7a73bc7e, 0x7f29f723, 0x845bf48c, 0x88d0b0b4, 0x0308f918, 0xe37a76e2, 0x72d1574f, 0x8072f360, 0x3060e10a, 0xcc10a3a6, 0x76aaef0c, 0x9963ae62, 0xa395d72f, 0xc33b5696, 0x634675f0, 0x2666698d, 0x5e60ef0b },
        },
    },
    { /* Case 4 */
        .iv = { 0x1a, 0x4c, 0x50, 0xba, 0xff, 0xa6, 0x9d, 0x39, 0xfb, 0x57, 0xe3, 0x4f, 0x62, 0xb7, 0xea, 0x72 },
        .p_data = {
            .Y = { 0x3e810ba1, 0x9f644dc7, 0xaa078e34, 0x1eb0da9b, 0x076595db, 0x1a394478, 0x34178765, 0xbb67ffc5, 0x76a0a1ab, 0x40eb29fc, 0x64dc1761, 0x11e6e8d4, 0x81a1e957, 0x23e4e925, 0xaebe1521, 0xa7a1713b, 0xa5468b31, 0xccf89f4b, 0xb3ad3540, 0x21a908b7, 0x8af93ee6, 0x29f5bae0, 0x1f50383a, 0xed32ad2e, 0x18a0ea2d, 0x38f0ea31, 0x203f0ff5, 0xf9a9f44b, 0xf07680e7, 0x9fb34a57, 0x340a3dff, 0x45212f6d, 0x7a187c6e, 0xc4c370bc, 0xa4c99c40, 0xa792a335, 0x647cad30, 0x2ef895b4, 0x43c9298a, 0x98b6f5bd, 0x35151bdd, 0xc2233553, 0x5226c0fb, 0x8be7c854, 0x4296f87e, 0x2d6e1342, 0x68d562a9, 0x281ba6e9, 0xd97fae63, 0x30227173, 0xe9bbd1bd, 0x75841134, 0xbd7f1af6, 0x089b989c, 0x150c0107, 0x5f948fde, 0x8955ae07, 0xedd30eec, 0xb428fe0d, 0x19ebfde8, 0x92415e6e, 0x2ec2dde0, 0x05c5a817, 0x616bb2e6, 0x09e3d733, 0x09769bcd, 0xe208ada7, 0x45625133, 0x319a1d60, 0xc7adbe47, 0x3dfbddff, 0x74272035, 0x70d71946, 0x68a75807, 0x344f528c, 0x92b0c036, 0x0a1b8be1, 0x7c3f481f, 0xf550c534, 0xc361acad, 0x1bf9030d, 0xdfd2e87c, 0xd015d6c2, 0x19439db8, 0xe4935ffa, 0x581caf7c, 0x7327959b, 0x77faee04, 0xe813509e, 0xb6523b05, 0xcb177c84, 0x09492f7f, 0x510cae30, 0x0cbdc3fb, 0x529734ac, 0xf532b43a, 0x6918bb87, 0x7c229488, 0x7ea7b591, 0xf842e5e1, 0x30ca0108, 0xe9fb7f8c, 0x92d5bf6b, 0x9c5d05d8, 0x3f8acd21, 0x38e46c65, 0xc62ac9d9, 0xd1d0bfc0, 0x55ea5880, 0xef5ac76b, 0xf72e8a73, 0x592d0761, 0xfdf0639a, 0x4c436242, 0x96792f01, 0x8888cd7e, 0x8c64fd68, 0x347dde4d, 0x59275d36, 0x5e4c068c, 0xf9365bed, 0xf54d9d10, 0xa3b4efd3, 0x150c488d, 0x09c5ad8e, 0xa16c26d0, 0x075090ab, 0x9b37ab03 },
            .M = { 0xb8c6cb7f, 0x6a28a1e1, 0x5c276d3c, 0xaaa07746, 0xa45f4875, 0x03b9f46b, 0xe8ae50f5, 0xa4a6da06, 0x3c1c9c30, 0xa859ec9f, 0xaa3e9a2e, 0xcdd446a4, 0x3c2bdae0, 0x909f1cf7, 0x40dd8fd0, 0xa7be13f0, 0x4dc244c8, 0x09f943c4, 0x1b645384, 0x3d27f01c, 0x7130473f, 0x6e380172, 0x32db86c6, 0xba13fb6e, 0xc325402d, 0x35e5fc93, 0x160f89cc, 0x485d56f9, 0x2e21b673, 0x14a3c3df, 0x00a172bb, 0x07cde7bc, 0xde5cd136, 0x54b5af00, 0x9fbbc455, 0x992be202, 0x7addc891, 0x179433b3, 0x5bb2fbb5, 0x7f4fd59e, 0x6d3c2c31, 0x011328fd, 0xbe2975ff, 0x8d42af6d, 0xb18ea96f, 0x02ea3e14, 0x474f728a, 0x39cf734c, 0x854f8b75, 0xabf755b9, 0x3e41a6b2, 0xabb28d2f, 0xb464f409, 0x63248bca, 0xab66d668, 0xd30986a7, 0xf6af0682, 0xbc4198b1, 0x91b60e6f, 0xb8024050, 0x8c8ea172, 0x6c5b0a34, 0xa3a1a2ae, 0x33d148ef, 0x9323b3c6, 0xce233c33, 0x3ec2872e, 0x1a0f1f34, 0xf66a1768, 0x626c272b, 0x63cdfe39, 0x93428587, 0x4e3acf4e, 0x85bd85c1, 0x3b8c3a63, 0x7439e0b9, 0xe965bd31, 0x1a338781, 0xe9111237, 0x84f08047, 0xf8edb04b, 0x7ac12a97, 0x63034a07, 0x4537f7b7, 0xf0a379b3, 0x85501147, 0x2bbab728, 0xa4b03198, 0xf04ad415, 0x5a29c443, 0x8186e3cf, 0xef474cd6, 0xe70b98a7, 0x18e2b385, 0x7fff695a, 0x72741fcd, 0x1fa5b7c0, 0x47d7af93, 0x9387ed18, 0xce66e3d9, 0xb929abe8, 0xf800fb74, 0x6ffed75b, 0xf3751f51, 0x5a2b25c8, 0xafe14ce1, 0xcef73f16, 0x97d26329, 0xe10281db, 0xbf7166c0, 0xd17c4148, 0x17824b21, 0x2971f5f4, 0x35cad8dd, 0xe86dabde, 0x666b0fc4, 0xc0ba9585, 0x963743cd, 0x76888a7c, 0x0c6cf767, 0xf6df6893, 0x10307071, 0x359151de, 0x785206df, 0x194167c1, 0x66871182, 0xdd28b011, 0xc1ac50af },
            .Rb = { 0x5601d942, 0x64406920, 0x8c7a0bd1, 0x86261be2, 0x998a1c5c, 0x13a2385b, 0x08006737, 0x26f1116d, 0xfdd4d386, 0x4e042d1f, 0x6cc9c843, 0x1b5fd9be, 0x1295af18, 0xe78c4d62, 0xca5e558f, 0x6aa821b7, 0x7953f0b0, 0xe00c418a, 0xc1ed8d5f, 0x09b356ea, 0x3e8d8804, 0xdf84e7fd, 0x18458a64, 0x03af2adb, 0xe4785ef7, 0x0dfb9ec2, 0x605310e2, 0x13427bd3, 0x5c2ac3af, 0x5610bc0f, 0xc8ee617c, 0x955ab02e, 0x26c8937c, 0xc996cfd7, 0x5fe5a7dc, 0xbc9fcf43, 0x7e7d7367, 0xd2d4e3df, 0xa1bbde53, 0x6da7080d, 0x26f727fd, 0x27f1e4a2, 0xc30f4c27, 0x2f22b83c, 0xc8454ab1, 0x14035a64, 0xcb668ae2, 0xaa706148, 0xff171528, 0x8f89b0b2, 0x2d2908a2, 0x1c6aa3f1, 0xea7f145c, 0x3b291b85, 0x804ba12c, 0xabec0d49, 0x5725a717, 0x4f688543, 0xcf8bc9b0, 0x930bba14, 0x8b26e3a4, 0xf4077f67, 0x6759fdb9, 0x1a483477, 0xa2141a28, 0xb29f8d27, 0x89f58be8, 0x852f483f, 0x5d0b7c5e, 0xc2b27bb0, 0x1a73f70b, 0xc9889f3d, 0xaca633e2, 0xb62bb4e9, 0x117369ac, 0x86217fa5, 0x7fcabf97, 0x43ea33e1, 0x84eeb189, 0x75bd17d3, 0x7e1ea7c1, 0x16a2ba4d, 0xd07e6f23, 0x2a0f88cc, 0x5d66590e, 0x5d00f33a, 0x39ad53e7, 0xf1edfab3, 0xc6a00ef7, 0x53e02654, 0x240a381c, 0xa9b977cf, 0xda92216b, 0x4a17d895, 0xc23adaec, 0xb51d2a59, 0xfdb8aa0b, 0x68834d23, 0x16136874, 0xb4427c6b, 0x4041ba51, 0x9e762fd8, 0x642d31d9, 0xa0ce898b, 0x1987209c, 0xdd509791, 0x4f9b2c85, 0x69c03518, 0x053b7ff4, 0x5126f869, 0xae33efa3, 0xca22b5b5, 0xb35298e2, 0x1f462924, 0xfe754ae2, 0x87cd8eef, 0xfcf54790, 0x053e588d, 0x389b5a40, 0x0478119d, 0x2c6d7f65, 0xe08ae821, 0x383d18d6, 0x7d8eff6e, 0x6e668fa3, 0x622cdd7b, 0xebf86fce, 0x9e8c4ef8 },
            .M_prime = 0x356b0b81,
            .length = 127, // 4096 bit
        },
        .expected_c = { 0xdc, 0x5b, 0x4a, 0x62, 0xf6, 0xdb, 0x54, 0x89, 0x9c, 0x0c, 0x5a, 0x0e, 0x1f, 0xf2, 0x63, 0x97, 0xa7, 0xa1, 0xe0, 0x92, 0xff, 0xda, 0x82, 0x90, 0x87, 0x9e, 0x8f, 0x4b, 0x96, 0xf7, 0x6b, 0x92, 0x5a, 0x0c, 0x4f, 0x4d, 0x4b, 0x26, 0x28, 0xb5, 0xf2, 0x59, 0xf1, 0xfd, 0xa8, 0x58, 0x46, 0xc2, 0xbd, 0xbf, 0xd5, 0xe0, 0xd4, 0x14, 0xab, 0x0d, 0xb4, 0xbb, 0xe8, 0x6f, 0x46, 0xc9, 0xab, 0x80, 0xa2, 0xf5, 0x41, 0xc8, 0x40, 0xa2, 0x1d, 0x25, 0xc7, 0x9e, 0xdb, 0x6c, 0x2e, 0x00, 0xb1, 0x54, 0x6f, 0xc4, 0x2a, 0x48, 0x73, 0x3d, 0x39, 0x1d, 0x8c, 0x93, 0xb3, 0x17, 0xe1, 0x2a, 0x7c, 0xac, 0x5f, 0x12, 0x74, 0xef, 0x3f, 0x57, 0x8b, 0x40, 0xb1, 0xd9, 0xc0, 0x6e, 0x8d, 0x84, 0x10, 0xba, 0xd2, 0x2b, 0xd2, 0x22, 0xc1, 0xbb, 0xc3, 0x33, 0xec, 0x5f, 0xbd, 0x4e, 0x89, 0x58, 0x33, 0x59, 0x78, 0x1d, 0x44, 0x7b, 0x9b, 0x5d, 0xda, 0xff, 0x31, 0x86, 0x18, 0xaa, 0x07, 0x2e, 0x28, 0x21, 0x81, 0x74, 0xe5, 0x1b, 0xfb, 0x1c, 0xcf, 0x44, 0x4c, 0x12, 0x5f, 0x24, 0xf9, 0xa0, 0x00, 0x76, 0x35, 0x14, 0xe5, 0x8d, 0x78, 0xa4, 0xec, 0x3d, 0xd9, 0x75, 0xe8, 0x0d, 0xbe, 0x85, 0x52, 0x66, 0x38, 0x34, 0x45, 0x00, 0x22, 0x3e, 0x8d, 0x40, 0x64, 0x0e, 0x4a, 0x44, 0x79, 0x8d, 0x94, 0x4b, 0xf5, 0x4c, 0xbb, 0xf4, 0x65, 0x66, 0x19, 0xf7, 0xb2, 0x39, 0xf2, 0x7d, 0x42, 0x01, 0x5d, 0x1b, 0xea, 0x57, 0xc5, 0xf0, 0xee, 0xce, 0x94, 0xca, 0x24, 0x3e, 0xa1, 0x18, 0xcc, 0x82, 0xe8, 0x2f, 0x6e, 0xcf, 0xf6, 0x89, 0x9a, 0x2c, 0x95, 0x15, 0x5b, 0x69, 0x12, 0x23, 0x63, 0x30, 0x8a, 0x45, 0x93, 0x0e, 0x07, 0x04, 0x6f, 0x75, 0x06, 0xbb, 0xe9, 0x0f, 0x6d, 0x83, 0xf0, 0x6b, 0x37, 0xab, 0xfa, 0x3c, 0x0e, 0xb6, 0x37, 0x4c, 0x66, 0x84, 0xe9, 0x79, 0xfb, 0xed, 0x8c, 0x0d, 0x47, 0xbc, 0x6c, 0x10, 0xad, 0x72, 0xeb, 0x40, 0xc9, 0x2f, 0x35, 0x33, 0x9b, 0x98, 0x4e, 0x36, 0xb3, 0x40, 0xb6, 0x7c, 0x1a, 0x7f, 0x09, 0x59, 0x6c, 0xe8, 0xac, 0x16, 0xa1, 0x40, 0xe1, 0xb5, 0x49, 0xd6, 0x66, 0xc4, 0x03, 0x78, 0x66, 0x58, 0xd0, 0x6e, 0xa2, 0xcd, 0x83, 0x4c, 0x9b, 0x54, 0x7c, 0x55, 0x53, 0x38, 0x88, 0x11, 0x78, 0x61, 0x34, 0xca, 0x0a, 0x13, 0x8a, 0xfa, 0x17, 0x7d, 0x6a, 0x5d, 0xd1, 0x65, 0x23, 0x3a, 0x39, 0x24, 0x01, 0x94, 0xfd, 0x95, 0x26, 0x57, 0x0b, 0xcd, 0x87, 0xbd, 0xbc, 0x5f, 0x25, 0xc1, 0xae, 0xbd, 0x13, 0x26, 0xfc, 0x01, 0x0d, 0x0b, 0x44, 0x71, 0x1c, 0x1f, 0x22, 0xf1, 0x11, 0x69, 0x78, 0xe7, 0xe4, 0x8f, 0x4d, 0xd6, 0x40, 0xff, 0xa3, 0x71, 0x49, 0x3f, 0xa9, 0x7e, 0x9d, 0x3b, 0x03, 0x31, 0x05, 0xe5, 0x50, 0x9a, 0x86, 0x71, 0x39, 0x21, 0xe2, 0xee, 0xb5, 0x51, 0xd2, 0xb7, 0xb8, 0x40, 0xee, 0xcd, 0x63, 0x45, 0x8a, 0x97, 0xa8, 0x1b, 0xb7, 0x12, 0x30, 0xc6, 0xe7, 0xdc, 0xcb, 0x9d, 0x8d, 0xc7, 0x33, 0xef, 0xb5, 0x86, 0x43, 0x2c, 0xe7, 0x2f, 0x29, 0x3a, 0x4f, 0x38, 0xc0, 0x3c, 0x53, 0xe9, 0x23, 0x64, 0x72, 0xe4, 0x13, 0xf3, 0x7c, 0x6c, 0x14, 0xb3, 0xad, 0xa9, 0xf9, 0xd4, 0x87, 0x6d, 0xee, 0x5c, 0x55, 0xa3, 0x3f, 0x80, 0x7d, 0x4e, 0xa4, 0xc7, 0xa9, 0xe4, 0x11, 0x22, 0x73, 0xc6, 0x5e, 0x73, 0x81, 0x36, 0xa8, 0x36, 0xce, 0xc7, 0x65, 0xdb, 0x96, 0x1b, 0xc9, 0x23, 0x22, 0x8d, 0x07, 0xb1, 0x75, 0x7f, 0xe7, 0x77, 0x73, 0x33, 0xa1, 0x8c, 0x82, 0x8f, 0x47, 0xe5, 0xa7, 0x9f, 0xf8, 0x9e, 0x5f, 0x82, 0xb7, 0x3c, 0xfb, 0xbc, 0x0a, 0x32, 0x65, 0x27, 0x9f, 0x85, 0x2c, 0xf0, 0x98, 0xf3, 0x2d, 0x32, 0x6f, 0xa2, 0xf6, 0xad, 0x60, 0xa0, 0x8d, 0xf4, 0x64, 0x50, 0x34, 0x61, 0x0f, 0x4d, 0xab, 0x2f, 0x66, 0xc6, 0x21, 0xa6, 0x3c, 0x01, 0x91, 0xa2, 0xad, 0x41, 0xe1, 0xaa, 0x47, 0x0b, 0x69, 0x43, 0x30, 0x75, 0x68, 0x11, 0x54, 0x55, 0x26, 0x21, 0xef, 0xc7, 0x8a, 0xca, 0x19, 0xd7, 0xd3, 0x1a, 0xfb, 0x73, 0x97, 0xdd, 0xf3, 0x77, 0xdb, 0x7c, 0x0d, 0x50, 0xec, 0xe7, 0xa4, 0x3f, 0xdd, 0x38, 0x51, 0xdf, 0xdf, 0x00, 0xdd, 0x3d, 0x31, 0xe4, 0x29, 0xab, 0x9b, 0xb9, 0x63, 0x73, 0x0f, 0x16, 0x87, 0xe4, 0xf1, 0x4e, 0x79, 0xa0, 0x2c, 0x9c, 0x52, 0x96, 0xe3, 0xe5, 0x2e, 0x25, 0x39, 0x70, 0x96, 0x88, 0xde, 0x61, 0xf8, 0x7c, 0x08, 0x83, 0xfc, 0xa6, 0x51, 0xb8, 0x2d, 0x77, 0xa1, 0x0b, 0x8b, 0xbc, 0xf9, 0xf9, 0xaa, 0x39, 0x8d, 0xcc, 0x7b, 0xe1, 0x3f, 0x56, 0x8c, 0x92, 0xe6, 0x36, 0x2f, 0xa4, 0x8a, 0x0b, 0x4d, 0x4f, 0x6a, 0x80, 0x76, 0x6e, 0x49, 0x23, 0xcc, 0x17, 0xa5, 0x74, 0x34, 0xd9, 0x39, 0x2b, 0xed, 0x4c, 0xbb, 0xa2, 0xb3, 0x94, 0x14, 0xca, 0x53, 0x09, 0xae, 0x63, 0x1d, 0xdd, 0x66, 0xab, 0xf4, 0x3f, 0xde, 0x75, 0x41, 0x49, 0xba, 0x45, 0xd4, 0xf4, 0x72, 0x88, 0x8b, 0x09, 0xf2, 0xff, 0x0c, 0x9c, 0xff, 0xbb, 0xe4, 0xa9, 0xb4, 0x13, 0x00, 0xb1, 0x08, 0xaa, 0x9c, 0x54, 0xd1, 0x88, 0x4c, 0x7b, 0x1b, 0x66, 0x94, 0xc3, 0x13, 0x89, 0xc6, 0x62, 0x60, 0x90, 0x42, 0xba, 0x4c, 0xf9, 0xc4, 0xf4, 0xbc, 0xe1, 0x30, 0x6e, 0x73, 0xfb, 0xd4, 0x91, 0xc5, 0xce, 0x0f, 0xb7, 0xd9, 0x62, 0x70, 0xdd, 0xfe, 0x71, 0xb2, 0x5e, 0xd0, 0xeb, 0xda, 0x4e, 0x7a, 0x90, 0x5b, 0x3b, 0xf6, 0x69, 0x1a, 0x59, 0xe3, 0xb8, 0x25, 0xab, 0x0e, 0x7b, 0x15, 0xbf, 0x60, 0xf7, 0x5e, 0x33, 0x34, 0x4b, 0x54, 0x9f, 0xa6, 0x68, 0x19, 0xf1, 0xf7, 0xf2, 0x63, 0x02, 0x05, 0x44, 0x74, 0xd4, 0x6a, 0x9b, 0x83, 0xd4, 0x29, 0xaf, 0x1d, 0x3f, 0x3d, 0x78, 0xf5, 0x31, 0xf4, 0xfb, 0xcd, 0xaa, 0xf8, 0x7e, 0x03, 0x75, 0x26, 0x74, 0xdd, 0xaa, 0x43, 0x84, 0x36, 0x80, 0xf2, 0x6e, 0x4d, 0x65, 0x16, 0xfb, 0x82, 0x4a, 0x23, 0x82, 0xe2, 0x52, 0xf6, 0xca, 0x1f, 0xfc, 0x1b, 0x6f, 0xad, 0xde, 0xfb, 0x10, 0xf9, 0x24, 0x69, 0xe0, 0x91, 0x90, 0x32, 0x84, 0x87, 0x11, 0x9c, 0x48, 0x3c, 0xa8, 0xfb, 0x07, 0x8c, 0xa5, 0xfe, 0xdf, 0x36, 0x0e, 0xaa, 0xe2, 0xed, 0x8b, 0x76, 0x35, 0x52, 0xb1, 0xf5, 0x63, 0xfe, 0x1c, 0xf2, 0xef, 0xb3, 0xef, 0x31, 0xfd, 0xb1, 0x4a, 0x8f, 0x54, 0xf0, 0x9f, 0xc2, 0x71, 0xa0, 0x02, 0x6f, 0x46, 0xc9, 0xf2, 0x17, 0x52, 0xff, 0xce, 0xa1, 0x63, 0x65, 0xe2, 0x1e, 0x5e, 0x5c, 0x0f, 0x01, 0xec, 0x6b, 0x19, 0x1c, 0xe3, 0xb0, 0xd4, 0xe0, 0xfc, 0x02, 0x8a, 0xe6, 0x63, 0xa0, 0xc5, 0xac, 0x15, 0xe1, 0x93, 0xcc, 0x01, 0x53, 0x94, 0x72, 0x2c, 0xd5, 0x77, 0xec, 0xf5, 0x9d, 0xcf, 0x04, 0xbb, 0xd1, 0x2a, 0x09, 0xee, 0xa4, 0xb5, 0x32, 0xf9, 0xeb, 0xdd, 0x86, 0x63, 0x79, 0xbe, 0xe8, 0x7a, 0xe6, 0x06, 0x77, 0x6c, 0x06, 0x06, 0x51, 0x08, 0xe9, 0x5c, 0x2e, 0x33, 0x10, 0x91, 0x48, 0xd3, 0x12, 0x59, 0xee, 0xc6, 0x43, 0x33, 0xc7, 0xe6, 0x4c, 0x2e, 0x25, 0x0e, 0x2a, 0x9f, 0x2d, 0x2d, 0x45, 0x7f, 0xcd, 0x94, 0x00, 0x1a, 0xd7, 0xd7, 0x9d, 0x04, 0x99, 0x6e, 0x51, 0x7d, 0x63, 0x0d, 0x19, 0xe7, 0xd3, 0xaa, 0x4a, 0xe9, 0xd3, 0x4d, 0x89, 0x70, 0x12, 0xb0, 0x33, 0xc5, 0xaf, 0x01, 0x02, 0x14, 0xe0, 0x3e, 0xb2, 0x78, 0xc2, 0xed, 0x67, 0xc6, 0xfa, 0x63, 0xcf, 0x95, 0x7e, 0xb7, 0x85, 0xbc, 0x17, 0x7a, 0x81, 0xc5, 0x3d, 0x93, 0x40, 0x64, 0xd8, 0xfc, 0x97, 0x3f, 0x9f, 0xb8, 0xd8, 0x4c, 0x77, 0x94, 0x3b, 0x2b, 0x12, 0xa9, 0xf2, 0x07, 0x15, 0x7b, 0x0f, 0xc0, 0xe2, 0xd7, 0x03, 0x3e, 0xe7, 0xef, 0xaa, 0xa9, 0xfe, 0x41, 0x8c, 0x01, 0xc8, 0x33, 0x91, 0xae, 0x31, 0xa3, 0x37, 0x88, 0x90, 0x00, 0x6e, 0xcf, 0x20, 0x04, 0x26, 0xa1, 0x14, 0xe9, 0x19, 0x61, 0x08, 0x22, 0x2c, 0x7e, 0x7e, 0xc3, 0x4a, 0xa3, 0xa2, 0x04, 0xe5, 0x00, 0x2a, 0xf9, 0xac, 0x41, 0x15, 0x13, 0x23, 0xb0, 0xee, 0x4d, 0x84, 0x23, 0xb4, 0x05, 0xca, 0x32, 0x98, 0x88, 0x64, 0x6b, 0xb6, 0x72, 0xeb, 0xc1, 0x38, 0x14, 0x25, 0xf1, 0xe9, 0xed, 0xdf, 0x80, 0x09, 0xea, 0xae, 0xe4, 0xe5, 0x6f, 0x92, 0x20, 0x16, 0x2a, 0xd6, 0x32, 0x24, 0x94, 0xcb, 0xe7, 0x22, 0x0d, 0xb2, 0x31, 0x53, 0xc8, 0x48, 0x8d, 0x94, 0xbc, 0xf5, 0x7e, 0xa1, 0xd6, 0xe1, 0xe1, 0xfc, 0x3c, 0xa9, 0x77, 0x99, 0x7b, 0xce, 0x8c, 0x79, 0xb4, 0xdd, 0x4f, 0x22, 0x02, 0xe9, 0x91, 0x81, 0x61, 0x90, 0x18, 0x90, 0x4e, 0x1d, 0xf4, 0xe3, 0xb6, 0x9e, 0x32, 0x15, 0xaf, 0x3c, 0x9a, 0x46, 0xe4, 0xf2, 0x16, 0x76, 0xfc, 0x26, 0x6c, 0xd4, 0xb0, 0xd7, 0xa9, 0xa5, 0x7d, 0x7c, 0x59, 0x17, 0xa4, 0x26, 0xa1, 0x72, 0xf5, 0x8f, 0x61, 0x71, 0x04, 0x02, 0x90, 0x1e, 0xc8, 0xc9, 0xa2, 0x5b, 0x44, 0x54, 0x45, 0xc7, 0xe1, 0x95, 0xff, 0x0e, 0xbb, 0x1b, 0x04, 0x92, 0x6a, 0xaa, 0x37, 0x3b, 0x71, 0x08, 0x77, 0xab, 0xae, 0xdc, 0xcc, 0x21, 0xf1, 0x7b, 0x13, 0x27, 0xb1, 0xf2, 0x4e, 0x47, 0x83, 0xd3, 0x71, 0xf2, 0xb8, 0x30, 0xb2, 0xce, 0x51, 0xc1, 0x4f, 0x11, 0xd5, 0xbe, 0x68, 0x52, 0x1c, 0x7d, 0x61, 0x3e, 0x9c, 0xc8, 0x96, 0xdd, 0xc4, 0xeb, 0x27, 0xf5, 0x6e, 0x39, 0x32, 0xff, 0xbb, 0x3d, 0x81, 0xe1, 0x29, 0x6f, 0x52, 0x76, 0xb4, 0xb4, 0x5c, 0xa6, 0x09, 0x51, 0x6c, 0x0d, 0xe7, 0x72, 0x2b, 0x9c, 0x11, 0x69, 0x14, 0xfe, 0x32, 0xbc, 0x66, 0xd0, 0x13, 0xa6, 0x76, 0x2e, 0xad, 0x87, 0x21, 0xa5, 0x6f, 0xc0, 0x32, 0x7a, 0x49, 0xc2, 0xa3, 0x6c, 0xac, 0x5b, 0x9d, 0x2c, 0xd4, 0x78, 0x4b, 0x1b, 0x0e, 0xeb, 0xa6, 0xb5, 0x02, 0xd6, 0xf6, 0xd5, 0xda, 0x7b, 0xf1, 0xe6, 0xd8, 0xef, 0x92, 0x36, 0xe3, 0xbc, 0x06, 0x4f, 0x00, 0x2d, 0x51, 0xe9, 0x41, 0x13, 0x3e, 0xf4, 0xf0, 0xe3, 0xe3, 0x08, 0xf1, 0x87, 0x70, 0xac, 0x30, 0x5d, 0x58, 0x0f, 0x60, 0x56, 0x27, 0xfe, 0x55, 0x2a, 0xec, 0x36, 0x7e, 0xe2, 0x09, 0x3d, 0x87, 0x92, 0x3d, 0x27, 0x1d, 0xb3, 0xbf, 0x9c, 0xd3, 0x60, 0x34, 0x40, 0xb2, 0xd7, 0x01, 0xca, 0x39, 0xe4, 0x22, 0x30, 0xad, 0x84, 0x80, 0xb7, 0x64, 0x67, 0x11, 0x0e, 0xbe, 0x29, 0x82, 0x87, 0x81, 0xe2, 0x47, 0xd1, 0x6e, 0x26, 0x2b, 0x90, 0x6a, 0x1d, 0xd5, 0x70, 0x58, 0xae, 0xd5, 0x45, 0xe2, 0xd1, 0x44, 0xb9, 0x87, 0x1c, 0x44, 0xae, 0x73, 0xe0, 0x30, 0xbb, 0x2a, 0xf7, 0xcf, 0xe1, 0xf3, 0x55, 0x91, 0x15, 0xdc, 0x3e, 0x18, 0x66, 0x8a, 0x00, 0xdb, 0x0f, 0x63, 0x46, 0x3a, 0xdc, 0x1f, 0xc3, 0x4c, 0x52, 0x5b, 0x33, 0xca, 0xa2, 0x54, 0x74, 0x87, 0x7c, 0x01, 0x49, 0xa9, 0x96, 0x5d, 0x2f, 0x8b, 0xc9, 0xb4, 0x6f, 0xc6, 0x51, 0xf8, 0x12, 0x8e, 0x43, 0xcb, 0x79, 0xd9, 0xf1, 0x6a, 0x93, 0x73, 0xb1, 0x20, 0x5b, 0x54, 0xc7, 0xac, 0xc0, 0x1a, 0x43, 0x82, 0xce, 0x36, 0x7e, 0x2f, 0xf0, 0xd8, 0x71, 0xca, 0xac, 0x8a, 0x3a, 0x12, 0xfc, 0x41, 0x37, 0x33, 0x3a, 0x8a, 0xe2, 0x5f, 0x3a, 0x21, 0x6e, 0xb5, 0x99, 0xcb, 0x27, 0x11, 0xe9, 0x6c, 0xeb, 0xb1, 0xa1, 0x63, 0x3b, 0xd4, 0xb0, 0x99, 0x7d, 0x21, 0x20, 0x38, 0xd0, 0xe8 },
        .hmac_key_idx = 0,
        // results of message array encrypted with these keys
        .expected_results = {
            // Message 0
            { 0xd6181232, 0x4c3f3b3c, 0x02a0117a, 0xb147d1bd, 0xefddcdf5, 0x643659c6, 0x9269d1fe, 0x75cbe975, 0xa5c6b0b8, 0x3217a488, 0x427b00ab, 0x2c722f10, 0xcb41a86b, 0xeeea8e33, 0xe2da56e4, 0xcb3cd04d, 0x426e8b0e, 0xd1f1313e, 0x7d819534, 0xe36bc154, 0x20df1ed5, 0x185506ab, 0x0ee68201, 0x94cde377, 0xb6580762, 0x21e6fdd4, 0x29c298af, 0xdc767cb2, 0x9399aa2e, 0x66731f3b, 0x6758040b, 0x201d182b, 0xa1ccd2d4, 0x7f65a75e, 0xdba1cb59, 0xc99d86a4, 0xbe8fa6c4, 0x63b00a31, 0x0284cb92, 0xceedac4b, 0xde2a5464, 0x4eb0b620, 0xf0c8df99, 0xe1bc0349, 0x3a40449c, 0xec1c195c, 0xcfbc468a, 0xc0fdcf7f, 0x54f7a64f, 0x46b1ec0c, 0x150f403d, 0xbfd9cdfd, 0x8de55c3f, 0xa7c16275, 0xb6249827, 0x98f5651a, 0xf65879d3, 0x6754363f, 0xc3dc0cbd, 0x52c7cf64, 0xc7bc362a, 0x26d460ed, 0x7c486d29, 0xb45c2503, 0x41a32b07, 0x7868e90e, 0x9cbbfdd2, 0xb7d139ec, 0x8c887d1b, 0x7a093383, 0xe3f7db73, 0xdd6753b2, 0xf3bedf1b, 0x1ff37916, 0x9d1b5055, 0x75c578ae, 0xc042e8bd, 0x459d6f50, 0xe1fab515, 0xe29127df, 0xc59cdcd3, 0x5f5b3232, 0x814a7cba, 0xc3a08009, 0xfb7eb550, 0x1668365d, 0x51a79a39, 0x602afd8d, 0xfbbda80a, 0xf9d876db, 0xe3243435, 0xd09a88d2, 0x5758caa9, 0x4f5dab1c, 0xca400386, 0xfacda8bf, 0x2fd4be34, 0x86eea3bc, 0x21b9d7db, 0x70fe2723, 0xa1e3f21d, 0x2dc8a5fb, 0xfde4610e, 0x95e94b2e, 0x1490a425, 0x3f9c7a30, 0xfae138af, 0x02c5721b, 0x5ad36aba, 0x546b4c2e, 0x7cd440eb, 0x6e59f972, 0xb056e630, 0x956eda28, 0x893c3222, 0x808b1df5, 0xf0a819f1, 0x8665d811, 0xec3651bb, 0x1be40421, 0xda17c3c8, 0xd957cc7e, 0x1e65855b, 0xb04bdee2, 0x67ee35e5, 0x0df1ce25, 0x641d8626, 0x44e55185 },        // Message 1
            { 0xe8655d24, 0x3cf44779, 0x6f5ce997, 0x4c954812, 0xb1411bac, 0xe17e382c, 0x68d687bd, 0xba823aee, 0xe12b8177, 0x1b0e8fab, 0x7b916f70, 0x0fad9234, 0xfe19d26d, 0xe7575249, 0xc995e816, 0x3e850516, 0xf0b4473a, 0x9f69a144, 0xdaaf2e85, 0x1cccc787, 0xb783f951, 0xe158b74a, 0x9b976056, 0x27e9d0d1, 0xca44ac47, 0x0043596b, 0x1845e608, 0x098ee588, 0x8e18c478, 0x37eb9188, 0x322ce0f8, 0xdd41611f, 0x946279c7, 0x71a52276, 0xfbe94893, 0x4fad7943, 0x606beefd, 0x81a5fd96, 0xc1a6be10, 0xebf3051e, 0xcd1e78d8, 0x3f6dbd11, 0x37231c5f, 0xf0b23b49, 0x2c5c6015, 0x0fe8e839, 0x11cbf712, 0xb98f7946, 0xd0ce3c64, 0x170dc629, 0x94996fde, 0x2891d7ce, 0x6be3efc5, 0x2549495d, 0xacda425a, 0x66e1d128, 0xd73c8cad, 0x4db74cd4, 0xdaf15f2c, 0x40fb43d3, 0x766157e6, 0x6115b1a1, 0x22e9f53f, 0x2f9c972b, 0xd1e466d1, 0xf6863116, 0xf1e833f7, 0xc2c8dcbe, 0xc2738786, 0x02755ad1, 0xe5f67790, 0x91f3b20e, 0x357cfa4f, 0xcd047a74, 0x9e0b28b2, 0x1b35d095, 0xfcba8a07, 0x02055ea3, 0x5f3e5cf2, 0x32818583, 0x4d6636b7, 0x383047ab, 0x7962077c, 0x65ec9d0a, 0x6608a8ac, 0x15eee1e5, 0x79c70043, 0x170e2c88, 0x3bc736ec, 0xde0b15a0, 0x8e67330d, 0xffacad3a, 0xaa919daf, 0x382a076a, 0x90c17105, 0x384f7237, 0x62a858d0, 0x6163ee2d, 0xd32c4283, 0x59bdecc8, 0x493a1b07, 0x0874f351, 0x81ee60e5, 0x40e12352, 0x4de89d93, 0xe90fb2a0, 0x9e7c59a8, 0x6264ab2e, 0x60d143a2, 0xe631c19d, 0x0eb76c17, 0x645f9ebf, 0x9694cff1, 0xe2d018a3, 0x99995405, 0x8ef0fa59, 0xde1d39e5, 0xb7caea84, 0xb5d5660b, 0xba95cad0, 0x5f42d2bb, 0x4ddee6e8, 0x4cd15df9, 0xf3e3151c, 0xdb67fb81, 0x941f8511, 0xa1ec08c4, 0xa17234dc },        // Message 2
            { 0xf498231c, 0xb596c199, 0x3c8bad8e, 0x0e48af8f, 0x731238f9, 0x5e41b7d0, 0xa281050b, 0x26092ca2, 0x4367262c, 0x85028677, 0x960a314d, 0x1735947a, 0xe00e3416, 0x75b7e10c, 0x7afd0873, 0x16fef2f7, 0xf1897b3a, 0x441ecaf2, 0x858cb22a, 0x477169a3, 0x0d049be1, 0x1de513a6, 0x674fc416, 0x77c4f189, 0x392814b1, 0x6a056172, 0xf09ecf7a, 0xce35d5f6, 0x27d7cc5f, 0x895b91e5, 0xc20d4fa3, 0x311c8bfb, 0x2ea43c2a, 0x735cf539, 0x73714e22, 0xc3a9351a, 0x8452f3d8, 0xd6667669, 0x6041f5a1, 0x8244a39b, 0xa32c91ea, 0x84c4dbc5, 0xa53e7960, 0x336dd099, 0x46c93e7a, 0xd54cbcb7, 0xec16e4cf, 0x5b8ebe64, 0x143cbbb3, 0xc9c7ee1c, 0x8c09588b, 0xd4b65608, 0x72caa6f6, 0xb8d1245d, 0x595773f0, 0x2ded1b4f, 0xca914bd1, 0x07baacaa, 0x5e7f9e7e, 0x55d1b8e7, 0x64088134, 0x3643ba31, 0xd5e90640, 0xe668e6c1, 0x710b463c, 0x94b7b835, 0xe68a4814, 0x0e0350fb, 0x8446b5ec, 0x69689dd6, 0x9e6d4f6d, 0x91a9212e, 0x782e2e51, 0x62f9c3fa, 0x19e47497, 0x84449127, 0x973aefa6, 0x7b8bf7d9, 0x09bedaf7, 0x50ea4856, 0x7f1650f6, 0x51d320cd, 0x08347674, 0x98ecf70c, 0xe10c17d0, 0x667625b7, 0xb219fbe7, 0xaa110390, 0x43a5e2ba, 0x54345607, 0x0a163657, 0x6065ae1e, 0x8aea4e2b, 0x7b230f06, 0x3102b623, 0x96c07dc0, 0x6e67dbe9, 0x6bea832d, 0xe75be0d0, 0x6a20b6fe, 0xf2fcec99, 0x5a356966, 0xcec9ef85, 0xe2c99dde, 0x7acfb061, 0x686a6353, 0x32c99493, 0x123a2fc5, 0x1917ba58, 0xe923ce08, 0x5fd754c1, 0x14f9a61d, 0x7b9cf858, 0x4390012e, 0xb4edc187, 0xcb13565b, 0xff24db38, 0xa1aad96a, 0xeba0d921, 0x681799c0, 0xdb3d978f, 0xca4876db, 0xb7712235, 0xea3a5422, 0xfe06090f, 0xe8872e98, 0x7dc5c55f, 0x0506fee5 },        // Message 3
            { 0x093f43a2, 0xf4feaebb, 0xa4ff9bac, 0xa595ee13, 0xd9ea05de, 0x9f0f07d9, 0x2a388bc8, 0x5ccbceb8, 0x1d2f159d, 0x8b6b099b, 0x49079cf7, 0x15e1d719, 0xeb3b16d8, 0x991fa156, 0x77202852, 0x5a6aa09c, 0x6ece5167, 0x2dca9247, 0xf711676b, 0xe4e17a42, 0x637cd250, 0x72e37215, 0x8c71329b, 0xa8de914e, 0x7b992f7f, 0x87cecf0f, 0x56018c3c, 0x99fc23db, 0xbe8227b7, 0xe0c18d87, 0x0cadd6bb, 0xe4469f3e, 0xef5e3743, 0xd4a8f77a, 0x3dfad4e1, 0x3ee0c146, 0xad03950c, 0x67fb2c13, 0x4294b8a3, 0xb47b6aca, 0x8b64024e, 0x118155df, 0x45a3af51, 0xabcb4ea3, 0x40aff48e, 0x5d01b4da, 0xfc4efc96, 0xcc177b93, 0x4760f26d, 0x22bf3212, 0xf7fe1d7f, 0x3e9aed77, 0x20b3990d, 0x62db3a2c, 0x7add6bae, 0x2410862b, 0x6010fb01, 0x1b652e93, 0xbd425b6c, 0x04eb6be3, 0x378374c6, 0x42848bcf, 0x4e800ed8, 0x326e00b6, 0xadee6835, 0xe9bb4acf, 0xc1c29674, 0xabf3946f, 0xe671f16e, 0x37acd6e4, 0x4b81e5ab, 0x95d7678c, 0x825c467a, 0xca910b11, 0x014bc7f9, 0x0a46052d, 0x37477f28, 0x50ee7bab, 0x2ef0f801, 0x8bfa75ec, 0xf90b5638, 0xf99d8820, 0xb6d31e8b, 0x282fc07d, 0xc0ef8fb9, 0x6f1ecbfe, 0x46b81c35, 0x1bd261c4, 0xb8a9d6ad, 0x07faf944, 0xa8355992, 0xfd80d186, 0xa862af41, 0x33693558, 0x2c3f0101, 0xbd6c8dfa, 0x8b52a97f, 0xe6e3ccec, 0x9b2a8bf7, 0x5303dcd8, 0xa34dc51c, 0x4afdeeee, 0x1a215b9c, 0x1ea10f26, 0xfb336df6, 0x193d82be, 0x14527d5e, 0xc1b00c26, 0xdf2bbf11, 0x590bb058, 0x4bc72430, 0x6a63b278, 0xd0af7750, 0xbdc79dfd, 0xa2b769aa, 0x5abb8414, 0xf8c2a483, 0x4753ed6a, 0x42ecad25, 0xf3a26ffc, 0xbbd34144, 0xa9943ac4, 0x5c28f188, 0x48f93813, 0x7e3ee3cc, 0xac3867be, 0x418f64a6, 0x9ce60ad1 },        // Message 4
            { 0x006ec7a4, 0x6b436c1c, 0xcd88b3d9, 0x49fa2429, 0x57b856f0, 0x49e5224d, 0xe2500640, 0x626c742d, 0x50636081, 0xadb9da73, 0x0daf0c4b, 0xde46f82d, 0x2524776a, 0xd1d68688, 0x753efcd4, 0xb1a46b8e, 0x8ed5a073, 0xd565372b, 0xfbc9be0d, 0x061e71a3, 0x7d92e217, 0x429fa130, 0x11cb8fb6, 0x759fb7eb, 0x00af28a1, 0x95e6ea71, 0x70b01242, 0x74584e47, 0x77813ba1, 0x94916792, 0x66330a6e, 0xaff823bc, 0x983a26b1, 0x2644d903, 0x713bc925, 0xc53bc83c, 0x41030037, 0x034fa6c1, 0x458aaaeb, 0xe60ae620, 0x7200aa21, 0xb911d1dc, 0xcb8a2002, 0x1f45e425, 0x8ebd5383, 0x0696acea, 0xbb6ad80f, 0x5d2d97d5, 0xae465356, 0xa94a348f, 0x18a69075, 0xfefd4d04, 0x93d6a5a4, 0xb0732ac6, 0xe793abd6, 0x3296dd34, 0x423e8d92, 0x400396a5, 0x9bf1fdcd, 0x6979f56a, 0xcc1b8a98, 0x50e89001, 0x892a2442, 0xf63da520, 0x445544da, 0xe5e46e6b, 0x025de7bf, 0x6da7a068, 0xf330e75d, 0xa42dbb46, 0x1b10a594, 0xe40adaf7, 0x601ad459, 0x2f924364, 0x284c1cf8, 0x1788a504, 0x92969bdf, 0x0d3cac69, 0xfe5cba21, 0xb446e5fa, 0x4ec5061c, 0x48f5f465, 0xc9b1c4c8, 0x0e761a8d, 0x923f99bb, 0x74d29ad4, 0xc0dc01dc, 0xd0249d36, 0xd0173662, 0x1790e2dc, 0xfaa95adb, 0x5f070749, 0x5382fa53, 0x2dc8d9ea, 0x63ced49a, 0x9e05ea49, 0x37b3e6bb, 0xa40285ca, 0x3a95cf89, 0xcad5417b, 0xda4fd307, 0xdb3dc567, 0x4067b4e8, 0x2368f369, 0x3931e8f8, 0x73de690d, 0x69bd79c8, 0x977b34e5, 0x0a7bef10, 0x07c8539c, 0xebfa37ca, 0xfd880453, 0x2b632c0b, 0x7462c433, 0x6f3d6d51, 0x7d47f508, 0x8adaefc9, 0x72527319, 0x83bd7c62, 0xbad87380, 0xad75ae09, 0x77214b06, 0x998b6114, 0x1b09cbcf, 0xafe16db5, 0x662962eb, 0xe058c0e9, 0xbe2ab5a2 },        // Message 5
            { 0xb8ad1ce7, 0x2422434e, 0x002e5c8e, 0xb04efab6, 0x4be20e9d, 0x82b40f52, 0x5e43ad2c, 0x7ea4098d, 0x1ac89521, 0x8b2f7897, 0x731917c3, 0xf42c8546, 0xd15059a5, 0xada739b5, 0x2feee210, 0x54449bba, 0x4066c2eb, 0xd67d8c46, 0xf7f8945c, 0x42d296b6, 0x767a7d68, 0x74255858, 0x6d928587, 0x91b2ba12, 0x5bda731c, 0xfda3f6e8, 0x523b42de, 0xdf470728, 0x7dc3f631, 0x7c6b8bdd, 0xe020926b, 0x50e68ce8, 0x4b551b98, 0x8fac6588, 0xb4aa4b1a, 0xd6c0319f, 0xf13be7b6, 0xd50d4992, 0xd8149671, 0x70460538, 0xf87326cd, 0x4b7d94fc, 0x638bf2a2, 0x923ac827, 0x67b4ce0e, 0x264964fb, 0x3ee13282, 0x3daf8aa7, 0x6a19dc6c, 0xe09bec37, 0x60416938, 0x6e52a0e1, 0x40ccfc24, 0x3357ef24, 0xe28a22c6, 0x556ea264, 0xcd7aa476, 0x50134123, 0xae2770e4, 0x401e7513, 0x9c438bb0, 0xe2dae578, 0x13511b19, 0xfaa22929, 0x95a5308b, 0xaf4a79a8, 0x1f4f037b, 0xde130499, 0x7487df23, 0x30e56c54, 0x59a0e290, 0x3f5f4664, 0x7b66a36c, 0x1af4a553, 0xec8ede85, 0xaab9fd2b, 0xc3067946, 0x29ad1746, 0x2791e8fa, 0xb0fa4fc3, 0xc4942417, 0x1b160fc4, 0xef2704ce, 0xf2d3991d, 0xbdbffa36, 0xbcdad4ce, 0x64ebdfef, 0x420e3bce, 0xa92cf445, 0x716c64d3, 0x82d8e99b, 0xa20ab921, 0xa636e9eb, 0x36f5a6b3, 0xd6f3f15e, 0xbd9ccb73, 0x8b41b4cc, 0xa928de4d, 0x1f7bd428, 0xc32a116d, 0xa8bdf7bd, 0x12fa968d, 0x6839e646, 0x73d62e0b, 0x6d44d1ce, 0xa17b59c2, 0x62a03b4d, 0xee384e0f, 0x2367bf6b, 0x8f298fd1, 0x093da705, 0xb8d6014b, 0x24e06646, 0xde5c9b52, 0xd6dda865, 0xaafa8bb0, 0x73a01671, 0x0879ada1, 0xd47e73ba, 0x5e576002, 0x81ad2b85, 0x235252f4, 0xba7c0508, 0x80458f5c, 0x81f60a70, 0x85cc67a2, 0xdab85092, 0x74fad90a },        // Message 6
            { 0x6ef02f44, 0x90f2847f, 0xe1ea6cfc, 0x9d8eace4, 0x4e0b6a2a, 0x29ecd2bf, 0x0be1a6b9, 0x5f4bf1d3, 0xb8fd6892, 0x2ed469f9, 0x887c1b29, 0x2a2415f2, 0xffd7de3d, 0x3ce8cf41, 0xcaf7d174, 0xe07e8adf, 0xb8e316c0, 0x0fe7615b, 0x89c6e542, 0xd3f6b53b, 0x9dbeffe1, 0x88020c5a, 0x81719094, 0xec159883, 0x1ff56a85, 0xde85edc6, 0x17363063, 0xf26a30a7, 0xb32a7d8d, 0xbb059911, 0x7ef3f0b5, 0xd8bd011f, 0x70644486, 0xab26bad5, 0x30e05839, 0xd2622fa1, 0xfb532423, 0xed71dc7e, 0x023a4fd9, 0x521d6d1f, 0xddfe5e28, 0xe86e05dc, 0xc594715d, 0xb3514174, 0xa57f951c, 0x6e376f0c, 0x26797930, 0x2d85df4d, 0x838bd85d, 0x3d21fdb3, 0x60e690fa, 0xa5a9f380, 0xa2308e97, 0x8004f7b7, 0xf275bee9, 0x44a89ca5, 0x60465d28, 0xb5052c5b, 0x4207b6de, 0x27225e75, 0x701f138e, 0xaf988be8, 0x49c64860, 0xb986eeb9, 0xa7c541cb, 0xd407e21f, 0xffd6f0ec, 0x085e1ee4, 0x8ad02786, 0x6a0ae1d6, 0xad6108dd, 0x9b59b6af, 0x23645880, 0x7120371d, 0x8b74d7eb, 0xfca886b2, 0x3397f01c, 0x81bfb9d8, 0x2bac2c6d, 0x70827970, 0x4e1909eb, 0x5467c681, 0x60ac5277, 0x63ebc057, 0x27867d95, 0x369af5a3, 0x7ba39f37, 0x142ecea5, 0x210d31fb, 0x764f7dfe, 0xcc400756, 0xaefefbf7, 0x98034d5d, 0xa2b4ec45, 0x476b1aa2, 0xdaf9ed72, 0x0e82f193, 0x6328cf44, 0x16cdea45, 0xc1b7f2df, 0x60f6387f, 0x5a04ed03, 0xd1c310ef, 0x605ced1c, 0xbee5f10a, 0xce7bd1d8, 0x02edc7ab, 0xb9eea0d2, 0x026a75aa, 0x40606771, 0xe2e86d43, 0xd734b7b6, 0x9fbe7ea7, 0xb90b5bea, 0x1416c657, 0x05c66239, 0x88a7df2e, 0x69dfc5ea, 0xd746669d, 0x45e327b7, 0xb51a095d, 0xe1c3e974, 0x424b415b, 0x870377cf, 0x2e33faf5, 0x90486a3e, 0xf17dfb9e, 0x93c26889 },        // Message 7
            { 0x8a68b729, 0x026a3969, 0xd578c7f5, 0x6373922e, 0xed8c7c9b, 0xd2d6b1f9, 0x81b0783a, 0x7c0ad2ff, 0xf09ba017, 0x14a711e4, 0x5653cc61, 0x861b9620, 0x3a378e0f, 0xed2e762f, 0x9c7ff5f1, 0x9f695be6, 0x81912e63, 0x0213a187, 0x228f1c6a, 0xaa93e0f2, 0x2b7fa58e, 0x797e7581, 0xba18076e, 0xc399b9be, 0xda0ed74e, 0x45ca3985, 0xd8794f04, 0x169359e2, 0x06375fde, 0x688304a7, 0x060e2be8, 0xc44c24d0, 0x7ffa36cb, 0xaf9a9fe4, 0x610ea78d, 0xf1d3bb9c, 0x76bbb4d5, 0xab8695ed, 0x0002f61d, 0x82adf07c, 0x3a1d8f8c, 0xe9fdada3, 0xad061847, 0xa8c50e99, 0x6534f8de, 0xd15832e2, 0x7b612734, 0x0e6f3262, 0x45ada93f, 0x5e818644, 0x193aa36d, 0x0447072c, 0xd43b8f1a, 0xfd0a4c9d, 0x5e8a0b45, 0x69698ea5, 0xe1fa65da, 0xdc85f4bf, 0x13db7e62, 0x29f7bff1, 0x3a9ac10b, 0xe13f8f37, 0x10fc1e75, 0xc9fa9a85, 0x37f8a27d, 0x09d7bed4, 0x9f6afe59, 0xcf7cde23, 0x726acc86, 0xe39ea1d9, 0x37c04b7b, 0x687d54ad, 0x1f7b0108, 0x6f0bafc1, 0x76c265c8, 0x349749bc, 0xd9c6bf2e, 0x6928ac83, 0x99d23dfa, 0x39bf238e, 0x24ddfc92, 0xc09110c0, 0x356acd40, 0x02fc0d80, 0x44866f39, 0xb28e3688, 0xdf7d8322, 0xf81a3e89, 0xc4669e99, 0xbc9a122e, 0x267a6775, 0xc989c0de, 0xafe1b702, 0xd1c66122, 0xbd73efaf, 0x67a75f0d, 0xf1cf31d2, 0x3f9a40ec, 0x8e7aebc6, 0x23e8f608, 0xa8181f2f, 0xc2115be2, 0x587b5804, 0xe8d011d7, 0xf5c1ced7, 0xb61fd3ae, 0xa77d72cc, 0xe64984a4, 0xe1d042b8, 0x831a3078, 0x5108924f, 0x81051916, 0x957ddb26, 0xa1885509, 0x5ed27bc9, 0xebfd14b0, 0x833d0226, 0xc6fea3fd, 0x80f008c8, 0x9accfd12, 0xb50eda4b, 0xc07c0fc7, 0x069d0e67, 0xdb854278, 0x755bbb3a, 0xacca6539, 0x0d5f6cd7, 0xafeb0b9d },        // Message 8
            { 0x2ea4f637, 0xe45c1cbd, 0x43ced540, 0xd4746821, 0xc385436c, 0xbd0d44e5, 0x8bcdb071, 0xe0835959, 0xbeccae1a, 0xb0ea178e, 0x5dd5e007, 0xc7f562ca, 0x349f3403, 0xfbaf7899, 0xf982648a, 0x09e6cd77, 0x09c49969, 0x31c9205f, 0x3faba5bb, 0x34247ec6, 0x0221697c, 0xd1bf1146, 0x7483466c, 0x58c97486, 0x35d1122d, 0xb4a7fd92, 0xb640e5ec, 0x8fc6cad2, 0x190deeb1, 0x610965cd, 0x0c44de9a, 0x46fa02cf, 0x68822f88, 0x6b72419d, 0xe01ac941, 0x3235f83a, 0x2e51f76b, 0x1d6e02aa, 0xc1874f7f, 0x78c64f41, 0xb18848ea, 0x8160ce86, 0xa10d385e, 0xfd056a9a, 0xaee90273, 0x45fc9472, 0x56313971, 0x199feabb, 0x152fed05, 0x91bd0ff5, 0x4b7ea26c, 0x135d97ba, 0x73a654c5, 0x67cdbdf1, 0x47c97458, 0x42a5d49b, 0x7283721a, 0x09046fbd, 0xa89e6c6e, 0x2c2db237, 0x7131b5b9, 0x8b4f5c7b, 0x59d30988, 0x30c57e4b, 0xaa3ccf45, 0x3a529b7c, 0x0c86c06d, 0x45010094, 0xdb8195b2, 0x709799c4, 0xb12bad7f, 0xb5034a0c, 0x75c86e27, 0x5857fdea, 0x65c65a87, 0x35379c05, 0x1bd8fcc2, 0x0c59dc01, 0x5e526342, 0xf32dcab9, 0x7dce0ef4, 0x4de8d2bf, 0xec720510, 0x3a77b1a9, 0xb59012f4, 0x82da2181, 0x3db38cc9, 0xedeb50f1, 0xf1084b14, 0xe97066c3, 0x59c6a72b, 0x8fc0b407, 0xd354671e, 0x334cb14e, 0x4eb44832, 0xb313d279, 0x59681b52, 0x261ecb17, 0x294c6cc4, 0x0e732870, 0x51c30bae, 0x64879f27, 0x17159b88, 0x6a4fe96a, 0xf1d34a95, 0x334ee983, 0xce9020aa, 0x8c8e9fdc, 0xe2d13a4d, 0xa6a8a7d4, 0x128e24b5, 0x7d462d5e, 0xcb549308, 0x5a6b8387, 0x08f66cbb, 0xfe4c3033, 0x2b322d80, 0x01083438, 0x80eb4a33, 0x60079be4, 0x09b63391, 0x6fce76a8, 0x4c9f9847, 0x1b929f41, 0xcf288859, 0x7c98aef6, 0x152f7494, 0x935a0b32 },        // Message 9
            { 0x47dac6bd, 0xd9e3cffd, 0x42f02d93, 0x0422522d, 0x56e8d2fe, 0x84f74937, 0xd1547e9e, 0x954ff74f, 0xcc81da04, 0x8233b92c, 0xf1bf11b1, 0x9536268e, 0x4248a0e4, 0x3a73c38c, 0x566a23bd, 0x442c2d5d, 0xf1fc5043, 0xf0767982, 0x935d6a9c, 0xa5340e20, 0x34444f72, 0xf58f7de1, 0xf01cd0d5, 0x2f616b48, 0xe3da3bd0, 0x45585073, 0x6c051a90, 0x79d66b6f, 0x83d06e1f, 0x786316df, 0xbb9e345c, 0x0b3581ac, 0x0029e47d, 0xd7093a97, 0xaabb92de, 0x3ee942fa, 0x6d4f2034, 0x29ac599b, 0xf5da090d, 0x6014f0fc, 0xbfc30034, 0xddcbe0d1, 0x7615b11f, 0x9a535f52, 0x2237e600, 0xf23b5a2d, 0x811405df, 0xc962e4b1, 0x64fd1ecd, 0x639e1e54, 0xdbce2917, 0xba3fc5e9, 0x4b204d48, 0x3213cbad, 0x12e93c47, 0x358f9623, 0x68b1a2e1, 0x0b1d0312, 0x9d56ce6e, 0xb78d6713, 0xa2e50f00, 0xce26b76c, 0x32aa021f, 0x97cba5ba, 0x71e8e671, 0x8b202722, 0x739ee32e, 0xdd6fba73, 0xbbabcda7, 0x724c0ef2, 0xeeeb061a, 0xf76f0af6, 0x06beb624, 0xce5d85df, 0x9b5cc7fa, 0xe8dffce6, 0xbe7caba4, 0xbca5e8c7, 0xf3eb7747, 0xd711b5db, 0xbbc1a52a, 0xcc007d76, 0x42f5871d, 0x5179d613, 0x45680df4, 0xbd1222d7, 0x0fee6947, 0x766e322d, 0xd8308036, 0x23697905, 0x2b1f21cf, 0x9411dda9, 0x7cbda1ea, 0xfa3cc4e5, 0xeb46fa2c, 0x2cc3696c, 0xe43fa80a, 0xf2273467, 0xef277111, 0x65c7ada2, 0xdf598dce, 0xa913632f, 0x927f36b7, 0xcbeb0304, 0x660b5f58, 0xf1e41df3, 0xfa836f55, 0x002f594e, 0x4ad64d96, 0xac9d4350, 0xda3a268c, 0x9904ca9c, 0x2ae5d591, 0x81fe5fa5, 0x05484993, 0xab009e04, 0x5c5be551, 0x9fef0958, 0xc83f41c5, 0x8e174480, 0xa6ba244f, 0xf32dd56c, 0x3769432a, 0x54f79959, 0x9797d41b, 0x749445bd, 0x5c5eaf4c, 0x8f2737c2 },
        },
    },
    { /* Case 5 */
        .iv = { 0xdf, 0xb2, 0x78, 0x21, 0xb1, 0x68, 0x58, 0x7c, 0x12, 0xfb, 0xff, 0x62, 0x6e, 0x20, 0x24, 0x69 },
        .p_data = {
            .Y = { 0xd5794891, 0xb68b5e18, 0xebec99a1, 0xbf0eaffa, 0x82fb145b, 0x53b67e97, 0xca2af164, 0xf6fc0fdd, 0x89775af0, 0x5ca53026, 0xc83532bf, 0xf6d537c8, 0x2521a241, 0x690dc307, 0x096527d4, 0x11cff318, 0x3aaef396, 0x9b72167a, 0x7b09bb8d, 0x222c63a8, 0xfcfa604f, 0x37b8f945, 0x01e26530, 0x82a5f636, 0x40091709, 0x93a71631, 0x1d734f5f, 0x6e8d63f6, 0x0f2ea5e6, 0x6147002a, 0x98c68b4c, 0xdf41652d, 0x2e0f9ef8, 0xcd9dd301, 0xc4557b4b, 0xa65f4974, 0x3b372bb6, 0x6ebbcaa9, 0x76d03a88, 0xbebd9567, 0x4906a66e, 0x46048851, 0xa2d3a9ca, 0xd0d21252, 0xf160a68e, 0xb04033c3, 0xff5f604e, 0x8cb75bb7, 0x792c56f4, 0x7417bb62, 0x98970766, 0x77c98ccc, 0x67c90d67, 0xd8748fc5, 0xb5d4775f, 0x99fe9fa7, 0xc831c7e4, 0x044285b4, 0x8c408842, 0xc1c633e1, 0x510c923c, 0x109507bd, 0x56a9a538, 0x04f1ea20, 0x8874b19a, 0xd8c74347, 0x1ae1f91e, 0x10549f2b, 0x042cfa07, 0x03e97592, 0xf8f71fdd, 0x65c551d5, 0x30db14c7, 0x6ee9b500, 0x5fc41c94, 0x6f0c8b10, 0x085e28c6, 0x1e4761e6, 0x124f872a, 0x903e1ee4, 0x0f18d538, 0xfe63be2d, 0x68bcafb3, 0xb0d6d58d, 0x4a87c27f, 0xf2a9e73d, 0x6e90b824, 0x925a2cf4, 0x5946dfd7, 0x163f7cfc, 0x28b8310a, 0x20ff871a, 0x407d16a4, 0x131f2320, 0xabeab811, 0x4ce5a78c },
            .M = { 0x091526ab, 0xe66c20e6, 0xa407eec4, 0xa4b83d5b, 0x41b9798b, 0x8cca59c7, 0xde5efafc, 0xda2d2d63, 0x67ef0c73, 0x22bf5326, 0x4ffc07de, 0xa5c7fcee, 0x09bc0ca4, 0x626c1380, 0xd1d11c62, 0xfc36c50b, 0x21171467, 0x5cd50acb, 0x7d50e0a7, 0xe044be0a, 0x68b496f0, 0x6be2fde9, 0x1c78c1db, 0x9350c66a, 0x8622aeb6, 0xc5b1d6bf, 0xc561fa88, 0xf8353cfd, 0x75111f90, 0xddf02468, 0x6809fc90, 0x7307eb2a, 0x15869909, 0x6f15772c, 0xe99abc75, 0x73038a7f, 0xe5080ef9, 0x4aa3fb7d, 0xb0376031, 0xe45d8c87, 0xd34419b0, 0xd244e981, 0xc0b10c57, 0x9da7aa2b, 0x22987887, 0x0d4d6c56, 0x69bd5495, 0xba8b5a8e, 0x703dcfa1, 0x69fb3135, 0xc178a9c7, 0x68e6cf8a, 0x67f79a7f, 0x3a117b80, 0x0f66a427, 0x67482015, 0x9e2060e1, 0x4cae4f11, 0x6620ae87, 0x5967e7c0, 0xc0031bc5, 0x605ac11d, 0x0f661d68, 0x155d1eeb, 0xf8b6b812, 0xdb556d2a, 0x56944549, 0x62530a6c, 0x49c877a6, 0xd9e2e1e9, 0x58100f11, 0x9a0502ed, 0xf19074fc, 0xa91fd513, 0x774284fe, 0xec788699, 0x4f03a6b4, 0x708c2ef8, 0xea39caa3, 0x9862effb, 0x62071c53, 0xc2ec8254, 0xf56a3286, 0x6087a3c1, 0x51fd789d, 0xae7fedfa, 0x0fa2ac93, 0x65d8be1c, 0x9bbe3b82, 0x2cb2d8dd, 0x4558f759, 0x533ec2b0, 0xfeb0e75f, 0x89a222b7, 0xd42fcef3, 0xd2146e1c },
            .Rb = { 0x3a6e0569, 0x53ec2cce, 0x2bd39843, 0x98254283, 0x05e3668e, 0x9c5a1b2a, 0x60901117, 0x07679a5e, 0x5a6eaca8, 0xc3b567b4, 0xbbd49487, 0x514e0303, 0xcc9f1968, 0x67c50804, 0x17c27d5e, 0x3248e594, 0xc4c1b388, 0xaf52507f, 0x4944a08b, 0x6ad65fbb, 0x3997f29d, 0xb12e8e96, 0x03f70c1f, 0xed308182, 0x8fd40dd5, 0x7ecea683, 0x58ccf705, 0xea36830a, 0x91db6f0e, 0x523e5651, 0xe3da6a6c, 0xf88ce3da, 0x38dd4fa6, 0x9d19a220, 0x33ef16b9, 0x22bb1cf8, 0x7e5d6853, 0x8981be47, 0x30122101, 0xc17a23b9, 0xbe0c6e00, 0x3aa26e03, 0x7df423b8, 0x2c27ba91, 0xdb7697da, 0x0bb868cd, 0xcc4f7d61, 0x8c9eea14, 0xeeacfe04, 0xfaf41d9e, 0x2e1e1375, 0x8cc69ce5, 0xe05d228a, 0x9dd5fedc, 0x2ab39a8d, 0xf2b283c7, 0x5ccf2559, 0x46fd2024, 0x67eecb62, 0x7ba5077d, 0xebaffd8b, 0xc9ea5892, 0xc13b3f6c, 0x1c1dc815, 0x49e19057, 0x2d5e70d4, 0x7d106a9e, 0xee4d6a21, 0xb1ed4e48, 0xb9d24508, 0xc8225da0, 0xd08f1472, 0x25f576bc, 0x80412ddc, 0x02669c45, 0x21e626e8, 0x2c438963, 0xf36cda28, 0xad9eec09, 0xd11eaf93, 0x2595e7c2, 0x23a2650b, 0xbdd6c840, 0xeb8b0f01, 0x7b14d4cb, 0xc841f7b5, 0x52f14bbf, 0xd5c9c34b, 0x258a15c4, 0xa9aaaccd, 0xab7dfc58, 0x45cd8518, 0x85155c51, 0x54d72cd7, 0xa481ff52, 0x245bee5c },
            .M_prime = 0x2c0e5bfd,
            .length = 95, // 3072 bit
        },
        .expected_c = { 0x04, 0x79, 0xb3, 0xfb, 0x4b, 0x3d, 0x54, 0x06, 0xbe, 0xb6, 0x89, 0xfa, 0x63, 0x35, 0xa8, 0x8c, 0x65, 0xca, 0x4b, 0x3a, 0xfe, 0xc2, 0xea, 0x2d, 0x2c, 0x0d, 0x7d, 0x09, 0x7a, 0xff, 0xe4, 0x7e, 0x9c, 0xaf, 0x9e, 0x77, 0xd3, 0xf4, 0x5c, 0x73, 0xe9, 0xc5, 0x24, 0x93, 0x38, 0x17, 0xe6, 0xfd, 0x4e, 0x30, 0xc3, 0xf7, 0x25, 0xbe, 0x03, 0xeb, 0x4e, 0xa9, 0x6a, 0x9c, 0xb6, 0x09, 0x7d, 0xad, 0x79, 0xb0, 0x52, 0x73, 0x4e, 0xcb, 0xaa, 0x22, 0x01, 0x1a, 0xab, 0x5e, 0xa7, 0x96, 0x07, 0x67, 0xcb, 0xa1, 0xf4, 0x29, 0x8d, 0xbb, 0xe4, 0x0e, 0x98, 0xe3, 0x56, 0x20, 0xb5, 0x63, 0x10, 0x29, 0xf2, 0xa0, 0x12, 0x3d, 0xd0, 0xf4, 0x30, 0x62, 0xef, 0xcd, 0x4f, 0x0c, 0xbb, 0xe1, 0xbd, 0x53, 0x4e, 0x1b, 0xf5, 0x64, 0x1d, 0xc4, 0x43, 0x93, 0x22, 0x1a, 0xdc, 0x5d, 0xfd, 0x54, 0x70, 0x16, 0x29, 0x85, 0x19, 0xe0, 0xe4, 0x6b, 0x24, 0x12, 0x57, 0xe5, 0x88, 0x66, 0x2f, 0x12, 0x06, 0x8b, 0x8f, 0x95, 0xc6, 0xa1, 0x29, 0x36, 0xd3, 0xe9, 0x70, 0xca, 0x16, 0xa1, 0x49, 0xe2, 0x47, 0x37, 0xb7, 0xff, 0x15, 0x88, 0xd6, 0xc8, 0x0a, 0x0f, 0xe0, 0x21, 0xa2, 0xf6, 0x9e, 0x47, 0x57, 0x4b, 0xdc, 0x2c, 0xf8, 0xd6, 0x2e, 0xda, 0xd5, 0x85, 0xc3, 0xd6, 0xc4, 0xd1, 0x6d, 0x2c, 0x40, 0x5a, 0xd2, 0x91, 0xc7, 0x93, 0xf0, 0xca, 0x26, 0xc0, 0xb3, 0xeb, 0x20, 0x76, 0x3e, 0x5f, 0x09, 0x98, 0x89, 0xce, 0x2e, 0xb5, 0xa2, 0x0f, 0x6e, 0x6d, 0xd7, 0x69, 0xbc, 0x92, 0x18, 0x0c, 0x9c, 0xb1, 0xdd, 0x4b, 0xc8, 0x14, 0x03, 0x29, 0xbd, 0x14, 0x6c, 0xe3, 0x8b, 0xae, 0x4b, 0x8e, 0xd2, 0xc8, 0x54, 0xb2, 0xdd, 0xb0, 0x44, 0x0a, 0xa5, 0x62, 0xbc, 0x5b, 0x56, 0x2a, 0xea, 0xb8, 0xd7, 0x68, 0x49, 0x2a, 0x3f, 0x56, 0xab, 0xfd, 0xea, 0x7a, 0x60, 0xbe, 0x21, 0xdc, 0x94, 0x8f, 0xf0, 0xb1, 0x90, 0x24, 0xc3, 0x96, 0x6e, 0x46, 0xcb, 0x15, 0xc9, 0xc4, 0x7e, 0x65, 0xf8, 0xf3, 0xbd, 0x65, 0x12, 0x10, 0x67, 0x5a, 0xab, 0xc0, 0x2f, 0x7b, 0xc4, 0x0b, 0x85, 0x34, 0x3a, 0x89, 0x5c, 0x7f, 0x3b, 0x57, 0x59, 0xfb, 0x28, 0x80, 0xb1, 0x57, 0x22, 0x31, 0x38, 0x36, 0xe5, 0xb5, 0x55, 0xce, 0x48, 0x3f, 0xaa, 0x9d, 0xa1, 0x78, 0xd4, 0xb8, 0xbf, 0xad, 0xf9, 0x7e, 0x02, 0x8e, 0x74, 0x7e, 0x31, 0xe1, 0x73, 0x03, 0x01, 0x5e, 0xf2, 0xc4, 0x01, 0xf1, 0xac, 0x5d, 0x82, 0xdf, 0x2d, 0x74, 0xa5, 0x4b, 0x77, 0x0c, 0x42, 0x80, 0x5f, 0xc2, 0x07, 0xcd, 0x1b, 0x0d, 0x91, 0xb7, 0x4c, 0xd2, 0x63, 0x3f, 0xf6, 0x16, 0xa3, 0xaa, 0x70, 0x3e, 0xbd, 0xe9, 0xa7, 0xb7, 0xc2, 0xca, 0x96, 0x5b, 0x78, 0xf0, 0xb6, 0xa0, 0x9f, 0x1f, 0x07, 0xca, 0x09, 0xa2, 0x42, 0x37, 0xe3, 0xd7, 0xbf, 0x18, 0x03, 0xf1, 0x23, 0xcb, 0x6e, 0x9c, 0x06, 0x3c, 0xee, 0x48, 0x3e, 0xc0, 0x65, 0x01, 0x5f, 0x8e, 0xd9, 0x82, 0x84, 0x8d, 0x13, 0xe5, 0x7b, 0x18, 0x4b, 0xb8, 0xa1, 0x23, 0xff, 0x60, 0xc7, 0x46, 0x9b, 0x9d, 0xf3, 0x8e, 0xc0, 0xa4, 0xf3, 0xae, 0xe1, 0x1d, 0xc4, 0x89, 0x8d, 0x7f, 0x9a, 0x0e, 0xad, 0x8e, 0x65, 0xc9, 0x0a, 0xda, 0xdb, 0x3b, 0xab, 0x0e, 0xcf, 0x68, 0x61, 0xa2, 0xbf, 0xda, 0xb4, 0x2e, 0xab, 0xcc, 0x1e, 0xbe, 0xc3, 0xc3, 0xf7, 0xde, 0xf1, 0xd3, 0x4a, 0x2c, 0x9d, 0x5a, 0x3b, 0xa9, 0x87, 0xd9, 0x5b, 0x84, 0xe1, 0xa7, 0xae, 0x44, 0xbf, 0xbf, 0xc8, 0xe1, 0x7a, 0x9e, 0xcc, 0x35, 0xa4, 0x38, 0x0f, 0xa9, 0xbc, 0x5c, 0xb8, 0x5b, 0x3c, 0x2a, 0x60, 0x77, 0x4e, 0x02, 0x9c, 0xb1, 0x07, 0x05, 0x45, 0x79, 0x58, 0x36, 0xc6, 0x53, 0xf6, 0xe9, 0xe2, 0x1c, 0x42, 0xf7, 0x1d, 0x00, 0xe4, 0x58, 0x03, 0x1b, 0x8a, 0xbe, 0xf1, 0x5e, 0x9a, 0x7f, 0xb0, 0x49, 0xcf, 0x37, 0x14, 0xf4, 0xf2, 0x8a, 0x24, 0xde, 0xbf, 0xe3, 0x3b, 0xda, 0x48, 0x1f, 0x6f, 0x2c, 0xcd, 0x96, 0xbe, 0xbd, 0xcd, 0xf4, 0x56, 0x13, 0x44, 0xab, 0x83, 0x32, 0x2c, 0x7d, 0xa7, 0x26, 0x3b, 0x54, 0xc2, 0x14, 0x54, 0x10, 0xd7, 0x4d, 0x81, 0x69, 0x92, 0xd0, 0xa1, 0x57, 0x10, 0x75, 0x42, 0x43, 0x3b, 0x08, 0x34, 0xad, 0xc6, 0xf6, 0xc9, 0xad, 0xe9, 0xbd, 0x91, 0xe2, 0x39, 0x03, 0x36, 0xcf, 0xf7, 0x75, 0xc8, 0xac, 0x2f, 0xc6, 0x72, 0xfe, 0x44, 0xad, 0x4d, 0x38, 0x3e, 0xa3, 0x5d, 0x08, 0xba, 0x2e, 0x1f, 0xe5, 0x9b, 0xae, 0x45, 0x1c, 0xa3, 0x7d, 0xb7, 0xb8, 0x15, 0x2e, 0xe3, 0xd2, 0x24, 0xa4, 0xf9, 0x43, 0x3a, 0x92, 0xbd, 0x5c, 0x1a, 0xca, 0xc7, 0x21, 0x66, 0x8a, 0x4c, 0x64, 0x09, 0xe8, 0xc5, 0xde, 0x5a, 0xbd, 0x85, 0x00, 0x07, 0x6c, 0x50, 0x4e, 0x38, 0x38, 0x64, 0x5f, 0x99, 0xe9, 0x5f, 0x74, 0xa5, 0xa2, 0x81, 0xd7, 0xdd, 0xb8, 0x4f, 0x63, 0x2e, 0xe6, 0xae, 0x39, 0xf4, 0xf4, 0x0d, 0xbe, 0xc9, 0xa6, 0x2e, 0x8e, 0x9b, 0xc1, 0x51, 0xe1, 0x09, 0x1d, 0x63, 0xf9, 0x3e, 0xee, 0xf7, 0xe6, 0x4f, 0xa9, 0xd8, 0x1c, 0xed, 0x39, 0x36, 0xbb, 0x58, 0x27, 0xf6, 0x57, 0x3f, 0x53, 0x1f, 0x6e, 0x67, 0x20, 0x65, 0xb6, 0x5d, 0x89, 0x4f, 0xaf, 0x46, 0xf5, 0xd6, 0xdf, 0x2d, 0x57, 0x79, 0xc8, 0x9c, 0x61, 0xa2, 0xfd, 0x08, 0x37, 0x8e, 0x81, 0xe7, 0x62, 0x48, 0xb0, 0x69, 0xd8, 0x21, 0xec, 0x28, 0x8a, 0x25, 0xe7, 0x35, 0xb4, 0xdb, 0xe3, 0x33, 0xb0, 0x43, 0xce, 0x2b, 0x5c, 0xdb, 0x01, 0xf9, 0x38, 0x68, 0x80, 0x62, 0xe8, 0x1b, 0xf4, 0x2b, 0xd9, 0xd7, 0xa3, 0xd2, 0xeb, 0x95, 0x77, 0x52, 0xf7, 0xe4, 0xa8, 0x27, 0x5a, 0xfd, 0x89, 0x4b, 0x07, 0x3e, 0x6f, 0x24, 0xd3, 0x48, 0xdf, 0xe5, 0x98, 0xa7, 0x33, 0xf9, 0x9a, 0x17, 0x35, 0xb3, 0x93, 0x7f, 0xeb, 0xae, 0x3f, 0x96, 0x14, 0xb6, 0xfb, 0x92, 0x1c, 0x0c, 0x99, 0x61, 0xee, 0x75, 0xf5, 0xad, 0xe1, 0xea, 0x01, 0xf1, 0x63, 0x58, 0x38, 0x10, 0x51, 0x62, 0x7b, 0x19, 0x8f, 0x10, 0x90, 0x45, 0x91, 0x08, 0xa1, 0x46, 0x02, 0xe7, 0x94, 0xdb, 0xb9, 0x18, 0x26, 0x3f, 0x55, 0x6b, 0xa5, 0xc4, 0xf0, 0xa9, 0x45, 0x93, 0x1c, 0x6e, 0xc8, 0x6f, 0x2c, 0x0f, 0x42, 0x11, 0xa8, 0xb0, 0x4f, 0xe8, 0x54, 0x4c, 0xa7, 0x53, 0xfb, 0x67, 0x8f, 0x3f, 0x65, 0x8e, 0x7b, 0xe0, 0x92, 0x1c, 0x04, 0xab, 0x13, 0x22, 0xf2, 0x9d, 0x9b, 0xe0, 0x32, 0x31, 0x95, 0x5d, 0x21, 0x06, 0x1d, 0x66, 0xfc, 0x77, 0x27, 0xbe, 0x50, 0xd1, 0x8f, 0xc4, 0x7b, 0x00, 0xe8, 0x0c, 0x88, 0x6a, 0x59, 0xfa, 0xac, 0x2f, 0xeb, 0x4d, 0x0c, 0xab, 0x96, 0xb6, 0x44, 0x2c, 0xdf, 0xf8, 0x1d, 0xe8, 0xfe, 0x03, 0xbc, 0x21, 0x69, 0xdd, 0xd6, 0xf3, 0xcc, 0xb0, 0x58, 0x95, 0x10, 0x0e, 0x09, 0x6c, 0x77, 0x25, 0x89, 0xc5, 0x15, 0x32, 0x2a, 0x83, 0x27, 0x1d, 0x33, 0x2d, 0x9e, 0x2a, 0xc8, 0xd5, 0x80, 0x06, 0xc4, 0x34, 0xf7, 0xd0, 0xff, 0x9a, 0x60, 0xd2, 0x4c, 0xb3, 0x81, 0x6b, 0x10, 0x15, 0x4e, 0xde, 0x28, 0xca, 0x4a, 0xb9, 0x1d, 0xcd, 0x60, 0x5e, 0x1a, 0x7f, 0x89, 0x78, 0x5f, 0x19, 0x57, 0x74, 0x7d, 0xba, 0x74, 0x0b, 0xb0, 0x07, 0x63, 0xdc, 0x3b, 0x3f, 0xa5, 0xa6, 0x70, 0x64, 0x00, 0x85, 0xb3, 0x03, 0x76, 0x7f, 0xfd, 0x6c, 0x3b, 0x84, 0x3d, 0xe5, 0xfc, 0x93, 0xf1, 0x3f, 0x03, 0x9c, 0x6e, 0x14, 0x6b, 0xc8, 0xa4, 0x44, 0x7f, 0xf0, 0x75, 0x0f, 0x74, 0x00, 0x3f, 0x51, 0x02, 0xb3, 0x0f, 0x26, 0x2b, 0xb6, 0x63, 0xfd, 0xbe, 0x9a, 0xc8, 0xdc, 0x66, 0x81, 0x44, 0xdb, 0xa7, 0xb2, 0x74, 0x2a, 0x2a, 0xe0, 0xb3, 0xdf, 0xc0, 0xe5, 0xab, 0xa7, 0x21, 0x35, 0x4d, 0x4a, 0x45, 0xb3, 0x9b, 0xb0, 0xdd, 0x13, 0x37, 0xf2, 0x01, 0x3d, 0x0c, 0xfc, 0xd9, 0x76, 0xb0, 0x29, 0x8d, 0x32, 0x05, 0xee, 0xa6, 0x69, 0xc0, 0xa2, 0x54, 0xa4, 0xd4, 0x95, 0x1c, 0x97, 0xd1, 0x13, 0xd3, 0xcf, 0x42, 0x60, 0x86, 0xed, 0x3b, 0x0e, 0xcc, 0x51, 0xdd, 0xf2, 0x97, 0xde, 0x6f, 0x2c, 0xd1, 0x6c, 0x28, 0x47, 0xd1, 0xa8, 0x66, 0xd0, 0x66, 0xc4, 0xea, 0x22, 0x29, 0x54, 0x2f, 0xd1, 0x0e, 0xf6, 0x70, 0xcb, 0x56, 0xf7, 0xd9, 0xd7, 0x0d, 0x92, 0xcb, 0xdd, 0xcf, 0xc5, 0xce, 0x9b, 0xf2, 0x48, 0xb6, 0xca, 0x4c, 0x22, 0x22, 0xc0, 0x7b, 0x2b, 0x79, 0x36, 0x4d, 0xb3, 0xce, 0xa5, 0x25, 0xf8, 0x1c, 0x0b, 0x4f, 0xe5, 0x27, 0x16, 0x2e, 0x17, 0xa5, 0xc5, 0x02, 0xb5, 0x45, 0x7e, 0x2b, 0xe4, 0xb1, 0x0b, 0x45, 0x38, 0x69, 0x44, 0x90, 0xc8, 0x5e, 0x28, 0x54, 0xa2, 0xf0, 0x4d, 0xaf, 0x9d, 0x61, 0xad, 0x8f, 0xf4, 0x10, 0xea, 0xf1, 0x3c, 0x4f, 0x6c, 0xe0, 0xb6, 0xfe, 0x6c, 0x6b, 0x4a, 0x04, 0xae, 0xf0, 0x25, 0x10, 0x24, 0xf9, 0x53, 0x9e, 0xe9, 0xfc, 0xb8, 0xf7, 0xf6, 0x4d, 0xe3, 0x68, 0x0f, 0x7d, 0x91, 0x60, 0x2e, 0x2b, 0x6f, 0xca, 0x5b, 0x7f, 0x5a, 0x26, 0x75, 0x56, 0xbf, 0x0a, 0xfa, 0x22, 0x84, 0xd2, 0xe7, 0x3d, 0xbe, 0x6a, 0x86, 0x05, 0x5d, 0x05, 0xc1, 0xea, 0xc5, 0x08, 0x98, 0x50, 0x80, 0x36, 0x74, 0xff, 0x0d, 0x2d, 0x04, 0x2d, 0xe6, 0xc7, 0x54, 0x71, 0x72, 0xca, 0xed, 0x98, 0x00, 0xd8, 0xa3, 0xff, 0x5e, 0x48, 0x1b, 0xcd, 0xbb, 0xbd, 0xa6, 0x12, 0x54, 0xd5, 0xdf, 0x65, 0x23, 0xfe, 0x13, 0x11, 0xbf, 0xc7, 0x97, 0xac, 0xed, 0x56, 0x94, 0xf7, 0x4c, 0xb8, 0xf5, 0x52, 0xe4, 0x12, 0x6a, 0x44, 0xa3, 0xa7, 0x91, 0x34, 0x71, 0xec, 0x20, 0x28, 0xb3, 0xe1, 0xed, 0x8e, 0xf9, 0xfa, 0x40, 0xa3, 0x19, 0x2b, 0x3d, 0x91, 0x24, 0x56, 0xa3, 0x59, 0xa5, 0x77, 0x99, 0x84, 0xf1, 0x9e, 0xfb, 0xa0, 0xdc, 0x7a, 0x9e, 0x0b, 0xcd, 0x2a, 0x7a, 0xe8, 0xee, 0xf8, 0x72, 0xf6, 0x40, 0x1e, 0x03, 0x48, 0x97, 0x55, 0xbc, 0x2e, 0x9b, 0xf6, 0x70, 0x69, 0xb4, 0xe3, 0x4a, 0xc4, 0x22, 0x75, 0xfa, 0x71, 0x21, 0x4a, 0x9d, 0x1e, 0x82, 0x28, 0xb8, 0x71, 0xaa, 0x6a, 0xdb, 0x04, 0x22, 0x74, 0x43, 0x2d, 0x54, 0xa9, 0xff, 0x93, 0x0a, 0x55, 0x85, 0xf8, 0x76, 0xeb, 0x0b, 0x16, 0xfc, 0xc4, 0x10, 0x0c, 0x1a, 0x4b, 0x77, 0xf2, 0x4d, 0x0a, 0x82, 0x30, 0x83, 0x80, 0x11, 0x1b, 0x5f, 0xc5, 0x5f, 0x54, 0xd1, 0xed, 0xa4, 0x17, 0x99, 0xfe, 0x39, 0x9d, 0x09, 0x5e, 0x6b, 0x35, 0xcc, 0x13, 0x80, 0xd7, 0x8f, 0x3b, 0xd0, 0xcf, 0x35, 0x00, 0xe7, 0xbb, 0xed, 0x0e, 0x70, 0x63, 0x32, 0xe8, 0x16, 0xba, 0x10, 0x78, 0x70, 0x07, 0x96, 0x1d, 0x9e, 0xf4, 0x38, 0x3f, 0xdc, 0x7b, 0x9c, 0x78, 0xd7, 0xb7, 0x82, 0x63, 0x98, 0xfb, 0xd5, 0x77, 0x76, 0x90, 0xdb, 0xfa, 0xeb, 0x61, 0x0c, 0xba, 0x94, 0x7b, 0x35, 0xbf, 0x43, 0x42, 0xc1, 0x97, 0xaf, 0xd4, 0xfb, 0xe2, 0x99, 0x71, 0x96, 0xf3, 0x07, 0x05, 0xa5, 0x58, 0xf1, 0xbe, 0x83, 0xf5, 0x6d, 0x16, 0xcd, 0x96, 0xdb, 0xae, 0x21, 0x8e, 0xfe, 0xa1, 0x0a, 0x02, 0xa1, 0xd7, 0xd6, 0x4d, 0xcd, 0x2c, 0xab, 0x5d, 0xad, 0x03, 0x25, 0xed, 0xc5, 0x8b, 0xd5, 0xff, 0xcf, 0x14, 0x8a, 0xcc, 0xb7, 0x60, 0xb2, 0xfd, 0x04, 0x86, 0x2a, 0xa0, 0xe4, 0xc1, 0x33, 0x8a, 0xc7, 0xba, 0x6e, 0x65, 0x64, 0x68, 0x5c, 0xe6, 0x6a, 0x5d },
        .hmac_key_idx = 0,
        // results of message array encrypted with these keys
        .expected_results = {
            // Message 0
            { 0x64c24e70, 0x03f4e5f7, 0xbdd3c270, 0x6987c775, 0x623bff9e, 0xa52ddc27, 0x55140d81, 0x3f830f6c, 0xde186954, 0x73900908, 0x6ebc1990, 0x753704e8, 0xc810ac35, 0x345dddcb, 0xc41c937f, 0x0c8eeee3, 0x74f3a128, 0x67473afa, 0x6667bbf2, 0xa3851d69, 0x2d6b5145, 0x4cf9d237, 0x181a8ff1, 0xa4e1c506, 0xb684684e, 0x1df012c5, 0x4546c158, 0xa87c6d87, 0x0d1e0f48, 0x01075128, 0x11b8baac, 0xfb51bd01, 0xdd079533, 0x4eb8c402, 0x33d649d0, 0xcdff3e1c, 0x23bef697, 0x1e181aef, 0x6c31d342, 0xd167abbb, 0x6128f652, 0x2ba7bed4, 0x3ef2fe5f, 0xead2f540, 0x122fcae9, 0xadcbf50c, 0x7edb76be, 0x16d92d27, 0xe15c225c, 0xcbf3dd52, 0xcf49716e, 0xeea16bb2, 0x8a82d04e, 0x7a63abd0, 0x1c010703, 0xaab6a261, 0x385cc6f3, 0x92f69b5b, 0x05e71345, 0x0569b623, 0x2684aa87, 0xeac5b3db, 0x8420d980, 0xa4cf7037, 0x8c7e999a, 0xf58e5cc2, 0xe250b65d, 0xb16a3c0f, 0x9969c3fa, 0xa0477cdd, 0x2400ffa5, 0xb74dbd79, 0xe5f33572, 0x655dd07c, 0xa5706dc1, 0xc96b9590, 0x0cf03658, 0x56c4f1c3, 0xcd0c5e74, 0x77f736d2, 0x69d18612, 0xca23b547, 0x7166ae08, 0x5494e6e0, 0x5154fc4f, 0xac6e3fbc, 0x0cf2e065, 0x9f1d081d, 0x230f6cf6, 0x487b74e1, 0xf52e5254, 0xf0ecdc99, 0x5320f081, 0x9c861a51, 0xc29c4302, 0xc8accc54 },        // Message 1
            { 0x831ac52b, 0x5f4806ad, 0xbc5f3fa7, 0xd26c151e, 0xc8870389, 0xf89ba084, 0x51243a73, 0x1ae04b55, 0xed43ccdb, 0x17a34d55, 0xb8d9d8eb, 0xba716829, 0xc51979a3, 0x440ac411, 0xbd54ee17, 0x205c811e, 0xcf31fa28, 0x26b912aa, 0x7611532d, 0x8832fd6d, 0x3a3980bd, 0xb84d0c19, 0xbd6a503c, 0x44558981, 0xe1e7aa64, 0x878fc357, 0xa6996ab7, 0x2d4615cd, 0x67aede4e, 0xcb6f77fa, 0xb6dd6323, 0x96d16b66, 0x41de13e4, 0xf0497ec8, 0xe9b622c3, 0xeb004a8d, 0x64a125a2, 0xbf309d9c, 0x5d0a298c, 0x33726396, 0x713914cf, 0x862602d7, 0x1c662821, 0xa604e69d, 0x16b77cd6, 0xaa83cb0f, 0xdb987f60, 0xaaff4ec8, 0x7a941629, 0xcd3a6f7d, 0x9a69302c, 0x465b2886, 0x7087686d, 0x98fde217, 0xd5964c1c, 0x95bd5d46, 0x6163c2ac, 0xbdfb9350, 0x11cd7f8c, 0xc798e6cd, 0x0ef5ea89, 0x2be92390, 0xc4831143, 0x61928747, 0xe23dd7ae, 0xfe87ae70, 0x5b645aac, 0x5bbb95d2, 0xf27fd00d, 0xc2dca04d, 0xa14fe33d, 0x287088a8, 0x3f60e052, 0xa2605635, 0xb51727ed, 0x868883dd, 0xb9d27411, 0x19b1c9bc, 0x446757e4, 0x78e5e348, 0x97da41e6, 0x9e799008, 0x70575a6c, 0x2f11ce5c, 0xe71bc323, 0xbf2ec758, 0x6c3aaa01, 0x7ddfa5f6, 0x59aaa01f, 0x7c5fac79, 0x27058b25, 0xe9e56e44, 0xb69fb209, 0xd752ba93, 0x81425877, 0x2c392ffe },        // Message 2
            { 0x7fa7b65f, 0x0f62aa8d, 0xf5103440, 0x77040239, 0x7fbacb28, 0x257056b7, 0xc45cfe66, 0x1f00f227, 0x8b932739, 0xcddfb5e1, 0x1daba0bb, 0x30021709, 0xfa5cf3e7, 0x07619442, 0x6308c66a, 0x3e518bdb, 0xc69faa93, 0x6c257ce2, 0xffe55054, 0x6ebac857, 0x3db1f438, 0xc4891802, 0xbf4dcd9a, 0x51f4d20b, 0x4d4af4b9, 0x3b689725, 0xba59bb9e, 0x35518898, 0x22738adf, 0x02ddcf6e, 0xa8971ee0, 0x18c28892, 0xad953b15, 0xc7467248, 0xafa8ade9, 0xc7d0996b, 0x2eab2209, 0x3fe14627, 0x078c914d, 0xec7aae74, 0x6c92279d, 0xc8c0d24f, 0x8a6f4fb6, 0xc58ee36d, 0x3b36d29a, 0x42bda927, 0xd27335ce, 0x7be8bf0a, 0x24674de3, 0x0bb233fb, 0x396a5a15, 0xfadac055, 0x5f2ddf35, 0xec9f7c40, 0xf1e79c1e, 0x478a57db, 0xeae25d2f, 0x9b6e59b5, 0x1998c689, 0x2b8a2bd0, 0xdc45e240, 0x70c6aacc, 0xaf8d272c, 0x62b6dc97, 0x121b31b4, 0x1df1cf7f, 0x5627432c, 0xac7095ac, 0x63649988, 0xdf5a6b80, 0x7cc6f26a, 0xf928d222, 0xde553e0c, 0xe79a0dcc, 0x62b52fce, 0x4f7668c1, 0x3b0b1871, 0x9a2ddf5b, 0x308bc241, 0xb731000e, 0x7e001a30, 0xa637004e, 0xbed18e29, 0x9f08b82a, 0x4713953e, 0xc785c82f, 0x7ff61900, 0x155d4627, 0xe1d9f6dc, 0x0d20928a, 0x35ce4ecd, 0x064a6b90, 0x30dd9e79, 0x62f7d800, 0x2ae9a6be, 0xb44aa4c2 },        // Message 3
            { 0x21455e3e, 0x25705524, 0x59490a68, 0xc4822a49, 0x8eea5881, 0x16996f95, 0x6dc1f6e3, 0x1a3869ac, 0x01f34509, 0x58709a31, 0xa09dd776, 0x9298b6e7, 0x8066195c, 0x262fe076, 0xfd5363ff, 0x163b7658, 0xa25bb253, 0x5ba8f842, 0x08fd4559, 0x491f12e3, 0x6b74028d, 0x9cd39858, 0x665f4457, 0x73b46f90, 0x3e077a77, 0x4bc537f0, 0xaf9144d8, 0x94df74bf, 0x4f158e93, 0x930d9a23, 0x40b94edf, 0x95352e7f, 0xb27548c0, 0x1f64e1dc, 0x4b2bbdc0, 0x1f7e56ad, 0xf42fc1e0, 0xf28bd40d, 0xfaf536e5, 0x633a86af, 0xa9b8b114, 0x8c7782c1, 0x0802c9b7, 0x9258e2b4, 0x27cc94ea, 0xd9fb10b5, 0x997c870f, 0xaae73078, 0xa56067d4, 0x4c77baf0, 0x471a1108, 0xaed379dd, 0x924405f2, 0xca74892f, 0x734fe88f, 0x5d140648, 0x2ccae3f7, 0x7c7a050a, 0x16d3cdf5, 0x5c5d3e21, 0xe58c7f66, 0xd147390f, 0x9218ad13, 0x0ce015a4, 0xb9baed51, 0xd9189b01, 0x34e7aa06, 0x49913b4a, 0x209fd3dd, 0xfa7efa53, 0x5e58ec0d, 0x789ed70b, 0xe3d234b3, 0xee786b8d, 0x5a1ad94e, 0x65c90ee4, 0x948dca7a, 0xc0d99437, 0xb8e50f04, 0xd7293909, 0x6cbc8188, 0xdc7b031b, 0x91b0d9d7, 0x354fd88e, 0x6a26b3c4, 0xc84e0ff0, 0xa752d269, 0x2940476e, 0x40760567, 0x797f43fb, 0x87e5b3a1, 0x6bc92f2b, 0xcf3e1d5c, 0x01a9fa5c, 0x74dc165e, 0x756b96c7 },        // Message 4
            { 0x75b94bcd, 0x4727321f, 0xc20f35e6, 0x2e24446e, 0x4518523d, 0x8c48b2dc, 0x96717d50, 0x821f1237, 0xbebbd2e8, 0x8fdad52d, 0xcbf66868, 0x717d052b, 0xc250a639, 0xc7324725, 0x9f5b81b0, 0x1eb023ca, 0xf74a9135, 0x1ffaf2c6, 0xfc239282, 0x5310170d, 0x88eeff37, 0x811a01f1, 0x0638b0f7, 0x2d9e0512, 0xe5651782, 0xa0b4d90f, 0x92bb6d8a, 0x29901b7b, 0x7e5ffe21, 0x8a2faf4b, 0xde6d9c1b, 0xc039f9db, 0x2fefa926, 0xd944448c, 0x0ef40b8f, 0x49e7ef54, 0x1aca067a, 0x31651dd1, 0x435e6f0a, 0x56418f85, 0x3132a6eb, 0x49071227, 0xaf64f72b, 0x5ddf9924, 0x7e5dc362, 0x08acbe35, 0xdd11cce3, 0xefbd9384, 0xe4145f92, 0xbfce1d13, 0x3b9272b7, 0x3475d474, 0xd1488f01, 0x1ee27762, 0x56ce6a8b, 0x52173cfe, 0xc8f01f5b, 0xb7e14351, 0x8c3d8913, 0xd0601b74, 0xb06a5c86, 0xb77e176d, 0x7f9055c1, 0x29d18cec, 0x78176f52, 0x4f63e07f, 0xc5dcef9b, 0x042a35cd, 0x78929548, 0x6ea48187, 0x895d4912, 0x6cefe216, 0x92fe5324, 0xea0eb66a, 0xa49bbf66, 0x25630b34, 0x91fc86a6, 0xe2a79600, 0x1b9fed8f, 0xe427eecc, 0xa3e57a0e, 0xa75a2f54, 0x78a78916, 0xe9d24fa4, 0xcd019448, 0x3c4c3be7, 0xbca05cba, 0xdcb5771d, 0x92d00fac, 0x24f36d77, 0x0b727526, 0x9ae0b9c5, 0xc1444216, 0x15dbe3c0, 0xd99cf784, 0x44b2fd73 },        // Message 5
            { 0x11f9bd96, 0xf7ea1e63, 0x150c8f6e, 0x44cc8a80, 0x42fed7e5, 0x0f61e30c, 0x033638ee, 0x16241c9a, 0x68d9e483, 0xf2ef13d1, 0x01ada294, 0xfc6ba49d, 0x5986b719, 0x31d9a8da, 0xcb96ac35, 0x46fd03de, 0x756a03cb, 0x56bede87, 0x3db9fa94, 0x3c3ea1e9, 0x426e8145, 0xf404e223, 0x7a3363b8, 0xd250034e, 0xa23b3113, 0x3fd58c62, 0xbefaffa4, 0xea33988f, 0xfd4d0faf, 0x3f34bb25, 0x5f7da7c7, 0x75335eae, 0x2d9d72be, 0x5cc321e8, 0x6c321f3e, 0x760a13d6, 0xc8065bc8, 0x1e286132, 0x711a05f6, 0x3bee7ea5, 0x7e74c8e7, 0xc8a3a954, 0x8d01a889, 0x7ced44c5, 0x5f3e3fd5, 0x39be9d5c, 0x6b0ecc90, 0x8776df48, 0xd2fdfe60, 0x1f7f04c8, 0xd4a2846a, 0xddbb74d9, 0x4d58d3eb, 0xe16757df, 0xad55dd71, 0x98c1496e, 0x8ffe3a6b, 0x283afc22, 0x49c8862a, 0x68996c1d, 0xdb520015, 0x2e969b5c, 0x2f5f740d, 0x12146eaf, 0xd0d2732d, 0xa8884b25, 0x4f220f85, 0xf135a28f, 0x049186fb, 0xb3666eb4, 0xc4ac6f00, 0xe3cc9915, 0x8109969c, 0xffe6b13c, 0xbba86af0, 0xe7851e32, 0x92859216, 0xb3b63ebd, 0xda770264, 0x16044416, 0x91ea85d0, 0xd59afc2a, 0xdbe40984, 0xf33227c2, 0x0c835eff, 0x030916c8, 0x030a7b89, 0xdb00bab8, 0x39a5eaa9, 0x2762b6c8, 0x97985604, 0x2739649a, 0x8a908a89, 0x96faa348, 0xe4106b3e, 0x19cb304f },        // Message 6
            { 0x95e204e0, 0x4c1d6b06, 0x22b54c81, 0xf93bf0f6, 0xd0e92737, 0x0a05c841, 0x101d5059, 0x5b2e8406, 0xac0e2652, 0x6682d406, 0x5347a137, 0xabf938ac, 0x18ec9576, 0x08613a1d, 0x12c7b359, 0x6ddf1968, 0x2d375bf2, 0x91db0b71, 0xd56613e9, 0x511e27dc, 0xb75afea5, 0x2a713567, 0x3fbc7c17, 0x1a06a794, 0xe9d3e146, 0xfab6aa85, 0x7d0130c8, 0x1a5edae4, 0x79f1a48e, 0xe4310003, 0xeef16617, 0xf74ed6bf, 0x35606830, 0x58d55432, 0xe987fe23, 0xe49d4b59, 0x24474156, 0x0544da62, 0x3d55350b, 0x91dd1909, 0x98817796, 0xbf97824f, 0xa33bc1ee, 0x12cc6861, 0xbf4f03b5, 0x8e26a2bc, 0x436c1adc, 0x2fbb42b1, 0x7735491e, 0xe061a448, 0xe72db823, 0x96cba6df, 0xd6c5f39a, 0x6ac73d93, 0x2220c46b, 0x6a91b642, 0x9e69693f, 0x3e8238bf, 0x443aaead, 0x207ba9cb, 0x337c15ea, 0x1b0bc624, 0x75b68671, 0x1b3d86f5, 0x7d1c8a3d, 0x53d3a5cb, 0x65b351db, 0x3121be26, 0x916c071b, 0xbffb13d5, 0xc6742bd3, 0x42b8d304, 0x8171987d, 0xe7c9bbed, 0x74aa982c, 0xe7f2997f, 0x61f72f0c, 0xa8f98719, 0xcc0276e3, 0x3559c7fe, 0x0850408f, 0x07730249, 0x478a5a56, 0x2059aeed, 0x7d2b4c4d, 0x0a33df12, 0x054a8aa5, 0x50d8a093, 0x6fb23fe2, 0xb7f4641e, 0x1c503388, 0xca0e245f, 0x2fd22529, 0xc2119e0e, 0x25fd6afd, 0x6de0e7f5 },        // Message 7
            { 0x48e6637f, 0x6804d74d, 0x0b779232, 0x7aa48561, 0x92efbae2, 0xb56d6b85, 0x18f8654c, 0x3d9901bc, 0x27bc4146, 0xd6ece0f2, 0x38b3463f, 0x00e8f46f, 0xaa76530b, 0x40ce9365, 0xe0ee68ee, 0x43e1ab45, 0xd00f6fc1, 0x5c1cb98d, 0x348bee22, 0xadfecab9, 0x62f54000, 0xd6c1eead, 0xf690c04d, 0xc04cdc70, 0xa937db09, 0x305342b4, 0xaf216410, 0xb8660b05, 0x94dffa5e, 0x3efaa489, 0xd6ce0101, 0x2aa00a5d, 0xe33137c7, 0xdf5dfbbd, 0x77cc49e3, 0x2a660869, 0x2f5f4dfe, 0x8b941c69, 0x2d2a5d0b, 0x986cfa7a, 0x70b119f7, 0xc2efedbd, 0x09b5329c, 0xd9809b8f, 0xc62c50f8, 0x4135e1c5, 0x26c14c00, 0x8ff2556e, 0x167eb63b, 0xe6ce0405, 0x98bf6772, 0x2c781030, 0xb89c94a1, 0x1f4ffd23, 0x75f42cff, 0xb2275a98, 0x88905856, 0xda3764e8, 0x7784da29, 0x083ac191, 0x98e6d5bc, 0x3ec067c9, 0x1f6688da, 0x40295ceb, 0xdb076f74, 0xd73ed31f, 0x1eced964, 0x5a00716b, 0xb7354831, 0xb4081b35, 0xd55f7374, 0x4f078453, 0xef208f40, 0xd1487976, 0x7027b268, 0x773dbfe7, 0x7d7b6c26, 0xa759838f, 0xf37bbc0a, 0xeea627e2, 0x7d4441c2, 0xfc882a4c, 0x26ab1884, 0x1ee7fb21, 0x901ccf77, 0x8745cd47, 0x590ea36b, 0xaf6765a3, 0xd6ca4d2c, 0xdf017cfc, 0x530aa4a4, 0x3c422af6, 0xdf8484a3, 0xf7ac6b75, 0xa9ed54aa, 0x12daf4c2 },        // Message 8
            { 0xa97a75a9, 0x1b42faf1, 0xce1399f5, 0x718a2ba1, 0x13415a2d, 0x9c43933a, 0x4c42743b, 0x467c6b83, 0x770cb2e6, 0x0047b22f, 0x6bfd5179, 0xc4080057, 0x122f0ac1, 0xe870bc9f, 0xa698c15a, 0xec98df98, 0x51be3e90, 0x9f90d7ab, 0x3a877a4e, 0x45af2bbc, 0xef28f5f7, 0xfce93fc8, 0xf18d6c53, 0xdd6577f5, 0x6e97e1da, 0x07d0949b, 0xcbc8326e, 0xf9e315a9, 0xc97c2f8a, 0xe76643ec, 0x63543d42, 0x0e01aeb1, 0xb9b51d58, 0x5783fbb9, 0x2a099aaf, 0xe141ea14, 0xc763b58e, 0x698e7a90, 0xf6ba62da, 0x13270a2f, 0xf2df8b30, 0xf788dc1b, 0xf50ea21e, 0xb2fbed7a, 0x56e95caa, 0x5f118c32, 0x54430ddf, 0x90c9f2e9, 0xc2475f91, 0xbabf8c6d, 0x17948b8c, 0x3d7a1438, 0x2ae8ba41, 0x496723f2, 0xa60718e4, 0xcc960e0d, 0xa4bdb10a, 0xde1adf3d, 0xbbd6c327, 0xf1398005, 0xb867c10d, 0x37f48fd6, 0xea795e19, 0x898bb52e, 0x4152897e, 0xbbf127dd, 0x2c335ef6, 0x8c0d4a76, 0x79090668, 0x7683f91c, 0xa8e58a83, 0xf001b762, 0xe1621309, 0xa562fa4c, 0xbfec7b42, 0xbf1b4a9d, 0x29207a95, 0x1d59987e, 0x7b428bef, 0x64cc46aa, 0xc79c99a5, 0x8a2a8bc9, 0x642a2b8f, 0x25a800ff, 0xeb00edf1, 0x9989c721, 0xaae4a05c, 0x454ec92f, 0xa2f72f0f, 0x5bcb9edd, 0x18cb73e4, 0x00a71263, 0x93f8c011, 0x6a96956b, 0x10ecb752, 0x205d5822 },        // Message 9
            { 0x3bfb11e4, 0xf6d6ebb3, 0x7ec5dcb8, 0x3840135d, 0x88388a13, 0x874bd2a5, 0xae525562, 0x354b7be8, 0x74ce87af, 0x51f350a5, 0x0793137d, 0x26aa0636, 0x8e10d76c, 0xd49d5e73, 0x4959f524, 0xb7555703, 0x99859035, 0x40c79673, 0x317fb940, 0x5cd8d72b, 0x1bf41d50, 0x61b31955, 0x62524def, 0x59f2c0dd, 0xdbe9d581, 0x6f4693bd, 0x187b99b0, 0x19f2409d, 0x5514e19d, 0x283e3fdc, 0xed3eb99a, 0x6b8426da, 0x18061fad, 0x897a3d73, 0x3052444c, 0x7072639e, 0xb00c252c, 0x22a7ad0e, 0x465c3c85, 0xe6ef64d7, 0xd52c1a8a, 0xb5b90f82, 0xe9faf74d, 0xc4f62e88, 0xe9c7b255, 0x095e8714, 0x87c0ea0b, 0x5fd386a6, 0xb61ff901, 0x7f874595, 0x347c8e6b, 0xa2c27bf1, 0x0ae4f4a2, 0xb0da37c4, 0xda204dfc, 0xad2bb768, 0xda456d50, 0x26ba84d2, 0x04605ef5, 0x585a5e1d, 0xe29c018e, 0x2e3cfc92, 0x193bc8e6, 0x4faf3ebb, 0xaabdef6a, 0x83322b12, 0xd86e4652, 0x83a72a63, 0xb4617f2d, 0x8753ebe4, 0xcadcf4ec, 0x70f32836, 0x4d1b40f5, 0x239ad371, 0x8218dc38, 0x20574ac8, 0xbf1699fa, 0xfe2771bd, 0x0cb48a07, 0x0151e1bf, 0xbcb58312, 0x9b4fb373, 0x026917d2, 0x22a4fad9, 0x384c6d19, 0x69e78c6d, 0xe59850f3, 0x837c9b3a, 0x76022e4a, 0x5418542d, 0xc912e299, 0x1525f115, 0xe068e14a, 0x5fc8d5f9, 0xba75c297, 0xce4163cf },
        },
    },
};
