'use client'

import {
  type AutoFormUIComponents,
  AutoForm as BaseAutoForm
} from '@autoform/react'
import React from 'react'
import { ArrayElementWrapper } from './components/ArrayElementWrapper'
import { ArrayWrapper } from './components/ArrayWrapper'
import { SwitchField } from './components/BooleanField'
import { DateField } from './components/DateField'
import { ErrorMessage } from './components/ErrorMessage'
import { FieldWrapper } from './components/FieldWrapper'
import { Form } from './components/Form'
import { NumberField } from './components/NumberField'
import { ObjectWrapper } from './components/ObjectWrapper'
import { SelectField } from './components/SelectField'
import { StringField, TextAreaField } from './components/StringField'
import { SubmitButton } from './components/SubmitButton'
import type { AutoFormProps } from './types'

const ShadcnUIComponents: AutoFormUIComponents = {
  Form,
  FieldWrapper,
  ErrorMessage,
  SubmitButton,
  ObjectWrapper,
  ArrayWrapper,
  ArrayElementWrapper
}

export const ShadcnAutoFormFieldComponents = {
  string: StringField,
  textarea: TextAreaField,
  number: NumberField,
  boolean: SwitchField,
  date: DateField,
  select: SelectField
} as const
export type FieldTypes = keyof typeof ShadcnAutoFormFieldComponents

export function AutoForm<T extends Record<string, unknown>>({
  uiComponents,
  formComponents,
  ...props
}: AutoFormProps<T>) {
  return (
    <BaseAutoForm
      {...props}
      uiComponents={{ ...ShadcnUIComponents, ...uiComponents }}
      formComponents={{ ...ShadcnAutoFormFieldComponents, ...formComponents }}
    />
  )
}
