import type * as React from 'react'

export const StartCallIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      fill='none'
      {...props}
    >
      <path
        d='M7.07108 16.7278C5.74088 15.3976 4.74468 13.8495 4.08247 12.0836C3.42026 10.3176 3.18085 8.47727 3.36425 6.5625C3.38907 6.36877 3.46441 6.20369 3.59026 6.06728C3.71612 5.93086 3.87573 5.86099 4.0691 5.85765L7.0985 5.80537C7.27038 5.8024 7.44096 5.87463 7.61025 6.02206C7.77953 6.16949 7.87343 6.32896 7.89195 6.50047L8.30391 9.69906C8.31262 9.81704 8.30002 9.92465 8.26612 10.0219C8.23223 10.1191 8.17703 10.206 8.10053 10.2825L5.82206 12.561C6.09061 13.1792 6.41899 13.7535 6.80719 14.2837C7.1954 14.814 7.6112 15.3008 8.0546 15.7442C8.498 16.1876 8.98483 16.6034 9.5151 16.9917C10.0454 17.3799 10.6196 17.7082 11.2379 17.9768L13.5164 15.6983C13.5928 15.6218 13.6797 15.5666 13.777 15.5327C13.8742 15.4988 13.9818 15.4862 14.0998 15.4949L17.2984 15.9069C17.5234 15.9352 17.6964 16.0208 17.8175 16.1637C17.9385 16.3066 17.9972 16.4855 17.9935 16.7003L17.9412 19.7297C17.9379 19.9231 17.868 20.0827 17.7316 20.2086C17.5952 20.3344 17.4301 20.4098 17.2363 20.4346C15.3216 20.618 13.4812 20.3786 11.7153 19.7164C9.94935 19.0542 8.40128 18.058 7.07108 16.7278Z'
        fill='currentColor'
      />
      <path
        d='M9.99957 7.21275C9.99957 7.58826 10.2812 7.905 10.6566 7.95167C10.665 7.95266 11.5282 8.07141 12.4318 8.59924C13.6308 9.29944 14.3284 10.3674 14.5054 11.7732C14.5524 12.1459 14.8714 12.4255 15.2496 12.4255C15.6278 12.4255 15.9468 12.1459 15.9938 11.7732C15.9948 11.7648 16.1144 10.9077 16.646 10.0106C17.3512 8.82006 18.4268 8.12741 19.8426 7.95167C20.218 7.905 20.4996 7.58826 20.4996 7.21275C20.4996 6.83723 20.218 6.52049 19.8426 6.47383C19.8342 6.47284 18.971 6.35408 18.0674 5.82626C16.8684 5.12606 16.1708 4.05809 15.9938 2.65234C15.9468 2.2796 15.6278 2 15.2496 2C14.8714 2 14.5524 2.2796 14.5054 2.65234C14.5044 2.66068 14.3848 3.51775 13.8532 4.41494C13.148 5.60543 12.0724 6.29808 10.6566 6.47383C10.2812 6.52049 9.99957 6.83723 9.99957 7.21275ZM15.146 5.17014C15.172 5.12626 15.1972 5.08257 15.2216 5.03908C15.7038 5.88345 16.405 6.58325 17.3068 7.10988C17.351 7.1357 17.395 7.16072 17.4388 7.18495C16.5884 7.66372 15.8836 8.35995 15.3532 9.25535C15.3272 9.29924 15.302 9.34293 15.2776 9.38641C14.7954 8.54205 14.0942 7.84225 13.1924 7.31561C13.1482 7.2898 13.1042 7.26478 13.0604 7.24055C13.9108 6.76177 14.6156 6.06555 15.146 5.17014Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const SubtitleZHCNIcon = (
  props: React.SVGProps<SVGSVGElement> & {
    isGradient?: boolean
  }
) => {
  const { isGradient = false, ...rest } = props
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 34 31'
      fill='none'
      {...rest}
    >
      <defs>
        <linearGradient
          id='subtitle-cn-gradient'
          x1='0%'
          y1='0%'
          x2='0%'
          y2='100%'
        >
          <stop offset='0%' stopColor='#00C2FF' />
          <stop offset='64.5%' stopColor='#00FFA2' />
          <stop offset='98.5%' stopColor='#FFFFFF' />
        </linearGradient>
      </defs>
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M6.66667 0C2.98477 0 0 2.98477 0 6.66667V18.3333C0 22.0152 2.98477 25 6.66667 25H9.5C9.9479 25 10.2796 25.4163 10.1795 25.8529L9 31L18.3722 25.4461C18.865 25.1541 19.4272 25 20 25H27.3333C31.0152 25 34 22.0152 34 18.3333V6.66667C34 2.98477 31.0152 0 27.3333 0H6.66667ZM4.15376 6.93202V9.85046H5.79454V11.3837H11.3356C10.9455 11.8544 10.5286 12.3251 10.0982 12.7958H4.00582V14.4904H9.70822V16.8036H7.67741V18.5117H11.4835V14.4904H16.1234V12.7958H12.1963C12.9763 11.8678 13.7026 10.886 14.3347 9.85046H15.962V6.93202H10.9455V6.13852H9.17025V6.93202H4.15376ZM14.2136 9.74287H5.90213V8.5997H14.2136V9.74287ZM20.2119 8.69384H18.4367V12.5941H22.6328V13.0917H17.4011V14.5845H18.9074C18.5173 15.1225 17.9794 15.5125 17.2531 15.7949V17.4895C18.0466 17.2071 18.7056 16.844 19.257 16.4002V18.3503H20.9516V16.8978H22.6462V18.5789H24.3677V16.8978H26.0623V18.3503H27.7568V16.4002C28.3083 16.844 28.9673 17.2071 29.7608 17.4895V15.7949C29.0345 15.5125 28.4965 15.1225 28.1065 14.5845H29.6128V13.0917H24.3811V12.5941H28.5772V8.69384H26.802V8.18278H29.3573V6.73028H26.802V6.24612H25.0536V6.73028H21.9603V6.24612H20.2119V6.73028H17.6566V8.18278H20.2119V8.69384ZM22.6462 15.4856H20.1312C20.333 15.2032 20.5078 14.9073 20.6557 14.5845H26.3581C26.5061 14.9073 26.6809 15.2032 26.8827 15.4856H24.3677V14.7863H22.6462V15.4856ZM26.8289 11.5181H20.185V11.1281H26.8289V11.5181ZM26.8289 10.1463H20.185V9.74287H26.8289V10.1463ZM25.0536 8.69384H21.9603V8.18278H25.0536V8.69384Z'
        fill={isGradient ? 'url(#subtitle-cn-gradient)' : 'currentColor'}
      />
    </svg>
  )
}

export const SubtitleENIcon = (
  props: React.SVGProps<SVGSVGElement> & {
    isGradient?: boolean
  }
) => {
  const { isGradient = false, ...rest } = props
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 30 30'
      fill='none'
      {...rest}
    >
      <defs>
        <linearGradient
          id='subtitle-en-gradient'
          x1='0%'
          y1='0%'
          x2='0%'
          y2='100%'
        >
          <stop offset='0%' stopColor='#00C2FF' />
          <stop offset='64.5%' stopColor='#00FFA2' />
          <stop offset='98.5%' stopColor='#FFFFFF' />
        </linearGradient>
      </defs>
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M7.49998 0.833496C3.81808 0.833496 0.833313 3.81827 0.833313 7.50017V22.5002C0.833313 26.1821 3.81809 29.1668 7.49998 29.1668H22.5C26.1819 29.1668 29.1666 26.1821 29.1666 22.5002V7.50016C29.1666 3.81826 26.1819 0.833496 22.5 0.833496H7.49998ZM10.4337 8.81552C6.97429 8.81552 4.16667 11.6231 4.16667 15.0825C4.16667 18.5419 6.97429 21.3496 10.4337 21.3496C12.1571 21.3496 13.7239 20.6445 14.8645 19.5133L12.6491 17.2979C12.2108 17.7363 11.6524 18.0349 11.0444 18.1558C10.4364 18.2768 9.80626 18.2147 9.23358 17.9774C8.66091 17.7401 8.17148 17.3383 7.82721 16.8228C7.48293 16.3073 7.29929 15.7013 7.29951 15.0814C7.29973 14.4615 7.4838 13.8557 7.82844 13.3404C8.17307 12.8252 8.66279 12.4237 9.23563 12.1868C9.80848 11.95 10.4387 11.8883 11.0466 12.0097C11.6545 12.1311 12.2127 12.43 12.6506 12.8687L14.866 10.6533C14.2849 10.0698 13.5942 9.60704 12.8335 9.29163C12.0728 8.97622 11.2572 8.81441 10.4337 8.81552ZM21.401 8.81552C17.9416 8.81552 15.134 11.6231 15.134 15.0825C15.135 16.3215 15.5031 17.5324 16.1919 18.5623C16.8807 19.5921 17.8592 20.3948 19.0038 20.8689C20.1485 21.343 21.408 21.4673 22.6233 21.226C23.8385 20.9847 24.955 20.3887 25.8318 19.5133L23.6164 17.2979C23.1781 17.7363 22.6197 18.0349 22.0117 18.1558C21.4037 18.2768 20.7736 18.2147 20.2009 17.9774C19.6282 17.7401 19.1388 17.3383 18.7945 16.8228C18.4502 16.3073 18.2666 15.7013 18.2668 15.0814C18.267 14.4615 18.4511 13.8557 18.7957 13.3404C19.1404 12.8252 19.6301 12.4237 20.2029 12.1868C20.7758 11.95 21.406 11.8883 22.0139 12.0097C22.6218 12.1311 23.18 12.43 23.6179 12.8687L25.8333 10.6533C25.2522 10.0698 24.5615 9.60704 23.8008 9.29163C23.0401 8.97622 22.2245 8.81441 21.401 8.81552Z'
        fill={isGradient ? 'url(#subtitle-en-gradient)' : 'currentColor'}
      />
    </svg>
  )
}

export const CustomSubtitleIcon = (
  props: React.SVGProps<SVGSVGElement> & {
    isZHCN?: boolean
    isGradient?: boolean
  }
) => {
  const { isZHCN = false, isGradient = false, ...rest } = props

  if (isZHCN) {
    return <SubtitleZHCNIcon isGradient={isGradient} {...rest} />
  }

  return <SubtitleENIcon isGradient={isGradient} {...rest} />
}

export const MicrophoneIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 30'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M12 0.983887C7.93056 0.983887 4.63161 4.28284 4.63161 8.35231V13.6155C4.63161 17.6849 7.93056 20.9839 12 20.9839C16.0695 20.9839 19.3685 17.6849 19.3685 13.6155V8.35231C19.3685 4.28284 16.0695 0.983887 12 0.983887ZM1.47371 12.5628C2.05507 12.5628 2.52634 13.0341 2.52634 13.6155C2.52634 18.8476 6.76786 23.0891 12 23.0891C17.2322 23.0891 21.4737 18.8476 21.4737 13.6155C21.4737 13.0341 21.945 12.5628 22.5263 12.5628C23.1077 12.5628 23.579 13.0341 23.579 13.6155C23.579 19.6555 18.9542 24.6154 13.0527 25.1472V28.3523C13.0527 28.9337 12.5814 29.4049 12 29.4049C11.4187 29.4049 10.9474 28.9337 10.9474 28.3523V25.1472C5.04582 24.6154 0.421082 19.6555 0.421082 13.6155C0.421082 13.0341 0.892361 12.5628 1.47371 12.5628Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const MicrophoneOffIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 31'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M21.0472 0.717555C20.5948 0.400777 19.9712 0.510725 19.6545 0.96313L2.44716 25.5377C2.13038 25.9901 2.24033 26.6136 2.69273 26.9304C3.14514 27.2472 3.76868 27.1373 4.08546 26.6848L21.2928 2.11028C21.6095 1.65788 21.4996 1.03433 21.0472 0.717555ZM12 1.9837C13.2663 1.9837 14.458 2.30313 15.4989 2.8658L5.23064 17.5303C4.84513 16.6363 4.63155 15.6507 4.63155 14.6153V9.35212C4.63155 5.28266 7.9305 1.9837 12 1.9837ZM2.52628 14.6153C2.52628 16.3928 3.0158 18.0559 3.86738 19.4773L2.5679 21.3331C1.21621 19.4387 0.421021 17.1198 0.421021 14.6153C0.421021 14.0339 0.8923 13.5626 1.47365 13.5626C2.055 13.5626 2.52628 14.0339 2.52628 14.6153ZM8.92945 23.5803L7.68174 25.3622C8.70595 25.7741 9.80262 26.0439 10.9473 26.147V29.3521C10.9473 29.9335 11.4186 30.4048 12 30.4048C12.5813 30.4048 13.0526 29.9335 13.0526 29.3521V26.147C18.9542 25.6152 23.5789 20.6553 23.5789 14.6153C23.5789 14.0339 23.1076 13.5626 22.5263 13.5626C21.9449 13.5626 21.4736 14.0339 21.4736 14.6153C21.4736 19.8474 17.2321 24.089 12 24.089C10.9253 24.089 9.89238 23.91 8.92945 23.5803ZM19.3409 8.71119L10.2021 21.7628C10.7775 21.9071 11.3798 21.9837 12 21.9837C16.0694 21.9837 19.3684 18.6847 19.3684 14.6153V9.35212C19.3684 9.13618 19.3591 8.92241 19.3409 8.71119Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const MicrophoneDisallowIcon = (
  props: React.SVGProps<SVGSVGElement>
) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 40 40'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M21.7355 6.18944C21.1789 6.05507 20.5978 5.98389 20 5.98389C15.9305 5.98389 12.6315 9.28284 12.6315 13.3523V18.6155C12.6315 20.9552 13.7221 23.0402 15.4226 24.39L18.9713 19.4613L17.6926 18.3424C16.168 17.0084 15.8814 14.7453 17.0254 13.0734L21.7355 6.18944ZM14.1914 26.1C11.9612 24.3668 10.5263 21.6587 10.5263 18.6155C10.5263 18.0341 10.055 17.5628 9.47365 17.5628C8.8923 17.5628 8.42102 18.0341 8.42102 18.6155C8.42102 22.3622 10.2005 25.6932 12.9605 27.8096L14.1914 26.1ZM18.6896 30.1211L20.1535 28.0879C25.3149 28.0059 29.4736 23.7964 29.4736 18.6155C29.4736 18.0341 29.9449 17.5628 30.5263 17.5628C31.1076 17.5628 31.5789 18.0341 31.5789 18.6155C31.5789 24.6555 26.9542 29.6154 21.0526 30.1472V33.3523C21.0526 33.9337 20.5813 34.4049 20 34.4049C19.4186 34.4049 18.9473 33.9337 18.9473 33.3523V30.1472C18.8612 30.1394 18.7752 30.1307 18.6896 30.1211ZM21.834 25.7538L24.9032 21.4911C26.1083 19.8173 25.8433 17.5017 24.2911 16.1435L22.9798 14.9962L26.4917 9.86343C27.051 10.902 27.3684 12.0901 27.3684 13.3523V18.6155C27.3684 22.0517 25.0162 24.9386 21.834 25.7538Z'
        fill='currentColor'
        fillOpacity='0.6'
      />
      <path
        d='M25.5 6L19.5013 14.7673C19.2153 15.1853 19.287 15.7511 19.6681 16.0846L22.3156 18.4011C22.7036 18.7407 22.7699 19.3196 22.4686 19.738L14 31.5'
        stroke='currentColor'
        strokeOpacity='0.75'
        strokeWidth='2'
        strokeLinecap='round'
      />
    </svg>
  )
}

export const AgentAvatarIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 20 20'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M5.02155 6.68136C5.02155 6.80089 5.11055 6.90172 5.22921 6.91658C5.23186 6.91689 5.50469 6.95469 5.7903 7.12272C6.16927 7.34561 6.38976 7.68558 6.44571 8.13308C6.46056 8.25173 6.56139 8.34074 6.68093 8.34074C6.80047 8.34074 6.90129 8.25173 6.91615 8.13308C6.91647 8.13042 6.95427 7.85759 7.12229 7.57199C7.34519 7.19301 7.68515 6.97252 8.13265 6.91658C8.2513 6.90172 8.34031 6.80089 8.34031 6.68136C8.34031 6.56182 8.2513 6.46099 8.13265 6.44613C8.13 6.44582 7.85716 6.40802 7.57156 6.23999C7.19259 6.0171 6.97209 5.67713 6.91615 5.22963C6.90129 5.11098 6.80047 5.02197 6.68093 5.02197C6.56139 5.02197 6.46056 5.11098 6.44571 5.22963C6.44539 5.23229 6.40759 5.50512 6.23956 5.79072C6.01667 6.1697 5.6767 6.39019 5.22921 6.44613C5.11055 6.46099 5.02155 6.56182 5.02155 6.68136ZM2.53278 12.0743C2.53278 12.2835 2.68854 12.46 2.89618 12.486C2.90083 12.4865 3.37829 12.5527 3.87809 12.8467C4.54129 13.2368 4.92715 13.8317 5.02506 14.6148C5.05105 14.8225 5.2275 14.9782 5.4367 14.9782C5.64589 14.9782 5.82234 14.8225 5.84833 14.6148C5.84889 14.6102 5.91504 14.1327 6.20908 13.6329C6.59915 12.9697 7.19409 12.5839 7.97721 12.486C8.18485 12.46 8.34061 12.2835 8.34061 12.0743C8.34061 11.8651 8.18485 11.6887 7.97721 11.6627C7.97256 11.6621 7.4951 11.596 6.9953 11.3019C6.3321 10.9119 5.94624 10.3169 5.84833 9.53381C5.82234 9.32617 5.64589 9.17041 5.4367 9.17041C5.2275 9.17041 5.05105 9.32617 5.02506 9.53381C5.0245 9.53846 4.95835 10.0159 4.66431 10.5157C4.27424 11.1789 3.6793 11.5648 2.89618 11.6627C2.68854 11.6887 2.53278 11.8651 2.53278 12.0743ZM13.5508 13.5775C13.5099 13.9038 13.2327 14.1486 12.9039 14.1486C12.5752 14.1486 12.2979 13.9038 12.2571 13.5775C12.1032 12.3469 11.4969 11.412 10.4547 10.799C9.66928 10.337 8.91898 10.233 8.91168 10.2322C8.58538 10.1913 8.34062 9.91403 8.34061 9.5853C8.34061 9.25657 8.58538 8.97929 8.91168 8.93844C10.1423 8.78458 11.0772 8.17822 11.6902 7.13605C12.1522 6.35064 12.2562 5.60034 12.257 5.59304C12.2979 5.26674 12.5752 5.02197 12.9039 5.02197C13.2326 5.02197 13.5099 5.26674 13.5508 5.59303C13.7046 6.82365 14.311 7.75856 15.3531 8.37151C16.1386 8.83357 16.8889 8.93752 16.8962 8.93839C17.2224 8.97924 17.4672 9.25652 17.4672 9.58525C17.4672 9.91398 17.2225 10.1913 16.8962 10.2321C15.6655 10.386 14.7306 10.9923 14.1177 12.0345C13.6556 12.8199 13.5517 13.5702 13.5508 13.5775Z'
        fill='url(#paint0_linear_410_1223)'
      />
      <defs>
        <linearGradient
          id='paint0_linear_410_1223'
          x1='17.4141'
          y1='10.1345'
          x2='2.29943'
          y2='10.1601'
          gradientUnits='userSpaceOnUse'
        >
          <stop stopColor='#00C2FF' />
          <stop offset='0.33' stopColor='#A0FAFF' />
          <stop offset='0.66' stopColor='#E5FEFF' />
          <stop offset='1' stopColor='#C46FFB' />
        </linearGradient>
      </defs>
    </svg>
  )
}

export const UserAvatarIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      fill='none'
      {...props}
    >
      <circle cx='12' cy='12' r='11' fill='#AADBFF' fillOpacity='0.9' />
      <path
        d='M12 11.7424C11.2135 11.7424 10.5415 11.4564 9.98418 10.8844C9.42684 10.3126 9.14818 9.62295 9.14818 8.81555C9.14818 8.00829 9.42684 7.31866 9.98418 6.74666C10.5415 6.17467 11.2135 5.88867 12 5.88867C12.7866 5.88867 13.4585 6.17467 14.0159 6.74666C14.5732 7.31866 14.8519 8.00829 14.8519 8.81555C14.8519 9.62295 14.5732 10.3126 14.0159 10.8844C13.4585 11.4564 12.7866 11.7424 12 11.7424ZM5.88892 16.8404V16.2517C5.88892 15.8422 5.99729 15.463 6.21403 15.114C6.43077 14.765 6.72043 14.4967 7.08303 14.3091C7.88834 13.9039 8.70077 13.6 9.52034 13.3974C10.3399 13.1947 11.1665 13.0934 12 13.0934C12.8336 13.0934 13.6601 13.1947 14.4797 13.3974C15.2993 13.6 16.1117 13.9039 16.917 14.3091C17.2796 14.4967 17.5693 14.765 17.786 15.114C18.0028 15.463 18.1111 15.8422 18.1111 16.2517V16.8404C18.1111 17.5246 18.1111 17.4998 16.8889 18.722C15.6667 19.9442 14.1291 20.5553 12 20.5553C9.87092 20.5553 8.31767 19.9285 7.11114 18.722C5.9046 17.5155 5.88892 17.5246 5.88892 16.8404Z'
        fill='#075C9A'
      />
    </svg>
  )
}

export const ChatInterruptIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 16 16'
      fill='none'
      {...props}
    >
      <g clipPath='url(#clip0_4249_6498)'>
        <path
          fillRule='evenodd'
          clipRule='evenodd'
          d='M0.666748 3.99996C0.666748 2.15901 2.15913 0.666626 4.00008 0.666626H12.0001C13.841 0.666626 15.3334 2.15901 15.3334 3.99996V12C15.3334 13.8409 13.841 15.3333 12.0001 15.3333H4.00008C2.15913 15.3333 0.666748 13.8409 0.666748 12V3.99996ZM4.00024 4.33321H7.00024V11.6665H4.00024V4.33321ZM12.0002 4.33321H9.00024V11.6665H12.0002V4.33321Z'
          fill='currentColor'
          fillOpacity='0.75'
        />
      </g>
      <defs>
        <clipPath id='clip0_4249_6498'>
          <rect width='16' height='16' fill='currentColor' />
        </clipPath>
      </defs>
    </svg>
  )
}

export const ChatInterruptActionIcon = (
  props: React.SVGProps<SVGSVGElement>
) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 28 28'
      fill='none'
      style={{
        width: '1.5rem',
        height: '1.5rem',
        color: 'currentColor'
      }}
      {...props}
    >
      <title className='sr-only'>Interrupt</title>
      <rect
        x='0.666504'
        y='0.666748'
        width='26.6667'
        height='26.6667'
        rx='6.66667'
        fill='currentColor'
      />
    </svg>
  )
}

export const ChatInterruptInlineActionIcon = (
  props: React.SVGProps<SVGSVGElement>
) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 20 20'
      fill='none'
      {...props}
    >
      <title className='sr-only'>Interrupt</title>
      <path
        d='M10.0005 0.598877C15.1924 0.599053 19.4009 4.8083 19.4009 10.0002C19.4007 15.192 15.1923 19.4005 10.0005 19.4006C4.80854 19.4006 0.599297 15.1921 0.599121 10.0002C0.599121 4.80819 4.80844 0.598877 10.0005 0.598877ZM10.0005 2.08325C5.62823 2.08325 2.0835 5.62799 2.0835 10.0002L2.09424 10.4075C2.29951 14.4552 5.54457 17.7011 9.59229 17.9065L10.0005 17.9163C14.2359 17.9161 17.6946 14.5902 17.9067 10.4075L17.9165 10.0002C17.9165 5.76468 14.5906 2.30612 10.4077 2.09399L10.0005 2.08325ZM9.99951 5.83325C11.9636 5.83325 12.9459 5.83353 13.5562 6.4436C14.1663 7.0538 14.1665 8.03606 14.1665 10.0002C14.1665 11.9643 14.1663 12.9467 13.5562 13.5569C12.9459 14.1667 11.9633 14.1663 9.99951 14.1663C8.03604 14.1663 7.05402 14.1667 6.44385 13.5569C5.83368 12.9467 5.8335 11.9643 5.8335 10.0002C5.8335 8.03606 5.83365 7.0538 6.44385 6.4436C7.054 5.83358 8.03578 5.83325 9.99951 5.83325Z'
        fill='currentColor'
        fillOpacity='0.75'
      />
    </svg>
  )
}

export const ChatUploadPicIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 34 29'
      fill='none'
      {...props}
    >
      <title className='sr-only'>Upload Picture</title>
      <path
        d='M27.0508 0.046875H7.10547C3.47656 0.046875 0.523438 3 0.523438 6.62891V21.4648C0.523438 25.0938 3.47656 28.0469 7.10547 28.0469H27.0469C30.6758 28.0469 33.6289 25.0938 33.6289 21.4648V6.62891C33.6328 3 30.6797 0.046875 27.0508 0.046875ZM12.5195 5.75C14.4102 5.75 15.9453 7.28125 15.9453 9.17578C15.9453 11.0664 14.4141 12.6016 12.5195 12.6016C10.6289 12.6016 9.09375 11.0703 9.09375 9.17578C9.09766 7.28516 10.6289 5.75 12.5195 5.75ZM7.94922 21.6484L12.6445 14.332L15.9961 19.0586L20.6953 11.9688L26.7305 21.6484H7.94922Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const PresetAvatarCloseIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 34 34'
      fill='none'
      {...props}
    >
      <title className='sr-only'>Close</title>
      <path
        d='M17 0.751953C25.9746 0.751953 33.25 8.02733 33.25 17.002C33.2497 25.9764 25.9745 33.252 17 33.252C8.02559 33.2519 0.750264 25.9763 0.75 17.002C0.75 8.02737 8.02543 0.752019 17 0.751953ZM17 4.25195C9.95843 4.25202 4.25 9.96036 4.25 17.002C4.25026 24.0433 9.95859 29.7519 17 29.752C24.0415 29.752 29.7497 24.0434 29.75 17.002C29.75 9.96032 24.0416 4.25195 17 4.25195ZM9.5127 9.51465C10.1961 8.83127 11.3039 8.83135 11.9873 9.51465L24.4873 22.0146L24.6074 22.1475C25.1682 22.8348 25.1281 23.8485 24.4873 24.4893C23.8466 25.1299 22.8328 25.1701 22.1455 24.6094L22.0127 24.4893L9.5127 11.9893C8.82944 11.3059 8.82944 10.198 9.5127 9.51465Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const PresetPlaceholderIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 54 54'
      fill='none'
      {...props}
    >
      <title className='sr-only'>Preset Placeholder</title>
      <g clipPath='url(#clip0_44062_5615)'>
        <rect width='54' height='54' fill='#446CFF' />
        <circle
          cx='27.5'
          cy='27.5'
          r='17.35'
          stroke='url(#paint0_linear_44062_5615)'
          strokeOpacity='0.15'
          strokeWidth='0.3'
        />
        <circle
          cx='27.5'
          cy='27.5'
          r='22.35'
          stroke='url(#paint1_linear_44062_5615)'
          strokeOpacity='0.15'
          strokeWidth='0.3'
        />
        <path
          d='M0 27H54'
          stroke='white'
          strokeOpacity='0.18'
          strokeWidth='0.3'
        />
        <path
          d='M27 53.7549L27 -0.245118'
          stroke='white'
          strokeOpacity='0.18'
          strokeWidth='0.3'
        />
        <g filter='url(#filter0_f_44062_5615)'>
          <ellipse
            cx='22.5'
            cy='26.5'
            rx='8.5'
            ry='12.5'
            transform='rotate(46.6997 22.5 26.5)'
            fill='#263CFF'
          />
        </g>
        <path
          d='M27.6497 17.3573C27.7393 17.1447 27.9437 17 28.1743 17H33.5313C34.1598 17 34.6341 17.574 34.4638 18.179C33.9922 19.8549 33.222 21.4405 32.1845 22.8602C31.078 24.3743 29.6926 25.6652 28.1046 26.6685C28.735 26.3772 29.387 26.1285 30.0564 25.925C32.0329 25.324 34.111 25.1317 36.1605 25.3564C36.6466 25.4096 37 25.8305 37 26.3196V30.9146C37 31.5895 36.342 32.0709 35.6738 31.9757C34.746 31.8433 33.797 31.8661 32.8677 32.0479C31.2602 32.3622 29.7836 33.1383 28.6247 34.2778C27.993 34.8989 27.4711 35.6128 27.0753 36.3897C26.8909 36.7516 26.5302 37 26.1241 37H21.0279C20.3914 37 19.9156 36.4122 20.101 35.8033C20.1485 35.6473 20.1986 35.4919 20.2514 35.3373C21.0097 33.1164 22.2943 31.1047 23.9991 29.4681C24.7273 28.7691 25.5232 28.1471 26.3735 27.6099C24.3794 28.5314 22.2014 29.0114 19.9937 29.013C19.2591 29.0151 18.5288 28.9636 17.8087 28.8605C17.3365 28.7929 17 28.3787 17 27.9017V23.2864C17 22.5857 17.7067 22.0989 18.3945 22.2325C18.9175 22.3341 19.4529 22.3866 19.9937 22.3871C21.6327 22.3871 23.2349 21.9093 24.5976 21.014C25.9604 20.1186 27.0225 18.8461 27.6497 17.3573Z'
          fill='white'
        />
        <path
          d='M41.5 9C41.5 9 41.8722 11.5938 42.9223 12.7616C43.8453 13.788 46 14.5 46 14.5C46 14.5 43.8457 15.2085 42.9223 16.2384C41.8762 17.4053 41.5 20 41.5 20C41.5 20 41.1278 17.4062 40.0777 16.2384C39.1547 15.212 37 14.5 37 14.5C37 14.5 39.1547 13.788 40.0777 12.7616C41.1278 11.5938 41.5 9 41.5 9Z'
          fill='white'
        />
      </g>
      <defs>
        <filter
          id='filter0_f_44062_5615'
          x='1.69385'
          y='5.92773'
          width='41.6123'
          height='41.1445'
          filterUnits='userSpaceOnUse'
          colorInterpolationFilters='sRGB'
        >
          <feFlood floodOpacity='0' result='BackgroundImageFix' />
          <feBlend
            mode='normal'
            in='SourceGraphic'
            in2='BackgroundImageFix'
            result='shape'
          />
          <feGaussianBlur
            stdDeviation='5'
            result='effect1_foregroundBlur_44062_5615'
          />
        </filter>
        <linearGradient
          id='paint0_linear_44062_5615'
          x1='38.6806'
          y1='38.1944'
          x2='14.375'
          y2='15.8333'
          gradientUnits='userSpaceOnUse'
        >
          <stop offset='0.00343646' stopColor='white' />
          <stop offset='1' stopColor='white' stopOpacity='0.8' />
        </linearGradient>
        <linearGradient
          id='paint1_linear_44062_5615'
          x1='27.5'
          y1='5'
          x2='27.5'
          y2='50'
          gradientUnits='userSpaceOnUse'
        >
          <stop stopColor='white' />
          <stop offset='1' stopColor='white' stopOpacity='0.5' />
        </linearGradient>
        <clipPath id='clip0_44062_5615'>
          <rect width='54' height='54' fill='white' />
        </clipPath>
      </defs>
    </svg>
  )
}

export const FilledTooltipIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns='http://www.w3.org/2000/svg'
    viewBox='0 0 20 20'
    fill='none'
    {...props}
  >
    {/* <title className='sr-only'>Tooltip</title> */}
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M16.25 10C16.25 13.4518 13.4518 16.25 10 16.25C6.54822 16.25 3.75 13.4518 3.75 10C3.75 6.54822 6.54822 3.75 10 3.75C13.4518 3.75 16.25 6.54822 16.25 10ZM8.75 6.66667C8.75 6.20643 9.1231 5.83333 9.58333 5.83333H10.4167C10.8769 5.83333 11.25 6.20643 11.25 6.66667V9.58333C11.25 10.0436 10.8769 10.4167 10.4167 10.4167H9.58333C9.1231 10.4167 8.75 10.0436 8.75 9.58333V6.66667ZM9.58333 11.6667C9.1231 11.6667 8.75 12.0398 8.75 12.5V13.3333C8.75 13.7936 9.1231 14.1667 9.58333 14.1667H10.4167C10.8769 14.1667 11.25 13.7936 11.25 13.3333V12.5C11.25 12.0398 10.8769 11.6667 10.4167 11.6667H9.58333Z'
      fill='currentColor'
      fillOpacity='0.75'
    />
  </svg>
)
