export default {
  // 登錄頁面相關提示文本
  'login.requiredUsername': '用戶名不能為空',
  'login.requiredPassword': '密碼不能為空',
  'login.requiredCaptcha': '驗證碼不能為空',
  'login.requiredMobile': '請輸入正確的手機號碼',
  'login.loginSuccess': '登錄成功！',

  // HeaderBar组件文本
  'header.smartManagement': '智能體管理',
  'header.modelConfig': '模型配置',
  'header.userManagement': '用戶管理',
  'header.voiceCloneManagement': '音色克隆',
  'header.voiceResourceManagement': '音色資源',
  'header.otaManagement': 'OTA管理',
  'header.paramDictionary': '參數字典',
  'header.paramManagement': '參數管理',
  'header.dictManagement': '字典管理',
  'header.agentTemplate': '預設角色模板', 
  'header.searchHistory': '搜索歷史',
  'header.clearHistory': '清空歷史',
  'header.providerManagement': '字段管理',
  'header.serverSideManagement': '服務端管理',
  'header.changePassword': '修改密碼',
  'header.logout': '退出登錄',
  'header.searchPlaceholder': '輸入名稱搜索..',

  // McpToolCallDialog组件文本
  'mcpToolCall.title': '工具調用',
  'mcpToolCall.execute': '執行',
  'mcpToolCall.chooseFunction': '1、選擇功能',
  'mcpToolCall.searchFunction': '搜索功能',
  'mcpToolCall.noResults': '未找到匹配的功能',
  'mcpToolCall.settings': '2、參數設置',
  'mcpToolCall.inputPlaceholder': '請輸入{label}',
  'mcpToolCall.valueRange': '取值範圍：{min} - {max}',
  'mcpToolCall.selectPlaceholder': '請選擇{label}',
  'mcpToolCall.lightTheme': '淺色主題',
  'mcpToolCall.darkTheme': '深色主題',
  'mcpToolCall.pleaseSelect': '請選擇一個功能',
  'mcpToolCall.cancel': '取消',
  'mcpToolCall.requiredField': '請輸入{field}',
  'mcpToolCall.minValue': '最小值為{value}',
  'mcpToolCall.maxValue': '最大值為{value}',
  'mcpToolCall.selectTool': '請選擇要執行的工具',
  'mcpToolCall.executionResult': '3、執行結果',
  'mcpToolCall.copyResult': '複製結果',
  'mcpToolCall.noResultYet': '暫無執行結果',
  'mcpToolCall.loadingToolList': '正在獲取工具列表...',

  // 工具名稱
  'mcpToolCall.toolName.getDeviceStatus': '查看設備狀態',
  'mcpToolCall.toolName.setVolume': '設置音量',
  'mcpToolCall.toolName.setBrightness': '設置亮度',
  'mcpToolCall.toolName.setTheme': '設置主題',
  'mcpToolCall.toolName.takePhoto': '拍照識別',
  'mcpToolCall.toolName.getSystemInfo': '系統資訊',
  'mcpToolCall.toolName.reboot': '重啟設備',
  'mcpToolCall.toolName.upgradeFirmware': '升級固件',
  'mcpToolCall.toolName.getScreenInfo': '螢幕資訊',
  'mcpToolCall.toolName.snapshot': '螢幕截圖',
  'mcpToolCall.toolName.previewImage': '預覽圖片',
  'mcpToolCall.toolName.setDownloadUrl': '設置下載地址',

  // 工具分類
  'mcpToolCall.category.audio': '音頻',
  'mcpToolCall.category.display': '顯示',
  'mcpToolCall.category.camera': '拍攝',
  'mcpToolCall.category.system': '系統',
  'mcpToolCall.category.assets': '資源',
  'mcpToolCall.category.deviceInfo': '設備資訊',

  // 表格分類和屬性
  'mcpToolCall.table.audioSpeaker': '音頻揚聲器',
  'mcpToolCall.table.screen': '螢幕',
  'mcpToolCall.table.network': '網路',
  'mcpToolCall.table.audioControl': '音頻控制',
  'mcpToolCall.table.screenControl': '螢幕控制',
  'mcpToolCall.table.systemControl': '系統控制',
  'mcpToolCall.table.screenInfo': '螢幕資訊',
  'mcpToolCall.table.hardwareInfo': '硬體資訊',
  'mcpToolCall.table.memoryInfo': '記憶體資訊',
  'mcpToolCall.table.applicationInfo': '應用資訊',
  'mcpToolCall.table.networkInfo': '網路資訊',
  'mcpToolCall.table.displayInfo': '顯示資訊',
  'mcpToolCall.table.deviceInfo': '設備資訊',
  'mcpToolCall.table.systemInfo': '系統資訊',
  // 表格列標題
  'mcpToolCall.table.component': '組件',
  'mcpToolCall.table.property': '屬性',
  'mcpToolCall.table.value': '值',

  'mcpToolCall.prop.volume': '音量',
  'mcpToolCall.prop.brightness': '亮度',
  'mcpToolCall.prop.theme': '主題',
  'mcpToolCall.prop.type': '類型',
  'mcpToolCall.prop.ssid': 'SSID',
  'mcpToolCall.prop.signalStrength': '信號強度',
  'mcpToolCall.prop.operationResult': '操作結果',
  'mcpToolCall.prop.width': '寬度',
  'mcpToolCall.prop.height': '高度',
  'mcpToolCall.prop.screenType': '類型',
  'mcpToolCall.prop.chipModel': '晶片型號',
  'mcpToolCall.prop.cpuCores': 'CPU核心數',
  'mcpToolCall.prop.chipVersion': '晶片版本',
  'mcpToolCall.prop.flashSize': 'Flash大小',
  'mcpToolCall.prop.minFreeHeap': '最小可用堆',
  'mcpToolCall.prop.applicationName': '應用名稱',
  'mcpToolCall.prop.applicationVersion': '應用版本',
  'mcpToolCall.prop.compileTime': '編譯時間',
  'mcpToolCall.prop.idfVersion': 'IDF版本',
  'mcpToolCall.prop.macAddress': 'MAC地址',
  'mcpToolCall.prop.ipAddress': 'IP地址',
  'mcpToolCall.prop.wifiName': 'WiFi名稱',
  'mcpToolCall.prop.wifiChannel': 'WiFi信道',
  'mcpToolCall.prop.screenSize': '螢幕尺寸',
  'mcpToolCall.prop.deviceUuid': '設備UUID',
  'mcpToolCall.prop.systemLanguage': '系統語言',
  'mcpToolCall.prop.currentOtaPartition': '當前OTA分區',
  'mcpToolCall.prop.getResult': '獲取結果',
  'mcpToolCall.prop.url': 'URL',
  'mcpToolCall.prop.quality': '品質',
  'mcpToolCall.prop.question': '問題',

  // 工具幫助文本
  'mcpToolCall.help.getDeviceStatus': '查看設備的當前運行狀態，包括音量、螢幕、電池等資訊。',
  'mcpToolCall.help.setVolume': '調整設備的音量大小，請輸入0-100之間的數值。',
  'mcpToolCall.help.setBrightness': '調整設備螢幕的亮度，請輸入0-100之間的數值。',
  'mcpToolCall.help.setTheme': '切換設備螢幕的顯示主題，可以選擇淺色或深色模式。',
  'mcpToolCall.help.takePhoto': '使用設備攝像頭拍攝照片並進行識別分析，請輸入要詢問的問題。',
  'mcpToolCall.help.getSystemInfo': '獲取設備的系統資訊，包括硬體規格、軟體版本等。',
  'mcpToolCall.help.reboot': '重啟設備，執行後設備將重新啟動。',
  'mcpToolCall.help.upgradeFirmware': '從指定URL下載並升級設備固件，升級後設備會自動重啟。',
  'mcpToolCall.help.getScreenInfo': '獲取螢幕的詳細資訊，如解析度、尺寸等參數。',
  'mcpToolCall.help.snapshot': '對當前螢幕進行截圖並上傳到指定URL。',
  'mcpToolCall.help.previewImage': '在設備螢幕上預覽指定URL的圖片。',
  'mcpToolCall.help.setDownloadUrl': '設置設備資源文件的下載地址。',

  // 其他文本
  'mcpToolCall.text.strong': '強',
  'mcpToolCall.text.medium': '中',
  'mcpToolCall.text.weak': '弱',
  'mcpToolCall.text.dark': '深色',
  'mcpToolCall.text.light': '淺色',
  'mcpToolCall.text.setSuccess': '設置成功',
  'mcpToolCall.text.setFailed': '設置失敗',
  'mcpToolCall.text.brightnessSetSuccess': '亮度設置成功',
  'mcpToolCall.text.brightnessSetFailed': '亮度設置失敗',
  'mcpToolCall.text.themeSetSuccess': '主題設置成功',
  'mcpToolCall.text.themeSetFailed': '主題設置失敗',
  'mcpToolCall.text.rebootCommandSent': '重啟指令已發送',
  'mcpToolCall.text.rebootFailed': '重啟失敗',
  'mcpToolCall.text.monochrome': '單色屏',
  'mcpToolCall.text.color': '彩色屏',
  'mcpToolCall.text.getSuccessParseFailed': '獲取成功，但解析失敗',
  'mcpToolCall.text.getFailed': '獲取失敗',
  'mcpToolCall.text.getSuccessFormatError': '獲取成功，但數據格式異常',

  // 字典數據對話框相關
  'dictDataDialog.addDictData': '新增字典數據',
  'dictDataDialog.dictLabel': '字典標籤',
  'dictDataDialog.dictLabelPlaceholder': '請輸入字典標籤',
  'dictDataDialog.dictValue': '字典值',
  'dictDataDialog.dictValuePlaceholder': '請輸入字典值',
  'dictDataDialog.sort': '排序',
  'dictDataDialog.requiredDictLabel': '請輸入字典標籤',
  'dictDataDialog.requiredDictValue': '請輸入字典值',

  // 字典類型對話框相關
  'dictTypeDialog.addDictType': '新增字典類型',
  'dictTypeDialog.dictName': '字典類型名稱',
  'dictTypeDialog.dictNamePlaceholder': '請輸入字典類型名稱',
  'dictTypeDialog.dictType': '字典類型編碼',
  'dictTypeDialog.dictTypePlaceholder': '請輸入字典類型編碼',
  'dictTypeDialog.requiredDictName': '請輸入字典類型名稱',
  'dictTypeDialog.requiredDictType': '請輸入字典類型編碼',

  // 音頻編輯對話框相關
  'editVoiceDialog.voiceCode': '音色編碼',
  'editVoiceDialog.voiceCodePlaceholder': '請輸入音色編碼',
  'editVoiceDialog.voiceName': '音色名稱',
  'editVoiceDialog.voiceNamePlaceholder': '請輸入音色名稱',
  'editVoiceDialog.languageType': '語言類型',
  'editVoiceDialog.languageTypePlaceholder': '請輸入語言類型',
  'editVoiceDialog.sortNumber': '排序號',
  'editVoiceDialog.remark': '備註',
  'editVoiceDialog.remarkPlaceholder': '請輸入備註內容',
  'editVoiceDialog.generatePreview': '生成試聽',
  'editVoiceDialog.defaultVoiceName': '灣灣小何',
  'editVoiceDialog.defaultLanguageType': '中文',
  'editVoiceDialog.requiredVoiceCode': '請輸入音色編碼',
  'editVoiceDialog.requiredVoiceName': '請輸入音色名稱',

  // 固件對話框相關
  'firmwareDialog.firmwareName': '固件名稱',
  'firmwareDialog.firmwareNamePlaceholder': '請輸入固件名稱(板子+版本號)',
  'firmwareDialog.firmwareType': '固件類型',
  'firmwareDialog.firmwareTypePlaceholder': '請選擇固件類型',
  'firmwareDialog.version': '版本號',
  'firmwareDialog.versionPlaceholder': '請輸入版本號(x.x.x格式)',
  'firmwareDialog.firmwareFile': '固件文件',
  'firmwareDialog.clickUpload': '點擊上傳',
  'firmwareDialog.uploadTip': '只能上傳固件文件(.bin/.apk)，且不超過100MB',
  'firmwareDialog.uploadHint': '溫馨提示：請上傳合併前的xiaozhi.bin文件，而不是合併後的merged-binary.bin文件',
  'firmwareDialog.remark': '備註',
  'firmwareDialog.remarkPlaceholder': '請輸入備註信息',
  'firmwareDialog.requiredFirmwareName': '請輸入固件名稱(板子+版本號)',
  'firmwareDialog.requiredFirmwareType': '請選擇固件類型',
  'firmwareDialog.requiredVersion': '請輸入版本號',
  'firmwareDialog.versionFormatError': '版本號格式不正確，請輸入x.x.x格式',
  'firmwareDialog.requiredFirmwareFile': '請上傳固件文件',
  'firmwareDialog.invalidFileType': '只能上傳.bin/.apk格式的固件文件!',
  'firmwareDialog.invalidFileSize': '固件文件大小不能超過100MB!',
  'firmwareDialog.uploadSuccess': '固件文件上傳成功',
  'firmwareDialog.uploadFailed': '文件上傳失敗',

  // 聲紋對話框相關
  'voicePrintDialog.addSpeaker': '添加說話人',
  'voicePrintDialog.voicePrintVector': '聲紋向量',
  'voicePrintDialog.selectVoiceMessage': '請選擇一條語言消息',
  'voicePrintDialog.name': '姓名',
  'voicePrintDialog.enterName': '請輸入姓名',
  'voicePrintDialog.description': '描述',
  'voicePrintDialog.enterDescription': '請輸入描述',
  'voicePrintDialog.save': '保存',
  'voicePrintDialog.cancel': '取消',
  'voicePrintDialog.requiredDescription': '請輸入描述',
  'voicePrintDialog.requiredName': '請輸入姓名',
  'voicePrintDialog.requiredAudioVector': '請選擇音頻向量',

  // 聲紋頁面相關
  'voicePrint.pageTitle': '聲紋識別',
  'voicePrint.name': '姓名',
  'voicePrint.description': '描述',
  'voicePrint.createTime': '創建時間',
  'voicePrint.action': '操作',
  'voicePrint.edit': '編輯',
  'voicePrint.delete': '刪除',
  'voicePrint.add': '新增',
  'voicePrint.addSpeaker': '添加說話人',
  'voicePrint.editSpeaker': '編輯說話人',
  'voicePrint.fetchFailed': '獲取聲紋列表失敗',
  'voicePrint.updateSuccess': '修改成功',
  'voicePrint.addSuccess': '新增成功',
  'voicePrint.confirmDelete': '確定要刪除選中的此聲紋嗎？',
  'voicePrint.warning': '警告',
  'voicePrint.confirm': '確定',
  'voicePrint.cancel': '取消',
  'voicePrint.deleteSuccess': '成功刪除此聲紋',
  'voicePrint.deleteFailed': '刪除失敗，請重試',
  'voicePrint.cancelDelete': '已取消刪除操作',
  'voicePrint.closeOperation': '操作已關閉',
  'voicePrint.loading': '拼命加載中',

  // 手動添加設備對話框相關
  'manualAddDeviceDialog.title': '手動添加設備',
  'manualAddDeviceDialog.deviceType': '設備型號',
  'manualAddDeviceDialog.deviceTypePlaceholder': '請選擇設備型號',
  'manualAddDeviceDialog.firmwareVersion': '固件版本',
  'manualAddDeviceDialog.firmwareVersionPlaceholder': '請輸入固件版本',
  'manualAddDeviceDialog.macAddress': 'Mac地址',
  'manualAddDeviceDialog.macAddressPlaceholder': '請輸入Mac地址',
  'manualAddDeviceDialog.confirm': '確定',
  'manualAddDeviceDialog.cancel': '取消',
  'manualAddDeviceDialog.requiredMacAddress': '請輸入Mac地址',
  'manualAddDeviceDialog.invalidMacAddress': '請輸入正確的Mac地址格式，例如：00:1A:2B:3C:4D:5E',
  'manualAddDeviceDialog.requiredDeviceType': '請選擇設備型號',
  'manualAddDeviceDialog.requiredFirmwareVersion': '請輸入固件版本',
  'manualAddDeviceDialog.getFirmwareTypeFailed': '獲取固件類型失敗',
  'manualAddDeviceDialog.addSuccess': '設備添加成功',
  'manualAddDeviceDialog.addFailed': '添加失敗',

  // AddModelDialog組件相關
  'addModelDialog.requiredSupplier': '請選擇供應器',

  // 註冊頁面相關
  'register.title': '建立帳號',
  'register.welcome': '歡迎使用小智慧AI',
  'register.usernamePlaceholder': '請輸入用戶名',
  'register.mobilePlaceholder': '請輸入手機號碼',
  'register.captchaPlaceholder': '請輸入驗證碼',
  'register.mobileCaptchaPlaceholder': '請輸入簡訊驗證碼',
  'register.passwordPlaceholder': '請設定密碼',
  'register.confirmPasswordPlaceholder': '請確認密碼',
  'register.goToLogin': '已有帳號？登錄',
  'register.registerButton': '註冊',
  'register.agreeTo': '註冊即表示您同意我們的',
  'register.userAgreement': '用戶協議',
  'register.privacyPolicy': '隱私政策',
  'register.notAllowRegister': '當前不允許用戶註冊',
  'register.captchaLoadFailed': '驗證碼加載失敗',
  'register.inputCaptcha': '請輸入驗證碼',
  'register.inputCorrectMobile': '請輸入正確的手機號碼',
  'register.captchaSendSuccess': '驗證碼發送成功',
  'register.captchaSendFailed': '驗證碼發送失敗',
  'register.passwordsNotMatch': '兩次輸入的密碼不一致',
  'register.secondsLater': '秒後',
  'register.registerSuccess': '註冊成功！',
  'register.registerFailed': '註冊失敗',
  'register.requiredUsername': '用戶名不能為空',
  'register.requiredPassword': '密碼不能為空',
  'register.requiredCaptcha': '驗證碼不能為空',
  'register.requiredMobileCaptcha': '請輸入簡訊驗證碼',
  'register.invalidCaptcha': '驗證碼不正確',
  'register.passwordLength': '密碼長度必須在6-20位之間',
  'register.usernameFormat': '用戶名格式不正確',
  'register.confirmPasswordRequired': '確認密碼不能為空',
  'register.sendCaptcha': '獲取驗證碼',

  // 參數對話框相關
  'paramDialog.paramCode': '參數編碼',
  'paramDialog.paramCodePlaceholder': '請輸入參數編碼',
  'paramDialog.paramValue': '參數值',
  'paramDialog.paramValuePlaceholder': '請輸入參數值',
  'paramDialog.valueType': '值類型',
  'paramDialog.valueTypePlaceholder': '請選擇值類型',
  'paramDialog.remark': '備註',
  'paramDialog.remarkPlaceholder': '請輸入備註',
  'paramDialog.save': '保存',
  'paramDialog.cancel': '取消',
  'paramDialog.requiredParamCode': '請輸入參數編碼',
  'paramDialog.requiredParamValue': '請輸入參數值',
  'paramDialog.requiredValueType': '請選擇值類型',
  'paramDialog.stringType': '字串(string)',
  'paramDialog.numberType': '數字(number)',
  'paramDialog.booleanType': '布林值(boolean)',
  'paramDialog.arrayType': '陣列(array)',
  'paramDialog.jsonType': 'JSON物件(json)',

  // 登录页面文本
  'login.title': '登錄',
  'login.welcome': 'WELCOME TO LOGIN',
  'login.username': '用戶名',
  'login.usernamePlaceholder': '請輸入用戶名',
  'login.mobilePlaceholder': '請輸入手機號碼',
  'login.password': '密碼',
  'login.passwordPlaceholder': '請輸入密碼',
  'login.captchaPlaceholder': '請輸入驗證碼',
  'login.loginButton': '登錄',
  'login.login': '登錄',
  'login.register': '新用戶註冊',
  'login.forgotPassword': '忘記密碼',
  'login.forgetPassword': '忘記密碼?',
  'login.mobileLogin': '手機號碼登錄',
  'login.usernameLogin': '用戶名登錄',
  'login.agreeTo': '登錄即同意',
  'login.userAgreement': '《用戶協議》',
  'login.and': '和',
  'login.privacyPolicy': '《隱私政策》',
  'login.registerAccount': '註冊賬號',

  // 忘记密码页面文本
  'retrievePassword.title': '重置密碼',
  'retrievePassword.welcome': '密碼找回',
  'retrievePassword.subtitle': '找回密碼',
  'retrievePassword.mobile': '手機號',
  'retrievePassword.mobilePlaceholder': '請輸入手機號碼',
  'retrievePassword.captcha': '驗證碼',
  'retrievePassword.captchaPlaceholder': '請輸入驗證碼',
  'retrievePassword.mobileCaptcha': '手機驗證碼',
  'retrievePassword.mobileCaptchaPlaceholder': '請輸入手機驗證碼',
  'retrievePassword.newPassword': '新密碼',
  'retrievePassword.newPasswordPlaceholder': '請輸入新密碼',
  'retrievePassword.confirmNewPassword': '確認新密碼',
  'retrievePassword.confirmNewPasswordPlaceholder': '請確認新密碼',
  'retrievePassword.getMobileCaptcha': '獲取驗證碼',
  'retrievePassword.resetButton': '重置密碼',
  'retrievePassword.updateButton': '立即修改',
  'retrievePassword.goToLogin': '返回登錄',
  'retrievePassword.inputCorrectMobile': '請輸入正確的手機號碼',
  'retrievePassword.captchaSendSuccess': '驗證碼發送成功',
  'retrievePassword.passwordsNotMatch': '兩次輸入的密碼不一致',
  'retrievePassword.passwordLength': '密碼長度必須在6-20位之間',
  'retrievePassword.mobileRequired': '手機號不能為空',
  'retrievePassword.captchaRequired': '驗證碼不能為空',
  'retrievePassword.mobileCaptchaRequired': '手機驗證碼不能為空',
  'retrievePassword.newPasswordRequired': '新密碼不能為空',
  'retrievePassword.confirmNewPasswordRequired': '確認新密碼不能為空',
  'retrievePassword.passwordUpdateSuccess': '密碼修改成功',
  'retrievePassword.agreeTo': '重置即同意',

  // 修改密码页面文本
  'changePassword.title': '修改密碼',
  'changePassword.oldPasswordLabel': '舊密碼：',
  'changePassword.oldPasswordPlaceholder': '請輸入舊密碼',
  'changePassword.newPasswordLabel': '新密碼：',
  'changePassword.newPasswordPlaceholder': '請輸入新密碼',
  'changePassword.confirmPasswordLabel': '確認新密碼：',
  'changePassword.confirmPasswordPlaceholder': '請再次輸入新密碼',
  'changePassword.confirmButton': '確定',
  'changePassword.cancelButton': '取消',
  'changePassword.allFieldsRequired': '請填寫所有字段',
  'changePassword.passwordsNotMatch': '兩次輸入的新密碼不一致',
  'changePassword.newPasswordSameAsOld': '新密碼不能與舊密碼相同',
  'changePassword.passwordChangedSuccessfully': '密碼修改成功，請重新登錄',
  'changePassword.changeFailed': '密碼修改失敗',

  // 设备管理页面文本
  'device.management': '設備管理',
  'device.add': '添加設備',
  'device.edit': '編輯設備',
  'device.delete': '刪除設備',
  'device.name': '設備名稱',
  'device.type': '設備類型',
  'device.status': '設備狀態',
  'device.dialogTitle': '添加設備',
  'device.verificationCode': '驗證碼：',
  'device.verificationCodePlaceholder': '請輸入設備播報的6位數驗證碼..',
  'device.confirmButton': '確定',
  'device.cancelButton': '取消',
  'device.input6DigitCode': '請輸入6位數字驗證碼',
  'device.bindSuccess': '設備綁定成功',
  'device.bindFailed': '綁定失敗',
  'device.searchPlaceholder': '請輸入設備型號或Mac地址查詢',
  'device.model': '設備型號',
  'device.macAddress': 'Mac地址',
  'device.firmwareVersion': '固件版本',
  'device.bindTime': '綁定時間',
  'device.lastConversation': '最後對話',
  'device.remark': '備註',
  'device.autoUpdate': '自動升級',
  'device.operation': '操作',
  'device.search': '搜索',
  'device.selectAll': '全選/取消全選',
  'deviceManagement.loading': '拼命加載中',
  'device.bindWithCode': '6位驗證碼綁定',
  'device.manualAdd': '手動添加',
  'device.unbind': '解綁',
  'device.toolCall': '工具調用',
  'device.selectAtLeastOne': '請至少選擇一條記錄',
  'device.confirmBatchUnbind': '確認要解綁選中的 {count} 台設備嗎？',
  'device.batchUnbindSuccess': '成功解綁 {count} 台設備',
  'device.batchUnbindError': '批量解綁過程中出現錯誤',
  'device.remarkTooLong': '備註不能超過 64 字符',
  'device.remarkSaved': '備註已保存',
  'device.remarkSaveFailed': '備註保存失敗',
  'device.confirmUnbind': '確認要解綁該設備嗎？',
  'device.unbindSuccess': '設備解綁成功',
  'device.unbindFailed': '設備解綁失敗',
  'device.getListFailed': '獲取設備列表失敗',
  'device.autoUpdateEnabled': '已設置成自動升級',
  'device.autoUpdateDisabled': '已關閉自動升級',
  'device.batchUnbindSuccess': '成功解綁 {count} 台設備',
  'device.getFirmwareTypeFailed': '獲取固件類型失敗',
  'device.deviceStatus': '狀態',
  'device.online': '在線',
  'device.offline': '離線',

  // 消息提示
  'message.success': '操作成功',
  'message.error': '操作失敗',
  'message.warning': '警告',
  'message.info': '提示',

  // 缓存相关
  'cache.viewer': '緩存查看器',

  // 聊天历史对话框相关
  'chatHistory.with': '與',
  'chatHistory.dialogTitle': '的聊天記錄',
  'chatHistory.loading': '加載中...',
  'chatHistory.noMoreRecords': '沒有更多記錄了',
  'chatHistory.selectSession': '請選擇會話查看聊天記錄',
  'chatHistory.today': '今天',
  'chatHistory.yesterday': '昨天',
  'chatHistory.downloadCurrentSession': '下載本會話聊天記錄',
  'chatHistory.downloadCurrentWithPreviousSessions': '下載本會話及前20條會話聊天記錄',
  'chatHistory.downloadLinkFailed': '獲取下載鏈接失敗',

  'cache.status': '緩存狀態',
  'cache.cdnEnabled': 'CDN模式已啟用',
  'cache.cdnDisabled': 'CDN模式已禁用',
  'cache.serviceWorkerRegistered': 'Service Worker已註冊',
  'cache.serviceWorkerNotRegistered': 'Service Worker未註冊',
  'cache.noCacheDetected': '還未檢測到緩存，請刷新頁面或等待緩存建立',
  'cache.swDevEnvWarning': '在開發環境中，Service Worker可能無法正常初始化緩存',
  'cache.swCheckMethods': '請嘗試以下方法檢查Service Worker是否生效:',
  'cache.swCheckMethod1': '在開發者工具的Application/Application標籤頁中查看Service Worker狀態',
  'cache.swCheckMethod2': '在開發者工具的Application/Cache/Cache Storage中查看緩存內容',
  'cache.swCheckMethod3': '使用生產構建(npm run build)並通過HTTP服務器訪問以測試完整功能',
  'cache.swDevEnvNormal': '在開發環境中，這是正常現象',
  'cache.swProdOnly': 'Service Worker通常只在生產環境中生效',
  'cache.swTestingTitle': '要測試Service Worker功能:',
  'cache.swTestingStep1': '運行npm run build構建生產版本',
  'cache.swTestingStep2': '通過HTTP服務器訪問構建後的頁面',
  'cache.swNotSupported': '當前瀏覽器不支持Service Worker，CDN資源緩存功能不可用',
  'cache.dialogTitle': 'CDN資源緩存狀態',
  'cache.loading': '正在加載緩存資訊...',
  'cache.notSupported': '您的瀏覽器不支援Cache API或Service Worker未安裝',
  'cache.refreshPage': '刷新頁面',
  'cache.noCachedResources': '未發現緩存的CDN資源',
  'cache.noCachedResourcesDesc': 'Service Worker可能尚未完成初始化或緩存尚未建立。請刷新頁面或等待一會後再試。',
  'cache.cdnCacheStatus': 'CDN資源緩存狀態',
  'cache.totalCachedResources': '共發現 {count} 個緩存資源',
  'cache.jsResources': 'JavaScript 資源 ({count})',
  'cache.cssResources': 'CSS 資源 ({count})',
  'cache.cached': '已緩存',
  'cache.notCached': '未緩存',
  'cache.refreshStatus': '刷新緩存狀態',
  'cache.clearCache': '清除緩存',
  'cache.refreshingStatus': '正在刷新緩存狀態',
  'cache.confirmClear': '確定要清除所有緩存嗎?',
  'cache.clearedSuccess': '緩存已清除',
  'cache.clearFailed': '清除緩存失敗',
  'cache.clearCanceled': '已取消清除',

  // 通用按钮
  'button.ok': '確定',
  'button.cancel': '取消',
  'button.save': '保存',
  'button.close': '關閉',

  // 系统信息
  'system.name': '小智服務',

  // 声纹相关
  'voiceprint.management': '聲紋管理',
  'voiceprint.add': '添加聲紋',
  'voiceprint.delete': '刪除聲紋',

  // 字典管理頁面文本
  'dictManagement.pageTitle': '字典管理',
  'dictManagement.searchPlaceholder': '請輸入字典值標籤查詢',
  'dictManagement.search': '搜索',
  'dictManagement.dictTypeName': '字典類型名稱',
  'dictManagement.operation': '操作',
  'dictManagement.edit': '編輯',
  'dictManagement.dictLabel': '字典標籤',
  'dictManagement.dictValue': '字典值',
  'dictManagement.sort': '排序',
  'dictManagement.delete': '刪除',
  'dictManagement.selectAll': '全選',
  'dictManagement.deselectAll': '取消全選',
  'dictManagement.addDictType': '新增字典類型',
  'dictManagement.batchDeleteDictType': '批量刪除字典類型',
  'dictManagement.addDictData': '新增字典數據',
  'dictManagement.batchDeleteDictData': '批量刪除字典數據',
  'dictManagement.itemsPerPage': '{items}條/頁',
  'dictManagement.firstPage': '首頁',
  'dictManagement.prevPage': '上一頁',
  'dictManagement.nextPage': '下一頁',
  'dictManagement.totalRecords': '共{total}條記錄',
  'dictManagement.editDictType': '編輯字典類型',
  'dictManagement.editDictData': '編輯字典數據',
  'dictManagement.saveSuccess': '保存成功',
  'dictManagement.deleteSuccess': '刪除成功',
  'dictManagement.selectDictTypeToDelete': '請選擇要刪除的字典類型',
  'dictManagement.confirmDeleteDictType': '確定要刪除選中的字典類型嗎?',
  'dictManagement.confirm': '確定',
  'dictManagement.cancel': '取消',
  'dictManagement.selectDictTypeFirst': '請先選擇字典類型',
  'dictManagement.confirmDeleteDictData': '確定要刪除該字典數據嗎?',
  'dictManagement.selectDictDataToDelete': '請選擇要刪除的字典數據',
  'dictManagement.confirmBatchDeleteDictData': '確定要刪除選中的{count}個字典數據嗎?',
  'dictManagement.getDictDataFailed': '獲取字典數據失敗',

  // 用户信息
  'user.info': '用戶信息',
  'user.username': '用戶名',
  'user.mobile': '手機號',
  'user.userid': '用戶Id',
  'user.deviceCount': '設備數量',
  'user.createDate': '註冊時間',
  'user.status': '狀態',
  'user.normal': '正常',
  'user.disabled': '禁用',
  'user.resetPassword': '重置密碼',
  'user.disableAccount': '禁用帳戶',
  'user.enableAccount': '恢復帳號',
  'user.deleteUser': '刪除用戶',
  'user.deselectAll': '取消全選',
  'user.selectAll': '全選',
  'user.enable': '啟用',
  'user.disable': '禁用',
  'user.delete': '刪除',
  'user.selectUsersFirst': '請先選擇需要刪除的用戶',
  'user.confirmDeleteSelected': '確定要刪除選中的{count}個用戶嗎？',
  'user.deleting': '正在刪除中...',
  'user.deleteSuccess': '成功刪除{count}個用戶',
  'user.deleteFailed': '刪除失敗，請重試',
  'user.partialDelete': '成功刪除{successCount}個用戶，{failCount}個刪除失敗',
  'user.deleteError': '刪除過程中發生錯誤',
  'user.deleteCancelled': '已取消刪除',
  'user.confirmResetPassword': '重置後將會生成新密碼，是否繼續？',
  'user.resetPasswordSuccess': '密碼已重置，請通知用戶使用新密碼登錄',
  'user.generatedPassword': '生成的默認密碼',
  'user.confirmDeleteUser': '確定要刪除該用戶嗎？',
  'user.deleteUserSuccess': '刪除成功',
  'user.operationFailed': '操作失敗，請重試',
  'user.confirmStatusChange': '確定要{action}選中的{count}個用戶嗎？',
  'user.statusChangeSuccess': '成功{action}{count}個用戶',
  'user.invalidUserId': '存在無效的用戶ID',
  'user.searchPhone': '請輸入手機號碼查詢',
  'user.search': '搜索',

  // 字段管理頁面文本
  'providerManagement.categoryFilter': '類別篩選',
  'providerManagement.searchPlaceholder': '請輸入供應器名稱查詢',
  'providerManagement.category': '類別',
  'providerManagement.providerCode': '供應器編碼',
  'providerManagement.fieldConfig': '字段配置',
  'providerManagement.selectToDelete': '請先選擇需要刪除的供應器',
  'providerManagement.confirmDelete': '確定要刪除選中的{count}個供應器嗎？',
  'providerManagement.viewFields': '查看字段',

  // 公共文本
  'common.all': '全部',
  'common.search': '搜索',
  'common.name': '名稱',
  'common.sort': '排序',
  'common.action': '操作',
  'common.edit': '編輯',
  'common.delete': '刪除',
  'common.selectAll': '全選',
  'common.deselectAll': '取消全選',
  'common.add': '新增',
  'common.perPage': '{number}條/頁',
  'common.firstPage': '首頁',
  'common.prevPage': '上一頁',
  'common.nextPage': '下一頁',
  'common.totalRecords': '共{number}條記錄',
  'common.addProvider': '新增供應器',
  'common.success': '成功',
  'common.editProvider': '編輯供應器',
  'common.updateSuccess': '修改成功',
  'common.addSuccess': '新增成功',
  'common.deleteSuccess': '刪除成功',
  'common.deleteFailure': '刪除失敗，請重試',
  'common.deleteCancelled': '已取消刪除',
  'common.warning': '警告',
  'common.tip': '提示',
  'common.confirm': '確定',
  'common.cancel': '取消',
  'common.sensitive': '敏感',

  // 語言切換
  'language.zhCN': '中文简体',
  'language.zhTW': '中文繁體',
  'language.en': 'English',

  // 首頁文本
  'home.addAgent': '添加智能體',
  'home.greeting': '你好小智',
  'home.wish': '讓我們度過美好的一天！',
  'home.languageModel': '語言模型',
  'home.voiceModel': '音色模型',
  'home.configureRole': '配置角色',
  'home.voiceprintRecognition': '聲紋識別',
  'home.deviceManagement': '設備管理',
  'home.chatHistory': '聊天記錄',
  'home.lastConversation': '最近對話',
  'home.noConversation': '暫未對話',
  'home.justNow': '剛剛',
  'home.minutesAgo': '{minutes}分鐘前',
  'home.hoursAgo': '{hours}小時{minutes}分鐘前',
  'home.confirmDeleteAgent': '確定要刪除該智能體嗎？',
  'home.deleteSuccess': '刪除成功',
  'home.deleteFailed': '刪除失敗',
  'home.enableMemory': '請先在「配置角色」介面開啟記憶',

  // 參數管理頁面文本
  'paramManagement.pageTitle': '參數管理',
  'paramManagement.searchPlaceholder': '請輸入參數編碼或備註查詢',
  'paramManagement.search': '搜索',
  'paramManagement.paramCode': '參數編碼',
  'paramManagement.paramValue': '參數值',
  'paramManagement.remark': '備註',
  'paramManagement.operation': '操作',
  'paramManagement.hide': '隱藏',
  'paramManagement.view': '查看',
  'paramManagement.deselectAll': '取消全選',
  'paramManagement.selectAll': '全選',
  'paramManagement.add': '新增',
  'paramManagement.delete': '刪除',
  'paramManagement.edit': '編輯',
  'paramManagement.itemsPerPage': '條/頁',
  'paramManagement.firstPage': '首頁',
  'paramManagement.prevPage': '上一頁',
  'paramManagement.nextPage': '下一頁',
  'paramManagement.totalRecords': '共{total}條記錄',
  'paramManagement.addParam': '新增參數',
  'paramManagement.editParam': '編輯參數',
  'paramManagement.getParamsListFailed': '獲取參數列表失敗',
  'paramManagement.selectParamsFirst': '請先選擇需要刪除的參數',
  'paramManagement.confirmBatchDelete': '確定要刪除選中的{paramCount}個參數嗎？',
  'paramManagement.invalidParamId': '存在無效的參數ID',
  'paramManagement.batchDeleteSuccess': '成功刪除{paramCount}個參數',
  'paramManagement.deleteFailed': '刪除失敗，請重試',
  'paramManagement.operationCancelled': '已取消刪除操作',
  'paramManagement.operationClosed': '操作已關閉',
  'paramManagement.updateSuccess': '修改成功',
  'paramManagement.addSuccess': '新增成功',
  'paramManagement.updateFailed': '更新失敗',
  'paramManagement.addFailed': '新增失敗',

  // 服務端管理頁面文本
  'serverSideManager.pageTitle': '服務端管理',
  'serverSideManager.wsAddress': 'ws地址',
  'serverSideManager.operation': '操作',
  'serverSideManager.restart': '重啟',
  'serverSideManager.updateConfig': '更新配置',
  'serverSideManager.restartServer': '重啟服務端',
  'serverSideManager.updateConfigTitle': '更新配置',
  'serverSideManager.confirmRestart': '確定要重啟服務端嗎？',
  'serverSideManager.confirmUpdateConfig': '確定要更新配置嗎？',
  'serverSideManager.loading': '拼命加載中',
  'serverSideManager.getServerListFailed': '獲取服務端列表失敗',
  'serverSideManager.operationFailed': '操作失敗',
  'serverSideManager.restartSuccess': '重啟成功',
  'serverSideManager.updateConfigSuccess': '更新配置成功',

  // 添加智能體對話框文本
  'addAgentDialog.title': '添加智能體',
  'addAgentDialog.agentName': '智能體名稱',
  'addAgentDialog.placeholder': '請輸入智能體名稱..',
  'addAgentDialog.confirm': '確定',
  'addAgentDialog.cancel': '取消',
  'addAgentDialog.nameRequired': '請輸入智能體名稱',
  'addAgentDialog.addSuccess': '添加成功',

  // 角色配置頁面文本
  'roleConfig.title': '角色配置',
  'roleConfig.restartNotice': '保存配置後，需要重啟設備，新的配置才會生效。',
  'roleConfig.saveConfig': '保存配置',
  'roleConfig.reset': '重置',
  'roleConfig.agentName': '助手暱稱',
  'roleConfig.roleTemplate': '角色模版',
  'roleConfig.roleIntroduction': '角色介紹',
  'roleConfig.languageCode': '語言編碼',
  'roleConfig.interactionLanguage': '交互語種',
  'roleConfig.vad': '語音活動檢測(VAD)',
  'roleConfig.asr': '語音識別(ASR)',
  'roleConfig.llm': '大語言模型(LLM)',
  'roleConfig.vllm': '視覺大模型(VLLM)',
  'roleConfig.tts': '語音合成(TTS)',
  'roleConfig.memoryHis': '記憶',
  'roleConfig.memory': '記憶模式',
  'roleConfig.intent': '意圖識別(Intent)',
  'roleConfig.voiceType': '聲音音色(Voice)',
  'roleConfig.pleaseEnterContent': '請輸入內容',
  'roleConfig.pleaseEnterLangCode': '請輸入語言編碼，如：zh_TW',
  'roleConfig.pleaseEnterLangName': '請輸入交互語種，如：繁體中文',
  'roleConfig.pleaseSelect': '請選擇',
  'roleConfig.editFunctions': '編輯功能',
  'roleConfig.reportText': '上報文字',
  'roleConfig.reportTextVoice': '上報文字+語音',
  'roleConfig.saveSuccess': '配置保存成功',
  'roleConfig.saveFailed': '配置保存失敗',
  'roleConfig.confirmReset': '確定要重置配置嗎？',
  'roleConfig.resetSuccess': '配置已重置',
  'roleConfig.fetchTemplatesFailed': '獲取模板列表失敗',
  'roleConfig.templateApplied': '模板已應用',
  'roleConfig.applyTemplateFailed': '應用模板失敗',
  'roleConfig.fetchConfigFailed': '獲取配置失敗',
  'roleConfig.fetchModelsFailed': '獲取模型列表失敗',
  'roleConfig.fetchPluginsFailed': '獲取插件列表失敗',

  // 功能管理對話框文本
  'functionDialog.title': '功能管理',
  'functionDialog.unselectedFunctions': '未選功能',
  'functionDialog.selectedFunctions': '已選功能',
  'functionDialog.selectAll': '全選',
  'functionDialog.noMorePlugins': '沒有更多的插件了',
  'functionDialog.pleaseSelectPlugin': '請選擇插件功能',
  'functionDialog.paramConfig': '參數配置',
  'functionDialog.noNeedToConfig': ' 無需配置參數',
  'functionDialog.pleaseSelectFunctionForParam': '請選擇已配置的功能進行參數設置',
  'functionDialog.mcpAccessPoint': 'MCP接入點',
  'functionDialog.mcpAddressDesc': '以下是智能體的MCP接入點地址。',
  'functionDialog.howToDeployMcp': '如何部署MCP接入點',
  'functionDialog.howToIntegrateMcp': '如何接入MCP功能',
  'functionDialog.copy': '複製',
  'functionDialog.accessPointStatus': '接入點狀態',
  'functionDialog.connected': '已連接',
  'functionDialog.loading': '加載中...',
  'functionDialog.disconnected': '未連接',
  'functionDialog.refresh': '刷新',
  'functionDialog.noAvailableTools': '暫無可用工具',
  'functionDialog.cancel': '取消',
  'functionDialog.saveConfig': '保存配置',
  'functionDialog.copiedToClipboard': '已複製到剪貼簿',
  'functionDialog.copyFailed': '複製失敗，請手動複製',
  'functionDialog.jsonFormatError': '的字段格式錯誤：JSON格式有誤',
  'functionDialog.defaultValue': '默認值',

  // 模型配置頁面文本
  'modelConfig.searchPlaceholder': '請輸入模型名稱查詢',
  'modelConfig.search': '搜索',
  'modelConfig.vad': '語言活動檢測',
  'modelConfig.asr': '語音識別',
  'modelConfig.llm': '大語言模型',
  'modelConfig.vllm': '視覺大語言模型',
  'modelConfig.intent': '意圖識別',
  'modelConfig.tts': '語音合成',
  'modelConfig.memory': '記憶',
  'modelConfig.modelId': '模型ID',
  'modelConfig.modelName': '模型名稱',
  'modelConfig.provider': '提供商',
  'modelConfig.unknown': '未知',
  'modelConfig.isEnabled': '是否啟用',
  'modelConfig.isDefault': '是否默認',
  'modelConfig.action': '操作',
  'modelConfig.voiceManagement': '音色管理',
  'modelConfig.edit': '修改',
  'modelConfig.duplicate': '創建副本',
  'modelConfig.delete': '刪除',
  'modelConfig.deselectAll': '取消全選',
  'modelConfig.select': '選擇',
  'modelConfig.selectAll': '全選',
  'modelConfig.add': '新增',
  'modelConfig.selectModelsFirst': '請先選擇要刪除的模型',
  'modelConfig.confirmBatchDelete': '確定要刪除選中的模型嗎?',
  'modelConfig.confirmDelete': '確定要刪除該模型嗎?',
  'modelConfig.batchDeleteSuccess': '批量刪除成功',
  'modelConfig.partialDeleteFailed': '部分刪除失敗',
  'modelConfig.deleteSuccess': '刪除成功',
  'modelConfig.deleteFailed': '刪除失敗',
  'modelConfig.duplicateSuccess': '創建副本成功',
  'modelConfig.duplicateFailed': '創建副本失敗',
  'modelConfig.saveSuccess': '保存成功',
  'modelConfig.saveFailed': '保存失敗',
  'modelConfig.addSuccess': '新增成功',
  'modelConfig.addFailed': '新增失敗',
  'modelConfig.fetchModelsFailed': '獲取模型列表失敗',
  'modelConfig.enableSuccess': '啟用成功',
  'modelConfig.disableSuccess': '禁用成功',
  'modelConfig.operationFailed': '操作失敗',
  'modelConfig.setDefaultSuccess': '設置默認模型成功',
  'modelConfig.itemsPerPage': '{items}條/頁',
  'modelConfig.firstPage': '首頁',
  'modelConfig.prevPage': '上一頁',
  'modelConfig.nextPage': '下一頁',
  'modelConfig.totalRecords': '共{total}條記錄',
  'modelConfig.loading': '拼命加載中',

  // 模型配置對話框文本
  'modelConfigDialog.addModel': '添加模型',
  'modelConfigDialog.editModel': '修改模型',
  'modelConfigDialog.duplicateModel': '建立副本',
  'modelConfigDialog.copySuffix': '_副本',
  'modelConfigDialog.modelInfo': '模型信息',
  'modelConfigDialog.enable': '是否啟用',
  'modelConfigDialog.setDefault': '設為默認',
  'modelConfigDialog.modelName': '模型名稱',
  'modelConfigDialog.enterModelName': '請輸入模型名稱',
  'modelConfigDialog.modelCode': '模型編碼',
  'modelConfigDialog.enterModelCode': '請輸入模型編碼',
  'modelConfigDialog.supplier': '供應器',
  'modelConfigDialog.selectSupplier': '請選擇',
  'modelConfigDialog.sortOrder': '排序號',
  'modelConfigDialog.enterSortOrder': '請輸入排序號',
  'modelConfigDialog.docLink': '文檔地址',
  'modelConfigDialog.enterDocLink': '請輸入文檔地址',
  'modelConfigDialog.remark': '備註',
  'modelConfigDialog.enterRemark': '請輸入模型備註',
  'modelConfigDialog.callInfo': '調用信息',
  'modelConfigDialog.enterJsonExample': '請輸入JSON格式變量(示例:{"key":"value"})',
  'modelConfigDialog.save': '保存',

  // TTS模型配置文本
  'ttsModel.select': '選擇',
  'ttsModel.voiceCode': '音色編碼',
  'ttsModel.voiceName': '音色名稱',
  'ttsModel.languageType': '語言類型',
  'ttsModel.preview': '試聽',
  'ttsModel.enterMp3Url': '請輸入MP3地址',
  'ttsModel.remark': '備註',
  'ttsModel.enterRemark': '這裡是備註',
  'ttsModel.referenceAudioPath': '克隆音頻路徑',
  'ttsModel.enterReferenceAudio': '這裡是克隆音頻路徑',
  'ttsModel.referenceText': '克隆音頻文本',
  'ttsModel.enterReferenceText': '這裡是克隆音頻對應文本',
  'ttsModel.action': '操作',
  'ttsModel.operation': '操作',
  'ttsModel.edit': '編輯',
  'ttsModel.delete': '刪除',
  'ttsModel.save': '保存',
  'ttsModel.deselectAll': '取消全選',
  'ttsModel.selectAll': '全選',
  'ttsModel.add': '新增',
  'ttsModel.fetchVoicesFailed': '獲取音色列表失敗',
  'ttsModel.loadVoicesFailed': '加載音色數據失敗',
  'ttsModel.unnamedVoice': '未命名音色',
  'ttsModel.finishEditingFirst': '請先完成目前編輯',
  'ttsModel.selectVoiceToDelete': '請選擇要刪除的音色',
  'ttsModel.operationFailed': '操作失敗',
  'ttsModel.operationClosed': '操作已關閉',

  // OTA管理頁面文本
  'otaManagement.firmwareManagement': '固件管理',
  'otaManagement.searchPlaceholder': '請輸入固件名稱查詢',
  'otaManagement.search': '搜索',
  'otaManagement.firmwareName': '固件名稱',
  'otaManagement.firmwareType': '固件類型',
  'otaManagement.version': '版本號',
  'otaManagement.fileSize': '文件大小',
  'otaManagement.remark': '備註',
  'otaManagement.createTime': '創建時間',
  'otaManagement.updateTime': '更新時間',
  'otaManagement.action': '操作',
  'otaManagement.download': '下載',
  'otaManagement.edit': '編輯',
  'otaManagement.delete': '刪除',
  'otaManagement.selectAll': '全選',
  'otaManagement.deselectAll': '取消全選',
  'otaManagement.addNew': '新增',
  'otaManagement.addFirmware': '新增固件',
  'otaManagement.editFirmware': '編輯固件',
  'otaManagement.itemsPerPage': '{items}條/頁',
  'otaManagement.firstPage': '首頁',
  'otaManagement.prevPage': '上一頁',
  'otaManagement.nextPage': '下一頁',
  'otaManagement.totalRecords': '共{total}條記錄',
  'otaManagement.selectFirmwareFirst': '請先選擇需要刪除的固件',
  'otaManagement.confirmBatchDelete': '確定要刪除選中的{paramCount}個固件嗎？',
  'otaManagement.operationCancelled': '已取消刪除操作',
  'otaManagement.operationClosed': '操作已關閉',
  'otaManagement.batchDeleteSuccess': '成功刪除{paramCount}個固件',
  'otaManagement.deleteFailed': '刪除失敗，請重試',
  'otaManagement.incompleteFirmwareInfo': '固件信息不完整',
  'otaManagement.getDownloadUrlFailed': '獲取下載鏈接失敗',
  'otaManagement.getFirmwareTypesFailed': '獲取固件類型失敗',
  'otaManagement.updateSuccess': '修改成功',
  'otaManagement.updateFailed': '修改失敗',
  'otaManagement.addSuccess': '新增成功',
  'otaManagement.addFailed': '新增失敗',
  'otaManagement.fetchFirmwareListFailed': '獲取固件列表失敗',

  // 字段管理頁面模型類型翻譯
  'providerManagement.all': '全部',
  'providerManagement.modelType.ASR': '語音識別',
  'providerManagement.modelType.TTS': '語音合成',
  'providerManagement.modelType.LLM': '大語言模型',
  'providerManagement.modelType.VLLM': '視覺大語言模型',
  'providerManagement.modelType.Intent': '意圖識別',
  'providerManagement.modelType.Memory': '記憶模組',
  'providerManagement.modelType.VAD': '語音活動檢測',
  'providerManagement.modelType.Plugin': '插件工具',

  // Provider Dialog 翻譯
  'providerDialog.category': '類別',
  'providerDialog.selectCategory': '請選擇類別',
  'providerDialog.code': '編碼',
  'providerDialog.inputCode': '請輸入供應器編碼',
  'providerDialog.name': '名稱',
  'providerDialog.inputName': '請輸入供應器名稱',
  'providerDialog.sort': '排序',
  'providerDialog.fieldConfig': '字段配置',
  'providerDialog.add': '添加',
  'providerDialog.deselectAll': '取消全選',
  'providerDialog.selectAll': '全選',
  'providerDialog.batchDelete': '批量刪除',
  'providerDialog.fieldKey': '字段key',
  'providerDialog.fieldLabel': '字段標籤',
  'providerDialog.fieldType': '字段類型',
  'providerDialog.type': '類型',
  'providerDialog.stringType': '字串',
  'providerDialog.numberType': '數字',
  'providerDialog.booleanType': '布林值',
  'providerDialog.dictType': '字典',
  'providerDialog.arrayType': '分號分隔的列表',
  'providerDialog.defaultValue': '預設值',
  'providerDialog.inputDefaultValue': '請輸入預設值',
  'providerDialog.operation': '操作',
  'providerDialog.edit': '編輯',
  'providerDialog.complete': '完成',
  'providerDialog.delete': '刪除',
  'providerDialog.save': '儲存',
  'providerDialog.requiredCategory': '請選擇類別',
  'providerDialog.requiredCode': '請輸入供應器編碼',
  'providerDialog.requiredName': '請輸入供應器名稱',
  'providerDialog.completeFieldEdit': '請先完成當前字段的編輯',
  'providerDialog.confirmDeleteField': '確定要刪除此字段嗎？',
  'providerDialog.selectFieldsToDelete': '請先選擇要刪除的字段',
  'providerDialog.confirmBatchDeleteFields': '確定要刪除選中的{count}個字段嗎？',
  'providerDialog.batchDeleteFieldsSuccess': '成功刪除{count}個字段',

  // 預設角色管理頁面文本
  'agentTemplateManagement.title': '預設角色管理',
  'agentTemplateManagement.templateName': '模板名稱',
  'agentTemplateManagement.action': '操作',
  'templateQuickConfig.saveSuccess': '配置保存成功',
  'templateQuickConfig.saveFailed': '配置保存失敗',
  'agentTemplateManagement.createTemplate': '建立模板',
  'agentTemplateManagement.editTemplate': '編輯模板',
  'agentTemplateManagement.deleteTemplate': '刪除模板',
  'agentTemplateManagement.deleteSuccess': '模板刪除成功',
  'agentTemplateManagement.batchDelete': '批次刪除',
  'agentTemplateManagement.batchDeleteSuccess': '批次刪除成功',
  'agentTemplateManagement.selectTemplate': '請選擇模板',
  'agentTemplateManagement.select': '選擇',
  'agentTemplateManagement.searchPlaceholder': '請輸入模板名稱搜尋',
  'agentTemplateManagement.search': '搜尋',
  'agentTemplateManagement.serialNumber': '序號',
  'agentTemplateManagement.selectAll': '全選',
  'agentTemplateManagement.deselectAll': '取消全選',
  'agentTemplateManagement.loading': '拼命加載中',
  'agentTemplateManagement.confirmSingleDelete': '確定要刪除這個模板嗎？',
  'agentTemplateManagement.confirmBatchDelete': '確定要刪除選中的 {count} 個模板嗎？',
  'agentTemplateManagement.deleteFailed': '模板刪除失敗',
  'agentTemplateManagement.batchDeleteFailed': '模板批次刪除失敗',
  'agentTemplateManagement.deleteBackendError': '刪除失敗，請檢查後端服務是否正常',

  // 模板快速配置
  'templateQuickConfig.title': '模組快速設定',
  'templateQuickConfig.agentSettings.agentName': '助手暱稱',
  'templateQuickConfig.agentSettings.agentNamePlaceholder': '請輸入助手暱稱',
  'templateQuickConfig.agentSettings.systemPrompt': '角色介紹',
  'templateQuickConfig.agentSettings.systemPromptPlaceholder': '請輸入角色介紹',
  'templateQuickConfig.saveConfig': '保存配置',
  'templateQuickConfig.resetConfig': '重置配置',
  'templateQuickConfig.configSaved': '配置保存成功',
  'templateQuickConfig.configReset': '配置已重置',
  'templateQuickConfig.confirmReset': '確定要重置配置嗎？',
  'templateQuickConfig.confirm': '確定',
  'templateQuickConfig.cancel': '取消',
  'templateQuickConfig.templateNotFound': '未找到指定模板',
  'templateQuickConfig.newTemplate': '新模板',
  'warning': '警告',
  'info': '提示',
  'common.networkError': '網路請求失敗',

  // SM2加密相關錯誤消息
  'sm2.publicKeyNotConfigured': 'SM2公鑰未配置，請聯繫管理員',
  'sm2.encryptionFailed': '密碼加密失敗',
  'sm2.keyGenerationFailed': '金鑰對生成失敗',
  'sm2.invalidPublicKey': '無效的公鑰格式',
  'sm2.encryptionError': '加密過程中發生錯誤',
  'sm2.publicKeyRetry': '正在重試獲取公鑰...',
  'sm2.publicKeyRetryFailed': '公鑰獲取重試失敗',

  // 音色資源管理
  'voiceClone.title': '音色克隆',
  'voiceResource.title': '音色資源',
  'voiceClone.platformName': '平台名稱',
  'voiceClone.voiceId': '聲音ID',
  'voiceClone.userId': '歸屬帳號',
  'voiceClone.name': '聲音名稱',
  'voiceClone.clone': '立即複刻',
  'voiceClone.action': '操作',
  'voiceClone.modelId': '模型ID',
  'voiceClone.trainStatus': '訓練狀態',
  'voiceClone.trainError': '訓練錯誤',
  'voiceClone.createdAt': '建立時間',
  'voiceClone.search': '搜尋',
  'voiceClone.searchPlaceholder': '請輸入聲音名稱或音色ID',
  'voiceClone.addNew': '新增',
  'voiceClone.delete': '刪除',
  'voiceClone.selectAll': '全選',
  'voiceClone.deselectAll': '取消全選',
  'voiceClone.addVoiceClone': '新增音色資源',
  'voiceClone.confirmDelete': '確定要刪除選中的 {count} 條音色資源嗎？',
  'voiceClone.deleteSuccess': '成功刪除 {count} 條音色資源',
  'voiceClone.deleteFailed': '刪除失敗',
  'voiceClone.addSuccess': '新增成功',
  'voiceClone.addFailed': '新增失敗',
  'voiceClone.updateSuccess': '更新成功',
  'voiceClone.updateFailed': '更新失敗',
  'voiceClone.selectFirst': '請先選擇要刪除的音色資源',
  'voiceClone.operationCancelled': '取消',
  'voiceClone.operationClosed': '已關閉彈窗',
  'voiceClone.cloneSuccess': '複刻成功',
  'voiceClone.cloneFailed': '複刻失敗',
  'voiceClone.confirmClone': '確定要複刻此音色嗎？',
  'voiceClone.onlySuccessCanClone': '只有訓練成功的音色才能複刻',
  'common.insufficient': '不足',
  'voiceClone.platformNameRequired': '請選擇平台名稱',
  'voiceClone.voiceIdRequired': '請選擇音色ID',
  'voiceClone.userIdRequired': '請選擇歸屬帳號',
  'voiceClone.platformNamePlaceholder': '請選擇平台名稱',
  'voiceClone.voiceIdPlaceholder': '請輸入音色ID並按回车',
  'voiceClone.userIdPlaceholder': '請輸入关键词選擇歸屬帳號',
  'voiceClone.waitingUpload': '待上傳',
  'voiceClone.waitingTraining': '待複刻',
  'voiceClone.training': '訓練中',
  'voiceClone.trainSuccess': '訓練成功',
  'voiceClone.trainFailed': '訓練失敗',
  'voiceClone.itemsPerPage': '每頁 {items} 條',
  'voiceClone.firstPage': '首頁',
  'voiceClone.prevPage': '上一頁',
  'voiceClone.nextPage': '下一頁',
  'voiceClone.totalRecords': '共 {total} 條',
  'voiceClone.noVoiceCloneAssigned': '您的帳號暂无音色資源',
  'voiceClone.contactAdmin': '請聯繫管理員分配音色資源',
  'voiceClone.dialogTitle': '聲音複刻',
  'voiceClone.stepUpload': '準備音頻',
  'voiceClone.stepEdit': '音頻編輯',
  'voiceClone.dragOrClick': '將音頻文件拖到此處，或點擊上傳',
  'voiceClone.uploadTip': '支持所有主流音頻格式，選區時長需要在8-60秒之間',
  'voiceClone.editTip1': '請確認上傳音頻是否滿意',
  'voiceClone.editTip2': '您可以試聽並裁剪音頻，如果不滿意可以返回重新錄製或上傳',
  'voiceClone.selectedDuration': '已選擇有效片段：{duration}秒',
  'voiceClone.trim': '對選擇區域進行裁剪',
  'voiceClone.reset': '重置',
  'voiceClone.play': '播放',
  'voiceClone.pause': '暫停',
  'voiceClone.cancel': '取消',
  'voiceClone.nextStep': '下一步',
  'voiceClone.prevStep': '上一步',
  'voiceClone.upload': '上傳音頻',
  'voiceClone.pleaseSelectAudio': '請先選擇音頻文件',
  'voiceClone.durationError': '音頻時長必須在8-60秒之間',
  'voiceClone.loadAudioFailed': '加載音頻失敗',
  'voiceClone.trimSuccess': '裁剪成功',
  'voiceClone.resetSuccess': '重置成功',
  'voiceClone.uploadSuccess': '上傳成功',
  'voiceClone.uploadFailed': '上傳失敗',
  'voiceClone.updateNameSuccess': '名稱更新成功',
  'voiceClone.updateNameFailed': '名稱更新失敗',
  'voiceClone.playFailed': '播放失敗',
}