| Supported Targets | ESP32 | ESP32-S2 |
| ----------------- | ----- | -------- |

# DAC Constant Example

(See the README.md file in the upper level 'examples' directory for more information about examples.)

## Overview

This example shows the basic usage of outputting cosine wave by the DAC driver. The cosine wave is generated by the hardware cosine wave generator in the DAC module.

This example will output cosine wave on both channels.

## How to use the Example

### Hardware Required

* A development board with ESP32 or ESP32-S2 SoC
    - Note that some ESP32-S2 DevKits have LED on it which is connected to GPIO18 (same pin as DAC channel1), so the output voltage of DAC channel 1 can't go down due the this LED.
* (Optional) An oscilloscope to monitor the output wave

### Build and Flash

Note that as we use the ADC to monitor the output data, we need to set false to `CONFIG_ADC_DISABLE_DAC_OUTPUT` in the menuconfig, otherwise the ADC will shutdown the DAC power to guarantee it won't be affect by DAC.

Build the project and flash it to the board, then run monitor tool to view serial output:

```
idf.py -p PORT flash monitor
```

(Replace PORT with the name of the serial port to use.)

(To exit the serial monitor, type ``Ctrl-]``.)

See the Getting Started Guide for full steps to configure and use ESP-IDF to build projects.

## Example Output

The DAC channels can be read by ADC channels internally. The ADC read period is 100 ms, the following log is the raw ADC value read from the DAC channels. But since the ADC sample-rate might be lower than the DAC cosine period, the sampling value can only indicate that the voltage is changing.

```
DAC channel 0 value:  647       DAC channel 1 value: 1728
DAC channel 0 value: 2112       DAC channel 1 value: 2166
DAC channel 0 value:  778       DAC channel 1 value: 2483
DAC channel 0 value: 4095       DAC channel 1 value: 1922
DAC channel 0 value:  238       DAC channel 1 value: 1282
DAC channel 0 value: 3187       DAC channel 1 value: 2609
DAC channel 0 value:  627       DAC channel 1 value: 1068
DAC channel 0 value: 3168       DAC channel 1 value: 2624
DAC channel 0 value:  225       DAC channel 1 value: 1286
DAC channel 0 value: 4095       DAC channel 1 value: 2083
DAC channel 0 value:   89       DAC channel 1 value: 1934
DAC channel 0 value: 3603       DAC channel 1 value: 1434
DAC channel 0 value:  725       DAC channel 1 value: 2469
DAC channel 0 value: 2277       DAC channel 1 value:  960
DAC channel 0 value: 1306       DAC channel 1 value: 2670
DAC channel 0 value: 1670       DAC channel 1 value:  899
DAC channel 0 value: 3189       DAC channel 1 value: 2609
DAC channel 0 value:   86       DAC channel 1 value: 1459
DAC channel 0 value: 4095       DAC channel 1 value: 2258
...
```

If monitoring the DAC channels with an oscilloscope, there will be two cosine waves with opposite phase and different amplitude at 8000 Hz on the two DAC channels.
