/*
 * SPDX-FileCopyrightText: 2017-2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef _SOC_SENSITIVE_REG_H_
#define _SOC_SENSITIVE_REG_H_


#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

#define SENSITIVE_CACHE_DATAARRAY_CONNECT_0_REG          (DR_REG_SENSITIVE_BASE + 0x0)
/* SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK    (BIT(0))
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_M  (BIT(0))
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_V  0x1
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_S  0

#define SENSITIVE_CACHE_DATAARRAY_CONNECT_1_REG          (DR_REG_SENSITIVE_BASE + 0x4)
/* SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN : R/W ;bitpos:[7:0] ;default: ~8'b0 ; */
/*description: .*/
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN    0x000000FF
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_M  ((SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_V)<<(SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_S))
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_V  0xFF
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_S  0

#define SENSITIVE_APB_PERIPHERAL_ACCESS_0_REG          (DR_REG_SENSITIVE_BASE + 0x8)
/* SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_M  (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_V  0x1
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_S  0

#define SENSITIVE_APB_PERIPHERAL_ACCESS_1_REG          (DR_REG_SENSITIVE_BASE + 0xC)
/* SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST    (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_M  (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_V  0x1
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_0_REG          (DR_REG_SENSITIVE_BASE + 0x10)
/* SENSITIVE_INTERNAL_SRAM_USAGE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK    (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_M  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_V  0x1
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_1_REG          (DR_REG_SENSITIVE_BASE + 0x14)
/* SENSITIVE_INTERNAL_SRAM_CPU_USAGE : R/W ;bitpos:[10:4] ;default: ~7'h0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE    0x0000007F
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_CPU_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_CPU_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE_V  0x7F
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE_S  4
/* SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE : R/W ;bitpos:[3:2] ;default: ~2'h0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE    0x00000003
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_V  0x3
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_S  2
/* SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE : R/W ;bitpos:[1:0] ;default: ~2'h0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE    0x00000003
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_V  0x3
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_2_REG          (DR_REG_SENSITIVE_BASE + 0x18)
/* SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC : R/W ;bitpos:[17:16] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC    0x00000003
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_M  ((SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_V)<<(SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_S))
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_V  0x3
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_S  16
/* SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC : R/W ;bitpos:[15:14] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC    0x00000003
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_M  ((SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_V)<<(SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_S))
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_V  0x3
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_S  14
/* SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE : R/W ;bitpos:[13:7] ;default: 7'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE    0x0000007F
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_V  0x7F
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_S  7
/* SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE : R/W ;bitpos:[6:0] ;default: 7'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE    0x0000007F
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_V  0x7F
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_3_REG          (DR_REG_SENSITIVE_BASE + 0x1C)
/* SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE : R/W ;bitpos:[3:0] ;default: 4'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE    0x0000000F
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_V  0xF
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_4_REG          (DR_REG_SENSITIVE_BASE + 0x20)
/* SENSITIVE_INTERNAL_SRAM_LOG_USAGE : R/W ;bitpos:[6:0] ;default: 7'b0 ; */
/*description: .*/
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE    0x0000007F
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE_M  ((SENSITIVE_INTERNAL_SRAM_LOG_USAGE_V)<<(SENSITIVE_INTERNAL_SRAM_LOG_USAGE_S))
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE_V  0x7F
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE_S  0

#define SENSITIVE_RETENTION_DISABLE_REG          (DR_REG_SENSITIVE_BASE + 0x24)
/* SENSITIVE_RETENTION_DISABLE : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_RETENTION_DISABLE    (BIT(0))
#define SENSITIVE_RETENTION_DISABLE_M  (BIT(0))
#define SENSITIVE_RETENTION_DISABLE_V  0x1
#define SENSITIVE_RETENTION_DISABLE_S  0

#define SENSITIVE_CACHE_TAG_ACCESS_0_REG          (DR_REG_SENSITIVE_BASE + 0x28)
/* SENSITIVE_CACHE_TAG_ACCESS_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_M  (BIT(0))
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_V  0x1
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_S  0

#define SENSITIVE_CACHE_TAG_ACCESS_1_REG          (DR_REG_SENSITIVE_BASE + 0x2C)
/* SENSITIVE_PRO_D_TAG_WR_ACS : R/W ;bitpos:[3] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_PRO_D_TAG_WR_ACS    (BIT(3))
#define SENSITIVE_PRO_D_TAG_WR_ACS_M  (BIT(3))
#define SENSITIVE_PRO_D_TAG_WR_ACS_V  0x1
#define SENSITIVE_PRO_D_TAG_WR_ACS_S  3
/* SENSITIVE_PRO_D_TAG_RD_ACS : R/W ;bitpos:[2] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_PRO_D_TAG_RD_ACS    (BIT(2))
#define SENSITIVE_PRO_D_TAG_RD_ACS_M  (BIT(2))
#define SENSITIVE_PRO_D_TAG_RD_ACS_V  0x1
#define SENSITIVE_PRO_D_TAG_RD_ACS_S  2
/* SENSITIVE_PRO_I_TAG_WR_ACS : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_PRO_I_TAG_WR_ACS    (BIT(1))
#define SENSITIVE_PRO_I_TAG_WR_ACS_M  (BIT(1))
#define SENSITIVE_PRO_I_TAG_WR_ACS_V  0x1
#define SENSITIVE_PRO_I_TAG_WR_ACS_S  1
/* SENSITIVE_PRO_I_TAG_RD_ACS : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_PRO_I_TAG_RD_ACS    (BIT(0))
#define SENSITIVE_PRO_I_TAG_RD_ACS_M  (BIT(0))
#define SENSITIVE_PRO_I_TAG_RD_ACS_V  0x1
#define SENSITIVE_PRO_I_TAG_RD_ACS_S  0

#define SENSITIVE_CACHE_MMU_ACCESS_0_REG          (DR_REG_SENSITIVE_BASE + 0x30)
/* SENSITIVE_CACHE_MMU_ACCESS_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_M  (BIT(0))
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_V  0x1
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_S  0

#define SENSITIVE_CACHE_MMU_ACCESS_1_REG          (DR_REG_SENSITIVE_BASE + 0x34)
/* SENSITIVE_PRO_MMU_WR_ACS : R/W ;bitpos:[1] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_PRO_MMU_WR_ACS    (BIT(1))
#define SENSITIVE_PRO_MMU_WR_ACS_M  (BIT(1))
#define SENSITIVE_PRO_MMU_WR_ACS_V  0x1
#define SENSITIVE_PRO_MMU_WR_ACS_S  1
/* SENSITIVE_PRO_MMU_RD_ACS : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_PRO_MMU_RD_ACS    (BIT(0))
#define SENSITIVE_PRO_MMU_RD_ACS_M  (BIT(0))
#define SENSITIVE_PRO_MMU_RD_ACS_V  0x1
#define SENSITIVE_PRO_MMU_RD_ACS_S  0

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x38)
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x3C)
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x40)
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x44)
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x48)
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x4C)
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x50)
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x54)
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x58)
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x5C)
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x60)
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x64)
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x68)
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x6C)
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x70)
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x74)
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x78)
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x7C)
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x80)
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x84)
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x88)
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x8C)
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x90)
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x94)
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x98)
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x9C)
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0xA0)
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0xA4)
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0xA8)
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0xAC)
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0xB0)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0xB4)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0xB8)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[24:3] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x003FFFFF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x3FFFFF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  3
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  1
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0xBC)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO ;bitpos:[16:1] ;default: 16'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000FFFF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  ((SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V)<<(SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0xFFFF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0xC0)
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0xC4)
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR    0x000000FF
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S  14
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6 : R/W ;bitpos:[13:12] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_S  12
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5 : R/W ;bitpos:[11:10] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_S  10
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4 : R/W ;bitpos:[9:8] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_S  8
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3 : R/W ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_S  6
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0xC8)
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR    0x000000FF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S  14
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6 : R/W ;bitpos:[13:12] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_S  12
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5 : R/W ;bitpos:[11:10] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_S  10
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4 : R/W ;bitpos:[9:8] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_S  8
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3 : R/W ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_S  6
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0xCC)
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR    0x000000FF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S  14
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6 : R/W ;bitpos:[13:12] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_S  12
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5 : R/W ;bitpos:[11:10] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_S  10
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4 : R/W ;bitpos:[9:8] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_S  8
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3 : R/W ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_S  6
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0xD0)
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR    0x000000FF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S  14
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6 : R/W ;bitpos:[13:12] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_S  12
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5 : R/W ;bitpos:[11:10] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_S  10
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4 : R/W ;bitpos:[9:8] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_S  8
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3 : R/W ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_S  6
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0xD4)
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR    0x000000FF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S  14
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6 : R/W ;bitpos:[13:12] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_S  12
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5 : R/W ;bitpos:[11:10] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_S  10
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4 : R/W ;bitpos:[9:8] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_S  8
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3 : R/W ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_S  6
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0xD8)
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0xDC)
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W ;bitpos:[20:18] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  18
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[17:15] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S  15
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[14:12] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S  12
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  9
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  6
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  3
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  0

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0xE0)
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W ;bitpos:[20:18] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  18
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[17:15] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S  15
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[14:12] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S  12
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  9
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  6
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  3
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0xE4)
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0xE8)
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0xEC)
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[28:5] ;default: 24'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00FFFFFF
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0xFFFFFF
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  5
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[4:3] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  3
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE : RO ;bitpos:[2] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE    (BIT(2))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_M  (BIT(2))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S  2
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  1
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0xF0)
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0xF4)
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0xF8)
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[28:5] ;default: 24'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00FFFFFF
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0xFFFFFF
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  5
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[4:3] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  3
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE : RO ;bitpos:[2] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE    (BIT(2))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_M  (BIT(2))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V  0x1
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S  2
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(1))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(1))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  1
/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0xFC)
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x100)
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  26
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  24
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S  22
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S  20
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S  10
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S  8
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x104)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x108)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x10C)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[25:4] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x003FFFFF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x3FFFFF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  4
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  2
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK    (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_M  (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S  1
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x110)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO ;bitpos:[16:1] ;default: 16'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000FFFF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  ((SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V)<<(SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0xFFFF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x114)
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x118)
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x11C)
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[25:4] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x003FFFFF
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x3FFFFF
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  4
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  2
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK    (BIT(1))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_M  (BIT(1))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V  0x1
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S  1
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x120)
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO ;bitpos:[16:1] ;default: 16'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000FFFF
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  ((SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V)<<(SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0xFFFF
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1
/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x124)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x128)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S  20
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x12C)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0 : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x130)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x134)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S  20
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x138)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S  20
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x13C)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0 : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_7_REG          (DR_REG_SENSITIVE_BASE + 0x140)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_8_REG          (DR_REG_SENSITIVE_BASE + 0x144)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S  20
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_9_REG          (DR_REG_SENSITIVE_BASE + 0x148)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1    0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0    0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_10_REG          (DR_REG_SENSITIVE_BASE + 0x14C)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S  9
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S  3
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_11_REG          (DR_REG_SENSITIVE_BASE + 0x150)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1    0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0    0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_12_REG          (DR_REG_SENSITIVE_BASE + 0x154)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S  9
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S  3
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_13_REG          (DR_REG_SENSITIVE_BASE + 0x158)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1    0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0    0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_14_REG          (DR_REG_SENSITIVE_BASE + 0x15C)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S  9
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S  3
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x160)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x164)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10 : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S  20
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S  18
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S  16
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S  14
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S  12
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S  10
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S  8
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S  6
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S  4
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S  2
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x168)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10 : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S  20
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S  18
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S  16
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S  14
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S  12
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S  10
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S  8
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S  6
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S  4
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S  2
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V  0x3
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x16C)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x170)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x174)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x178)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_7_REG          (DR_REG_SENSITIVE_BASE + 0x17C)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_8_REG          (DR_REG_SENSITIVE_BASE + 0x180)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_9_REG          (DR_REG_SENSITIVE_BASE + 0x184)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_10_REG          (DR_REG_SENSITIVE_BASE + 0x188)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_11_REG          (DR_REG_SENSITIVE_BASE + 0x18C)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_12_REG          (DR_REG_SENSITIVE_BASE + 0x190)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_13_REG          (DR_REG_SENSITIVE_BASE + 0x194)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_S  0

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_14_REG          (DR_REG_SENSITIVE_BASE + 0x198)
/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11    0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_M  ((SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_V)<<(SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_S))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_V  0x3FFFFFFF
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x19C)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x1A0)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x1A4)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD : RO ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S  6
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO ;bitpos:[5] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(5))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (BIT(5))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  5
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO ;bitpos:[4:2] ;default: 3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  2
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0 : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_M  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x1A8)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR    0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V  0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_4_REG          (DR_REG_SENSITIVE_BASE + 0x1AC)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_5_REG          (DR_REG_SENSITIVE_BASE + 0x1B0)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD : RO ;bitpos:[4:3] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S  3
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_6_REG          (DR_REG_SENSITIVE_BASE + 0x1B4)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR    0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V  0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S  0

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x1B8)
/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_V  0x1
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_S  0

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_0_REG          (DR_REG_SENSITIVE_BASE + 0x1BC)
/* SENSITIVE_CORE_0_VECBASE_WORLD_MASK : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK    (BIT(0))
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK_M  (BIT(0))
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK_V  0x1
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK_S  0

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_1_REG          (DR_REG_SENSITIVE_BASE + 0x1C0)
/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL : R/W ;bitpos:[23:22] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL    0x00000003
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_M  ((SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_V)<<(SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_S))
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_V  0x3
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_S  22
/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE : R/W ;bitpos:[21:0] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE    0x003FFFFF
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_M  ((SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_V)<<(SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_S))
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_V  0x3FFFFF
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_S  0

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_2_REG          (DR_REG_SENSITIVE_BASE + 0x1C4)
/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE : R/W ;bitpos:[21:0] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE    0x003FFFFF
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_M  ((SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_V)<<(SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_S))
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_V  0x3FFFFF
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_S  0

#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_0_REG          (DR_REG_SENSITIVE_BASE + 0x1C8)
/* SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_V  0x1
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_S  0

#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_1_REG          (DR_REG_SENSITIVE_BASE + 0x1CC)
/* SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE    (BIT(0))
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_M  (BIT(0))
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_V  0x1
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x1D0)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x1D4)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S  30
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S  24
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S  20
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S  2
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x1D8)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S  30
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0 : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S  24
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_S  22
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S  18
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S  12
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x1DC)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S  22
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S  12
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S  2
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x1E0)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S  30
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S  24
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S  22
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S  20
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S  18
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S  12
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S  2
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x1E4)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S  30
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S  24
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S  20
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S  2
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x1E8)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S  30
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0 : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S  24
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_S  22
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S  18
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S  12
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_7_REG          (DR_REG_SENSITIVE_BASE + 0x1EC)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S  22
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S  12
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S  2
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_8_REG          (DR_REG_SENSITIVE_BASE + 0x1F0)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S  30
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S  28
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_S  26
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S  24
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S  22
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S  20
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S  18
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S  16
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_S  14
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S  12
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S  10
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S  8
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S  4
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S  2
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_9_REG          (DR_REG_SENSITIVE_BASE + 0x1F4)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1    0x000007FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0    0x000007FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_10_REG          (DR_REG_SENSITIVE_BASE + 0x1F8)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S  9
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S  3
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_11_REG          (DR_REG_SENSITIVE_BASE + 0x1FC)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1    0x000007FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0    0x000007FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_12_REG          (DR_REG_SENSITIVE_BASE + 0x200)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S  9
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S  3
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_13_REG          (DR_REG_SENSITIVE_BASE + 0x204)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1    0x000007FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0    0x000007FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_14_REG          (DR_REG_SENSITIVE_BASE + 0x208)
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S  9
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S  6
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S  3
/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_M  ((SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V)<<(SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x20C)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x210)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10 : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S  20
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S  18
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S  16
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S  14
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S  12
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S  10
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S  8
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S  6
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S  4
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S  2
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x214)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10 : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S  20
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S  18
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S  16
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S  14
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S  12
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S  10
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S  8
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S  6
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S  4
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S  2
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V  0x3
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x218)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x21C)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x220)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x224)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_7_REG          (DR_REG_SENSITIVE_BASE + 0x228)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_8_REG          (DR_REG_SENSITIVE_BASE + 0x22C)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_9_REG          (DR_REG_SENSITIVE_BASE + 0x230)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_10_REG          (DR_REG_SENSITIVE_BASE + 0x234)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_11_REG          (DR_REG_SENSITIVE_BASE + 0x238)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_12_REG          (DR_REG_SENSITIVE_BASE + 0x23C)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_13_REG          (DR_REG_SENSITIVE_BASE + 0x240)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_S  0

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_14_REG          (DR_REG_SENSITIVE_BASE + 0x244)
/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11    0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_M  ((SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_V)<<(SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_S))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_V  0x3FFFFFFF
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x248)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x24C)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x250)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD : RO ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_M  ((SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V)<<(SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S  6
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO ;bitpos:[5] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(5))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (BIT(5))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  5
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO ;bitpos:[4:2] ;default: 3'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x7
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  2
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0 : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0    (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_M  (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S  1
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x254)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR    0xFFFFFFFF
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_M  ((SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V)<<(SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V  0xFFFFFFFF
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_4_REG          (DR_REG_SENSITIVE_BASE + 0x258)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S  1
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_5_REG          (DR_REG_SENSITIVE_BASE + 0x25C)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD : RO ;bitpos:[4:3] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_M  ((SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V)<<(SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S  3
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V  0x3
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S  1
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_6_REG          (DR_REG_SENSITIVE_BASE + 0x260)
/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR    0xFFFFFFFF
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_M  ((SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V)<<(SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V  0xFFFFFFFF
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S  0

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x264)
/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_V  0x1
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_S  0

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_0_REG          (DR_REG_SENSITIVE_BASE + 0x268)
/* SENSITIVE_CORE_1_VECBASE_WORLD_MASK : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK    (BIT(0))
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK_M  (BIT(0))
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK_V  0x1
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK_S  0

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_1_REG          (DR_REG_SENSITIVE_BASE + 0x26C)
/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL : R/W ;bitpos:[23:22] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL    0x00000003
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_M  ((SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_V)<<(SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_S))
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_V  0x3
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_S  22
/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE : R/W ;bitpos:[21:0] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE    0x003FFFFF
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_M  ((SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_V)<<(SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_S))
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_V  0x3FFFFF
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_S  0

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_2_REG          (DR_REG_SENSITIVE_BASE + 0x270)
/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE : R/W ;bitpos:[21:0] ;default: 22'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE    0x003FFFFF
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_M  ((SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_V)<<(SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_S))
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_V  0x3FFFFF
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_S  0

#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_0_REG          (DR_REG_SENSITIVE_BASE + 0x274)
/* SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_V  0x1
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_S  0

#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_1_REG          (DR_REG_SENSITIVE_BASE + 0x278)
/* SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE    (BIT(0))
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_M  (BIT(0))
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_V  0x1
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x27C)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x280)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S  30
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_S  28
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S  24
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_S  20
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_S  8
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S  2
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x284)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S  30
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S  28
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0 : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_S  24
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_S  22
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_S  18
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_S  12
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_S  8
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x288)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_S  28
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S  22
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_S  12
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_S  8
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_S  2
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x28C)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_S  30
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_S  28
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_S  24
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_S  22
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_S  20
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_S  18
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_S  12
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S  8
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_S  2
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x290)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR    0x000007FF
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_V  0x7FF
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x294)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H    0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_V  0x7
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_S  3
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L    0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_V  0x7
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x298)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x29C)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x2A0)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO ;bitpos:[6] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(6))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (BIT(6))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  6
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO ;bitpos:[5:3] ;default: 3'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x7
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  3
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_M  ((SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V)<<(SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S  1
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x2A4)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: .*/
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR    0xFFFFFFFF
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_M  ((SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V)<<(SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V  0xFFFFFFFF
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S  0

#define SENSITIVE_EDMA_BOUNDARY_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2A8)
/* SENSITIVE_EDMA_BOUNDARY_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_BOUNDARY_LOCK    (BIT(0))
#define SENSITIVE_EDMA_BOUNDARY_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_BOUNDARY_LOCK_V  0x1
#define SENSITIVE_EDMA_BOUNDARY_LOCK_S  0

#define SENSITIVE_EDMA_BOUNDARY_0_REG          (DR_REG_SENSITIVE_BASE + 0x2AC)
/* SENSITIVE_EDMA_BOUNDARY_0 : R/W ;bitpos:[13:0] ;default: 14'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_BOUNDARY_0    0x00003FFF
#define SENSITIVE_EDMA_BOUNDARY_0_M  ((SENSITIVE_EDMA_BOUNDARY_0_V)<<(SENSITIVE_EDMA_BOUNDARY_0_S))
#define SENSITIVE_EDMA_BOUNDARY_0_V  0x3FFF
#define SENSITIVE_EDMA_BOUNDARY_0_S  0

#define SENSITIVE_EDMA_BOUNDARY_1_REG          (DR_REG_SENSITIVE_BASE + 0x2B0)
/* SENSITIVE_EDMA_BOUNDARY_1 : R/W ;bitpos:[13:0] ;default: 14'h2000 ; */
/*description: .*/
#define SENSITIVE_EDMA_BOUNDARY_1    0x00003FFF
#define SENSITIVE_EDMA_BOUNDARY_1_M  ((SENSITIVE_EDMA_BOUNDARY_1_V)<<(SENSITIVE_EDMA_BOUNDARY_1_S))
#define SENSITIVE_EDMA_BOUNDARY_1_V  0x3FFF
#define SENSITIVE_EDMA_BOUNDARY_1_S  0

#define SENSITIVE_EDMA_BOUNDARY_2_REG          (DR_REG_SENSITIVE_BASE + 0x2B4)
/* SENSITIVE_EDMA_BOUNDARY_2 : R/W ;bitpos:[13:0] ;default: 14'h2000 ; */
/*description: .*/
#define SENSITIVE_EDMA_BOUNDARY_2    0x00003FFF
#define SENSITIVE_EDMA_BOUNDARY_2_M  ((SENSITIVE_EDMA_BOUNDARY_2_V)<<(SENSITIVE_EDMA_BOUNDARY_2_S))
#define SENSITIVE_EDMA_BOUNDARY_2_V  0x3FFF
#define SENSITIVE_EDMA_BOUNDARY_2_S  0

#define SENSITIVE_EDMA_PMS_SPI2_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2B8)
/* SENSITIVE_EDMA_PMS_SPI2_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SPI2_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_SPI2_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_SPI2_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_SPI2_LOCK_S  0

#define SENSITIVE_EDMA_PMS_SPI2_REG          (DR_REG_SENSITIVE_BASE + 0x2BC)
/* SENSITIVE_EDMA_PMS_SPI2_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2_M  ((SENSITIVE_EDMA_PMS_SPI2_ATTR2_V)<<(SENSITIVE_EDMA_PMS_SPI2_ATTR2_S))
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_SPI2_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1_M  ((SENSITIVE_EDMA_PMS_SPI2_ATTR1_V)<<(SENSITIVE_EDMA_PMS_SPI2_ATTR1_S))
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_SPI3_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2C0)
/* SENSITIVE_EDMA_PMS_SPI3_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SPI3_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_SPI3_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_SPI3_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_SPI3_LOCK_S  0

#define SENSITIVE_EDMA_PMS_SPI3_REG          (DR_REG_SENSITIVE_BASE + 0x2C4)
/* SENSITIVE_EDMA_PMS_SPI3_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2_M  ((SENSITIVE_EDMA_PMS_SPI3_ATTR2_V)<<(SENSITIVE_EDMA_PMS_SPI3_ATTR2_S))
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_SPI3_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1_M  ((SENSITIVE_EDMA_PMS_SPI3_ATTR1_V)<<(SENSITIVE_EDMA_PMS_SPI3_ATTR1_S))
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2C8)
/* SENSITIVE_EDMA_PMS_UHCI0_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_S  0

#define SENSITIVE_EDMA_PMS_UHCI0_REG          (DR_REG_SENSITIVE_BASE + 0x2CC)
/* SENSITIVE_EDMA_PMS_UHCI0_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2_M  ((SENSITIVE_EDMA_PMS_UHCI0_ATTR2_V)<<(SENSITIVE_EDMA_PMS_UHCI0_ATTR2_S))
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_UHCI0_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1_M  ((SENSITIVE_EDMA_PMS_UHCI0_ATTR1_V)<<(SENSITIVE_EDMA_PMS_UHCI0_ATTR1_S))
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_I2S0_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2D0)
/* SENSITIVE_EDMA_PMS_I2S0_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_I2S0_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_I2S0_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_I2S0_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_I2S0_LOCK_S  0

#define SENSITIVE_EDMA_PMS_I2S0_REG          (DR_REG_SENSITIVE_BASE + 0x2D4)
/* SENSITIVE_EDMA_PMS_I2S0_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2_M  ((SENSITIVE_EDMA_PMS_I2S0_ATTR2_V)<<(SENSITIVE_EDMA_PMS_I2S0_ATTR2_S))
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_I2S0_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1_M  ((SENSITIVE_EDMA_PMS_I2S0_ATTR1_V)<<(SENSITIVE_EDMA_PMS_I2S0_ATTR1_S))
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_I2S1_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2D8)
/* SENSITIVE_EDMA_PMS_I2S1_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_I2S1_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_I2S1_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_I2S1_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_I2S1_LOCK_S  0

#define SENSITIVE_EDMA_PMS_I2S1_REG          (DR_REG_SENSITIVE_BASE + 0x2DC)
/* SENSITIVE_EDMA_PMS_I2S1_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2_M  ((SENSITIVE_EDMA_PMS_I2S1_ATTR2_V)<<(SENSITIVE_EDMA_PMS_I2S1_ATTR2_S))
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_I2S1_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1_M  ((SENSITIVE_EDMA_PMS_I2S1_ATTR1_V)<<(SENSITIVE_EDMA_PMS_I2S1_ATTR1_S))
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2E0)
/* SENSITIVE_EDMA_PMS_LCD_CAM_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_S  0

#define SENSITIVE_EDMA_PMS_LCD_CAM_REG          (DR_REG_SENSITIVE_BASE + 0x2E4)
/* SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_M  ((SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_V)<<(SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_S))
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_M  ((SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_V)<<(SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_S))
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_AES_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2E8)
/* SENSITIVE_EDMA_PMS_AES_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_AES_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_AES_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_AES_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_AES_LOCK_S  0

#define SENSITIVE_EDMA_PMS_AES_REG          (DR_REG_SENSITIVE_BASE + 0x2EC)
/* SENSITIVE_EDMA_PMS_AES_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_AES_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_AES_ATTR2_M  ((SENSITIVE_EDMA_PMS_AES_ATTR2_V)<<(SENSITIVE_EDMA_PMS_AES_ATTR2_S))
#define SENSITIVE_EDMA_PMS_AES_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_AES_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_AES_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_AES_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_AES_ATTR1_M  ((SENSITIVE_EDMA_PMS_AES_ATTR1_V)<<(SENSITIVE_EDMA_PMS_AES_ATTR1_S))
#define SENSITIVE_EDMA_PMS_AES_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_AES_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_SHA_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2F0)
/* SENSITIVE_EDMA_PMS_SHA_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SHA_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_SHA_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_SHA_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_SHA_LOCK_S  0

#define SENSITIVE_EDMA_PMS_SHA_REG          (DR_REG_SENSITIVE_BASE + 0x2F4)
/* SENSITIVE_EDMA_PMS_SHA_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SHA_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_SHA_ATTR2_M  ((SENSITIVE_EDMA_PMS_SHA_ATTR2_V)<<(SENSITIVE_EDMA_PMS_SHA_ATTR2_S))
#define SENSITIVE_EDMA_PMS_SHA_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_SHA_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_SHA_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_SHA_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_SHA_ATTR1_M  ((SENSITIVE_EDMA_PMS_SHA_ATTR1_V)<<(SENSITIVE_EDMA_PMS_SHA_ATTR1_S))
#define SENSITIVE_EDMA_PMS_SHA_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_SHA_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x2F8)
/* SENSITIVE_EDMA_PMS_ADC_DAC_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_S  0

#define SENSITIVE_EDMA_PMS_ADC_DAC_REG          (DR_REG_SENSITIVE_BASE + 0x2FC)
/* SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_M  ((SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_V)<<(SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_S))
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_M  ((SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_V)<<(SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_S))
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_S  0

#define SENSITIVE_EDMA_PMS_RMT_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x300)
/* SENSITIVE_EDMA_PMS_RMT_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_RMT_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_RMT_LOCK_M  (BIT(0))
#define SENSITIVE_EDMA_PMS_RMT_LOCK_V  0x1
#define SENSITIVE_EDMA_PMS_RMT_LOCK_S  0

#define SENSITIVE_EDMA_PMS_RMT_REG          (DR_REG_SENSITIVE_BASE + 0x304)
/* SENSITIVE_EDMA_PMS_RMT_ATTR2 : R/W ;bitpos:[3:2] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_RMT_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_RMT_ATTR2_M  ((SENSITIVE_EDMA_PMS_RMT_ATTR2_V)<<(SENSITIVE_EDMA_PMS_RMT_ATTR2_S))
#define SENSITIVE_EDMA_PMS_RMT_ATTR2_V  0x3
#define SENSITIVE_EDMA_PMS_RMT_ATTR2_S  2
/* SENSITIVE_EDMA_PMS_RMT_ATTR1 : R/W ;bitpos:[1:0] ;default: 2'b11 ; */
/*description: .*/
#define SENSITIVE_EDMA_PMS_RMT_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_RMT_ATTR1_M  ((SENSITIVE_EDMA_PMS_RMT_ATTR1_V)<<(SENSITIVE_EDMA_PMS_RMT_ATTR1_S))
#define SENSITIVE_EDMA_PMS_RMT_ATTR1_V  0x3
#define SENSITIVE_EDMA_PMS_RMT_ATTR1_S  0

#define SENSITIVE_CLOCK_GATE_REG          (DR_REG_SENSITIVE_BASE + 0x308)
/* SENSITIVE_CLK_EN : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: .*/
#define SENSITIVE_CLK_EN    (BIT(0))
#define SENSITIVE_CLK_EN_M  (BIT(0))
#define SENSITIVE_CLK_EN_V  0x1
#define SENSITIVE_CLK_EN_S  0

#define SENSITIVE_RTC_PMS_REG          (DR_REG_SENSITIVE_BASE + 0x30C)
/* SENSITIVE_DIS_RTC_CPU : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: .*/
#define SENSITIVE_DIS_RTC_CPU    (BIT(0))
#define SENSITIVE_DIS_RTC_CPU_M  (BIT(0))
#define SENSITIVE_DIS_RTC_CPU_V  0x1
#define SENSITIVE_DIS_RTC_CPU_S  0

#define SENSITIVE_DATE_REG          (DR_REG_SENSITIVE_BASE + 0xFFC)
/* SENSITIVE_DATE : R/W ;bitpos:[27:0] ;default: 28'h2101280 ; */
/*description: .*/
#define SENSITIVE_DATE    0x0FFFFFFF
#define SENSITIVE_DATE_M  ((SENSITIVE_DATE_V)<<(SENSITIVE_DATE_S))
#define SENSITIVE_DATE_V  0xFFFFFFF
#define SENSITIVE_DATE_S  0


#ifdef __cplusplus
}
#endif



#endif /*_SOC_SENSITIVE_REG_H_ */
