/*
 * SPDX-FileCopyrightText: 2023-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Unlicense OR CC0-1.0
 */
#pragma once

#include <stdint.h>

const uint8_t ecc_p256_k[] = {
   0xB2, 0xC5, 0x9E, 0x92, 0x64, 0xCD, 0x5F, 0x66,
   0x9E, 0xC8, 0x83, 0x6D, 0x99, 0x61, 0x18, 0x72,
   0xC8, 0x60, 0x83, 0x1E, 0xE5, 0x79, 0xCC, 0x73,
   0xA9, 0xB4, 0x74, 0x85, 0x70, 0x11, 0x2D, 0xA2,
};

const uint8_t ecc_p192_k[] = {
    0x6f, 0x18, 0x34, 0xeb, 0x16, 0xb7, 0xac, 0x9f,
    0x3c, 0x77, 0x71, 0xb3, 0x02, 0x30, 0x70, 0x48,
    0x75, 0x87, 0xbb, 0x6f, 0x80, 0x34, 0x8d, 0x5e
};

/* Little endian */
uint8_t ecdsa256_r[] = {
    0x23, 0xc0, 0x94, 0xe5, 0x49, 0x17, 0xf4, 0x30,
    0x10, 0xa4, 0xa0, 0x53, 0x28, 0x8b, 0x87, 0xde,
    0xfc, 0x58, 0x9e, 0x64, 0x0b, 0x27, 0xe3, 0xb4,
    0x46, 0x6c, 0x24, 0x64, 0x0f, 0xe1, 0x3e, 0x97
};

/* Little endian */
uint8_t ecdsa256_s[] = {
    0x98, 0x16, 0xf0, 0x9a, 0x8a, 0xf1, 0x8c, 0x8f,
    0x3b, 0xcb, 0x75, 0x78, 0x71, 0xc9, 0x98, 0x67,
    0x86, 0xf3, 0x05, 0x0c, 0x5a, 0xe3, 0x8d, 0xec,
    0x55, 0x6f, 0x3b, 0xab, 0xd5, 0x1b, 0xae, 0xb1
};

/* Little endian */
uint8_t ecdsa256_pub_x[] = {
    0xa8, 0xe9, 0x88, 0x85, 0x26, 0x08, 0x55, 0x95,
    0xf9, 0x11, 0x5a, 0xce, 0x7a, 0x5f, 0xff, 0x0c,
    0xda, 0x45, 0xb8, 0x11, 0xc7, 0x04, 0xca, 0xa7,
    0x8b, 0xd4, 0x6e, 0xd8, 0x1f, 0x64, 0xdf, 0x4d
};

/* Little endian */
uint8_t ecdsa256_pub_y[] = {
    0x34, 0x25, 0x2c, 0xaf, 0xec, 0xe8, 0xa1, 0x73,
    0xbc, 0xa0, 0x80, 0x2c, 0xaa, 0xfd, 0xa8, 0x50,
    0x6a, 0x71, 0xf2, 0x40, 0x1a, 0xb6, 0x8a, 0xa0,
    0x6e, 0x9a, 0xce, 0xbf, 0xcc, 0x4d, 0xb0, 0x24
};

/* Little endian */
uint8_t ecdsa192_r[] = {
    0x9c, 0xd0, 0xbc, 0x89, 0xbe, 0x77, 0x7e, 0x87,
    0x00, 0xfc, 0x20, 0x07, 0x2f, 0x2d, 0x46, 0xef,
    0xa2, 0x81, 0x29, 0x68, 0x95, 0x29, 0xc8, 0x90
};

/* Little endian */
uint8_t ecdsa192_s[] = {
    0x46, 0x46, 0x2b, 0xfa, 0x9e, 0x0e, 0xb2, 0x74,
    0x57, 0xd6, 0xb2, 0xea, 0xbd, 0x76, 0xc1, 0x3b,
    0x11, 0x8a, 0x5b, 0xb6, 0xc5, 0x84, 0xb1, 0x1e
};

/* Little endian */
uint8_t ecdsa192_pub_x[] = {
    0xb1, 0x9c, 0x10, 0x21, 0x5d, 0x56, 0x59, 0x74,
    0x34, 0x33, 0x23, 0xab, 0x82, 0x7b, 0x63, 0x1e,
    0xc0, 0xf4, 0xaa, 0x5d, 0xe7, 0x6f, 0x3f, 0xd0
};

/* Little endian */
uint8_t ecdsa192_pub_y[] = {
    0xc2, 0x87, 0x5c, 0x46, 0xad, 0x23, 0x4b, 0x7e,
    0xde, 0xc2, 0xdc, 0x74, 0xf3, 0xfd, 0x09, 0x74,
    0xbe, 0xc4, 0xbc, 0x65, 0xcb, 0x76, 0xfc, 0x85
};

/* Big endian */
uint8_t sha[] = {
    0x98, 0xca, 0xea, 0x85, 0x7b, 0x03, 0x5e, 0xc0,
    0xe3, 0xc3, 0x39, 0x29, 0xef, 0xf1, 0xf1, 0x25,
    0x00, 0x19, 0xe7, 0x11, 0xc3, 0x3d, 0x84, 0x42,
    0x38, 0x79, 0x10, 0xef, 0xb2, 0x9b, 0xd2, 0x63,
    0xed, 0xfe, 0x04, 0xce, 0x66, 0x89, 0xd0, 0xa4,
    0xb2, 0x60, 0xb2, 0x38, 0x93, 0xa6, 0x27, 0x14
};

/* Little endian */
uint8_t ecdsa384_r[] = {
    0xbb, 0x6e, 0x80, 0x35, 0x09, 0x36, 0x31, 0xc5,
    0x59, 0x0a, 0x89, 0x82, 0x22, 0xa7, 0x5f, 0xfb,
    0x35, 0x6a, 0x4b, 0xf0, 0x4a, 0x20, 0x3a, 0x9d,
    0xbe, 0x6f, 0xf0, 0xa9, 0xd7, 0x2e, 0x2d, 0x6b,
    0x04, 0x7f, 0x75, 0x14, 0xf8, 0xc6, 0x18, 0xe6,
    0x81, 0xb6, 0x08, 0x08, 0xaf, 0xe3, 0x24, 0x1a,
};

/* Little endian */
uint8_t ecdsa384_s[] = {
    0x94, 0x61, 0xf9, 0xa8, 0xcd, 0x7a, 0x3c, 0x23,
    0xd8, 0x12, 0x3e, 0x33, 0x29, 0xa9, 0x9b, 0xe9,
    0x85, 0x5b, 0x34, 0xb9, 0xdc, 0xc2, 0x90, 0x87,
    0x71, 0x7c, 0x89, 0xa2, 0x94, 0x5f, 0x4e, 0x47,
    0x5f, 0xa7, 0xe4, 0x20, 0x4e, 0xf7, 0x36, 0x6e,
    0xe4, 0x62, 0x94, 0x41, 0x8c, 0x30, 0x81, 0x38,
};

/* Little endian */
uint8_t ecdsa384_pub_x[] = {
    0x45, 0x91, 0x5b, 0xe9, 0x19, 0xde, 0x7b, 0x8b,
    0xe5, 0x71, 0xc5, 0xcc, 0x7e, 0x93, 0xe1, 0x07,
    0x0c, 0x34, 0xd3, 0xd1, 0x97, 0x9e, 0x2d, 0x73,
    0xe7, 0x7e, 0x06, 0x15, 0xbb, 0x71, 0x5b, 0xc7,
    0x19, 0xc5, 0x5e, 0x6f, 0xf9, 0x1d, 0xe5, 0x8d,
    0x29, 0x09, 0xb2, 0xcd, 0xb3, 0x2b, 0xc2, 0xae,
};

/* Little endian */
uint8_t ecdsa384_pub_y[] = {
    0x29, 0xbf, 0xad, 0xae, 0xd6, 0xc9, 0x86, 0x7f,
    0xce, 0xc2, 0xd6, 0x78, 0x4b, 0x23, 0xe0, 0x97,
    0x3d, 0xf2, 0x2a, 0x82, 0xa3, 0xa0, 0xfc, 0x4c,
    0x48, 0x47, 0x20, 0xcd, 0xba, 0xc4, 0x1c, 0x4c,
    0xd1, 0xf1, 0x81, 0x70, 0x7c, 0xce, 0x42, 0xf3,
    0x3d, 0xa1, 0x64, 0x84, 0x91, 0xac, 0xee, 0xf7,
};
