export default {
  // Login page related prompt text
  'login.requiredUsername': 'Username cannot be empty',
  'login.requiredPassword': 'Password cannot be empty',
  'login.requiredCaptcha': 'Captcha cannot be empty',
  'login.requiredMobile': 'Please enter a valid mobile phone number',
  'login.loginSuccess': 'Login successful!',

  // HeaderBar组件文本
  'header.smartManagement': 'Agents',
  'header.modelConfig': 'Models',
  'header.voiceCloneManagement': 'Voice Clone',
  'header.voiceResourceManagement': 'Voice Resource',
  'header.userManagement': 'Users',
  'header.otaManagement': 'OTA Management',
  'header.paramDictionary': 'More',
  'header.paramManagement': 'Params Management',
  'header.dictManagement': 'Dict Management',
  'header.agentTemplate': 'Default Role Templates', // 添加这一行
  'header.searchHistory': 'Search History',
  'header.clearHistory': 'Clear History',
  'header.providerManagement': 'Provider Management',
  'header.serverSideManagement': 'Server Management',
  'header.changePassword': 'Change Password',
  'header.logout': 'Logout',
  'header.searchPlaceholder': 'Search by name..',

  // McpToolCallDialog component text
  'mcpToolCall.title': 'Tool Call',
  'mcpToolCall.execute': 'Execute',
  'mcpToolCall.chooseFunction': '1、Choose Function',
  'mcpToolCall.searchFunction': 'Search Function',
  'mcpToolCall.noResults': 'No matching functions found',
  'mcpToolCall.settings': '2、Parameter Settings',
  'mcpToolCall.inputPlaceholder': 'Please enter {label}',
  'mcpToolCall.valueRange': 'Value range: {min} - {max}',
  'mcpToolCall.selectPlaceholder': 'Please select {label}',
  'mcpToolCall.lightTheme': 'Light Theme',
  'mcpToolCall.darkTheme': 'Dark Theme',
  'mcpToolCall.pleaseSelect': 'Please select a function',
  'mcpToolCall.cancel': 'Cancel',
  'mcpToolCall.requiredField': 'Please enter {field}',
  'mcpToolCall.minValue': 'Minimum value is {value}',
  'mcpToolCall.maxValue': 'Maximum value is {value}',
  'mcpToolCall.selectTool': 'Please select a tool to execute',
  'mcpToolCall.executionResult': '3、Execution Result',
  'mcpToolCall.copyResult': 'Copy Result',
  'mcpToolCall.noResultYet': 'No result yet',
  'mcpToolCall.loadingToolList': 'Loading tool list...',

  // Tool names
  'mcpToolCall.toolName.getDeviceStatus': 'View Device Status',
  'mcpToolCall.toolName.setVolume': 'Set Volume',
  'mcpToolCall.toolName.setBrightness': 'Set Brightness',
  'mcpToolCall.toolName.setTheme': 'Set Theme',
  'mcpToolCall.toolName.takePhoto': 'Take Photo & Recognize',
  'mcpToolCall.toolName.getSystemInfo': 'System Info',
  'mcpToolCall.toolName.reboot': 'Reboot Device',
  'mcpToolCall.toolName.upgradeFirmware': 'Upgrade Firmware',
  'mcpToolCall.toolName.getScreenInfo': 'Screen Info',
  'mcpToolCall.toolName.snapshot': 'Screen Snapshot',
  'mcpToolCall.toolName.previewImage': 'Preview Image',
  'mcpToolCall.toolName.setDownloadUrl': 'Set Download URL',

  // Tool categories
  'mcpToolCall.category.audio': 'Audio',
  'mcpToolCall.category.display': 'Display',
  'mcpToolCall.category.camera': 'Camera',
  'mcpToolCall.category.system': 'System',
  'mcpToolCall.category.assets': 'Assets',
  'mcpToolCall.category.deviceInfo': 'Device Info',

  // Table categories and properties
  'mcpToolCall.table.audioSpeaker': 'Audio Speaker',
  'mcpToolCall.table.screen': 'Screen',
  'mcpToolCall.table.network': 'Network',
  'mcpToolCall.table.audioControl': 'Audio Control',
  'mcpToolCall.table.screenControl': 'Screen Control',
  'mcpToolCall.table.systemControl': 'System Control',
  'mcpToolCall.table.screenInfo': 'Screen Info',
  'mcpToolCall.table.hardwareInfo': 'Hardware Info',
  'mcpToolCall.table.memoryInfo': 'Memory Info',
  'mcpToolCall.table.applicationInfo': 'Application Info',
  'mcpToolCall.table.networkInfo': 'Network Info',
  'mcpToolCall.table.displayInfo': 'Display Info',
  'mcpToolCall.table.deviceInfo': 'Device Info',
  'mcpToolCall.table.systemInfo': 'System Info',
  // Table column headers
  'mcpToolCall.table.component': 'Component',
  'mcpToolCall.table.property': 'Property',
  'mcpToolCall.table.value': 'Value',

  'mcpToolCall.prop.volume': 'Volume',
  'mcpToolCall.prop.brightness': 'Brightness',
  'mcpToolCall.prop.theme': 'Theme',
  'mcpToolCall.prop.type': 'Type',
  'mcpToolCall.prop.ssid': 'SSID',
  'mcpToolCall.prop.signalStrength': 'Signal Strength',
  'mcpToolCall.prop.operationResult': 'Operation Result',
  'mcpToolCall.prop.width': 'Width',
  'mcpToolCall.prop.height': 'Height',
  'mcpToolCall.prop.screenType': 'Type',
  'mcpToolCall.prop.chipModel': 'Chip Model',
  'mcpToolCall.prop.cpuCores': 'CPU Cores',
  'mcpToolCall.prop.chipVersion': 'Chip Version',
  'mcpToolCall.prop.flashSize': 'Flash Size',
  'mcpToolCall.prop.minFreeHeap': 'Minimum Free Heap',
  'mcpToolCall.prop.applicationName': 'Application Name',
  'mcpToolCall.prop.applicationVersion': 'Application Version',
  'mcpToolCall.prop.compileTime': 'Compile Time',
  'mcpToolCall.prop.idfVersion': 'IDF Version',
  'mcpToolCall.prop.macAddress': 'MAC Address',
  'mcpToolCall.prop.ipAddress': 'IP Address',
  'mcpToolCall.prop.wifiName': 'WiFi Name',
  'mcpToolCall.prop.wifiChannel': 'WiFi Channel',
  'mcpToolCall.prop.screenSize': 'Screen Size',
  'mcpToolCall.prop.deviceUuid': 'Device UUID',
  'mcpToolCall.prop.systemLanguage': 'System Language',
  'mcpToolCall.prop.currentOtaPartition': 'Current OTA Partition',
  'mcpToolCall.prop.getResult': 'Get Result',
  'mcpToolCall.prop.url': 'URL',
  'mcpToolCall.prop.quality': 'Quality',
  'mcpToolCall.prop.question': 'Question',

  // Tool help texts
  'mcpToolCall.help.getDeviceStatus': 'View the current running status of the device, including volume, screen, battery and other information.',
  'mcpToolCall.help.setVolume': 'Adjust the volume of the device, please enter a value between 0-100.',
  'mcpToolCall.help.setBrightness': 'Adjust the brightness of the device screen, please enter a value between 0-100.',
  'mcpToolCall.help.setTheme': 'Switch the display theme of the device screen, you can choose light or dark mode.',
  'mcpToolCall.help.takePhoto': 'Take photos with the device camera and perform recognition analysis, please enter the question you want to ask.',
  'mcpToolCall.help.getSystemInfo': 'Get the system information of the device, including hardware specifications, software version, etc.',
  'mcpToolCall.help.reboot': 'Reboot the device, the device will restart after execution.',
  'mcpToolCall.help.upgradeFirmware': 'Download and upgrade the device firmware from the specified URL, the device will restart automatically after the upgrade.',
  'mcpToolCall.help.getScreenInfo': 'Get detailed information about the screen, such as resolution, size and other parameters.',
  'mcpToolCall.help.snapshot': 'Take a screenshot of the current screen and upload it to the specified URL.',
  'mcpToolCall.help.previewImage': 'Preview images from the specified URL on the device screen.',
  'mcpToolCall.help.setDownloadUrl': 'Set the download address for device resource files.',

  // Other text
  'mcpToolCall.text.strong': 'Strong',
  'mcpToolCall.text.medium': 'Medium',
  'mcpToolCall.text.weak': 'Weak',
  'mcpToolCall.text.dark': 'Dark',
  'mcpToolCall.text.light': 'Light',
  'mcpToolCall.text.setSuccess': 'Setting successful',
  'mcpToolCall.text.setFailed': 'Setting failed',
  'mcpToolCall.text.brightnessSetSuccess': 'Brightness setting successful',
  'mcpToolCall.text.brightnessSetFailed': 'Brightness setting failed',
  'mcpToolCall.text.themeSetSuccess': 'Theme setting successful',
  'mcpToolCall.text.themeSetFailed': 'Theme setting failed',
  'mcpToolCall.text.rebootCommandSent': 'Reboot command sent',
  'mcpToolCall.text.rebootFailed': 'Reboot failed',
  'mcpToolCall.text.monochrome': 'Monochrome Screen',
  'mcpToolCall.text.color': 'Color Screen',
  'mcpToolCall.text.getSuccessParseFailed': 'Get successful, but parse failed',
  'mcpToolCall.text.getFailed': 'Get failed',
  'mcpToolCall.text.getSuccessFormatError': 'Get successful, but data format is abnormal',

  // Dictionary data dialog related
  'dictDataDialog.addDictData': 'Add Dictionary Data',
  'dictDataDialog.dictLabel': 'Dictionary Label',
  'dictDataDialog.dictLabelPlaceholder': 'Please enter dictionary label',
  'dictDataDialog.dictValue': 'Dictionary Value',
  'dictDataDialog.dictValuePlaceholder': 'Please enter dictionary value',
  'dictDataDialog.sort': 'Sort',
  'dictDataDialog.requiredDictLabel': 'Please enter dictionary label',
  'dictDataDialog.requiredDictValue': 'Please enter dictionary value',

  // Dictionary type dialog related
  'dictTypeDialog.addDictType': 'Add Dictionary Type',
  'dictTypeDialog.dictName': 'Dictionary Type Name',
  'dictTypeDialog.dictNamePlaceholder': 'Please enter dictionary type name',
  'dictTypeDialog.dictType': 'Dictionary Type Code',
  'dictTypeDialog.dictTypePlaceholder': 'Please enter dictionary type code',
  'dictTypeDialog.requiredDictName': 'Please enter dictionary type name',
  'dictTypeDialog.requiredDictType': 'Please enter dictionary type code',

  // Audio edit dialog related
  'editVoiceDialog.voiceCode': 'Voice Code',
  'editVoiceDialog.voiceCodePlaceholder': 'Please enter voice code',
  'editVoiceDialog.voiceName': 'Voice Name',
  'editVoiceDialog.voiceNamePlaceholder': 'Please enter voice name',
  'editVoiceDialog.languageType': 'Language Type',
  'editVoiceDialog.languageTypePlaceholder': 'Please enter language type',
  'editVoiceDialog.sortNumber': 'Sort Number',
  'editVoiceDialog.remark': 'Remark',
  'editVoiceDialog.remarkPlaceholder': 'Please enter remark content',
  'editVoiceDialog.generatePreview': 'Generate Preview',
  'editVoiceDialog.defaultVoiceName': 'Wawa Xiaohe',
  'editVoiceDialog.defaultLanguageType': 'Chinese',
  'editVoiceDialog.requiredVoiceCode': 'Please enter voice code',
  'editVoiceDialog.requiredVoiceName': 'Please enter voice name',

  // Firmware dialog related
  'firmwareDialog.firmwareName': 'Firmware Name',
  'firmwareDialog.firmwareNamePlaceholder': 'Please enter firmware name (board + version)',
  'firmwareDialog.firmwareType': 'Firmware Type',
  'firmwareDialog.firmwareTypePlaceholder': 'Please select firmware type',
  'firmwareDialog.version': 'Version',
  'firmwareDialog.versionPlaceholder': 'Please enter version (x.x.x format)',
  'firmwareDialog.firmwareFile': 'Firmware File',
  'firmwareDialog.clickUpload': 'Click to Upload',
  'firmwareDialog.uploadTip': 'Only firmware files (.bin/.apk) are supported, and size should not exceed 100MB',
  'firmwareDialog.uploadHint': 'Warm reminder: Please upload the pre-merged xiaozhi.bin file, not the merged merged-binary.bin file',
  'firmwareDialog.remark': 'Remark',
  'firmwareDialog.remarkPlaceholder': 'Please enter remark information',
  'firmwareDialog.requiredFirmwareName': 'Please enter firmware name (board + version)',
  'firmwareDialog.requiredFirmwareType': 'Please select firmware type',
  'firmwareDialog.requiredVersion': 'Please enter version',
  'firmwareDialog.versionFormatError': 'Version format is incorrect, please enter x.x.x format',
  'firmwareDialog.requiredFirmwareFile': 'Please upload firmware file',
  'firmwareDialog.invalidFileType': 'Only .bin/.apk format firmware files are supported!',
  'firmwareDialog.invalidFileSize': 'Firmware file size cannot exceed 100MB!',
  'firmwareDialog.uploadSuccess': 'Firmware file uploaded successfully',
  'firmwareDialog.uploadFailed': 'File upload failed',

  // Voice print dialog related
  'voicePrintDialog.addSpeaker': 'Add Speaker',
  'voicePrintDialog.voicePrintVector': 'Voice Print Vector',
  'voicePrintDialog.selectVoiceMessage': 'Please select a voice message',
  'voicePrintDialog.name': 'Name',
  'voicePrintDialog.enterName': 'Please enter name',
  'voicePrintDialog.description': 'Description',
  'voicePrintDialog.enterDescription': 'Please enter description',
  'voicePrintDialog.save': 'Save',
  'voicePrintDialog.cancel': 'Cancel',
  'voicePrintDialog.requiredDescription': 'Please enter description',
  'voicePrintDialog.requiredName': 'Please enter name',
  'voicePrintDialog.requiredAudioVector': 'Please select audio vector',

  // Voice print page related
  'voicePrint.pageTitle': 'Voice Print Recognition',
  'voicePrint.name': 'Name',
  'voicePrint.description': 'Description',
  'voicePrint.createTime': 'Creation Time',
  'voicePrint.action': 'Action',
  'voicePrint.edit': 'Edit',
  'voicePrint.delete': 'Delete',
  'voicePrint.add': 'Add',
  'voicePrint.addSpeaker': 'Add Speaker',
  'voicePrint.editSpeaker': 'Edit Speaker',
  'voicePrint.fetchFailed': 'Failed to fetch voice print list',
  'voicePrint.updateSuccess': 'Update successful',
  'voicePrint.addSuccess': 'Add successful',
  'voicePrint.confirmDelete': 'Are you sure you want to delete this voice print?',
  'voicePrint.warning': 'Warning',
  'voicePrint.confirm': 'Confirm',
  'voicePrint.cancel': 'Cancel',
  'voicePrint.deleteSuccess': 'Successfully deleted this voice print',
  'voicePrint.deleteFailed': 'Deletion failed, please try again',
  'voicePrint.cancelDelete': 'Deletion operation canceled',
  'voicePrint.closeOperation': 'Operation closed',
  'voicePrint.loading': 'Loading...',

  // Manual add device dialog related
  'manualAddDeviceDialog.title': 'Manual Add Device',
  'manualAddDeviceDialog.deviceType': 'Device Type',
  'manualAddDeviceDialog.deviceTypePlaceholder': 'Please select device type',
  'manualAddDeviceDialog.firmwareVersion': 'Firmware Version',
  'manualAddDeviceDialog.firmwareVersionPlaceholder': 'Please enter firmware version',
  'manualAddDeviceDialog.macAddress': 'Mac Address',
  'manualAddDeviceDialog.macAddressPlaceholder': 'Please enter Mac address',
  'manualAddDeviceDialog.confirm': 'Confirm',
  'manualAddDeviceDialog.cancel': 'Cancel',
  'manualAddDeviceDialog.requiredMacAddress': 'Please enter Mac address',
  'manualAddDeviceDialog.invalidMacAddress': 'Please enter correct Mac address format, e.g.: 00:1A:2B:3C:4D:5E',
  'manualAddDeviceDialog.requiredDeviceType': 'Please select device type',
  'manualAddDeviceDialog.requiredFirmwareVersion': 'Please enter firmware version',
  'manualAddDeviceDialog.getFirmwareTypeFailed': 'Failed to get firmware type',
  'manualAddDeviceDialog.addSuccess': 'Device added successfully',
  'manualAddDeviceDialog.addFailed': 'Failed to add',

  // AddModelDialog component related
  'addModelDialog.requiredSupplier': 'Please select a supplier',

  // Register page related
  'register.title': 'Create Account',
  'register.welcome': 'Welcome to XiaoZhi AI',
  'register.usernamePlaceholder': 'Please enter username',
  'register.mobilePlaceholder': 'Please enter mobile phone number',
  'register.captchaPlaceholder': 'Please enter captcha',
  'register.mobileCaptchaPlaceholder': 'Please enter SMS verification code',
  'register.passwordPlaceholder': 'Please set password',
  'register.confirmPasswordPlaceholder': 'Please confirm password',
  'register.goToLogin': 'Already have an account? Login',
  'register.registerButton': 'Register',
  'register.agreeTo': 'By registering, you agree to our',
  'register.userAgreement': 'User Agreement',
  'register.privacyPolicy': 'Privacy Policy',
  'register.notAllowRegister': 'User registration is not allowed',
  'register.captchaLoadFailed': 'Failed to load captcha',
  'register.inputCaptcha': 'Please enter captcha',
  'register.inputCorrectMobile': 'Please enter correct mobile phone number',
  'register.captchaSendSuccess': 'Verification code sent successfully',
  'register.captchaSendFailed': 'Failed to send verification code',
  'register.passwordsNotMatch': 'Passwords do not match',
  'register.registerSuccess': 'Registration successful!',
  'register.registerFailed': 'Registration failed',
  'register.requiredUsername': 'Username cannot be empty',
  'register.requiredPassword': 'Password cannot be empty',
  'register.requiredCaptcha': 'Captcha cannot be empty',
  'register.requiredMobileCaptcha': 'Please enter SMS verification code',
  'register.invalidCaptcha': 'Invalid verification code',
  'register.passwordLength': 'Password length must be between 6-20 characters',
  'register.usernameFormat': 'Invalid username format',
  'register.confirmPasswordRequired': 'Confirm password cannot be empty',
  'register.sendCaptcha': 'Get Verification Code',
  'register.secondsLater': 'seconds later',

  // Parameter dialog related
  'paramDialog.paramCode': 'Parameter Code',
  'paramDialog.paramCodePlaceholder': 'Please enter parameter code',
  'paramDialog.paramValue': 'Parameter Value',
  'paramDialog.paramValuePlaceholder': 'Please enter parameter value',
  'paramDialog.valueType': 'Value Type',
  'paramDialog.valueTypePlaceholder': 'Please select value type',
  'paramDialog.remark': 'Remark',
  'paramDialog.remarkPlaceholder': 'Please enter remark',
  'paramDialog.save': 'Save',
  'paramDialog.cancel': 'Cancel',
  'paramDialog.requiredParamCode': 'Please enter parameter code',
  'paramDialog.requiredParamValue': 'Please enter parameter value',
  'paramDialog.requiredValueType': 'Please select value type',
  'paramDialog.stringType': 'String',
  'paramDialog.numberType': 'Number',
  'paramDialog.booleanType': 'Boolean',
  'paramDialog.arrayType': 'Array',
  'paramDialog.jsonType': 'JSON Object',

  // Login page text
  'login.title': 'Login',
  'login.welcome': 'WELCOME TO LOGIN',
  'login.username': 'Username',
  'login.usernamePlaceholder': 'Please enter username',
  'login.mobilePlaceholder': 'Please enter mobile number',
  'login.password': 'Password',
  'login.passwordPlaceholder': 'Please enter password',
  'login.captchaPlaceholder': 'Please enter verification code',
  'login.loginButton': 'Login',
  'login.login': 'Login',
  'login.register': 'Register',
  'login.forgotPassword': 'Forgot Password',
  'login.forgetPassword': 'Forgot Password?',
  'login.mobileLogin': 'Mobile Login',
  'login.usernameLogin': 'Username Login',
  'login.agreeTo': 'Login implies acceptance of',
  'login.userAgreement': 'User Agreement',
  'login.and': 'and',
  'login.privacyPolicy': 'Privacy Policy',
  'login.registerAccount': 'Register Account',

  // Retrieve password page text
  'retrievePassword.title': 'Reset Password',
  'retrievePassword.welcome': 'PASSWORD RETRIEVE',
  'retrievePassword.subtitle': 'Retrieve Password',
  'retrievePassword.mobile': 'Mobile',
  'retrievePassword.mobilePlaceholder': 'Please enter mobile number',
  'retrievePassword.captcha': 'Verification Code',
  'retrievePassword.captchaPlaceholder': 'Please enter verification code',
  'retrievePassword.mobileCaptcha': 'Mobile Verification Code',
  'retrievePassword.mobileCaptchaPlaceholder': 'Please enter mobile verification code',
  'retrievePassword.newPassword': 'New Password',
  'retrievePassword.newPasswordPlaceholder': 'Please enter new password',
  'retrievePassword.confirmNewPassword': 'Confirm New Password',
  'retrievePassword.confirmNewPasswordPlaceholder': 'Please confirm new password',
  'retrievePassword.getMobileCaptcha': 'Get Verification Code',
  'retrievePassword.resetButton': 'Reset Password',
  'retrievePassword.updateButton': 'Update Now',
  'retrievePassword.goToLogin': 'Back to Login',
  'retrievePassword.inputCorrectMobile': 'Please enter correct mobile number',
  'retrievePassword.captchaSendSuccess': 'Verification code sent successfully',
  'retrievePassword.passwordsNotMatch': 'Two password entries do not match',
  'retrievePassword.passwordLength': 'Password length must be between 6-20 characters',
  'retrievePassword.mobileRequired': 'Mobile number cannot be empty',
  'retrievePassword.captchaRequired': 'Verification code cannot be empty',
  'retrievePassword.mobileCaptchaRequired': 'Mobile verification code cannot be empty',
  'retrievePassword.newPasswordRequired': 'New password cannot be empty',
  'retrievePassword.confirmNewPasswordRequired': 'Confirm new password cannot be empty',
  'retrievePassword.passwordUpdateSuccess': 'Password updated successfully',
  'retrievePassword.agreeTo': 'Reset means agree',

  // Change password page text
  'changePassword.title': 'Change Password',
  'changePassword.oldPasswordLabel': 'Old Password:',
  'changePassword.oldPasswordPlaceholder': 'Please enter old password',
  'changePassword.newPasswordLabel': 'New Password:',
  'changePassword.newPasswordPlaceholder': 'Please enter new password',
  'changePassword.confirmPasswordLabel': 'Confirm New Password:',
  'changePassword.confirmPasswordPlaceholder': 'Please re-enter new password',
  'changePassword.confirmButton': 'Confirm',
  'changePassword.cancelButton': 'Cancel',
  'changePassword.allFieldsRequired': 'Please fill in all fields',
  'changePassword.passwordsNotMatch': 'Two new password entries do not match',
  'changePassword.newPasswordSameAsOld': 'New password cannot be the same as old password',
  'changePassword.passwordChangedSuccessfully': 'Password changed successfully, please login again',
  'changePassword.changeFailed': 'Password change failed',

  // Device management page text
  'device.management': 'Device Management',
  'device.add': 'Add Device',
  'device.edit': 'Edit Device',
  'device.delete': 'Delete Device',
  'device.name': 'Device Name',
  'device.type': 'Device Type',
  'device.status': 'Device Status',
  'device.dialogTitle': 'Add Device',
  'device.verificationCode': 'Verification Code:',
  'device.verificationCodePlaceholder': 'Please enter the 6-digit verification code broadcasted by the device..',
  'device.confirmButton': 'Confirm',
  'device.cancelButton': 'Cancel',
  'device.input6DigitCode': 'Please enter a 6-digit verification code',
  'device.bindSuccess': 'Device binding successful',
  'device.bindFailed': 'Binding failed',
  'device.searchPlaceholder': 'Please enter device model or Mac address to search',
  'device.model': 'Device Model',
  'device.macAddress': 'Mac Address',
  'device.firmwareVersion': 'Firmware Version',
  'device.bindTime': 'Binding Time',
  'device.lastConversation': 'Last Conversation',
  'device.remark': 'Remark',
  'device.autoUpdate': 'Auto Update',
  'device.operation': 'Operation',
  'device.search': 'Search',
  'device.selectAll': 'Select All/Deselect All',
  'deviceManagement.loading': 'Loading...',
  'device.bindWithCode': '6-digit Verification Code Binding',
  'device.manualAdd': 'Manual Add',
  'device.unbind': 'Unbind',
  'device.toolCall': 'Tool Call',
  'device.selectAtLeastOne': 'Please select at least one record',
  'device.confirmBatchUnbind': 'Are you sure you want to unbind {count} selected devices?',
  'device.batchUnbindSuccess': 'Successfully unbound {count} devices',
  'device.batchUnbindError': 'Error occurred during batch unbinding',
  'device.remarkTooLong': 'Remark cannot exceed 64 characters',
  'device.remarkSaved': 'Remark saved successfully',
  'device.remarkSaveFailed': 'Failed to save remark',
  'device.confirmUnbind': 'Are you sure you want to unbind this device?',
  'device.unbindSuccess': 'Device unbound successfully',
  'device.unbindFailed': 'Failed to unbind device',
  'device.getListFailed': 'Failed to fetch device list',
  'device.autoUpdateEnabled': 'Auto update enabled',
  'device.autoUpdateDisabled': 'Auto update disabled',
  'device.batchUnbindSuccess': 'Successfully unbound {count} devices',
  'device.getFirmwareTypeFailed': 'Failed to fetch firmware type',
  'device.deviceStatus': 'Status',
  'device.online': 'Online',
  'device.offline': 'Offline',

  // Message tips
  'message.success': 'Operation Successful',
  'message.error': 'Operation Failed',
  'message.warning': 'Warning',
  'message.info': 'Information',

  // Cache related
  'cache.viewer': 'Cache Viewer',

  // Chat history dialog related
  'chatHistory.with': 'With',
  'chatHistory.dialogTitle': "'s Chat History",
  'chatHistory.loading': 'Loading...',
  'chatHistory.noMoreRecords': 'No more records',
  'chatHistory.selectSession': 'Please select a session to view chat history',
  'chatHistory.today': 'Today',
  'chatHistory.yesterday': 'Yesterday',
  'chatHistory.downloadCurrentSession': 'Download current session chat history',
  'chatHistory.downloadCurrentWithPreviousSessions': 'Download current and previous 20 sessions chat history',
  'chatHistory.downloadLinkFailed': 'Failed to get download link',

  'cache.status': 'Cache Status',
  'cache.cdnEnabled': 'CDN Mode Enabled',
  'cache.cdnDisabled': 'CDN Mode Disabled',
  'cache.serviceWorkerRegistered': 'Service Worker Registered',
  'cache.serviceWorkerNotRegistered': 'Service Worker Not Registered',
  'cache.noCacheDetected': 'No cache detected yet, please refresh the page or wait for cache to be established',
  'cache.swDevEnvWarning': 'In development environment, Service Worker may not initialize cache properly',
  'cache.swCheckMethods': 'Please try the following methods to check if Service Worker is working:',
  'cache.swCheckMethod1': 'Check Service Worker status in Application/Application tab of developer tools',
  'cache.swCheckMethod2': 'View cache content in Application/Cache/Cache Storage of developer tools',
  'cache.swCheckMethod3': 'Use production build (npm run build) and access through HTTP server to test full functionality',
  'cache.swDevEnvNormal': 'In development environment, this is normal',
  'cache.swProdOnly': 'Service Worker usually only works in production environment',
  'cache.swTestingTitle': 'To test Service Worker functionality:',
  'cache.swTestingStep1': 'Run npm run build to build production version',
  'cache.swTestingStep2': 'Access the built page through HTTP server',
  'cache.swNotSupported': 'The current browser does not support Service Worker, CDN resource caching function is unavailable',
  'cache.dialogTitle': 'CDN Resource Cache Status',
  'cache.loading': 'Loading cache information...',
  'cache.notSupported': 'Your browser does not support Cache API or Service Worker is not installed',
  'cache.refreshPage': 'Refresh Page',
  'cache.noCachedResources': 'No cached CDN resources found',
  'cache.noCachedResourcesDesc': 'Service Worker may not have completed initialization or cache has not been established. Please refresh the page or try again later.',
  'cache.cdnCacheStatus': 'CDN Resource Cache Status',
  'cache.totalCachedResources': 'Found {count} cached resources in total',
  'cache.jsResources': 'JavaScript Resources ({count})',
  'cache.cssResources': 'CSS Resources ({count})',
  'cache.cached': 'Cached',
  'cache.notCached': 'Not Cached',
  'cache.refreshStatus': 'Refresh Cache Status',
  'cache.clearCache': 'Clear Cache',
  'cache.refreshingStatus': 'Refreshing cache status',
  'cache.confirmClear': 'Are you sure you want to clear all cache?',
  'cache.clearedSuccess': 'Cache cleared successfully',
  'cache.clearFailed': 'Failed to clear cache',
  'cache.clearCanceled': 'Clear operation canceled',

  // Common buttons
  'button.ok': 'OK',
  'button.cancel': 'Cancel',
  'button.save': 'Save',
  'button.close': 'Close',

  // System information
  'system.name': 'XiaoZhi Service',

  // Voiceprint related
  'voiceprint.management': 'Voiceprint Management',
  'voiceprint.add': 'Add Voiceprint',
  'voiceprint.delete': 'Delete Voiceprint',

  // Dictionary management page text
  'dictManagement.pageTitle': 'Dictionary Management',
  'dictManagement.searchPlaceholder': 'Please enter dict value label to search',
  'dictManagement.search': 'Search',
  'dictManagement.dictTypeName': 'Dict Type Name',
  'dictManagement.operation': 'Operation',
  'dictManagement.edit': 'Edit',
  'dictManagement.dictLabel': 'Dict Label',
  'dictManagement.dictValue': 'Dict Value',
  'dictManagement.sort': 'Sort',
  'dictManagement.delete': 'Delete',
  'dictManagement.selectAll': 'Select All',
  'dictManagement.deselectAll': 'Deselect All',
  'dictManagement.addDictType': 'Add Dict Type',
  'dictManagement.batchDeleteDictType': 'Batch Delete Dict Types',
  'dictManagement.addDictData': 'Add Dict Data',
  'dictManagement.batchDeleteDictData': 'Batch Delete Dict Data',
  'dictManagement.itemsPerPage': '{items} items/page',
  'dictManagement.firstPage': 'First Page',
  'dictManagement.prevPage': 'Previous Page',
  'dictManagement.nextPage': 'Next Page',
  'dictManagement.totalRecords': 'Total {total} records',
  'dictManagement.editDictType': 'Edit Dict Type',
  'dictManagement.editDictData': 'Edit Dict Data',
  'dictManagement.saveSuccess': 'Save Success',
  'dictManagement.deleteSuccess': 'Delete Success',
  'dictManagement.selectDictTypeToDelete': 'Please select dict types to delete',
  'dictManagement.confirmDeleteDictType': 'Are you sure you want to delete the selected dict types?',
  'dictManagement.confirm': 'Confirm',
  'dictManagement.cancel': 'Cancel',
  'dictManagement.selectDictTypeFirst': 'Please select a dict type first',
  'dictManagement.confirmDeleteDictData': 'Are you sure you want to delete this dict data?',
  'dictManagement.selectDictDataToDelete': 'Please select dict data to delete',
  'dictManagement.confirmBatchDeleteDictData': 'Are you sure you want to delete {count} selected dict data items?',
  'dictManagement.getDictDataFailed': 'Failed to get dict data',

  // User information
  'user.info': 'User Information',
  'user.username': 'Username',
  'user.mobile': 'Mobile Phone',
  'user.userid': 'User ID',
  'user.deviceCount': 'Device Count',
  'user.createDate': 'Registration Time',
  'user.status': 'Status',
  'user.normal': 'Normal',
  'user.disabled': 'Disabled',
  'user.resetPassword': 'Reset Password',
  'user.disableAccount': 'Disable Account',
  'user.enableAccount': 'Enable Account',
  'user.deleteUser': 'Delete User',
  'user.deselectAll': 'Deselect All',
  'user.selectAll': 'Select All',
  'user.enable': 'Enable',
  'user.disable': 'Disable',
  'user.delete': 'Delete',
  'user.selectUsersFirst': 'Please select users to delete first',
  'user.confirmDeleteSelected': 'Are you sure you want to delete {count} selected users?',
  'user.deleting': 'Deleting...',
  'user.deleteSuccess': 'Successfully deleted {count} users',
  'user.deleteFailed': 'Deletion failed, please try again',
  'user.partialDelete': 'Successfully deleted {successCount} users, {failCount} failed to delete',
  'user.deleteError': 'An error occurred during deletion',
  'user.deleteCancelled': 'Deletion cancelled',
  'user.confirmResetPassword': 'A new password will be generated after reset. Continue?',
  'user.resetPasswordSuccess': 'Password has been reset, please notify the user to log in with the new password',
  'user.generatedPassword': 'Generated Default Password',
  'user.confirmDeleteUser': 'Are you sure you want to delete this user?',
  'user.deleteUserSuccess': 'Deletion successful',
  'user.operationFailed': 'Operation failed, please try again',
  'user.confirmStatusChange': 'Are you sure you want to {action} {count} selected users?',
  'user.statusChangeSuccess': 'Successfully {action} {count} users',
  'user.invalidUserId': 'There are invalid user IDs',
  'user.searchPhone': 'Please enter mobile phone number to search',
  'user.search': 'Search',

  // Provider Management Page Text
  'providerManagement.categoryFilter': 'Category Filter',
  'providerManagement.searchPlaceholder': 'Please enter provider name to search',
  'providerManagement.category': 'Category',
  'providerManagement.providerCode': 'Provider Code',
  'providerManagement.fieldConfig': 'Field Configuration',
  'providerManagement.selectToDelete': 'Please select providers to delete first',
  'providerManagement.confirmDelete': 'Are you sure to delete the selected {count} providers?',
  'providerManagement.viewFields': 'View Fields',

  // Common Text
  'common.all': 'All',
  'common.search': 'Search',
  'common.name': 'Name',
  'common.sort': 'Sort',
  'common.action': 'Action',
  'common.edit': 'Edit',
  'common.delete': 'Delete',
  'common.selectAll': 'Select All',
  'common.deselectAll': 'Deselect All',
  'common.add': 'Add',
  'common.perPage': '{number}/page',
  'common.firstPage': 'First Page',
  'common.prevPage': 'Previous Page',
  'common.nextPage': 'Next Page',
  'common.totalRecords': 'Total {number} records',
  'common.addProvider': 'Add Provider',
  'common.success': 'Success',
  'common.editProvider': 'Edit Provider',
  'common.updateSuccess': 'Update Success',
  'common.addSuccess': 'Add Success',
  'common.deleteSuccess': 'Delete Success',
  'common.deleteFailure': 'Delete Failed, Please Try Again',
  'common.deleteCancelled': 'Delete Cancelled',
  'common.warning': 'Warning',
  'common.tip': 'Tip',
  'common.confirm': 'Confirm',
  'common.cancel': 'Cancel',
  'common.sensitive': 'Sensitive',

  // Language switch
  'language.zhCN': '中文简体',
  'language.zhTW': '中文繁體',
  'language.en': 'English',

  // Home page text
  'home.addAgent': 'Add Agent',
  'home.greeting': 'Hi Jarvis',
  'home.wish': "Let's have a wonderful day!",
  'home.languageModel': 'LLM',
  'home.voiceModel': 'TTS',
  'home.configureRole': 'Config Role',
  'home.voiceprintRecognition': 'Voiceprint',
  'home.deviceManagement': 'Devices',
  'home.chatHistory': 'Chat History',
  'home.lastConversation': 'Last Conversation',
  'home.noConversation': 'No conversation',
  'home.justNow': 'Just now',
  'home.minutesAgo': '{minutes} minutes ago',
  'home.hoursAgo': '{hours} hours {minutes} minutes ago',
  'home.confirmDeleteAgent': 'Are you sure you want to delete this agent?',
  'home.deleteSuccess': 'Delete successful',
  'home.deleteFailed': 'Delete failed',
  'home.enableMemory': 'Please enable memory in the "Config Role" page first',

  // Parameter management page text
  'paramManagement.pageTitle': 'Parameter Management',
  'paramManagement.searchPlaceholder': 'Please enter parameter code or remark to search',
  'paramManagement.search': 'Search',
  'paramManagement.paramCode': 'Parameter Code',
  'paramManagement.paramValue': 'Parameter Value',
  'paramManagement.remark': 'Remark',
  'paramManagement.operation': 'Operation',
  'paramManagement.hide': 'Hide',
  'paramManagement.view': 'View',
  'paramManagement.deselectAll': 'Deselect All',
  'paramManagement.selectAll': 'Select All',
  'paramManagement.add': 'Add',
  'paramManagement.delete': 'Delete',
  'paramManagement.edit': 'Edit',
  'paramManagement.itemsPerPage': 'items/page',
  'paramManagement.firstPage': 'First Page',
  'paramManagement.prevPage': 'Previous Page',
  'paramManagement.nextPage': 'Next Page',
  'paramManagement.totalRecords': 'Total {total} records',
  'paramManagement.addParam': 'Add Parameter',
  'paramManagement.editParam': 'Edit Parameter',
  'paramManagement.getParamsListFailed': 'Failed to get parameter list',
  'paramManagement.selectParamsFirst': 'Please select parameters to delete first',
  'paramManagement.confirmBatchDelete': 'Are you sure you want to delete {paramCount} selected parameters?',
  'paramManagement.invalidParamId': 'There are invalid parameter IDs',
  'paramManagement.batchDeleteSuccess': 'Successfully deleted {paramCount} parameters',
  'paramManagement.deleteFailed': 'Deletion failed, please try again',
  'paramManagement.operationCancelled': 'Deletion cancelled',
  'paramManagement.operationClosed': 'Operation closed',
  'paramManagement.updateSuccess': 'Update successful',
  'paramManagement.addSuccess': 'Add successful',
  'paramManagement.updateFailed': 'Update failed',
  'paramManagement.addFailed': 'Add failed',

  // Server side management page text
  'serverSideManager.pageTitle': 'Server Management',
  'serverSideManager.wsAddress': 'WS Address',
  'serverSideManager.operation': 'Operation',
  'serverSideManager.restart': 'Restart',
  'serverSideManager.updateConfig': 'Update Config',
  'serverSideManager.restartServer': 'Restart Server',
  'serverSideManager.updateConfigTitle': 'Update Config',
  'serverSideManager.confirmRestart': 'Are you sure you want to restart the server?',
  'serverSideManager.confirmUpdateConfig': 'Are you sure you want to update the config?',
  'serverSideManager.loading': 'Loading...',
  'serverSideManager.getServerListFailed': 'Failed to get server list',
  'serverSideManager.operationFailed': 'Operation failed',
  'serverSideManager.restartSuccess': 'Restart successful',
  'serverSideManager.updateConfigSuccess': 'Config update successful',

  // Add agent dialog text
  'addAgentDialog.title': 'Add Agent',
  'addAgentDialog.agentName': 'Agent Name',
  'addAgentDialog.placeholder': 'Please enter agent name..',
  'addAgentDialog.confirm': 'Confirm',
  'addAgentDialog.cancel': 'Cancel',
  'addAgentDialog.nameRequired': 'Please enter agent name',
  'addAgentDialog.addSuccess': 'Add successful',

  // Role configuration page text
  'roleConfig.title': 'Role Configuration',
  'roleConfig.restartNotice': 'After saving the configuration, you need to restart the device for the new configuration to take effect.',
  'roleConfig.saveConfig': 'Save Configuration',
  'roleConfig.reset': 'Reset',
  'roleConfig.agentName': 'Nickname',
  'roleConfig.roleTemplate': 'Template',
  'roleConfig.roleIntroduction': 'Introduction',
  'roleConfig.languageCode': 'Language Code',
  'roleConfig.interactionLanguage': 'Interaction Language',
  'roleConfig.vad': 'Voice Detect',
  'roleConfig.asr': 'Speech Recognition',
  'roleConfig.llm': 'Language Model',
  'roleConfig.vllm': 'Vision Model',
  'roleConfig.tts': 'Text-to-Speech',
  'roleConfig.memoryHis': 'Memory',
  'roleConfig.memory': 'Memory Model',
  'roleConfig.intent': 'Intent Recognition',
  'roleConfig.voiceType': 'Voice Type',
  'roleConfig.pleaseEnterContent': 'Please enter content',
  'roleConfig.pleaseEnterLangCode': 'Please enter language code, e.g.: en_US',
  'roleConfig.pleaseEnterLangName': 'Please enter interaction language, e.g.: English',
  'roleConfig.pleaseSelect': 'Please select',
  'roleConfig.editFunctions': 'Edit Functions',
  'roleConfig.reportText': 'Text Only',
  'roleConfig.reportTextVoice': 'Text & Voice',
  'roleConfig.saveSuccess': 'Configuration saved successfully',
  'roleConfig.saveFailed': 'Configuration save failed',
  'roleConfig.confirmReset': 'Are you sure you want to reset the configuration?',
  'roleConfig.resetSuccess': 'Configuration has been reset',
  'roleConfig.fetchTemplatesFailed': 'Failed to fetch template list',
  'roleConfig.templateApplied': 'template has been applied',
  'roleConfig.applyTemplateFailed': 'Failed to apply template',
  'roleConfig.fetchConfigFailed': 'Failed to fetch configuration',
  'roleConfig.fetchModelsFailed': 'Failed to fetch model list',
  'roleConfig.fetchPluginsFailed': 'Failed to fetch plugin list',

  // Function management dialog text
  'functionDialog.title': 'Function Management',
  'functionDialog.unselectedFunctions': 'Unselected Functions',
  'functionDialog.selectedFunctions': 'Selected Functions',
  'functionDialog.selectAll': 'Select All',
  'functionDialog.noMorePlugins': 'No more plugins available',
  'functionDialog.pleaseSelectPlugin': 'Please select plugin functions',
  'functionDialog.paramConfig': 'Parameter Configuration',
  'functionDialog.noNeedToConfig': ' does not require parameter configuration',
  'functionDialog.pleaseSelectFunctionForParam': 'Please select a configured function for parameter settings',
  'functionDialog.mcpAccessPoint': 'MCP Access Point',
  'functionDialog.mcpAddressDesc': 'Below are the MCP access point addresses for the agent.',
  'functionDialog.howToDeployMcp': 'How to deploy MCP access point',
  'functionDialog.howToIntegrateMcp': 'How to integrate MCP functions',
  'functionDialog.copy': 'Copy',
  'functionDialog.accessPointStatus': 'Access Point Status',
  'functionDialog.connected': 'Connected',
  'functionDialog.loading': 'Loading...',
  'functionDialog.disconnected': 'Disconnected',
  'functionDialog.refresh': 'Refresh',
  'functionDialog.noAvailableTools': 'No available tools',
  'functionDialog.cancel': 'Cancel',
  'functionDialog.saveConfig': 'Save Configuration',
  'functionDialog.copiedToClipboard': 'Copied to clipboard',
  'functionDialog.copyFailed': 'Copy failed, please copy manually',
  'functionDialog.jsonFormatError': ' field format error: invalid JSON format',
  'functionDialog.defaultValue': 'Default Value',

  // Model Configuration Page Text
  'modelConfig.searchPlaceholder': 'Please enter model name to search',
  'modelConfig.search': 'Search',
  'modelConfig.vad': 'Voice Activity Detection',
  'modelConfig.asr': 'Speech Recognition',
  'modelConfig.llm': 'Large Language Model',
  'modelConfig.vllm': 'Visual Language Model',
  'modelConfig.intent': 'Intent Recognition',
  'modelConfig.tts': 'Text-to-Speech',
  'modelConfig.memory': 'Memory',
  'modelConfig.modelId': 'Model ID',
  'modelConfig.modelName': 'Model Name',
  'modelConfig.provider': 'Provider',
  'modelConfig.unknown': 'Unknown',
  'modelConfig.isEnabled': 'Enabled',
  'modelConfig.isDefault': 'Default',
  'modelConfig.action': 'Action',
  'modelConfig.voiceManagement': 'Voice Management',
  'modelConfig.edit': 'Edit',
  'modelConfig.duplicate': 'Duplicate',
  'modelConfig.delete': 'Delete',
  'modelConfig.deselectAll': 'Deselect All',
  'modelConfig.select': 'Select',
  'modelConfig.selectAll': 'Select All',
  'modelConfig.add': 'Add New',
  'modelConfig.selectModelsFirst': 'Please select models to delete first',
  'modelConfig.confirmBatchDelete': 'Are you sure you want to delete the selected models?',
  'modelConfig.confirmDelete': 'Are you sure you want to delete this model?',
  'modelConfig.batchDeleteSuccess': 'Batch deletion successful',
  'modelConfig.partialDeleteFailed': 'Partial deletion failed',
  'modelConfig.deleteSuccess': 'Deletion successful',
  'modelConfig.deleteFailed': 'Deletion failed',
  'modelConfig.duplicateSuccess': 'Duplication successful',
  'modelConfig.duplicateFailed': 'Duplication failed',
  'modelConfig.saveSuccess': 'Save successful',
  'modelConfig.saveFailed': 'Save failed',
  'modelConfig.addSuccess': 'Addition successful',
  'modelConfig.addFailed': 'Addition failed',
  'modelConfig.fetchModelsFailed': 'Failed to fetch model list',
  'modelConfig.enableSuccess': 'Enable successful',
  'modelConfig.disableSuccess': 'Disable successful',
  'modelConfig.operationFailed': 'Operation failed',
  'modelConfig.setDefaultSuccess': 'Set default model successful',
  'modelConfig.itemsPerPage': '{items} items/page',
  'modelConfig.firstPage': 'First Page',
  'modelConfig.prevPage': 'Previous Page',
  'modelConfig.nextPage': 'Next Page',
  'modelConfig.totalRecords': 'Total {total} records',
  'modelConfig.loading': 'Loading...',

  // Model Configuration Dialog Text
  'modelConfigDialog.addModel': 'Add Model',
  'modelConfigDialog.editModel': 'Edit Model',
  'modelConfigDialog.duplicateModel': 'Duplicate Model',
  'modelConfigDialog.copySuffix': '_copy',
  'modelConfigDialog.modelInfo': 'Model Information',
  'modelConfigDialog.enable': 'Enable',
  'modelConfigDialog.setDefault': 'Set as Default',
  'modelConfigDialog.modelName': 'Model Name',
  'modelConfigDialog.enterModelName': 'Please enter model name',
  'modelConfigDialog.modelCode': 'Model Code',
  'modelConfigDialog.enterModelCode': 'Please enter model code',
  'modelConfigDialog.supplier': 'Supplier',
  'modelConfigDialog.selectSupplier': 'Please select',
  'modelConfigDialog.sortOrder': 'Sort Order',
  'modelConfigDialog.enterSortOrder': 'Please enter sort order',
  'modelConfigDialog.docLink': 'Documentation Link',
  'modelConfigDialog.enterDocLink': 'Please enter documentation link',
  'modelConfigDialog.remark': 'Remark',
  'modelConfigDialog.enterRemark': 'Please enter model remark',
  'modelConfigDialog.callInfo': 'Call Information',
  'modelConfigDialog.enterJsonExample': 'Please enter JSON format variables (example:{"key":"value"})',
  'modelConfigDialog.save': 'Save',

  // TTS Model Configuration Text
  'ttsModel.select': 'Select',
  'ttsModel.voiceCode': 'Voice Code',
  'ttsModel.voiceName': 'Voice Name',
  'ttsModel.languageType': 'Language Type',
  'ttsModel.preview': 'Preview',
  'ttsModel.enterMp3Url': 'Please enter MP3 URL',
  'ttsModel.remark': 'Remark',
  'ttsModel.enterRemark': 'This is a remark',
  'ttsModel.referenceAudioPath': 'Reference Audio Path',
  'ttsModel.enterReferenceAudio': 'This is the reference audio path',
  'ttsModel.referenceText': 'Reference Audio Text',
  'ttsModel.enterReferenceText': 'This is the text for reference audio',
  'ttsModel.action': 'Action',
  'ttsModel.operation': 'Operation',
  'ttsModel.operationFailed': 'Operation failed',
  'ttsModel.operationClosed': 'Operation closed',
  'ttsModel.edit': 'Edit',
  'ttsModel.delete': 'Delete',
  'ttsModel.save': 'Save',
  'ttsModel.deselectAll': 'Deselect All',
  'ttsModel.selectAll': 'Select All',
  'ttsModel.add': 'Add',
  'ttsModel.fetchVoicesFailed': 'Failed to fetch voice list',
  'ttsModel.loadVoicesFailed': 'Failed to load voice data',
  'ttsModel.unnamedVoice': 'Unnamed Voice',
  'ttsModel.finishEditingFirst': 'Please finish current editing first',
  'ttsModel.selectVoiceToDelete': 'Please select voices to delete',

  // OTA Management Page Text
  'otaManagement.firmwareManagement': 'Firmware Management',
  'otaManagement.searchPlaceholder': 'Please enter firmware name to search',
  'otaManagement.search': 'Search',
  'otaManagement.firmwareName': 'Firmware Name',
  'otaManagement.firmwareType': 'Firmware Type',
  'otaManagement.version': 'Version',
  'otaManagement.fileSize': 'File Size',
  'otaManagement.remark': 'Remark',
  'otaManagement.createTime': 'Create Time',
  'otaManagement.updateTime': 'Update Time',
  'otaManagement.action': 'Action',
  'otaManagement.download': 'Download',
  'otaManagement.edit': 'Edit',
  'otaManagement.delete': 'Delete',
  'otaManagement.selectAll': 'Select All',
  'otaManagement.deselectAll': 'Deselect All',
  'otaManagement.addNew': 'Add New',
  'otaManagement.addFirmware': 'Add Firmware',
  'otaManagement.editFirmware': 'Edit Firmware',
  'otaManagement.itemsPerPage': '{items} items/page',
  'otaManagement.firstPage': 'First Page',
  'otaManagement.prevPage': 'Previous Page',
  'otaManagement.nextPage': 'Next Page',
  'otaManagement.totalRecords': 'Total {total} records',
  'otaManagement.selectFirmwareFirst': 'Please select firmware to delete first',
  'otaManagement.confirmBatchDelete': 'Are you sure you want to delete the selected {paramCount} firmware?',
  'otaManagement.operationCancelled': 'Deletion operation has been cancelled',
  'otaManagement.operationClosed': 'Operation has been closed',
  'otaManagement.batchDeleteSuccess': 'Successfully deleted {paramCount} firmware',
  'otaManagement.deleteFailed': 'Deletion failed, please try again',
  'otaManagement.incompleteFirmwareInfo': 'Incomplete firmware information',
  'otaManagement.getDownloadUrlFailed': 'Failed to get download link',
  'otaManagement.getFirmwareTypesFailed': 'Failed to get firmware types',
  'otaManagement.updateSuccess': 'Update successful',
  'otaManagement.updateFailed': 'Update failed',
  'otaManagement.addSuccess': 'Addition successful',
  'otaManagement.addFailed': 'Addition failed',
  'otaManagement.fetchFirmwareListFailed': 'Failed to fetch firmware list',

  // Provider Management page model type translations
  'providerManagement.all': 'All',
  'providerManagement.modelType.ASR': 'Speech Recognition',
  'providerManagement.modelType.TTS': 'Text-to-Speech',
  'providerManagement.modelType.LLM': 'Large Language Model',
  'providerManagement.modelType.VLLM': 'Vision Large Language Model',
  'providerManagement.modelType.Intent': 'Intent Recognition',
  'providerManagement.modelType.Memory': 'Memory Module',
  'providerManagement.modelType.VAD': 'Voice Activity Detection',
  'providerManagement.modelType.Plugin': 'Plugin Tool',

  // Provider Dialog translations
  'providerDialog.category': 'Category',
  'providerDialog.selectCategory': 'Please select category',
  'providerDialog.code': 'Code',
  'providerDialog.inputCode': 'Please input provider code',
  'providerDialog.name': 'Name',
  'providerDialog.inputName': 'Please input provider name',
  'providerDialog.sort': 'Sort',
  'providerDialog.fieldConfig': 'Field Configuration',
  'providerDialog.add': 'Add',
  'providerDialog.deselectAll': 'Deselect All',
  'providerDialog.selectAll': 'Select All',
  'providerDialog.batchDelete': 'Batch Delete',
  'providerDialog.fieldKey': 'Field Key',
  'providerDialog.fieldLabel': 'Field Label',
  'providerDialog.fieldType': 'Field Type',
  'providerDialog.type': 'Type',
  'providerDialog.stringType': 'String',
  'providerDialog.numberType': 'Number',
  'providerDialog.booleanType': 'Boolean',
  'providerDialog.dictType': 'Dictionary',
  'providerDialog.arrayType': 'Semicolon-separated List',
  'providerDialog.defaultValue': 'Default Value',
  'providerDialog.inputDefaultValue': 'Please input default value',
  'providerDialog.operation': 'Operation',
  'providerDialog.edit': 'Edit',
  'providerDialog.complete': 'Complete',
  'providerDialog.delete': 'Delete',
  'providerDialog.save': 'Save',
  'providerDialog.requiredCategory': 'Please select category',
  'providerDialog.requiredCode': 'Please input provider code',
  'providerDialog.requiredName': 'Please input provider name',
  'providerDialog.completeFieldEdit': 'Please complete current field editing first',
  'providerDialog.confirmDeleteField': 'Are you sure to delete this field?',
  'providerDialog.selectFieldsToDelete': 'Please select fields to delete first',
  'providerDialog.confirmBatchDeleteFields': 'Are you sure to delete {count} selected fields?',
  'providerDialog.batchDeleteFieldsSuccess': 'Successfully deleted {count} fields',

  // agentTemplateManagement
  'agentTemplateManagement.title': 'Default Role Management',
  'agentTemplateManagement.templateName': 'Template Name',
  'agentTemplateManagement.action': 'Action',
  'agentTemplateManagement.createTemplate': 'Create Template',
  'templateQuickConfig.newTemplate': 'New Template',
  'agentTemplateManagement.editTemplate': 'Edit Template',
  'agentTemplateManagement.deleteTemplate': 'Delete Template',
  'agentTemplateManagement.deleteSuccess': 'Template deleted successfully',
  'agentTemplateManagement.batchDelete': 'Batch Delete',
  'agentTemplateManagement.batchDeleteSuccess': 'Batch deletion successful',
  'agentTemplateManagement.selectTemplate': 'Please select a template',
  'agentTemplateManagement.select': 'Select',
  'agentTemplateManagement.searchPlaceholder': 'Please enter template name to search',
  'agentTemplateManagement.search': 'Search',
  'agentTemplateManagement.serialNumber': 'Serial Number',
  'agentTemplateManagement.selectAll': 'Select All',
  'agentTemplateManagement.deselectAll': 'Deselect All',
  'agentTemplateManagement.loading': 'Loading...',
  'agentTemplateManagement.confirmSingleDelete': 'Are you sure you want to delete this template?',
  'agentTemplateManagement.confirmBatchDelete': 'Are you sure you want to delete the selected {count} templates?',
  'agentTemplateManagement.deleteFailed': 'Template deletion failed',
  'agentTemplateManagement.batchDeleteFailed': 'Template batch deletion failed',
  'agentTemplateManagement.deleteBackendError': 'Deletion failed, please check if the backend service is normal',
  'agentTemplateManagement.deleteCancelled': 'Deletion cancelled',

  // templateQuickConfig
  'templateQuickConfig.title': 'Module Quick Configuration',
  'templateQuickConfig.agentSettings.agentName': 'Nickname',
  'templateQuickConfig.agentSettings.agentNamePlaceholder': 'Please enter nickname',
  'templateQuickConfig.agentSettings.systemPrompt': 'Introduction',
  'templateQuickConfig.agentSettings.systemPromptPlaceholder': 'Please enter ntroduction',
  'templateQuickConfig.saveConfig': 'Save Configuration',
  'templateQuickConfig.resetConfig': 'Reset Configuration',
  'templateQuickConfig.configSaved': 'Configuration saved successfully',
  'templateQuickConfig.configReset': 'Configuration has been reset',
  'templateQuickConfig.confirmReset': 'Are you sure you want to reset the configuration?',
  'templateQuickConfig.saveFailed': 'Configuration save failed',
  'templateQuickConfig.confirm': 'Confirm',
  'templateQuickConfig.cancel': 'Cancel',
  'templateQuickConfig.templateNotFound': 'Template not found',
  'warning': 'Warning',
  'info': 'Info',
  'common.networkError': 'Network request failed',
  
  // SM2 Encryption
  'sm2.publicKeyNotConfigured': 'SM2 public key not configured, please contact administrator',
  'sm2.encryptionFailed': 'Password encryption failed',
  'sm2.keyGenerationFailed': 'Key pair generation failed',
  'sm2.invalidPublicKey': 'Invalid public key format',
  'sm2.encryptionError': 'Error occurred during encryption',
  'sm2.publicKeyRetry': 'Retrying to get public key...',
  'sm2.publicKeyRetryFailed': 'Public key retrieval retry failed',

  // Voice Clone and Resource Management
  'voiceClone.title': 'Voice Clone',
  'voiceResource.title': 'Voice Resource',
  'voiceClone.platformName': 'Platform Name',
  'voiceClone.voiceId': 'Voice ID',
  'voiceClone.userId': 'Account Owner',
  'voiceClone.name': 'Voice Name',
  'voiceClone.clone': 'Clone Voice',
  'voiceClone.action': 'Action',
  'voiceClone.modelId': 'Model ID',
  'voiceClone.trainStatus': 'Training Status',
  'voiceClone.trainError': 'Training Error',
  'voiceClone.createdAt': 'Creation Time',
  'voiceClone.search': 'Search',
  'voiceClone.searchPlaceholder': 'Please enter voice name or voice ID',
  'voiceClone.addNew': 'Add',
  'voiceClone.delete': 'Delete',
  'voiceClone.selectAll': 'Select All',
  'voiceClone.deselectAll': 'Deselect All',
  'voiceClone.addVoiceClone': 'Add Voice Resource',
  'voiceClone.confirmDelete': 'Are you sure you want to delete the selected {count} voice resources?',
  'voiceClone.deleteSuccess': 'Successfully deleted {count} voice resources',
  'voiceClone.deleteFailed': 'Deletion failed',
  'voiceClone.addSuccess': 'Add successful',
  'voiceClone.addFailed': 'Add failed',
  'voiceClone.updateSuccess': 'Update successful',
  'voiceClone.updateFailed': 'Update failed',
  'voiceClone.selectFirst': 'Please select voice resources to delete first',
  'voiceClone.operationCancelled': 'Cancel',
  'voiceClone.operationClosed': 'Popup closed',
  'voiceClone.cloneSuccess': 'Clone successful',
  'voiceClone.cloneFailed': 'Clone failed',
  'voiceClone.confirmClone': 'Are you sure you want to clone this voice?',
  'voiceClone.onlySuccessCanClone': 'Only successfully trained voices can be cloned',
  'common.insufficient': 'Insufficient',
  'voiceClone.platformNameRequired': 'Please select platform name',
  'voiceClone.voiceIdRequired': 'Please select voice ID',
  'voiceClone.userIdRequired': 'Please select account owner',
  'voiceClone.platformNamePlaceholder': 'Please select platform name',
  'voiceClone.voiceIdPlaceholder': 'Please enter voice ID and press Enter',
  'voiceClone.userIdPlaceholder': 'Please enter keyword to select account owner',
  'voiceClone.waitingUpload': 'Waiting for upload',
  'voiceClone.waitingTraining': 'Waiting for clone',
  'voiceClone.training': 'Training',
  'voiceClone.trainSuccess': 'Training successful',
  'voiceClone.trainFailed': 'Training failed',
  'voiceClone.itemsPerPage': '{items} items per page',
  'voiceClone.firstPage': 'First Page',
  'voiceClone.prevPage': 'Previous Page',
  'voiceClone.nextPage': 'Next Page',
  'voiceClone.totalRecords': '{total} records in total',
  'voiceClone.noVoiceCloneAssigned': 'Your account has no voice resources assigned',
  'voiceClone.contactAdmin': 'Please contact administrator for voice resource assignment',
  'voiceClone.dialogTitle': 'Voice Clone',
  'voiceClone.stepUpload': 'Prepare Audio',
  'voiceClone.stepEdit': 'Audio Edit',
  'voiceClone.dragOrClick': 'Drag audio file here, or click to upload',
  'voiceClone.uploadTip': 'Support all mainstream audio formats, selected duration must be between 8-60 seconds',
  'voiceClone.editTip1': 'Please confirm if the uploaded audio is satisfactory',
  'voiceClone.editTip2': 'You can listen and trim the audio, if not satisfied you can go back to re-record or upload',
  'voiceClone.selectedDuration': 'Selected valid segment: {duration} seconds',
  'voiceClone.trim': 'Trim selected segment',
  'voiceClone.reset': 'Reset',
  'voiceClone.play': 'Play',
  'voiceClone.pause': 'Pause',
  'voiceClone.cancel': 'Cancel',
  'voiceClone.nextStep': 'Next',
  'voiceClone.prevStep': 'Previous',
  'voiceClone.upload': 'Upload Audio',
  'voiceClone.pleaseSelectAudio': 'Please select an audio file first',
  'voiceClone.durationError': 'Audio duration must be between 8-60 seconds',
  'voiceClone.loadAudioFailed': 'Failed to load audio',
  'voiceClone.trimSuccess': 'Trim successful',
  'voiceClone.resetSuccess': 'Reset successful',
  'voiceClone.uploadSuccess': 'Upload successful',
  'voiceClone.uploadFailed': 'Upload failed',
  'voiceClone.updateNameSuccess': 'Name updated successfully',
  'voiceClone.updateNameFailed': 'Failed to update name',
  'voiceClone.playFailed': 'Play failed',
}